/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.beans.DirectoryObjectEJB;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.SessionController;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.ejb.SessionBean;

public class DirectoryGroupObjectEJB
extends DirectoryObjectEJB
implements SessionBean {
    private void copyIntoHash(Hashtable result, GlobalObjectClientBean[] goArr) throws RemoteException, Exception {
        if (goArr != null) {
            int len = goArr.length;
            for (int i = 0; i < len; ++i) {
                if (result.containsKey(goArr[i].getId())) continue;
                result.put(goArr[i].getId(), goArr[i]);
            }
        }
    }

    public GlobalObjectClientBean[] convertHashtableToObjectArray(Hashtable result) throws RemoteException, Exception {
        Enumeration keyEnum = result.keys();
        GlobalObjectClientBean[] goArr = new GlobalObjectClientBean[result.size()];
        int i = 0;
        while (keyEnum.hasMoreElements()) {
            Long key = (Long)keyEnum.nextElement();
            goArr[i] = (GlobalObjectClientBean)result.get(key);
            ++i;
        }
        return goArr;
    }

    public DirectoryObjectClientBean[] getAllMembers(SessionController sessionController, DirectoryGroupObjectClientBean group, Hashtable selectedGroups) throws RemoteException, Exception {
        Hashtable<Long, DirectoryObjectClientBean> result = new Hashtable<Long, DirectoryObjectClientBean>();
        DirectoryObjectClientBean[] members = group.getDirectMembers();
        if (members != null) {
            int len = members.length;
            for (int i = 0; i < len; ++i) {
                if (!result.containsKey(members[i].getId())) {
                    result.put(members[i].getId(), members[i]);
                }
                if (!(members[i] instanceof DirectoryGroupObjectClientBean) || selectedGroups.containsKey(members[i].getId())) continue;
                GlobalObjectClientBean[] subMembers = ((DirectoryGroupObjectClientBean)members[i]).getAllMembers(selectedGroups);
                this.copyIntoHash(result, subMembers);
                selectedGroups.put(members[i].getId(), "");
            }
        }
        Object[] goArr = this.convertHashtableToObjectArray(result);
        JavaUtil ju = new JavaUtil();
        DirectoryObjectClientBean[] doRet = null;
        try {
            doRet = (DirectoryObjectClientBean[])ju.convertArray(goArr, DirectoryObjectClientBean.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doRet;
    }

    public DirectoryObjectClientBean[] getAllUserMembers(SessionController sessionController, DirectoryGroupObjectClientBean group, Hashtable selectedGroups) throws RemoteException, Exception {
        Hashtable<Long, DirectoryObjectClientBean> result = new Hashtable<Long, DirectoryObjectClientBean>();
        DirectoryObjectClientBean[] members = group.getDirectMembers();
        if (members != null) {
            int len = members.length;
            for (int i = 0; i < len; ++i) {
                if (members[i] instanceof DirectoryGroupObjectClientBean && !sessionController.isWorldGroup(members[i])) {
                    if (selectedGroups.containsKey(members[i].getId())) continue;
                    GlobalObjectClientBean[] subMembers = ((DirectoryGroupObjectClientBean)members[i]).getAllUserMembers(selectedGroups);
                    this.copyIntoHash(result, subMembers);
                    selectedGroups.put(members[i].getId(), "");
                    continue;
                }
                if (result.containsKey(members[i].getId())) continue;
                result.put(members[i].getId(), members[i]);
            }
        }
        Object[] goArr = this.convertHashtableToObjectArray(result);
        JavaUtil ju = new JavaUtil();
        DirectoryObjectClientBean[] doRet = null;
        try {
            doRet = (DirectoryObjectClientBean[])ju.convertArray(goArr, DirectoryObjectClientBean.class.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return doRet;
    }

    public DirectoryObjectClientBean[] getDirectMembers(SessionController sessionController, DirectoryGroupObjectClientBean group) throws RemoteException, Exception {
        DirectoryObjectClientBean[] goRet = null;
        RelationObjectClientBean[] relArr = group.getRightwardRelations(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (relArr != null) {
            int i;
            Vector<DirectoryObjectClientBean> vRel = new Vector<DirectoryObjectClientBean>();
            int len = relArr.length;
            for (i = 0; i < len; ++i) {
                DirectoryObjectClientBean docb = null;
                try {
                    docb = (DirectoryObjectClientBean)relArr[i].getRightObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (docb == null) continue;
                vRel.addElement(docb);
            }
            len = vRel.size();
            if (len > 0) {
                goRet = new DirectoryObjectClientBean[len];
                for (i = 0; i < len; ++i) {
                    goRet[i] = (DirectoryObjectClientBean)vRel.elementAt(i);
                }
            }
        }
        return goRet;
    }

    public DirectoryUserObjectClientBean[] getDirectUserMembers(SessionController sessionController, DirectoryGroupObjectClientBean group) throws RemoteException, Exception {
        DirectoryUserObjectClientBean[] goRet = null;
        RelationObjectClientBean[] relArr = group.getRightwardRelations(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (relArr != null) {
            int i;
            Vector<DirectoryObjectClientBean> vRel = new Vector<DirectoryObjectClientBean>();
            int len = relArr.length;
            for (i = 0; i < len; ++i) {
                DirectoryObjectClientBean docb = null;
                try {
                    docb = (DirectoryObjectClientBean)relArr[i].getRightObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (docb == null || !(docb instanceof DirectoryUserObjectClientBean)) continue;
                vRel.addElement(docb);
            }
            len = vRel.size();
            if (len > 0) {
                goRet = new DirectoryUserObjectClientBean[len];
                for (i = 0; i < len; ++i) {
                    goRet[i] = (DirectoryUserObjectClientBean)vRel.elementAt(i);
                }
            }
        }
        return goRet;
    }

    public DirectoryGroupObjectClientBean[] getDirectGroupMembers(SessionController sessionController, DirectoryGroupObjectClientBean group) throws RemoteException, Exception {
        DirectoryGroupObjectClientBean[] goRet = null;
        RelationObjectClientBean[] relArr = group.getRightwardRelations(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (relArr != null) {
            int i;
            Vector<DirectoryObjectClientBean> vRel = new Vector<DirectoryObjectClientBean>();
            int len = relArr.length;
            for (i = 0; i < len; ++i) {
                DirectoryObjectClientBean docb = null;
                try {
                    docb = (DirectoryObjectClientBean)relArr[i].getRightObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (docb == null || !(docb instanceof DirectoryGroupObjectClientBean)) continue;
                vRel.addElement(docb);
            }
            len = vRel.size();
            if (len > 0) {
                goRet = new DirectoryGroupObjectClientBean[len];
                for (i = 0; i < len; ++i) {
                    goRet[i] = (DirectoryGroupObjectClientBean)vRel.elementAt(i);
                }
            }
        }
        return goRet;
    }

    public DirectoryGroupObjectClientBean[] getParentGroups(SessionController sessionController, DirectoryGroupObjectClientBean group) throws RemoteException, Exception {
        DirectoryGroupObjectClientBean[] goRet = null;
        RelationObjectClientBean[] relArr = group.getLeftwardRelations(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (relArr != null) {
            int i;
            Vector<DirectoryObjectClientBean> vRel = new Vector<DirectoryObjectClientBean>();
            int len = relArr.length;
            for (i = 0; i < len; ++i) {
                DirectoryObjectClientBean docb = null;
                try {
                    docb = (DirectoryObjectClientBean)relArr[i].getLeftObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (docb == null || !(docb instanceof DirectoryGroupObjectClientBean)) continue;
                vRel.addElement(docb);
            }
            len = vRel.size();
            if (len > 0) {
                goRet = new DirectoryGroupObjectClientBean[len];
                for (i = 0; i < len; ++i) {
                    goRet[i] = (DirectoryGroupObjectClientBean)vRel.elementAt(i);
                }
            }
        }
        return goRet;
    }

    public boolean isDirectMember(SessionController sessionController, DirectoryGroupObjectClientBean group, DirectoryObjectClientBean member) throws RemoteException, Exception {
        boolean isDirectMember = false;
        RelationObjectClientBean[] relArr = group.getRelations(GroupMemberRelationObjectClientBean.CLASS_NAME, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, member);
        if (relArr != null) {
            isDirectMember = true;
        }
        return isDirectMember;
    }

    public Set<Long> getAllUserMembersDirect(SessionController sessionController, Long groupId) throws RemoteException, Exception {
        HashSet<Long> allUsers = new HashSet<Long>();
        HashSet<Long> done = new HashSet<Long>();
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection conn = cu.getConnection();){
            this.getAllUserMembers(conn, sessionController, groupId, allUsers, done);
        }
        return allUsers;
    }

    private void getAllUserMembers(Connection conn, SessionController sessionController, Long groupId, Set<Long> allUsers, Set<Long> done) throws Exception {
        String select = "select a.classid, a.id from globalobject a, relationobject b, groupmemberrelationobject c where b.id=c.id and b.leftobject=? and b.rightobject=a.id";
        try (PreparedStatement pstmt = conn.prepareStatement(select);){
            pstmt.setLong(1, groupId);
            try (ResultSet rSet = pstmt.executeQuery();){
                while (rSet.next()) {
                    Long classId = rSet.getLong(1);
                    Long memberId = rSet.getLong(2);
                    if (done.contains(memberId)) continue;
                    done.add(memberId);
                    String className = sessionController.getClassNameFromClassId(classId);
                    SuperObjectClientBean obj = sessionController.getEmptyClassObject(className);
                    if (obj instanceof DirectoryGroupObjectClientBean) {
                        this.getAllUserMembers(conn, sessionController, memberId, allUsers, done);
                        continue;
                    }
                    allUsers.add(memberId);
                }
            }
        }
    }
}

