/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.beans;

import agorum.commons.cron.SystemTimer;
import agorum.commons.statistic.PerformanceValueHolder;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemTaskAbortedException;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.callback.SuperObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlEntryObjectClientBean;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.ClassObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DataBaseObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryGroupObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.EmailUserProfileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GroupMemberRelationObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ApplicationHashtable;
import agorum.roi.ejb.common.AssociatedGroupOfDirectoryObject;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArrayDBUtils;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.CallBackUtils;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialCallerBean;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialInfoBean;
import agorum.roi.ejb.common.CredentialManager;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.DbPrimaryKey;
import agorum.roi.ejb.common.DbSizeUpdateTimer;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.EventAssistanceUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.InitSessionReturnBean;
import agorum.roi.ejb.common.LocatorHelper;
import agorum.roi.ejb.common.ObjectCreatedInformation;
import agorum.roi.ejb.common.RoiCredentialManager;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.StartupInitializer;
import agorum.roi.ejb.common.TestDbPerformanceUtil;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.UserManager;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.ejb.interfaces.home.AttributeObjectEntityHome;
import agorum.roi.ejb.interfaces.home.ClassObjectEntityHome;
import agorum.roi.ejb.interfaces.home.DataBaseObjectEntityHome;
import agorum.roi.ejb.interfaces.home.GlobalObjectEntityHome;
import agorum.roi.ejb.interfaces.home.InternalObjectEntityHome;
import agorum.roi.ejb.interfaces.remote.DataBaseObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.GlobalObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.InternalObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectEntityRemote;
import agorum.roi.ejb.interfaces.remote.SuperObjectRemote;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.search.SearchClass;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class SystemSessionEJB
implements SessionBean {
    protected SessionContext context = null;
    private boolean adminFlag = true;
    public static final String PENDING_INDEX_TABLE = "PendingIndexTable";
    public static final String WORLDGROUP_ID = "999";
    public static long lastFormatSelectTime;
    public static long staticDbSize;
    private static Long ROOT_FOLDER_ID;

    public void ejbCreate() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sc) {
        this.context = sc;
    }

    public boolean getAdminFlag() {
        return this.adminFlag;
    }

    public GlobalObjectClientBean getGlobalObjectByPrimaryKey(SessionController sessionController, DbPrimaryKey pk) throws RemoteException, Exception {
        try {
            GlobalObjectClientBean cb = null;
            GlobalObjectEntityHome globalObjectEntityHome = (GlobalObjectEntityHome)EJBHomeHolder.getHome("ejb/GlobalObjectEntity");
            GlobalObjectEntityRemote remote = null;
            try {
                remote = globalObjectEntityHome.findByPrimaryKey(sessionController, pk, pk.getAttributes());
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e, "Object with id " + pk.id + " not found.", "agorum.roi.remote.exception.NoEntryFound", 101);
            }
            cb = (GlobalObjectClientBean)this.getObjectById(sessionController, remote, pk);
            if (pk.getCheckObjectAccess() && !cb.checkEffectiveAccess(4L)) {
                ExceptionUtils.handleException("No access for object with id " + cb.getId(), "agorum.roi.remote.exception.NoAccess", 21);
            }
            cb.checkAdditionReadAccess();
            return cb;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e, "agorum.roi.remote.exception.NoEntryFound", 101);
            return null;
        }
    }

    public DataBaseObjectClientBean getDataBaseObjectById(SessionController sessionController, Long id) throws RemoteException, Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        return this.getDataBaseObjectByPrimaryKey(sessionController, pk);
    }

    public DataBaseObjectClientBean getDataBaseObjectByPrimaryKey(SessionController sessionController, DbPrimaryKey pk) throws RemoteException, Exception {
        try {
            DataBaseObjectEntityHome home = (DataBaseObjectEntityHome)EJBHomeHolder.getHome("ejb/DataBaseObjectEntity");
            DataBaseObjectEntityRemote remote = null;
            try {
                remote = home.findByPrimaryKey(sessionController, pk, pk.getAttributes());
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            if (remote.getClassId(sessionController) == 9L) {
                ClassObjectEntityHome clHome = (ClassObjectEntityHome)EJBHomeHolder.getHome("ejb/ClassObjectEntity");
                try {
                    remote = clHome.findByPrimaryKey(sessionController, pk, pk.getAttributes());
                }
                catch (Exception e) {
                    ExceptionUtils.handleException(e);
                }
            }
            return (DataBaseObjectClientBean)this.getObjectById(sessionController, remote, pk);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public GlobalObjectClientBean getGlobalObjectById(SessionController sessionController, Long id) throws RemoteException, Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        return this.getGlobalObjectByPrimaryKey(sessionController, pk);
    }

    public boolean existGlobalObjectById(SessionController sessionController, Long id) throws RemoteException, Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        pk.setCheckObjectAccess(false);
        GlobalObjectClientBean clientBean = null;
        try {
            clientBean = this.getGlobalObjectByPrimaryKey(sessionController, pk);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clientBean != null;
    }

    public InternalObjectClientBean getInternalObjectById(SessionController sessionController, Long id) throws RemoteException, Exception {
        DbPrimaryKey pk = new DbPrimaryKey();
        pk.id = id;
        return this.getInternalObjectByPrimaryKey(sessionController, pk);
    }

    public InternalObjectClientBean getInternalObjectByPrimaryKey(SessionController sessionController, DbPrimaryKey pk) throws RemoteException, Exception {
        try {
            InternalObjectEntityHome home = (InternalObjectEntityHome)EJBHomeHolder.getHome("ejb/InternalObjectEntity");
            InternalObjectEntityRemote remote = null;
            try {
                remote = home.findByPrimaryKey(sessionController, pk, pk.getAttributes());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                ExceptionUtils.handleException(e);
            }
            InternalObjectClientBean cb = (InternalObjectClientBean)this.getObjectById(sessionController, remote, pk);
            return cb;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    private SuperObjectClientBean getObjectById(SessionController sessionController, SuperObjectEntityRemote remote, DbPrimaryKey pk) throws RemoteException, Exception {
        return remote.getClientBean(sessionController, remote, pk);
    }

    public FolderObjectClientBean getRootFolder(SessionController sessionController) throws RemoteException, Exception {
        return (FolderObjectClientBean)this.getGlobalObjectById(sessionController, ROOT_FOLDER_ID);
    }

    public FolderObjectClientBean getRealRootFolder(SessionController sessionController) throws RemoteException, Exception {
        return (FolderObjectClientBean)this.getGlobalObjectById(sessionController, ROOT_FOLDER_ID);
    }

    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, FolderObjectClientBean rootFolder, String fullPath) throws RemoteException, Exception {
        return this.findGlobalObjectByPath(sessionController, rootFolder, fullPath, false);
    }

    public GlobalObjectClientBean findGlobalObjectByPathNoLookup(SessionController sessionController, String fullPath) throws RemoteException, Exception {
        FolderObjectClientBean rootFolder = sessionController.getRootFolder();
        return this.findGlobalObjectByPath(sessionController, rootFolder, fullPath, false, false);
    }

    public GlobalObjectClientBean findGlobalObjectByPathNoLookup(SessionController sessionController, FolderObjectClientBean folder, String fullPath) throws RemoteException, Exception {
        return this.findGlobalObjectByPath(sessionController, folder, fullPath, false, false);
    }

    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, FolderObjectClientBean rootFolder, String fullPath, boolean caseSensitive) throws RemoteException, Exception {
        return this.findGlobalObjectByPath(sessionController, rootFolder, fullPath, caseSensitive, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, FolderObjectClientBean rootFolder, String fullPath, boolean caseSensitive, boolean lookup) throws RemoteException, Exception {
        if (fullPath.indexOf(":") != -1 && lookup) {
            try {
                return (GlobalObjectClientBean)Beans.lookup(sessionController, fullPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fullPath.equals("/")) {
            return sessionController.getRootFolder();
        }
        if (fullPath.toLowerCase().startsWith("${user_home}")) {
            rootFolder = SessionController.getHomeFolder(sessionController.getLoginUser());
            fullPath = fullPath.substring("${user_home}".length());
        } else if (fullPath.toLowerCase().indexOf("${username}") != -1) {
            fullPath = fullPath.toLowerCase();
            fullPath = fullPath.replace("${username}", sessionController.getLoginUser().getName());
        }
        StringTokenizer st = new StringTokenizer(fullPath, "/");
        ConnectionUtils cu = null;
        GlobalObjectClientBean cbRet = null;
        try {
            cu = new ConnectionUtils(sessionController);
            cu.getConnection();
            cbRet = this.findGlobalObjectByPathRecursive(sessionController, st, rootFolder, caseSensitive);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return cbRet;
    }

    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, Long folderId, String fullPath) throws RemoteException, Exception {
        FolderObjectClientBean folder = (FolderObjectClientBean)this.getGlobalObjectById(sessionController, folderId);
        return this.findGlobalObjectByPath(sessionController, folder, fullPath);
    }

    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, String fullPath) throws RemoteException, Exception {
        FolderObjectClientBean rootFolder = sessionController.getRootFolder();
        GlobalObjectClientBean gocb = this.findGlobalObjectByPath(sessionController, rootFolder, fullPath);
        return gocb;
    }

    public GlobalObjectClientBean findGlobalObjectByPath(SessionController sessionController, String fullPath, boolean caseSensitive) throws RemoteException, Exception {
        FolderObjectClientBean rootFolder = sessionController.getRootFolder();
        GlobalObjectClientBean gocb = this.findGlobalObjectByPath(sessionController, rootFolder, fullPath, caseSensitive);
        return gocb;
    }

    public GlobalObjectClientBean findGlobalObjectByPathFromRoot(SessionController sessionController, String fullPath) throws RemoteException, Exception {
        FolderObjectClientBean rootFolder = sessionController.getRealRootFolder();
        GlobalObjectClientBean gocb = this.findGlobalObjectByPath(sessionController, rootFolder, fullPath);
        return gocb;
    }

    private GlobalObjectClientBean findGlobalObjectByPathRecursive(SessionController sessionController, StringTokenizer st, FolderObjectClientBean folder, boolean caseSensitive) throws RemoteException, Exception {
        String name = st.nextElement().toString();
        GlobalObjectClientBean item = null;
        if (name.equals("..")) {
            item = folder.getParents()[0];
        } else if (name.equals(".")) {
            item = folder;
        } else {
            item = folder.getItem(name);
            if (caseSensitive && item != null && !item.getName().equals(name)) {
                item = null;
            }
        }
        GlobalObjectClientBean itemRet = item;
        if (st.hasMoreElements()) {
            if (item != null && sessionController.isFolder(item)) {
                FolderObjectClientBean nextFolder = (FolderObjectClientBean)item;
                itemRet = this.findGlobalObjectByPathRecursive(sessionController, st, nextFolder, caseSensitive);
            } else {
                itemRet = null;
            }
        }
        return itemRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalObjectClientBean createGlobalObject(SessionController sessionController, SuperObjectClientBeanDefinition def) throws RemoteException, Exception {
        CallBackUtils cbu = new CallBackUtils();
        try {
            if (def.getId() == null) {
                def.setId(sessionController.getSequenceId());
            }
            Long classId = def.getClassId();
            SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, classId);
            callBack.executeBeforeCreate(sessionController, def);
            def.setSessionController(sessionController);
            DbPrimaryKey pk = new DbPrimaryKey();
            GlobalObjectEntityHome home = (GlobalObjectEntityHome)EJBHomeHolder.getHome("ejb/GlobalObjectEntity");
            pk.setDefinition(def);
            GlobalObjectEntityRemote remote = home.create(sessionController, pk);
            pk.setCheckObjectAccess(false);
            GlobalObjectClientBean clientBean = this.getGlobalObjectByPrimaryKey(sessionController, pk);
            try {
                if (def.getSystemOption(GlobalObjectClientBean.SYSTEMOPTION_NOEVENT) == null) {
                    new MessageUtils().sendCreateEvent(clientBean, def);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ObjectCreatedInformation.rememberObjectCreatedInTransaction(clientBean);
            this.storeAclToAclObjectTable(sessionController, clientBean);
            AuditUtil.createAuditEntry(clientBean, sessionController.getLoginUser(), AuditUtil.ACTION_CREATE, def.getAttributes());
            callBack.executeAfterCreate(sessionController, def, clientBean);
            cbu.finishCallBack(sessionController);
            cbu = null;
            GlobalObjectClientBean globalObjectClientBean = clientBean;
            return globalObjectClientBean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cbu != null) {
                    cbu.finishCallBack(sessionController);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalObjectClientBean createInternalObject(SessionController sessionController, SuperObjectClientBeanDefinition def) throws RemoteException, Exception {
        CallBackUtils cbu = new CallBackUtils();
        try {
            def.setId(sessionController.getSequenceId());
            def.setSessionController(sessionController);
            Long classId = def.getClassId();
            SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, classId);
            callBack.executeBeforeCreate(sessionController, def);
            DbPrimaryKey pk = new DbPrimaryKey();
            InternalObjectEntityHome home = (InternalObjectEntityHome)EJBHomeHolder.getHome("ejb/InternalObjectEntity");
            pk.setDefinition(def);
            InternalObjectEntityRemote remote = home.create(sessionController, pk);
            InternalObjectClientBean clientBean = this.getInternalObjectByPrimaryKey(sessionController, pk);
            AuditUtil.createAuditEntry(clientBean, sessionController.getLoginUser(), AuditUtil.ACTION_CREATE, def.getAttributes());
            callBack.executeAfterCreate(sessionController, def, clientBean);
            cbu.finishCallBack(sessionController);
            cbu = null;
            InternalObjectClientBean internalObjectClientBean = clientBean;
            return internalObjectClientBean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cbu != null) {
                    cbu.finishCallBack(sessionController);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void updateDataBaseObject(SessionController sessionController, SuperObjectClientBeanDefinition def, ClassObjectClientBean classObject) throws RemoteException, Exception {
        try {
            this.updateClassObject(sessionController, def, classObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataBaseObjectClientBean createDataBaseObject(SessionController sessionController, SuperObjectClientBeanDefinition def) throws RemoteException, Exception {
        CallBackUtils cbu = new CallBackUtils();
        try {
            Object home;
            def.setId(sessionController.getSequenceId());
            def.setSessionController(sessionController);
            Long classId = def.getClassId();
            SuperObjectCallBack callBack = cbu.getCallBackFromClassId(sessionController, classId);
            callBack.executeBeforeCreate(sessionController, def);
            DbPrimaryKey pk = new DbPrimaryKey();
            DataBaseObjectEntityRemote remote = null;
            pk.setDefinition(def);
            if (classId == 9L) {
                home = (ClassObjectEntityHome)EJBHomeHolder.getHome("ejb/ClassObjectEntity");
                remote = home.create(sessionController, pk);
            } else {
                home = (DataBaseObjectEntityHome)EJBHomeHolder.getHome("ejb/DataBaseObjectEntity");
                remote = home.create(sessionController, pk);
            }
            DataBaseObjectClientBean clientBean = this.getDataBaseObjectByPrimaryKey(sessionController, pk);
            if (classId == 9L) {
                this.createClassObject(sessionController, def, (ClassObjectClientBean)clientBean);
            }
            AuditUtil.createAuditEntry(clientBean, sessionController.getLoginUser(), AuditUtil.ACTION_CREATE, def.getAttributes());
            callBack.executeAfterCreate(sessionController, def, clientBean);
            cbu.finishCallBack(sessionController);
            cbu = null;
            DataBaseObjectClientBean dataBaseObjectClientBean = clientBean;
            return dataBaseObjectClientBean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cbu != null) {
                    cbu.finishCallBack(sessionController);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public ClassObjectClientBean getRootClassObjectFromClassId(SessionController sessionController, Long classId) throws RemoteException, Exception {
        ClassObjectClientBean classObjectClientBean = sessionController.getClassObject(classId);
        while (classObjectClientBean.getId().longValue() != classObjectClientBean.getSuperClass(sessionController).getId().longValue()) {
            classObjectClientBean = classObjectClientBean.getSuperClass(sessionController);
        }
        return classObjectClientBean;
    }

    public SuperObjectClientBean createSuperObject(SessionController sessionController, SuperObjectClientBeanDefinition def) throws RemoteException, Exception {
        try {
            def.setSessionController(sessionController);
            Long classId = def.getClassId();
            ClassObjectClientBean classObjectClientBean = this.getRootClassObjectFromClassId(sessionController, classId);
            SuperObjectClientBean superObjectClientBean = null;
            String classObjectName = classObjectClientBean.getDataBaseObjectName();
            if (classObjectName.equalsIgnoreCase(GlobalObjectClientBean.CLASS_NAME)) {
                superObjectClientBean = this.createGlobalObject(sessionController, def);
            } else if (classObjectName.equalsIgnoreCase(InternalObjectClientBean.CLASS_NAME)) {
                superObjectClientBean = this.createInternalObject(sessionController, def);
            } else if (classObjectName.equalsIgnoreCase(DataBaseObjectClientBean.CLASS_NAME)) {
                superObjectClientBean = this.createDataBaseObject(sessionController, def);
            }
            return superObjectClientBean;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public ClassObjectClientBean getClassObjectByIdOld(SessionController sessionController, Long id) throws RemoteException, Exception {
        ApplicationHashtable allClassObjects = sessionController.getAllClassObjects();
        return (ClassObjectClientBean)allClassObjects.get(sessionController, id);
    }

    private SuperObjectEntityRemote getRemoteEntityObjectOld(SessionController sessionController, EJBHome home, DbPrimaryKey pk) throws RemoteException, Exception {
        SuperObjectEntityRemote remote = null;
        try {
            if (home instanceof GlobalObjectEntityHome) {
                remote = ((GlobalObjectEntityHome)home).findByPrimaryKey(sessionController, pk, pk.getAttributes());
            } else if (home instanceof DataBaseObjectEntityHome) {
                remote = ((DataBaseObjectEntityHome)home).findByPrimaryKey(sessionController, pk, pk.getAttributes());
            } else if (home instanceof AttributeObjectEntityHome) {
                remote = ((AttributeObjectEntityHome)home).findByPrimaryKey(sessionController, pk, pk.getAttributes());
            } else if (home instanceof ClassObjectEntityHome) {
                remote = ((ClassObjectEntityHome)home).findByPrimaryKey(sessionController, pk, pk.getAttributes());
            } else if (home instanceof InternalObjectEntityHome) {
                remote = ((InternalObjectEntityHome)home).findByPrimaryKey(sessionController, pk, pk.getAttributes());
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return remote;
    }

    private SuperObjectRemote getRemoteEJBObject(SessionController sessionController, EJBHome home) throws RemoteException, Exception {
        SuperObjectRemote remote = null;
        try {
            Method dynMethodSetS = home.getClass().getMethod("create", new Class[0]);
            Object obj = dynMethodSetS.invoke((Object)home, new Object[0]);
            remote = (SuperObjectRemote)obj;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return remote;
    }

    private SuperObjectEntityRemote createEntityObject(SessionController sessionController, EJBHome home, DbPrimaryKey pk) throws RemoteException, Exception {
        SuperObjectEntityRemote remote = null;
        try {
            if (home instanceof GlobalObjectEntityHome) {
                remote = ((GlobalObjectEntityHome)home).create(sessionController, pk);
            } else if (home instanceof DataBaseObjectEntityHome) {
                remote = ((DataBaseObjectEntityHome)home).create(sessionController, pk);
            } else if (home instanceof AttributeObjectEntityHome) {
                remote = ((AttributeObjectEntityHome)home).create(sessionController, pk);
            } else if (home instanceof ClassObjectEntityHome) {
                remote = ((ClassObjectEntityHome)home).create(sessionController, pk);
            } else if (home instanceof InternalObjectEntityHome) {
                remote = ((InternalObjectEntityHome)home).create(sessionController, pk);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return remote;
    }

    public void reInitEffectiveAttributes(SessionController sessionController) throws RemoteException, Exception {
        Hashtable effectiveAttributes = sessionController.getEffectiveAttributes().getHashtable();
        Enumeration coEnum = sessionController.getAllClassObjects().keys();
        while (coEnum.hasMoreElements()) {
            Long classId = (Long)coEnum.nextElement();
            if (effectiveAttributes.containsKey(classId)) continue;
            effectiveAttributes.put(classId, new Hashtable());
        }
        sessionController.setEffectiveAttributes(new ApplicationHashtable(sessionController, effectiveAttributes, 6));
    }

    public static void mergeHashTables(Hashtable sourceHash, Hashtable destHash) {
        Enumeration sourceEnum = sourceHash.keys();
        while (sourceEnum.hasMoreElements()) {
            Object key = sourceEnum.nextElement();
            Object value = sourceHash.get(key);
            destHash.put(key, value);
        }
    }

    public static void getAllAttributes(SessionController sessionController, ClassObjectClientBean co, Hashtable allAttrHash) throws RemoteException, Exception {
        while (true) {
            Hashtable effAttrHash = co.getEffectiveAttributes();
            SystemSessionEJB.mergeHashTables(effAttrHash, allAttrHash);
            ClassObjectClientBean coSuper = (ClassObjectClientBean)co.getAttribute(ClassObjectClientBean.SUPERCLASS_ATTRIBUTE).getDataBaseObjectClientBean(sessionController);
            if (coSuper.getId().longValue() == co.getId().longValue()) break;
            co = coSuper;
        }
    }

    public Long findClassIdByAttribute(SessionController sessionController, String attrName, Long classId) throws RemoteException, Exception {
        ApplicationHashtable allAttributes = sessionController.getAllAttributes();
        Hashtable allAttr = (Hashtable)allAttributes.get(sessionController, classId);
        AttributeObjectClientBean ao = (AttributeObjectClientBean)allAttr.get(attrName);
        return ao != null ? ao.getClassId() : null;
    }

    public Hashtable getAllAttributesFromClassId(SessionController sessionController, Long classId) throws RemoteException, Exception {
        Hashtable hRet = (Hashtable)sessionController.getEffectiveAttributes().get(sessionController, classId);
        hRet = hRet == null ? new Hashtable() : hRet;
        return hRet;
    }

    public ClassObjectClientBean getClassObjectOld(SessionController sessionController, Long id) throws RemoteException, Exception {
        return (ClassObjectClientBean)sessionController.getAllClassObjects().get(sessionController, id);
    }

    public ClassObjectClientBean getClassObjectOld(SessionController sessionController, String name) throws RemoteException, Exception {
        name = name.toUpperCase();
        return (ClassObjectClientBean)sessionController.getAllClassObjectsByName().get(sessionController, name);
    }

    private void performInitialization(SessionController sessionController) throws RemoteException, Exception {
        System.err.println("Set is initialized");
        sessionController.setIsInitialized(true);
        StartupInitializer.init(sessionController, this);
    }

    public void initApplicationContainer(SessionController sessionController) throws RemoteException, Exception {
        if (!sessionController.getIsInitialized()) {
            this.performInitialization(sessionController);
        }
    }

    public void reInitStartup(SessionController sessionController) throws RemoteException, Exception {
        StartupInitializer.reInit(sessionController, this);
    }

    public InitSessionReturnBean initSession(SessionController sessionController, CredentialObject credential) throws RemoteException, Exception {
        InitSessionReturnBean retBean = new InitSessionReturnBean();
        LocatorHelper lh = LocatorHelper.getInstance();
        lh.setIsContainer(true);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        long time = System.currentTimeMillis();
        boolean checkCred = cm != null ? cm.checkCredential(credential) : false;
        System.err.println("checkCredential: " + (System.currentTimeMillis() - time));
        if (!checkCred) {
            ExceptionUtils.handleException("Invalid credential, username or password wrong. User: " + credential.getUserName() + ", IP: " + credential.getIp(), "agorum.roi.remote.exception.InvalidCredential", 30);
        } else {
            time = System.currentTimeMillis();
            sessionController.initDirectoryUserObject(credential.getUserName());
            System.err.println("initDirectoryUserObject: " + (System.currentTimeMillis() - time));
        }
        retBean.setServerTime(System.currentTimeMillis());
        retBean.setUserName(credential.getUserName());
        return retBean;
    }

    public String getEncodedNTPassword(SessionController sessionController, CredentialObject credential) throws RemoteException, Exception {
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        String ntPassword = cm.getNtPassword(sessionController, credential.getUserName());
        return ntPassword;
    }

    public void changeAgorumPassword(SessionController sessionController, DirectoryUserObjectClientBean user, String encodedPassword) throws RemoteException, Exception {
        RoiCredentialManager cm = new RoiCredentialManager();
        cm.changeAgorumPassword(sessionController, encodedPassword, user);
    }

    public Object getAttributeArray(SessionController sessionController, String tablename, String dataType, String valueType, Long objectId, Long attributeId) throws RemoteException, Exception {
        Object o = null;
        AttributeValueArrayDBUtils avdbu = new AttributeValueArrayDBUtils();
        o = avdbu.getAttributeArrayFromDB(sessionController, tablename, dataType, valueType, objectId, attributeId);
        return o;
    }

    public FormatObjectClientBean getFormatByExtension(SessionController sessionController, String extension) throws RemoteException, Exception {
        ApplicationHashtable allFormatObjects = sessionController.getAllFormatObjects();
        if (extension == null || !allFormatObjects.containsKey(extension.toUpperCase())) {
            if (extension != null && System.currentTimeMillis() - lastFormatSelectTime > 60000L) {
                lastFormatSelectTime = System.currentTimeMillis();
                SuperObjectClientBean[] formatObject = sessionController.getSuperObjectByAttribute(sessionController, FormatObjectClientBean.EXTENSION_ATTRIBUTE, extension, true, sessionController.getClassObject(FormatObjectClientBean.CLASS_NAME));
                if (formatObject != null && formatObject.length > 0) {
                    FormatObjectClientBean focb = (FormatObjectClientBean)formatObject[0];
                    allFormatObjects.put(extension.toUpperCase(), focb);
                    StartupInitializer.addFormat(extension, focb);
                    System.err.println("FormatObjects reinitialized for " + extension);
                }
                if (extension == null || !allFormatObjects.containsKey(extension.toUpperCase())) {
                    extension = "UNKNOWN FORMAT";
                }
            } else {
                extension = "UNKNOWN FORMAT";
            }
        }
        extension = extension.toUpperCase();
        FormatObjectClientBean format = (FormatObjectClientBean)allFormatObjects.get(sessionController, extension);
        return format;
    }

    public FormatObjectClientBean getFormatByMimeType(SessionController sessionController, String mimeType) throws RemoteException, Exception {
        SuperObjectClientBean[] formatObject;
        if (mimeType != null && (formatObject = sessionController.getSuperObjectByAttribute(sessionController, FormatObjectClientBean.MIMETYPE_ATTRIBUTE, mimeType, true, sessionController.getClassObject(FormatObjectClientBean.CLASS_NAME))) != null && formatObject.length > 0) {
            FormatObjectClientBean focb = (FormatObjectClientBean)formatObject[0];
            return focb;
        }
        return null;
    }

    public SuperObjectClientBean[] getSuperObjectByAttributes(SessionController sessionController, ClassObjectClientBean classObject, String[] attributeName, Object[] value, int[] qualification, boolean[] ignorecase, int[] clause, String[] sortAttribute, int[] sortOrder, int limit) throws RemoteException, Exception {
        int i;
        SuperObjectClientBean[] soRet = null;
        ClassObjectClientBean coRoot = sessionController.getRootClassObjectFromClassId(classObject.getId());
        Long[] attClassIDs = null;
        ClassObjectClientBean[] attClassObjects = null;
        Hashtable<String, ClassObjectClientBean> classNameHash = new Hashtable<String, ClassObjectClientBean>();
        classNameHash.put(coRoot.getName(), coRoot);
        Vector<String> classNameVec = new Vector<String>();
        classNameVec.addElement(coRoot.getName());
        if (!classNameHash.containsKey(classObject.getName())) {
            classNameHash.put(classObject.getName(), classObject);
            classNameVec.addElement(classObject.getName());
        }
        int lenAttr = 0;
        if (attributeName != null) {
            lenAttr = attributeName.length;
            attClassIDs = new Long[lenAttr];
            attClassObjects = new ClassObjectClientBean[lenAttr];
            for (int i2 = 0; i2 < lenAttr; ++i2) {
                String attrName = attributeName[i2].toUpperCase();
                if (attrName.equals("ID")) {
                    attClassIDs[i2] = classObject.getId();
                    attClassObjects[i2] = classObject;
                } else {
                    attClassIDs[i2] = sessionController.findClassIdByAttribute(attrName, classObject.getId());
                    attClassObjects[i2] = sessionController.getClassObject(attClassIDs[i2]);
                }
                if (classNameHash.containsKey(attClassObjects[i2].getName())) continue;
                classNameHash.put(attClassObjects[i2].getName(), attClassObjects[i2]);
                classNameVec.addElement(attClassObjects[i2].getName());
            }
        }
        SearchClass sc = new SearchClass(sessionController);
        sc.setLimit(limit);
        int len = classNameVec.size();
        String[] classNameArr = new String[len];
        for (i = 0; i < len; ++i) {
            classNameArr[i] = (String)classNameVec.elementAt(i);
        }
        sc.setClassname(classNameArr);
        for (i = 1; i < len; ++i) {
            sc.setJoin(classNameArr[i - 1], null, classNameArr[i], null);
            if (i <= 1) continue;
            sc.setSearchClauseAND();
        }
        if (attributeName != null) {
            len = attributeName.length;
            for (i = 0; i < len; ++i) {
                Hashtable effectiveAttributes = attClassObjects[i].getEffectiveAttributes();
                String colName = "ID".equals(attributeName[i]) ? "ID" : ((AttributeObjectClientBean)effectiveAttributes.get(attributeName[i])).getDataBaseObjectName();
                sc.setAttributeData(attClassObjects[i].getName(), colName, value[i], qualification[i], ignorecase[i]);
                sc.setSearchClause(clause[i]);
            }
            int lenC = clause.length;
            for (int i3 = len; i3 < lenC; ++i3) {
                sc.setSearchClause(clause[i3]);
            }
        }
        String[] sortClassnames = null;
        String[] sortCols = null;
        int lenAttrSort = 0;
        if (sortAttribute != null) {
            lenAttrSort = sortAttribute.length;
            sortClassnames = new String[lenAttrSort];
            sortCols = new String[lenAttrSort];
            for (int i4 = 0; i4 < lenAttrSort; ++i4) {
                ClassObjectClientBean co = sessionController.getClassObject(sessionController.findClassIdByAttribute(sortAttribute[i4].toUpperCase(), classObject.getId()));
                sortClassnames[i4] = co.getName();
                AttributeObjectClientBean ao = (AttributeObjectClientBean)co.getEffectiveAttributes().get(sortAttribute[i4].toUpperCase());
                sortCols[i4] = ao.getDataBaseObjectName();
            }
        }
        if (sortClassnames != null && sortAttribute != null && sortOrder != null) {
            sc.setSortSpezification(sortClassnames, sortCols, sortOrder);
        }
        sc.openSearch(coRoot.getName());
        if (coRoot.getDataBaseObjectName().equalsIgnoreCase(GlobalObjectClientBean.CLASS_NAME)) {
            soRet = sc.getItems();
        } else if (coRoot.getName().equalsIgnoreCase(InternalObjectClientBean.CLASS_NAME)) {
            soRet = sc.getItemsInternalObject();
        } else if (coRoot.getName().equalsIgnoreCase(DataBaseObjectClientBean.CLASS_NAME)) {
            soRet = sc.getItemsDataBaseObject();
        }
        return soRet;
    }

    public SuperObjectClientBean[] getSuperObjectByAttribute(SessionController sessionController, String attributeName, Object value, boolean ignoreCase, ClassObjectClientBean classObject) throws RemoteException, Exception {
        return this.getSuperObjectByAttribute(sessionController, attributeName, value, ignoreCase, "=", classObject);
    }

    public SuperObjectClientBean[] getSuperObjectByAttribute(SessionController sessionController, String attributeName, Object value, boolean ignoreCase, String operator, ClassObjectClientBean classObject) throws RemoteException, Exception {
        String[] classArr;
        long time = System.currentTimeMillis();
        SuperObjectClientBean[] soRet = null;
        ClassObjectClientBean coRoot = sessionController.getRootClassObjectFromClassId(classObject.getId());
        long time1 = System.currentTimeMillis();
        time = System.currentTimeMillis();
        Long attClassID = sessionController.findClassIdByAttribute(attributeName.toUpperCase(), classObject.getId());
        time1 = System.currentTimeMillis();
        time = System.currentTimeMillis();
        ClassObjectClientBean coAtt = sessionController.getClassObject(attClassID);
        time1 = System.currentTimeMillis();
        time = System.currentTimeMillis();
        SearchClass sc = new SearchClass(sessionController);
        sc.setBindOn();
        time1 = System.currentTimeMillis();
        boolean setNoAnd = true;
        if (attClassID.longValue() != classObject.getId().longValue() && attClassID.longValue() != coRoot.getId().longValue()) {
            classArr = new String[]{coRoot.getName(), coAtt.getName(), classObject.getName()};
            sc.setClassname(classArr);
            sc.setJoin(classArr[0], null, classArr[1], null);
            sc.setJoin(classArr[1], null, classArr[2], null);
            sc.setSearchClauseAND();
        } else if (classObject.getId().longValue() != coRoot.getId().longValue()) {
            classArr = new String[]{coRoot.getName(), classObject.getName()};
            sc.setClassname(classArr);
            sc.setJoin(classArr[0], null, classArr[1], null);
        } else {
            classArr = new String[]{coRoot.getName()};
            sc.setClassname(classArr);
            setNoAnd = false;
        }
        time1 = System.currentTimeMillis();
        AttributeObjectClientBean ao = (AttributeObjectClientBean)coAtt.getEffectiveAttributes().get(attributeName.toUpperCase());
        String colName = ao.getDataBaseObjectName();
        if (value != null) {
            if (value instanceof String && ((String)value).indexOf("%") >= 0) {
                sc.setAttributeLIKE(coAtt.getName(), colName, value, ignoreCase);
            } else if (operator.equals("=")) {
                sc.setAttributeEQUAL(coAtt.getName(), colName, value, ignoreCase);
            } else if (operator.equals(">")) {
                sc.setAttributeGREATER_THAN(coAtt.getName(), colName, value, ignoreCase);
            } else if (operator.equals("<")) {
                sc.setAttributeLESS_THAN(coAtt.getName(), colName, value, ignoreCase);
            } else if (operator.equals(">=")) {
                sc.setAttributeGREATER_THAN_EQUAL(coAtt.getName(), colName, value, ignoreCase);
            } else if (operator.equals("<=")) {
                sc.setAttributeLESS_THAN_EQUAL(coAtt.getName(), colName, value, ignoreCase);
            }
            if (setNoAnd) {
                sc.setSearchClauseAND();
            }
        }
        time1 = System.currentTimeMillis();
        sc.openSearch(coRoot.getName());
        time1 = System.currentTimeMillis();
        if (coRoot.getDataBaseObjectName().equalsIgnoreCase(GlobalObjectClientBean.CLASS_NAME)) {
            time = System.currentTimeMillis();
            soRet = sc.getItems();
            time1 = System.currentTimeMillis();
        } else if (coRoot.getName().equalsIgnoreCase(InternalObjectClientBean.CLASS_NAME)) {
            soRet = sc.getItemsInternalObject();
        } else if (coRoot.getName().equalsIgnoreCase(DataBaseObjectClientBean.CLASS_NAME)) {
            soRet = sc.getItemsDataBaseObject();
        }
        return soRet;
    }

    public void createCredential(SessionController sessionController, CredentialObject credential, CredentialCallerBean credentialCaller) throws RemoteException, Exception {
        CredentialConfig config = BaseCredentialManager.getCredentialConfig(credential.getCredentialManager());
        CredentialManager cm = BaseCredentialManager.getCredentialManager(config);
        cm.createCredential(sessionController, credential, credentialCaller);
    }

    public void changeCredential(SessionController sessionController, String userName, String oldCredential, String newCredential) throws RemoteException, Exception {
        System.err.println("Change the credential manager from " + oldCredential + " to " + newCredential);
        CredentialConfig oldConfig = BaseCredentialManager.getCredentialConfig(oldCredential);
        CredentialManager oldCM = BaseCredentialManager.getCredentialManager(oldConfig);
        CredentialConfig newConfig = BaseCredentialManager.getCredentialConfig(newCredential);
        CredentialManager newCM = BaseCredentialManager.getCredentialManager(newConfig);
        CredentialInfoBean credInfo = null;
        try {
            credInfo = oldCM.getCredentialInfo(sessionController, userName);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e, "The credential for user '" + userName + "' could could not be found in the credential manager '" + oldCredential + "'. Please enter a password to recreate the credential.", "agorum.roi.remote.exception.CredentialNotFound", 34);
        }
        oldCM.cleanUpCredential(sessionController, userName);
        newCM.setCredentialInfo(sessionController, credInfo);
    }

    public void changeAliases(SessionController sessionController, String userName, String[] aliases) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        cm.changeAliases(sessionController, userName, aliases);
    }

    public String[] getAliases(SessionController sessionController, String userName) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        return cm.getAliases(sessionController, userName);
    }

    public void changePassword(SessionController sessionController, String userName, String password, CredentialCallerBean credentialCaller) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        cm.changePassword(sessionController, userName, password, credentialCaller);
    }

    public void setPasswordsDirect(SessionController sessionController, String userName, String password, String lmHash, String ntHash, CredentialCallerBean credentialCaller, DirectoryUserObjectClientBean user) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        cm.setLMAndNTHashes(sessionController, userName, lmHash, ntHash, credentialCaller);
        ((BaseCredentialManager)cm).changeAgorumPassword(sessionController, password, user);
    }

    public void setLMAndNTHashes(SessionController sessionController, String userName, String lmHash, String ntHash, CredentialCallerBean credentialCaller) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        cm.setLMAndNTHashes(sessionController, userName, lmHash, ntHash, credentialCaller);
    }

    public boolean updatePasswords(SessionController sessionController, DirectoryUserObjectClientBean du) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(du.getName());
        BaseCredentialManager cm = (BaseCredentialManager)BaseCredentialManager.getCredentialManager(credential);
        return cm.updatePasswords(sessionController, du);
    }

    public void changePasswordToDes(SessionController sessionController, String userName) throws RemoteException, Exception {
        CredentialObject credential = new CredentialObject();
        credential.setUserName(userName);
        CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
        cm.changePasswordToDes(sessionController, userName);
    }

    public void changeDistinguisheName(SessionController sessionController, String oldUserName, String newUserName, CredentialCallerBean credentialCaller) throws RemoteException, Exception {
        if (oldUserName != null && newUserName != null && !oldUserName.equals(newUserName)) {
            CredentialObject credential = new CredentialObject();
            credential.setUserName(oldUserName);
            CredentialManager cm = BaseCredentialManager.getCredentialManager(credential);
            cm.changeDistinguisheName(sessionController, oldUserName, newUserName, credentialCaller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateClassObject(SessionController sessionController, SuperObjectClientBeanDefinition def, ClassObjectClientBean classObject) throws RemoteException, Exception {
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        String alterTableStmt = "";
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            ClassObjectClientBeanDefinition classDef = (ClassObjectClientBeanDefinition)def;
            Vector vAllAttributes = classDef.getAllAttributeDefinitions();
            int len = vAllAttributes.size();
            Vector<DataBaseObjectClientBean> vAttributeObjects = new Vector<DataBaseObjectClientBean>();
            for (int i = 0; i < len; ++i) {
                AttributeObjectClientBeanDefinition attrDef = (AttributeObjectClientBeanDefinition)vAllAttributes.elementAt(i);
                attrDef.setClassObject(classObject);
                vAttributeObjects.addElement(sessionController.createDataBaseObject(attrDef));
            }
            Vector<AttributeObjectClientBean> vIndex = new Vector<AttributeObjectClientBean>();
            Vector<AttributeObjectClientBean> vUnique = new Vector<AttributeObjectClientBean>();
            DatabaseUtils dbu = new DatabaseUtils();
            DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
            len = vAttributeObjects.size();
            for (int i = 0; i < len; ++i) {
                AttributeObjectClientBean attrObject = (AttributeObjectClientBean)vAttributeObjects.elementAt(i);
                alterTableStmt = dbi.getAlterTableAddColumn(classObject.getDataBaseObjectName(), attrObject);
                pstmt = conn.prepareStatement(alterTableStmt);
                pstmt.execute();
                pstmt.close();
                pstmt = null;
                if (attrObject.getIndexed()) {
                    vIndex.addElement(attrObject);
                }
                if (!attrObject.getIsUnique()) continue;
                vUnique.addElement(attrObject);
            }
            this.createIndexToTable(dbi, vIndex, classObject, conn, (PreparedStatement)pstmt, "IDX_", false);
            this.createIndexToTable(dbi, vUnique, classObject, conn, (PreparedStatement)pstmt, "UNIQUE_", true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            message = message + "\nStatement : \n" + alterTableStmt;
            ExceptionUtils.handleException(message, "agorum.roi.remote.exception.UnKnown", 1);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createClassObject(SessionController sessionController, SuperObjectClientBeanDefinition def, ClassObjectClientBean classObject) throws RemoteException, Exception {
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        String createTableStmt = "";
        try {
            ClassObjectClientBeanDefinition classDef = (ClassObjectClientBeanDefinition)def;
            Vector vAllAttributes = classDef.getAllAttributeDefinitions();
            int len = vAllAttributes.size();
            Vector<DataBaseObjectClientBean> vAttributeObjects = new Vector<DataBaseObjectClientBean>();
            for (int i = 0; i < len; ++i) {
                AttributeObjectClientBeanDefinition attrDef = (AttributeObjectClientBeanDefinition)vAllAttributes.elementAt(i);
                attrDef.setClassObject(classObject);
                vAttributeObjects.addElement(sessionController.createDataBaseObject(attrDef));
            }
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            Vector<AttributeObjectClientBean> vIndex = new Vector<AttributeObjectClientBean>();
            Vector<AttributeObjectClientBean> vUnique = new Vector<AttributeObjectClientBean>();
            DatabaseUtils dbu = new DatabaseUtils();
            DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
            createTableStmt = dbi.getCreateTableBeginStatement(classObject.getDataBaseObjectName());
            len = vAttributeObjects.size();
            for (int i = 0; i < len; ++i) {
                createTableStmt = createTableStmt + ",";
                AttributeObjectClientBean attrObject = (AttributeObjectClientBean)vAttributeObjects.elementAt(i);
                String dataType = attrObject.getDataType();
                createTableStmt = createTableStmt + dbi.getTableAttribute(dataType, attrObject);
                if (attrObject.getIndexed()) {
                    vIndex.addElement(attrObject);
                }
                if (!attrObject.getIsUnique()) continue;
                vUnique.addElement(attrObject);
            }
            createTableStmt = createTableStmt + dbi.getCreateTableEndStatement(classObject.getDataBaseObjectName());
            pstmt = conn.prepareStatement(createTableStmt);
            pstmt.execute();
            pstmt.close();
            pstmt = null;
            String primaryKeyStatement = dbi.getPrimaryKeyStatement(classObject.getDataBaseObjectName());
            if (primaryKeyStatement != null) {
                pstmt = conn.prepareStatement(primaryKeyStatement);
                pstmt.execute();
                pstmt.close();
                pstmt = null;
            }
            this.createIndexToTable(dbi, vIndex, classObject, conn, (PreparedStatement)pstmt, "IDX_", false);
            this.createIndexToTable(dbi, vUnique, classObject, conn, (PreparedStatement)pstmt, "UNIQUE_", true);
        }
        catch (Exception e) {
            String message = e.getMessage();
            message = message + "\nStatement : \n" + createTableStmt;
            ExceptionUtils.handleException(message, "agorum.roi.remote.exception.UnKnown", 1);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    private void createIndexToTable(DatabaseInterface dbi, Vector vIndex, ClassObjectClientBean classObject, Connection conn, PreparedStatement pstmt, String indexNameOffset, boolean isUnique) throws Exception {
        int len = vIndex.size();
        for (int i = 0; i < len; ++i) {
            AttributeObjectClientBean attributeObjectClientBean = (AttributeObjectClientBean)vIndex.elementAt(i);
            String createIndexStatement = dbi.getCreateIndexStatement(classObject.getDataBaseObjectName(), indexNameOffset + attributeObjectClientBean.getId(), attributeObjectClientBean.getIndexedDataBaseObjects() == null || attributeObjectClientBean.getIndexedDataBaseObjects() != null && attributeObjectClientBean.getIndexedDataBaseObjects().length() < 1 ? attributeObjectClientBean.getDataBaseObjectName().toUpperCase() : attributeObjectClientBean.getIndexedDataBaseObjects().toUpperCase(), isUnique);
            if (createIndexStatement == null) continue;
            pstmt = conn.prepareStatement(createIndexStatement);
            pstmt.execute();
            pstmt.close();
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirectoryUserObjectClientBean createUser(SessionController sessionController, UserManagerBean userManagerBean) throws RemoteException, Exception {
        SessionController cloneSC;
        this.adminFlag = true;
        try {
            cloneSC = sessionController.clone(this);
        }
        finally {
            this.adminFlag = false;
        }
        UserManager userManager = new UserManager(cloneSC);
        return userManager.create(userManagerBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getEventAssistanceList(SessionController sessionController, String[] classNames, int amount, long after) throws RemoteException, Exception {
        ArrayList alRet = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
            alRet = eau.getUserIds(sessionController.getLoginUser().getUserSequence(), amount, classNames, after);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cu != null) {
                    cu.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
        return alRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventAssistanceEntryRead(SessionController sessionController, Long objectId) throws RemoteException, Exception {
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
            eau.deleteUserFromId(sessionController.getLoginUser().getUserSequence(), objectId);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cu != null) {
                    cu.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventAssistanceEntryUnRead(SessionController sessionController, Long objectId) throws RemoteException, Exception {
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
            eau.addUserToId(sessionController.getLoginUser().getUserSequence(), objectId);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cu != null) {
                    cu.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventAssistanceDeleteExpirationObjects(SessionController sessionController) throws RemoteException, Exception {
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
            eau.deleteExpirationObjects();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cu != null) {
                    cu.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEventAssistanceAllRead(SessionController sessionController) throws RemoteException, Exception {
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            EventAssistanceUtils eau = new EventAssistanceUtils(cu.getConnection());
            eau.deleteUserFromAllIds(sessionController.getLoginUser().getUserSequence());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (cu != null) {
                    cu.closeConnection();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeDBSize(SessionController sessionController) throws RemoteException, Exception {
        Connection conn = null;
        ConnectionUtils cu = null;
        long lFreeDBSize = -1L;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            lFreeDBSize = sessionController.getTotalDbSize() - dbi.getDbSize(conn);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return lFreeDBSize;
    }

    public long getDbSize(SessionController sessionController) throws RemoteException, Exception {
        if (staticDbSize == -1L) {
            SystemSessionEJB.getDbSizeInternal();
            SystemTimer.ofPeriod((long)600000L).name("DbSizeUpdateTimer").call((Runnable)new DbSizeUpdateTimer());
        }
        return staticDbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void getDbSizeInternal() throws RemoteException, Exception {
        Connection conn = null;
        ConnectionUtils cu = null;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        try {
            cu = new ConnectionUtils();
            conn = cu.getConnection();
            staticDbSize = dbi.getDbSize(conn);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexCounter(SessionController sessionController) throws RemoteException, Exception {
        int indexCount = -1;
        Connection conn = null;
        Statement ps = null;
        ConnectionUtils cu = null;
        ResultSet rs = null;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            ps = conn.prepareStatement("select ifnull(max(sortid) - (min(sortid) - 1),0) from totextindex");
            rs = ps.executeQuery();
            if (rs != null && rs.next()) {
                indexCount = rs.getInt(1);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                ps.close();
                ps = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return indexCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Long> getAllTableCount(SessionController sessionController) throws RemoteException, Exception {
        Hashtable<String, Long> hRet = new Hashtable<String, Long>();
        ConnectionUtils cu = null;
        Vector<String> allTables = new Vector<String>();
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        allTables.addElement(dbi.getAvBooleanArrayTableName());
        allTables.addElement(dbi.getAvDateArrayTableName());
        allTables.addElement(dbi.getAvDirectoryObjectArrayTableName());
        allTables.addElement(dbi.getAvDoubleArrayTableName());
        allTables.addElement(dbi.getAvIntegerArrayTableName());
        allTables.addElement(dbi.getAvLongArrayTableName());
        allTables.addElement(dbi.getAvGlobalobjectArrayTableName());
        allTables.addElement(dbi.getAvDatabaseObjectArrayTableName());
        allTables.addElement(dbi.getAvStringArrayTableName());
        allTables.addElement(dbi.getAvInternalObjectArrayTableName());
        allTables.addElement("ACLUSERTABLE");
        allTables.addElement("ACLOBJECTTABLE");
        if (sessionController.getLoginUser() != null && sessionController.isAdminEnabled()) {
            cu = new ConnectionUtils(sessionController);
            Connection conn = null;
            Statement ps = null;
            Statement ps2 = null;
            ResultSet rs = null;
            ResultSet rs2 = null;
            try {
                String tableName;
                conn = cu.getConnection();
                long userId = sessionController.getLoginUser().getId();
                ClassObjectClientBean co = sessionController.getClassObject(ClassObjectClientBean.CLASS_NAME);
                Hashtable effectiveAttributes = co.getEffectiveAttributes();
                AttributeObjectClientBean attribute = (AttributeObjectClientBean)effectiveAttributes.get(ClassObjectClientBean.DATABASEOBJECTNAME_ATTRIBUTE);
                AttributeValue av = co.getAttribute(ClassObjectClientBean.DATABASEOBJECTNAME_ATTRIBUTE);
                String select = "select " + attribute.getDataBaseObjectName() + " from " + co.getDataBaseObjectName();
                ps = conn.prepareStatement(select);
                rs = ps.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        tableName = rs.getString(1);
                        allTables.addElement(tableName);
                    }
                    rs.close();
                    rs = null;
                }
                ps.close();
                ps = null;
                co = sessionController.getClassObject(FormatObjectClientBean.CLASS_NAME);
                effectiveAttributes = co.getEffectiveAttributes();
                attribute = (AttributeObjectClientBean)effectiveAttributes.get(FormatObjectClientBean.TABLENAME_ATTRIBUTE);
                select = "select distinct " + attribute.getDataBaseObjectName() + " from " + co.getDataBaseObjectName();
                ps = conn.prepareStatement(select);
                rs = ps.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        tableName = rs.getString(1);
                        allTables.addElement(tableName);
                    }
                    rs.close();
                    rs = null;
                }
                ps.close();
                ps = null;
                if (allTables != null) {
                    int len = allTables.size();
                    for (int i = 0; i < len; ++i) {
                        ps2 = conn.prepareStatement("select count(*) from " + (String)allTables.elementAt(i));
                        rs2 = ps2.executeQuery();
                        if (rs2 != null) {
                            rs2.next();
                            hRet.put((String)allTables.elementAt(i), new Long(rs2.getLong(1)));
                        }
                        if (rs2 != null) {
                            rs2.close();
                            rs2 = null;
                        }
                        ps2.close();
                        ps2 = null;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                try {
                    rs.close();
                    rs = null;
                }
                catch (Exception exception) {}
                try {
                    rs2.close();
                    rs2 = null;
                }
                catch (Exception exception) {}
                try {
                    ps.close();
                    ps = null;
                }
                catch (Exception exception) {}
                try {
                    ps2.close();
                    ps2 = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        return hRet;
    }

    public DirectoryUserObjectClientBean getDirectoryUserFromEmailAddress(SessionController sessionController, String emailAddress) throws RemoteException, Exception {
        DirectoryUserObjectClientBean user = null;
        SearchClass sc = new SearchClass(sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME, EmailUserProfileObjectClientBean.CLASS_NAME});
        sc.setBindOn();
        sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, EmailUserProfileObjectClientBean.CLASS_NAME, null);
        sc.setAttributeEQUAL(EmailUserProfileObjectClientBean.CLASS_NAME, EmailUserProfileObjectClientBean.EMAILADDRESS_ATTRIBUTE, (Object)emailAddress.toLowerCase(), false);
        sc.setSearchClauseAND();
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        GlobalObjectClientBean[] cb = sc.getItems();
        sc.closeSearch();
        if (cb != null && cb.length == 1) {
            EmailUserProfileObjectClientBean ep = (EmailUserProfileObjectClientBean)cb[0];
            user = ep.getDirectoryUserObject(sessionController);
        }
        return user;
    }

    public boolean isObjectExistant(SessionController sessionController, String className, String name) throws RemoteException, Exception {
        int count = 0;
        try {
            SessionController scAdmin = SessionControllerAdmin.getSessionControllerAdmin(sessionController, "UserAdminTmpMode");
            ClassObjectClientBean classObject = scAdmin.getClassObject(className);
            count = scAdmin.getSuperObjectByAttribute(sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, classObject).length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return count != 0;
    }

    public GlobalObjectClientBean[] getMyDeletedObjects(SessionController sessionController) throws RemoteException, Exception {
        GlobalObjectClientBean[] goArr = null;
        goArr = this.getDeletedObjects(sessionController, false);
        return goArr;
    }

    public GlobalObjectClientBean[] getAllDeletedObjects(SessionController sessionController) throws RemoteException, Exception {
        GlobalObjectClientBean[] goArr = null;
        if (sessionController.isAdminEnabled()) {
            goArr = this.getDeletedObjects(sessionController, true);
        } else {
            ExceptionUtils.handleException("You need admin access to delete this object.", "agorum.roi.remote.exception.AdminAccessNeeded", 23);
        }
        return goArr;
    }

    private GlobalObjectClientBean[] getDeletedObjects(SessionController sessionController, boolean allObjects) throws Exception {
        SearchClass sc = new SearchClass(sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
        sc.setBindOn();
        if (!allObjects) {
            sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.DELETOR_ATTRIBUTE, (Object)sessionController.getLoginUser(), false);
        } else {
            sc.setAttributeNOT_EQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.DELETOR_ATTRIBUTE, (Object)new Long(0L), false);
            sc.setAttributeIS_NOT_NULL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.DELETOR_ATTRIBUTE, (Object)null, false);
            sc.setSearchClauseAND();
        }
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        GlobalObjectClientBean[] goArr = sc.getItems();
        sc.closeSearch();
        return goArr;
    }

    public AssociatedGroupOfDirectoryObject[] getAssociatedGroupOfDirectoryObject(SessionController sessionController, DirectoryObjectClientBean directoryObject, int depth, boolean unique) throws RemoteException, Exception {
        AssociatedGroupOfDirectoryObject[] associatedGroupOfDirectoryObject = null;
        Vector v = new Vector();
        this.getAssociatedGroupOfDirectoryObjectRecursiv(sessionController, directoryObject, depth, v, 1, unique);
        if (v.size() > 0) {
            int len = v.size();
            associatedGroupOfDirectoryObject = new AssociatedGroupOfDirectoryObject[len];
            for (int i = 0; i < len; ++i) {
                associatedGroupOfDirectoryObject[i] = (AssociatedGroupOfDirectoryObject)v.elementAt(i);
            }
        }
        return associatedGroupOfDirectoryObject;
    }

    private void getAssociatedGroupOfDirectoryObjectRecursiv(SessionController sessionController, DirectoryObjectClientBean directoryObject, int depth, Vector v, int depthAct, boolean unique) throws Exception {
        GlobalObjectClientBean[] leftObjects = directoryObject.getLeftwardRelationObjects(GroupMemberRelationObjectClientBean.CLASS_NAME);
        if (leftObjects != null) {
            int len = leftObjects.length;
            for (int i = 0; i < len; ++i) {
                if (leftObjects[i] == null || !(leftObjects[i] instanceof DirectoryGroupObjectClientBean)) continue;
                AssociatedGroupOfDirectoryObject agodo = new AssociatedGroupOfDirectoryObject();
                agodo.setDepth(depthAct);
                agodo.setDirectoryObjectClientBean((DirectoryObjectClientBean)leftObjects[i]);
                boolean found = false;
                if (unique) {
                    int lenV = v.size();
                    for (int k = 0; k < lenV; ++k) {
                        AssociatedGroupOfDirectoryObject agodoC = (AssociatedGroupOfDirectoryObject)v.elementAt(k);
                        if (agodoC.getDirectoryObjectClientBean().getId().longValue() != agodo.getDirectoryObjectClientBean().getId().longValue()) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    v.addElement(agodo);
                }
                if (depth == depthAct) continue;
                this.getAssociatedGroupOfDirectoryObjectRecursiv(sessionController, agodo.getDirectoryObjectClientBean(), depth, v, depthAct + 1, unique);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAclToAclObjectTable(SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        Connection conn = null;
        Statement ps = null;
        ConnectionUtils cu = null;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            ps = conn.prepareStatement("insert into ACLOBJECTTABLE (ISSCOPE,ACLID,OBJECTID) values (0,?,?)");
            ps.setLong(1, clientBean.getAcl().getId());
            ps.setLong(2, clientBean.getId());
            ps.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                ps.close();
                ps = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getScopeAclCount(SessionController sessionController, AccessControlListObjectClientBean acl) throws RemoteException, Exception {
        Connection conn = null;
        Statement ps = null;
        ConnectionUtils cu = null;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        ResultSet rs = null;
        long count = 0L;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            ps = conn.prepareStatement("select count(*) from ACLOBJECTTABLE where ISSCOPE=1 and ACLID=?");
            ps.setLong(1, acl.getId());
            rs = ps.executeQuery();
            if (rs != null) {
                rs.next();
                count = rs.getLong(1);
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                ps.close();
                ps = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessControlListObjectClientBean[] getAssociatedAclsOfDirectoryUser(SessionController sessionController, DirectoryUserObjectClientBean directoryUserObject) throws RemoteException, Exception {
        AccessControlListObjectClientBean[] acls = null;
        Connection conn = null;
        Statement ps = null;
        ConnectionUtils cu = null;
        ResultSet rs = null;
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            ps = conn.prepareStatement("select ACLID from ACLUSERTABLE where USERID=?");
            ps.setLong(1, directoryUserObject.getId());
            rs = ps.executeQuery();
            Vector<AccessControlListObjectClientBean> v = new Vector<AccessControlListObjectClientBean>();
            if (rs != null) {
                while (rs.next()) {
                    long aclId = rs.getLong(1);
                    AccessControlListObjectClientBean acl = (AccessControlListObjectClientBean)sessionController.getGlobalObjectById(new Long(aclId));
                    v.addElement(acl);
                }
                if (v.size() > 0) {
                    int len = v.size();
                    acls = new AccessControlListObjectClientBean[len];
                    for (int i = 0; i < len; ++i) {
                        acls[i] = (AccessControlListObjectClientBean)v.elementAt(i);
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                ps.close();
                ps = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return acls;
    }

    public AccessControlListObjectClientBean[] getAssociatedAclsOfDirectoryGroup(SessionController sessionController, DirectoryGroupObjectClientBean directoryGroupObject, boolean directOnly) throws RemoteException, Exception {
        int i;
        AccessControlListObjectClientBean[] acls = null;
        Hashtable<Long, AccessControlListObjectClientBean> h = new Hashtable<Long, AccessControlListObjectClientBean>();
        DirectoryGroupObjectClientBean[] allGroups = null;
        if (directOnly) {
            allGroups = new DirectoryGroupObjectClientBean[]{directoryGroupObject};
        } else {
            AssociatedGroupOfDirectoryObject[] allAss = this.getAssociatedGroupOfDirectoryObject(sessionController, directoryGroupObject, 0, true);
            int len = 1;
            if (allAss != null) {
                len += allAss.length;
            }
            allGroups = new DirectoryGroupObjectClientBean[len];
            allGroups[0] = directoryGroupObject;
            for (i = 1; i < len; ++i) {
                allGroups[i] = (DirectoryGroupObjectClientBean)allAss[i - 1].getDirectoryObjectClientBean();
            }
        }
        int len = allGroups.length;
        ClassObjectClientBean classObject = sessionController.getClassObject(AccessControlEntryObjectClientBean.CLASS_NAME);
        for (i = 0; i < len; ++i) {
            SuperObjectClientBean[] allObjects = sessionController.getSuperObjectByAttribute(sessionController, AccessControlEntryObjectClientBean.GRANTEE_ATTRIBUTE, allGroups[i], false, classObject);
            if (allObjects == null) continue;
            int lenO = allObjects.length;
            for (int k = 0; k < lenO; ++k) {
                AccessControlEntryObjectClientBean entry;
                AccessControlListObjectClientBean acl;
                if (!(allObjects[k] instanceof AccessControlEntryObjectClientBean) || h.containsKey((acl = (entry = (AccessControlEntryObjectClientBean)allObjects[k]).getAcl()).getId())) continue;
                h.put(acl.getId(), acl);
            }
        }
        if (h.size() > 0) {
            len = h.size();
            acls = new AccessControlListObjectClientBean[len];
            Enumeration en = h.keys();
            int i2 = 0;
            while (en.hasMoreElements()) {
                Long key = (Long)en.nextElement();
                acls[i2] = (AccessControlListObjectClientBean)h.get(key);
                ++i2;
            }
        }
        return acls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserNameByAliasName(SessionController sessionController, String aliasName) throws Exception {
        String userName = null;
        if (aliasName != null && aliasName.length() > 0) {
            Connection conn = null;
            Statement ps = null;
            ConnectionUtils cu = null;
            ResultSet rs = null;
            try {
                cu = new ConnectionUtils(sessionController);
                conn = cu.getConnection();
                ps = conn.prepareStatement("select DISTINGUISHEDNAME from ROICREDENTIALALIASES where ALIAS=?");
                ps.setString(1, aliasName.toUpperCase());
                rs = ps.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        userName = rs.getString(1);
                    }
                }
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
            finally {
                try {
                    rs.close();
                    rs = null;
                }
                catch (Exception exception) {}
                try {
                    ps.close();
                    ps = null;
                }
                catch (Exception exception) {}
                try {
                    cu.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        return userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performanceTestDb(SessionController sessionController, Map<String, PerformanceValueHolder> times, SystemCheck systemCheck) throws RemoteException, Exception {
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection conn = cu.getConnection();){
            DatabaseUtils du = new DatabaseUtils();
            DatabaseInterface di = du.getDatabaseInterfaceImpl();
            try (Transaction t2 = new Transaction();){
                if (di.tableExists(conn, "performancetesttable")) {
                    TestDbPerformanceUtil.dropTestTable(conn);
                    if (systemCheck.abortRequired()) {
                        throw new SystemTaskAbortedException();
                    }
                }
                t2.commit();
            }
            catch (Exception t2) {
                // empty catch block
            }
            for (int pass = 0; pass < 3; ++pass) {
                systemCheck.info("Loop " + (pass + 1) + "/3: Preparing: creating test table");
                systemCheck.info("Preparing: creating test table");
                try (Transaction t = new Transaction();){
                    TestDbPerformanceUtil.createTestTable(conn);
                    t.commit();
                }
                try {
                    PerformanceValueHolder pvh;
                    long time = 0L;
                    try (Transaction t = new Transaction();){
                        time = System.currentTimeMillis();
                        systemCheck.info().detail((Object)"folder selects within agorum core structure").send("Performing test 1");
                        TestDbPerformanceUtil.testDbACSelects(conn, 5000);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        pvh = new PerformanceValueHolder();
                        pvh.detail = "Folder selects within agorum core structure";
                        pvh.title = "Test 1";
                        pvh.performanceReferenceValue = 8000.0;
                        pvh.unit = "op/sec";
                        TestDbPerformanceUtil.collectPerformance("Test 1, folder selects within agorum core structure", time, 5000L, times, pvh);
                        t.commit();
                    }
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing many inserts").send("Performing test 2");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbManyInserts(conn, false, false, 10000, false);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing many inserts";
                    pvh.title = "Test 2";
                    pvh.performanceReferenceValue = 18000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 2, performing many inserts", time, 10000L, times, pvh);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing many selects").send("Performing test 3");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbManySelects(conn, 10000, 10000);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing many selects";
                    pvh.title = "Test 3";
                    pvh.performanceReferenceValue = 17000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 3, performing many selects", time, 10000L, times, pvh);
                    TestDbPerformanceUtil.testDbTruncate(conn);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing many inserts 2").send("Performing test 4");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbManyInserts2(conn, false, false, 10000);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing many inserts 2";
                    pvh.title = "Test 4";
                    pvh.performanceReferenceValue = 18000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 4, performing many inserts 2", time, 10000L, times, pvh);
                    TestDbPerformanceUtil.testDbTruncate(conn);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing inserts with blobs").send("Performing test 5");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbBlobInserts(conn, false, false, 250);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing inserts with blobs";
                    pvh.title = "Test 5";
                    pvh.performanceReferenceValue = 70.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 5, performing inserts with blobs", time, 250L, times, pvh);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing blob selects").send("Performing test 6");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbBlobSelects(conn, 1000, 1000);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing blob selects";
                    pvh.title = "Test 6";
                    pvh.performanceReferenceValue = 1000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 6, performing blob selects", time, 1000L, times, pvh);
                    TestDbPerformanceUtil.testDbTruncate(conn);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"performing many inserts with commits for each statement").send("Performing test 7");
                    TestDbPerformanceUtil.testDbManyInserts(conn, false, false, 1000, true);
                    if (systemCheck.abortRequired()) {
                        throw new SystemTaskAbortedException();
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Performing many inserts with commits for each statement";
                    pvh.title = "Test 7";
                    pvh.performanceReferenceValue = 2000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 7, performing many inserts with commits for each statement", time, 1000L, times, pvh);
                    TestDbPerformanceUtil.testDbTruncate(conn);
                    time = System.currentTimeMillis();
                    systemCheck.info().detail((Object)"network latency test (if this is slow, then there is an issue with you network connection to your database)").send("Performing test 8");
                    t = new Transaction();
                    var14_27 = null;
                    try {
                        TestDbPerformanceUtil.testDbSelect1(conn, 10000);
                        if (systemCheck.abortRequired()) {
                            throw new SystemTaskAbortedException();
                        }
                        t.commit();
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (t != null) {
                            if (var14_27 != null) {
                                try {
                                    t.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                t.close();
                            }
                        }
                    }
                    pvh = new PerformanceValueHolder();
                    pvh.detail = "Network latency test (if this is slow, then there is an issue with you network connection to your database or with your jdbc driver)";
                    pvh.title = "Test 8";
                    pvh.performanceReferenceValue = 35000.0;
                    pvh.unit = "op/sec";
                    TestDbPerformanceUtil.collectPerformance("Test 8, network latency test (if this is slow, then there is an issue with you network connection to your database or with your jdbc driver)", time, 10000L, times, pvh);
                    continue;
                }
                finally {
                    TestDbPerformanceUtil.dropTestTable(conn);
                }
            }
        }
        catch (SystemTaskAbortedException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public String getDatabaseDriverName(SessionController sessionController) throws RemoteException, Exception {
        ConnectionUtils cu = new ConnectionUtils(sessionController);
        try (Connection conn = cu.getConnection();){
            String string = conn.getMetaData().getDriverName();
            return string;
        }
    }

    static {
        staticDbSize = -1L;
        ROOT_FOLDER_ID = new Long(FolderObjectClientBean.ROOT_FOLDER_ID);
    }
}

