/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.roi.ejb.beans.GlobalObjectEntity;
import agorum.roi.ejb.callback.CustomFolderObjectCallBack;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDocumentObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentUtils;
import agorum.roi.ejb.common.DataBaseProperties;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class FolderDocumentObjectCallBack
extends CustomFolderObjectCallBack {
    @Override
    public void executeBeforeCreate(SessionController sessionController, SuperObjectClientBeanDefinition def) throws Exception {
        def.setAttribute(FolderDocumentObjectClientBean.CONTENT_ATTRIBUTE, AttributeValue.newAttributeValueObject(def.getId()));
        FormatObjectClientBean format = null;
        format = ((FolderDocumentObjectClientBeanDefinition)def).getFormat();
        if (format == null) {
            String name = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE).getString();
            format = sessionController.getFormatByFileName(name);
        }
        ((FolderDocumentObjectClientBeanDefinition)def).setFormat(format);
        if (def.getAttribute(GlobalObjectClientBean.ISFOLDER_ATTRIBUTE) == null) {
            ((FolderDocumentObjectClientBeanDefinition)def).setIsFolder(false);
        }
        DataBaseProperties dbp = new DataBaseProperties();
        if (def.getAttribute(FolderDocumentObjectClientBean.BLOCKSIZE_ATTRIBUTE) == null) {
            def.setAttribute(FolderDocumentObjectClientBean.BLOCKSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Long(dbp.getContentTransferBufferSize())));
        }
        AttributeValue av = def.getAttribute(FolderDocumentObjectClientBean.BLOCKSIZE_ATTRIBUTE);
        int blockSize = (int)av.getLong();
        int blockSizeMin = dbp.getContentTransferBufferSizeMin();
        int blockSizeMax = dbp.getContentTransferBufferSizeMax();
        if (blockSize > blockSizeMax || blockSize < blockSizeMin) {
            ExceptionUtils.handleException("BlockSize (" + blockSize + ") not allowed -> Min = " + blockSizeMin + ", Max = " + blockSizeMax, "agorum.roi.remote.exception.BlockSizeNotAllowed", 2007);
        }
        super.executeBeforeCreate(sessionController, def);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        AccessCounterUtils acu = new AccessCounterUtils(sessionController);
        acu.deleteAllAccessCounterUserObjects((ContentInterface)((Object)clientBean));
        acu.deleteAccessCounterObject((ContentInterface)((Object)clientBean));
        FolderDocumentObjectClientBean folderDocument = (FolderDocumentObjectClientBean)clientBean;
        ContentUtils cu = new ContentUtils(sessionController, folderDocument);
        cu.clearContent(sessionController, folderDocument.getContent(), folderDocument.getFormat().getTableName());
        super.executeBeforeDelete(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        if (((GlobalObjectClientBean)clientBean).createAccessCounterObject()) {
            AccessCounterObjectClientBeanDefinition accessDef = new AccessCounterObjectClientBeanDefinition(sessionController);
            accessDef.setAttribute("REFERENCEOBJECT", AttributeValue.newAttributeValueObject(clientBean));
            sessionController.createInternalObject(accessDef);
        }
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBeanSource, SuperObjectClientBean clientBeanDestination) throws Exception {
        ContentInterface ci = (ContentInterface)((Object)clientBeanSource);
        if (ci.supportsServerSideStreaming((GlobalObjectClientBean)clientBeanDestination)) {
            ci.streamContent((ContentInterface)((Object)clientBeanDestination));
        } else {
            ((FolderDocumentObjectClientBean)clientBeanDestination).setContent(((FolderDocumentObjectClientBean)clientBeanSource).getContentStream());
        }
        super.executeAfterCopy(sessionController, def, clientBeanSource, clientBeanDestination);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        ContentInterface ci;
        FormatObjectClientBean format;
        long oldBlockSize;
        long newBlockSize;
        AttributeValue av = def.getAttribute(FolderDocumentObjectClientBean.BLOCKSIZE_ATTRIBUTE);
        if (av != null && (newBlockSize = av.getLong()) != (oldBlockSize = ((FolderDocumentObjectClientBean)clientBean).getBlockSize()) && def.getSystemOption("FORCE_BLOCKSIZE_CHANGE") == null) {
            ExceptionUtils.handleException("Update BlockSize not implemented", "agorum.roi.remote.exception.NotImplemented", 3);
        }
        if (!Transaction.has("SILENT_CONTENT_UPDATE") && (av = def.getAttribute(FolderDocumentObjectClientBean.CONTENTSIZE_ATTRIBUTE)) != null && def.getAttribute(FolderDocumentObjectClientBean.LASTCONTENTMODIFYDATE_ATTRIBUTE) == null) {
            def.setAttribute(FolderDocumentObjectClientBean.LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(new Date()));
        }
        if ((av = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE)) != null && def.getAttribute(FolderDocumentObjectClientBean.FORMATOBJECT_ATTRIBUTE) == null && (format = (ci = (ContentInterface)((Object)clientBean)).getFormat()) != null && format.getId() == 10100L) {
            FormatObjectClientBean newFormat = sessionController.getFormatByFileName(av.getString());
            def.setAttribute(FolderDocumentObjectClientBean.FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(newFormat));
        }
        if ((av = def.getAttribute(FolderDocumentObjectClientBean.FORMATOBJECT_ATTRIBUTE)) != null) {
            ci = (ContentInterface)((Object)clientBean);
            format = ci.getFormat();
            FormatObjectClientBean newFormat = (FormatObjectClientBean)av.getInternalObjectClientBean(sessionController);
            if (!newFormat.getTableName().equalsIgnoreCase(format.getTableName())) {
                ContentUtils cu = new ContentUtils(sessionController, ci);
                cu.moveContent(ci, format.getTableName(), newFormat.getTableName());
            }
            Hashtable classIdsHash = def.getAttributes();
            Enumeration enumer = classIdsHash.keys();
            int count = 0;
            while (enumer.hasMoreElements()) {
                Long key = (Long)enumer.nextElement();
                if (key.longValue() == GlobalObjectEntity.CLASS_ID.longValue()) continue;
                count += ((Hashtable)classIdsHash.get(key)).size();
            }
            if (count <= 1) {
                def.setSystemOption("SetNoLASTMODIFYDATE", "");
            }
        }
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }
}

