/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.callback;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.common.ClassHolder;
import agorum.roi.ejb.callback.CustomRelationObjectCallBack;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.GenericRelationObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.HashMap;
import java.util.Map;

public class GenericRelationObjectCallBack
extends CustomRelationObjectCallBack {
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/genericrelation/";
    private Behavior behavior;
    private static Map<String, Class<Behavior>> behaviorCache = new HashMap<String, Class<Behavior>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeBehavior(String relationType) throws Exception {
        if (this.behavior == null) {
            Class<Behavior> behaviorClass = null;
            Map<String, Class<Behavior>> map = behaviorCache;
            synchronized (map) {
                behaviorClass = behaviorCache.get(relationType);
            }
            if (behaviorClass == null) {
                SessionController sessionController = SessionControllerHolder.sessionController;
                sessionController.reconnectIfNeeded();
                MetaDb metaDb = sessionController.getMetaDbInstance();
                String className = null;
                try {
                    String[] array = metaDb.getSimplePropertyValue(METADB_BASE + relationType + "/CallBackBehavior");
                    if (array != null && array.length > 0) {
                        className = array[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                behaviorClass = className != null ? ClassHolder.getClassInstance(className) : Behavior.class;
                Map<String, Class<Behavior>> map2 = behaviorCache;
                synchronized (map2) {
                    behaviorCache.put(relationType, behaviorClass);
                }
            }
            this.behavior = behaviorClass.newInstance();
            this.behavior.callback = this;
        }
    }

    @Override
    public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeAfterCreate(sessionController, def, clientBean);
    }

    public void executeAfterCreateDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeAfterCreate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeUpdate(sessionController, def, clientBean);
    }

    public void executeBeforeUpdateDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeBeforeUpdate(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeAfterUpdate(sessionController, def, clientBean);
    }

    public void executeAfterUpdateDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeAfterUpdate(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeCopy(sessionController, def, clientBean);
    }

    public void executeBeforeCopyDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeBeforeCopy(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBeanSource, SuperObjectClientBean clientBeanDestination) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBeanSource).getRelationType());
        this.behavior.executeAfterCopy(sessionController, def, clientBeanSource, clientBeanDestination);
    }

    public void executeAfterCopyDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBeanSource, SuperObjectClientBean clientBeanDestination) throws Exception {
        super.executeAfterCopy(sessionController, def, clientBeanSource, clientBeanDestination);
    }

    @Override
    public void executeBeforeLeaveAcl(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition, AccessControlListObjectClientBean acl) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeLeaveAcl(sessionController, clientBean, definition, acl);
    }

    public void executeBeforeLeaveAclDefault(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition, AccessControlListObjectClientBean acl) throws Exception {
        super.executeBeforeLeaveAcl(sessionController, clientBean, definition, acl);
    }

    @Override
    public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeDelete(sessionController, def, clientBean);
    }

    public void executeBeforeDeleteDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeBeforeDelete(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeDeleteToRecycling(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeDeleteToRecycling(sessionController, def, clientBean);
    }

    public void executeBeforeDeleteToRecyclingDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeBeforeDeleteToRecycling(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterDeleteToRecycling(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeAfterDeleteToRecycling(sessionController, def, clientBean);
    }

    public void executeAfterDeleteToRecyclingDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeAfterDeleteToRecycling(sessionController, def, clientBean);
    }

    @Override
    public void executeBeforeUndelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeBeforeUndelete(sessionController, def, clientBean);
    }

    public void executeBeforeUndeleteDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeBeforeUndelete(sessionController, def, clientBean);
    }

    @Override
    public void executeAfterUndelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)clientBean).getRelationType());
        this.behavior.executeAfterUndelete(sessionController, def, clientBean);
    }

    public void executeAfterUndeleteDefault(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
        super.executeAfterUndelete(sessionController, def, clientBean);
    }

    @Override
    public boolean isDeleted(SuperObjectClientBeanDefinition def, SuperObjectClientBean socb) throws Exception {
        this.initializeBehavior(((GenericRelationObjectClientBean)socb).getRelationType());
        return this.behavior.isDeleted(def, socb);
    }

    public boolean isDeletedDefault(SuperObjectClientBeanDefinition def, SuperObjectClientBean socb) throws Exception {
        return super.isDeleted(def, socb);
    }

    private static class SessionControllerHolder {
        public static SessionController sessionController;

        private SessionControllerHolder() {
        }

        static {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setModulInfo("GenericRelationObjectCallBack");
            credential.setAuthInterface(new ServiceAuthInterface());
            try {
                sessionController = SessionController.connect(credential);
            }
            catch (Exception e) {
                System.err.println("FATAL: GenericRelation session controller could not be initialized");
                e.printStackTrace();
            }
        }
    }

    public static class Behavior {
        private GenericRelationObjectCallBack callback;

        public void executeAfterCreate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeAfterCreateDefault(sessionController, def, clientBean);
        }

        public void executeBeforeUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeBeforeUpdateDefault(sessionController, def, clientBean);
        }

        public void executeAfterUpdate(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeAfterUpdateDefault(sessionController, def, clientBean);
        }

        public void executeBeforeCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeBeforeCopyDefault(sessionController, def, clientBean);
        }

        public void executeAfterCopy(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBeanSource, SuperObjectClientBean clientBeanDestination) throws Exception {
            this.callback.executeAfterCopyDefault(sessionController, def, clientBeanSource, clientBeanDestination);
        }

        public void executeBeforeLeaveAcl(SessionController sessionController, SuperObjectClientBean clientBean, SuperObjectClientBeanDefinition definition, AccessControlListObjectClientBean acl) throws Exception {
            this.callback.executeBeforeLeaveAclDefault(sessionController, clientBean, definition, acl);
        }

        public void executeBeforeDelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeBeforeDeleteDefault(sessionController, def, clientBean);
        }

        public void executeBeforeDeleteToRecycling(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeBeforeDeleteToRecyclingDefault(sessionController, def, clientBean);
        }

        public void executeAfterDeleteToRecycling(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeAfterDeleteToRecyclingDefault(sessionController, def, clientBean);
        }

        public void executeBeforeUndelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeBeforeUndeleteDefault(sessionController, def, clientBean);
        }

        public void executeAfterUndelete(SessionController sessionController, SuperObjectClientBeanDefinition def, SuperObjectClientBean clientBean) throws Exception {
            this.callback.executeAfterUndeleteDefault(sessionController, def, clientBean);
        }

        public boolean isDeleted(SuperObjectClientBeanDefinition def, SuperObjectClientBean socb) throws Exception {
            return this.callback.isDeletedDefault(def, socb);
        }
    }
}

