/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.ContentHashObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.util.annotations.ObjDoc;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.Date;

@ObjDoc(groups={ObjDoc.Group.FILE}, description="Client Bean for the ContentHashObject Class")
public class ContentHashObjectClientBean
extends InternalObjectClientBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static String CLASS_NAME = "CONTENTHASHOBJECT";
    public static String IDENT_ATTRIBUTE = "IDENT";
    public static String HASH_ATTRIBUTE = "HASH";
    public static String LASTCONTENTMODIFYDATE_ATTRIBUTE = "LASTCONTENTMODIFYDATE";
    public static String CHUNKNUMBER_ATTRIBUTE = "CHUNKNUMBER";
    public static String CONTENTOBJECT_ATTRIBUTE = "CONTENTOBJECT";

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new ContentHashObjectClientBeanDefinition(sessionController);
    }

    public void setIdent(String value) throws Exception {
        this.setAttribute(IDENT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setHash(String value) throws Exception {
        this.setAttribute(HASH_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setLastContentModifyDate(Date value) throws Exception {
        this.setAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setChunkNumber(Long value) throws Exception {
        this.setAttribute(CHUNKNUMBER_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setContentObject(GlobalObjectClientBean value) throws Exception {
        this.setAttribute(CONTENTOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the identifier for the type of hash")
    public String getIdent() throws Exception {
        return this.getAttribute(IDENT_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the hash value")
    public String getHash() throws Exception {
        return this.getAttribute(HASH_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the date of the contentobject when this has had been created")
    public Date getLastContentModifyDate() throws Exception {
        return this.getAttribute(LASTCONTENTMODIFYDATE_ATTRIBUTE).getDate();
    }

    @ObjDocAttribute(value="the number of the chunk, where this hash belongs to (-1 if for whole content object)")
    public long getChunkNumber() throws Exception {
        return this.getAttribute(CHUNKNUMBER_ATTRIBUTE).getLong();
    }

    @ObjDocAttribute(value="the associated contentobject")
    public GlobalObjectClientBean getContentObject() throws Exception {
        return this.getAttribute(CONTENTOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @Override
    public int makeAuditEntry() {
        return AuditUtil.ACTION_EXT_NORMAL;
    }
}

