/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.client.beans;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CheckUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.remote.RelationObjectRemote;
import agorum.roi.util.annotations.ObjDocAttribute;
import java.io.Serializable;
import java.util.Date;

public class RelationObjectClientBean
extends InternalObjectClientBean
implements Serializable {
    public static String CLASS_NAME = "RELATIONOBJECT";
    public static String LEFTOBJECT_ATTRIBUTE = "LEFTOBJECT";
    public static String RIGHTOBJECT_ATTRIBUTE = "RIGHTOBJECT";
    public static String SORTSEQUENCE_ATTRIBUTE = "SORTSEQUENCE";
    public static String NAME_ATTRIBUTE = "NAME";
    public static String FILTERFLAG_ATTRIBUTE = "FILTERFLAG";
    public static String FILTERDATE_ATTRIBUTE = "FILTERDATE";

    public void setLeftObject(GlobalObjectClientBean go) throws Exception {
        this.setAttribute(LEFTOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(go));
    }

    public void setRightObject(GlobalObjectClientBean go) throws Exception {
        this.setAttribute(RIGHTOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(go));
    }

    public void setSortSequence(Long value) throws Exception {
        this.setAttribute(SORTSEQUENCE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setName(String value) throws Exception {
        this.setAttribute(NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setFilterFlag(boolean value) throws Exception {
        this.setAttribute(FILTERFLAG_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    public void setFilterDate(Date value) throws Exception {
        this.setAttribute(FILTERDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(value));
    }

    @ObjDocAttribute(value="the left Object")
    public GlobalObjectClientBean getLeftObject() throws Exception {
        return this.getAttribute(LEFTOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="the right Object")
    public GlobalObjectClientBean getRightObject() throws Exception {
        return this.getAttribute(RIGHTOBJECT_ATTRIBUTE).getGlobalObjectClientBean(this.sessionController);
    }

    @ObjDocAttribute(value="the sorted sequence")
    public Long getSortSequence() throws Exception {
        return new Long(this.getAttribute(SORTSEQUENCE_ATTRIBUTE).getLong());
    }

    @ObjDocAttribute(value="the name of the object")
    public String getName() throws Exception {
        return this.getAttribute(NAME_ATTRIBUTE).getString();
    }

    @ObjDocAttribute(value="the filter flag of the relation object")
    public boolean getFilterFlag() throws Exception {
        return this.getAttribute(FILTERFLAG_ATTRIBUTE).getBoolean();
    }

    @ObjDocAttribute(value="the filter date")
    public Date getFilterDate() throws Exception {
        return this.getAttribute(FILTERDATE_ATTRIBUTE).getDate();
    }

    @Override
    public SuperObjectClientBeanDefinition getNewDefinition(SessionController sessionController) throws Exception {
        return new RelationObjectClientBeanDefinition(sessionController);
    }

    public void deleteToRecycle(GlobalObjectClientBeanDefinition def, int relationOffset) throws Exception {
        CheckUtils cu;
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
            System.err.println("RO untersuche " + gocb.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null && gocb.getAttribute(GlobalObjectClientBean.DELETOR_ATTRIBUTE).getLong() == 0L && !(cu = new CheckUtils()).checkFolderRelation(this.sessionController, def, gocb, relationOffset)) {
            gocb.deleteToRecycling(def);
        }
    }

    public void deleteToRecycle(GlobalObjectClientBeanDefinition def) throws Exception {
        this.deleteToRecycle(def, 0);
    }

    public void undelete(GlobalObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
            System.err.println("undelete RO untersuche " + gocb.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null) {
            gocb.undelete(def);
        }
    }

    public void leaveAcl(AccessControlListObjectClientBean acl, SuperObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null) {
            gocb.leaveAcl(acl, def);
        }
    }

    public void leaveOwner(DirectoryUserObjectClientBean owner, SuperObjectClientBeanDefinition def) throws Exception {
    }

    public void deleteRightObject(SuperObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean gocb = null;
        try {
            gocb = this.getRightObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (gocb != null) {
            gocb.delete(def);
        }
    }

    public void copyRightObject(SuperObjectClientBeanDefinition def, SuperObjectClientBean newLeftObject) throws Exception {
        RelationObjectRemote remObj = (RelationObjectRemote)this.getRemoteReference();
        remObj.copyRightObject(this.sessionController, def, this, newLeftObject);
    }

    public void leaveAclToSubObjects(AccessControlListObjectClientBean acl, GlobalObjectClientBeanDefinition def) throws Exception {
    }

    protected void setSubObjectAcl(AccessControlListObjectClientBean acl, GlobalObjectClientBeanDefinition def) throws Exception {
        GlobalObjectClientBean rightObj = this.getRightObject();
        SuperObjectClientBeanDefinition aclDef = rightObj.getNewDefinition(this.sessionController);
        aclDef.setSystemOption("doNotEA", def.getSystemOption("doNotEA"));
        aclDef.setSystemOption("NewOwnerForPrivateACL", def.getSystemOption("NewOwnerForPrivateACL"));
        aclDef.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, AttributeValue.newAttributeValueObject(acl));
        rightObj.update(aclDef);
    }

    public void leaveScopeAclsToSubObjects(GlobalObjectClientBeanDefinition def) throws Exception {
    }

    @ObjDocAttribute(value="the id of the left object")
    public Long getLeftObjectId() throws Exception {
        return this.getAttribute(LEFTOBJECT_ATTRIBUTE).getLong();
    }

    @ObjDocAttribute(value="the id of the right object")
    public Long getRightObjectId() throws Exception {
        return this.getAttribute(RIGHTOBJECT_ATTRIBUTE).getLong();
    }

    public boolean isConnectedObject() throws Exception {
        return false;
    }

    public DirectoryUserObjectClientBean getAssociatedUser() throws Exception {
        return this.getCreator();
    }
}

