/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SetFileSizeFromIndexFiles {
    private Connection connection = null;
    private DatabaseInterface dbi = null;

    public SetFileSizeFromIndexFiles(Connection conn) throws Exception {
        this.connection = conn;
        this.dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
    }

    public void setFileSize() throws Exception {
        PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getIndexStatement22());
        ResultSet rs = pstmt.executeQuery();
        int counter = 0;
        while (rs.next()) {
            ++counter;
            long id = rs.getLong(1);
            long blocksize = rs.getLong(2);
            this.setFileSizeFromFile(id, blocksize);
        }
        rs.close();
        rs = null;
        pstmt.close();
        pstmt = null;
    }

    private void setFileSizeFromFile(long docid, long blocksize) throws Exception {
        PreparedStatement pstmt = this.connection.prepareStatement(this.dbi.getIndexStatement23());
        pstmt.setLong(1, docid);
        ResultSet rs = pstmt.executeQuery();
        rs.next();
        long count = rs.getLong(1);
        long size = (count - 1L) * blocksize;
        System.err.println("blocksize = " + blocksize + ", count-1 = " + (count - 1L) + ", size1 = " + size);
        pstmt.close();
        pstmt = null;
        rs.close();
        rs = null;
        pstmt = this.connection.prepareStatement(this.dbi.getIndexStatement24());
        pstmt.setLong(1, count - 1L);
        pstmt.setLong(2, docid);
        rs = pstmt.executeQuery();
        rs.next();
        Blob blob = rs.getBlob(1);
        long len = blob.length();
        size += len;
        pstmt.close();
        pstmt = null;
        rs.close();
        rs = null;
        pstmt = this.connection.prepareStatement(this.dbi.getIndexStatement25());
        pstmt.setLong(1, size);
        pstmt.setLong(2, docid);
        pstmt.executeUpdate();
        pstmt.close();
        pstmt = null;
        System.err.println("Ermittelte Filesize : " + size);
    }

    public static void main(String[] args) {
        Connection conn = null;
        try {
            Class.forName("org.mariadb.jdbc.Driver").newInstance();
            String dbserver = args[2];
            String dbname = "roi";
            String user = args[0];
            String password = args[1];
            String cs = "jdbc:mariadb://" + dbserver + "/" + dbname + "?user=" + user + "&password=" + password;
            conn = DriverManager.getConnection(cs);
            conn.setAutoCommit(false);
            SetFileSizeFromIndexFiles setFileSizeFromIndexFiles = new SetFileSizeFromIndexFiles(conn);
            setFileSizeFromIndexFiles.setFileSize();
            conn.commit();
            conn.close();
        }
        catch (Exception ex) {
            try {
                conn.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.err.println("An exception has been intercepted");
            ex.printStackTrace();
        }
        System.err.println("Programm Ende");
    }
}

