/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ChangeHistoryUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

public class TestChangeHistoryUtil {
    private SessionController sessionController = null;

    public TestChangeHistoryUtil(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void test01(Long id) throws Exception {
        String localPath = "c:\\temp\\aaaaa";
        File f = new File(localPath);
        f.mkdirs();
        String[] allFiles = f.list();
        if (allFiles != null) {
            int len1 = allFiles.length;
            for (int i = 0; i < len1; ++i) {
                String path = localPath + File.separator + allFiles[i];
                System.err.println("" + i + " : " + path);
                File f1 = new File(path);
                f1.delete();
            }
        }
        GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(id);
        ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
        System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
        GlobalObjectClientBean[] allGocb = chu.getHistoryObjects(gocb);
        if (allGocb != null) {
            int len = allGocb.length;
            for (int i = 0; i < len; ++i) {
                String path = localPath + File.separator + i + "_";
                String name = allGocb[i].getName();
                this.printObjectToDisk(allGocb[i], path, name);
                System.err.println("Name (" + i + ") : " + allGocb[i].getName() + ", ID = " + allGocb[i].getId());
                System.err.println("  ContentSize : " + ((FileObjectClientBean)allGocb[i]).getContentSize());
            }
            String path = localPath + File.separator + "ORG_";
            String name = gocb.getName();
            this.printObjectToDisk(gocb, path, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printObjectToDisk(GlobalObjectClientBean gocb, String path, String name) throws Exception {
        File f2 = new File(path + name);
        if (!f2.exists()) {
            f2.createNewFile();
        }
        InputStream is1 = ((FileObjectClientBean)gocb).getContentStream();
        File file1 = new File(path + name);
        FileOutputStream fos1 = new FileOutputStream(file1);
        try {
            int read;
            long wbyte = 0L;
            byte[] buffer = new byte[1024];
            while ((read = is1.read(buffer)) >= 0) {
                wbyte += (long)read;
                fos1.write(buffer, 0, read);
            }
            System.err.println("wbyte geschrieben: " + wbyte);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            fos1.close();
            is1.close();
        }
        try (FileOutputStream fos2 = null;){
            File file2 = new File(path + "Att_" + name);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            fos2 = new FileOutputStream(file2);
            StringBuffer sb = new StringBuffer();
            sb.append("ID: " + ((FileObjectClientBean)gocb).getId() + "\r\n");
            sb.append("FILESIZE: " + ((FileObjectClientBean)gocb).getContentSize() + "\r\n");
            sb.append("----- DESCRIPTION ---------\r\n");
            String description = gocb.getDescription();
            sb.append(description == null ? "" : description);
            sb.append("\r\n");
            sb.append("-----ENDE DESCRIPTION ---------\r\n");
            String xml = gocb.getExtendedAttributesXml();
            sb.append(xml != null ? xml : "keine ExtendedAttributes");
            fos2.write(sb.toString().getBytes());
        }
    }

    public void testRestore(Long id, int pos) throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(id);
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
            GlobalObjectClientBean[] allGocb = chu.getHistoryObjects(gocb);
            if (allGocb != null && allGocb.length >= pos) {
                gocb.restoreHistoryObject(allGocb[pos], null);
            }
            rth.end();
            rth = null;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw e;
        }
        finally {
            try {
                if (rth != null) {
                    rth.abort();
                    rth = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public void test(String path) throws Exception {
        GlobalObjectClientBean gocb = this.sessionController.findGlobalObjectByPath(path);
        ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
        System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
        chu.makeHistory(gocb);
        System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
        chu.deleteHistoryObjects(gocb, 1);
        System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
        for (int i = 0; i < 10; ++i) {
            chu.makeHistory(gocb);
        }
        System.err.println("HistoryCount = " + chu.getHistoryCount(gocb));
        String name = gocb.getName();
        SuperObjectClientBean[] soArr = this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        AccessControlListObjectClientBean acl = this.sessionController.getAclByName("Private");
        gocb.leaveAcl(acl, null);
        if (soArr != null) {
            GlobalObjectClientBean go;
            int i;
            System.err.println("Gefunden : " + soArr.length);
            System.err.println("ACL Basisi: " + gocb.getAcl().getName());
            for (i = 0; i < soArr.length; ++i) {
                go = (GlobalObjectClientBean)soArr[i];
                System.err.println("ACL Historie: " + go.getAcl().getName() + ", ID = " + go.getId());
            }
            System.err.println("Set ACL tu Public");
            acl = this.sessionController.getAclByName("Public");
            gocb.leaveAcl(acl, null);
            System.err.println("ACL Basisi: " + gocb.getAcl().getName());
            for (i = 0; i < soArr.length; ++i) {
                go = (GlobalObjectClientBean)soArr[i];
                System.err.println("ACL Historie: " + go.getAcl().getName() + ", ID = " + go.getId());
            }
        }
        SuperObjectClientBeanDefinition mygocbdDef = gocb.getDefinition(this.sessionController);
        ((GlobalObjectClientBeanDefinition)mygocbdDef).setAddToFolderOption(gocb.getParents()[0]);
        mygocbdDef.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject("" + System.currentTimeMillis() + "_" + gocb.getName()));
        gocb.copy(mygocbdDef);
        soArr = this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            System.err.println("Gefunden nach Copy: " + soArr.length);
        }
        gocb.delete();
        soArr = this.sessionController.getSuperObjectByAttribute(this.sessionController, GlobalObjectClientBean.NAME_ATTRIBUTE, name, false, this.sessionController.getClassObject(GlobalObjectClientBean.CLASS_NAME));
        if (soArr != null) {
            System.err.println("Gefunden : " + soArr.length);
            for (int i = 0; i < soArr.length; ++i) {
                soArr[0].delete();
            }
        } else {
            System.err.println("Gefunden : 0");
        }
    }

    public static void main(String[] args) {
        System.err.println("Hallo");
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestChangeHistoryUtil");
            SessionController sessionController = SessionController.connect(credential);
            TestChangeHistoryUtil testChangeHistoryUtil = new TestChangeHistoryUtil(sessionController);
            Long id = new Long(1695472L);
            testChangeHistoryUtil.test01(id);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende Programm");
    }
}

