/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.common.utils.CycleUtils;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.exception.RoiException;
import java.sql.Connection;
import java.sql.DriverManager;

public class TestCycle {
    private SessionController sessionController = null;

    public TestCycle(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void rebuildCycleChecker() {
        try {
            CycleUtils cyu = new CycleUtils(this.sessionController);
            cyu.rebuildCycleChecker(this.getConnection());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void makeACycle() {
        try {
            FolderObjectClientBean focb_1 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home/roi/MyFiles/a2/b2");
            FolderObjectClientBean focb_2 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home/roi/MyFiles/a2");
            try {
                focb_1.addItem(focb_2);
            }
            catch (RoiException re) {
                if (re.getErrorKey().equals("agorum.roi.remote.exception.WeHasACycle")) {
                    System.err.println("Cycle vorhanden");
                } else {
                    System.err.println("Error : " + re.getErrorKey() + ", Message = " + re.getMessage() + ", original = " + re.getNestedException().getMessage());
                }
                throw re;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test() {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            FolderObjectClientBean focb_1 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home/rolf.lang");
            FolderObjectClientBean focb_2 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/Home/rolf.lang");
            focb_1.addItem(focb_2);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            try {
                rth.abort();
            }
            catch (Exception exception) {}
        }
    }

    private void testMakeCycle() {
        try {
            FolderObjectClientBean focb_3 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/roi");
            FolderObjectClientBean focb_4 = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/roi");
            CycleUtils cyu = new CycleUtils(this.sessionController);
            Connection conn = this.getConnection();
            long leftObject = focb_3.getId();
            long rightObject = focb_4.getId();
            conn.setAutoCommit(false);
            conn.rollback();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public Connection getConnection() throws Exception {
        Connection conn = null;
        try {
            Class.forName("org.mariadb.jdbc.Driver").newInstance();
            String dbserver = "10.0.0.82";
            String dbname = "roi";
            String user = "root";
            String password = "agorum";
            String cs = "jdbc:mariadb://" + dbserver + "/" + dbname + "?user=" + user + "&password=" + password;
            conn = DriverManager.getConnection(cs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conn;
    }

    public static void main(String[] args) {
        System.err.println("Hallo");
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestCycle");
            SessionController sessionController = SessionController.connect(credential);
            TestCycle tc = new TestCycle(sessionController);
            tc.testMakeCycle();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende Programm");
    }
}

