/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.roi.common.beans.FolderDeleteRelationObjectInfoBean;
import agorum.roi.common.beans.FolderDeleteRelationObjectUnDoBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderDeleteRelationObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.search.SearchClass;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.File;
import java.io.FileInputStream;
import java.util.Date;
import java.util.Vector;

public class TestFolderDeleteRelationObject {
    private SessionController sessionController = null;

    public TestFolderDeleteRelationObject(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void test() throws Exception {
        FolderObjectClientBean myRoot = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/roi/Files");
        RoiTransactionHandler rth = null;
        try {
            int ls;
            int i;
            FolderDeleteRelationObjectInfoBean[] infoBean;
            rth = new RoiTransactionHandler();
            rth.begin();
            String folderPath = "/agorum/roi/Files/d4wdemo/Projekte";
            FolderObjectClientBean f = null;
            f = this.importFileStructure("c:\\temp\\FolderDeleteRelationTest", folderPath);
            rth.end();
            rth = null;
            rth = new RoiTransactionHandler();
            rth.begin();
            if (f != null && (infoBean = f.getFolderDeleteRelationObjectInfoBean()) != null) {
                int len = infoBean.length;
                for (i = 0; i < len; ++i) {
                    System.err.println("\n --------------- \nDeleteId :" + infoBean[i].getDeleteId() + "\n");
                    this.printDeletesItems(infoBean[i].getGlobalObject(), new Long(infoBean[i].getDeleteId()), "");
                    if (i != 0) continue;
                }
            }
            rth.end();
            rth = null;
            GlobalObjectClientBean[] allStartObjects = this.getAllStartObjects();
            if (allStartObjects != null) {
                ls = allStartObjects.length;
                System.err.println("\n\nAnzahl gefundene Objecte : " + ls + "\n\n");
                for (i = 0; i < ls; ++i) {
                    System.err.println("Name : " + allStartObjects[i].getName());
                }
            }
            if ((allStartObjects = this.getAllDeletedObjects()) != null) {
                ls = allStartObjects.length;
                System.err.println("\n\nAnzahl gefundene Objecte : " + ls + "\n\n");
                for (i = 0; i < ls; ++i) {
                    System.err.println("Name : " + allStartObjects[i].getName());
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    private GlobalObjectClientBean[] getAllStartObjects() throws Exception {
        GlobalObjectClientBean[] allStartObjects = null;
        SearchClass sc = new SearchClass(this.sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME, RelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.CLASS_NAME, GlobalObjectClientBean.CLASS_NAME}, new String[]{"a", "b", "c", "d"});
        sc.setBindOn();
        sc.setJoin("b", null, "c", null);
        sc.setJoin("b", RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, "d", null);
        sc.setSearchClauseAND();
        sc.setJoin("b", RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, "a", null);
        sc.setSearchClauseAND();
        sc.setAttribute("d", GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)new Date(0L), false, 0);
        sc.setSearchClauseAND();
        sc.setAttribute("a", GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)new Date(0L), false, 3);
        sc.setSearchClauseAND();
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        allStartObjects = sc.getItems();
        return allStartObjects;
    }

    private GlobalObjectClientBean[] getAllDeletedObjects() throws Exception {
        GlobalObjectClientBean[] allStartObjects = null;
        SearchClass sc = new SearchClass(this.sessionController);
        sc.setClassname(new String[]{GlobalObjectClientBean.CLASS_NAME});
        sc.setBindOn();
        sc.setAttribute(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, (Object)new Date(0L), false, 3);
        sc.setAttribute(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.ID_ATTRIBUTE, (Object)"select c.RIGHTOBJECT from relationobject c, folderdeleterelationobject d where c.id = d.id", false, 11);
        sc.setSearchClauseAND();
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        allStartObjects = sc.getItems();
        return allStartObjects;
    }

    private void printDeletesItems(GlobalObjectClientBean gocb, Long deleteId, String offset) throws Exception {
        if (gocb != null) {
            FolderObjectClientBean f;
            GlobalObjectClientBean[] deletedItems;
            FolderDeleteRelationObjectUnDoBean folderDeleteRelationObjectUnDoBean;
            String nextOffset = offset + "/" + gocb.getName();
            System.err.println(nextOffset);
            FolderObjectClientBean[] startFolders = this.getStartObject(gocb, deleteId);
            if (startFolders != null) {
                int len = startFolders.length;
                for (int i = 0; i < len; ++i) {
                    if (startFolders[i] == null) continue;
                    System.err.println("    startFolder: " + startFolders[i].getAnyFolderPath());
                }
            }
            String startFolderPath = (folderDeleteRelationObjectUnDoBean = this.getFolderDeleteRelationObjectUnDoBean(gocb, deleteId)).getStartFolder() != null ? folderDeleteRelationObjectUnDoBean.getStartFolder().getAnyFolderPath() : "null";
            System.err.println("----- startFolder: " + startFolderPath + "\n----- StartUndoObject : " + (folderDeleteRelationObjectUnDoBean.getStartUndoObject() != null ? folderDeleteRelationObjectUnDoBean.getStartUndoObject().getName() : "null") + "\n----- MyObject : " + folderDeleteRelationObjectUnDoBean.getMyObject().getName() + "\n----- DeleteId : " + folderDeleteRelationObjectUnDoBean.getDeleteId() + "\n----- MyObjectFolderPath : " + folderDeleteRelationObjectUnDoBean.getMyObjectFolderPath() + "\n----- FullPath : " + startFolderPath + folderDeleteRelationObjectUnDoBean.getMyObjectFolderPath() + "/" + folderDeleteRelationObjectUnDoBean.getMyObject().getName());
            if (this.sessionController.isFolder(gocb) && (deletedItems = (f = (FolderObjectClientBean)gocb).getDeletedItems(deleteId)) != null) {
                int len = deletedItems.length;
                for (int i = 0; i < len; ++i) {
                    this.printDeletesItems(deletedItems[i], deleteId, nextOffset);
                }
            }
        }
    }

    private FolderObjectClientBean[] getStartObject(GlobalObjectClientBean clientBean, Long deletedId) throws Exception {
        FolderObjectClientBean[] startFolders = null;
        RelationObjectClientBean[] rel = clientBean.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, FolderDeleteRelationObjectClientBean.CLASS_NAME, "DELETEID", deletedId);
        if (rel != null) {
            int i;
            int len = rel.length;
            Vector<GlobalObjectClientBean> v = new Vector<GlobalObjectClientBean>();
            for (i = 0; i < len; ++i) {
                GlobalObjectClientBean lo = null;
                try {
                    lo = rel[i].getLeftObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lo != null && lo.getExpirationDate().getTime() == 0L) {
                    v.addElement(lo);
                    continue;
                }
                if (lo == null) continue;
                startFolders = this.getStartObject(lo, deletedId);
                break;
            }
            if ((len = v.size()) > 0) {
                startFolders = new FolderObjectClientBean[len];
                for (i = 0; i < len; ++i) {
                    startFolders[i] = (FolderObjectClientBean)v.elementAt(i);
                }
            }
        }
        return startFolders;
    }

    private FolderDeleteRelationObjectUnDoBean getFolderDeleteRelationObjectUnDoBean(GlobalObjectClientBean clientBean, Long deleteId) throws Exception {
        FolderDeleteRelationObjectUnDoBean folderDeleteRelationObjectUnDoBean = new FolderDeleteRelationObjectUnDoBean();
        folderDeleteRelationObjectUnDoBean.setDeleteId(deleteId);
        folderDeleteRelationObjectUnDoBean.setMyObject(clientBean);
        this.getFolderDeleteRelationObjectUnDoBean(clientBean, deleteId, folderDeleteRelationObjectUnDoBean);
        return folderDeleteRelationObjectUnDoBean;
    }

    private void getFolderDeleteRelationObjectUnDoBean(GlobalObjectClientBean clientBean, Long deleteId, FolderDeleteRelationObjectUnDoBean folderDeleteRelationObjectUnDoBean) throws Exception {
        RelationObjectClientBean[] rel = clientBean.getRelations(FolderDeleteRelationObjectClientBean.CLASS_NAME, FolderDeleteRelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, FolderDeleteRelationObjectClientBean.CLASS_NAME, "DELETEID", deleteId);
        if (rel != null) {
            int i = 0;
            int len = rel.length;
            if (i < len) {
                GlobalObjectClientBean lo = null;
                try {
                    lo = rel[i].getLeftObject();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (lo != null && lo.getExpirationDate().getTime() == 0L) {
                    folderDeleteRelationObjectUnDoBean.setStartFolder((FolderObjectClientBean)lo);
                    folderDeleteRelationObjectUnDoBean.setStartUndoObject(clientBean);
                } else if (lo != null) {
                    folderDeleteRelationObjectUnDoBean.setMyObjectFolderPath("/" + lo.getName() + folderDeleteRelationObjectUnDoBean.getMyObjectFolderPath());
                    this.getFolderDeleteRelationObjectUnDoBean(lo, deleteId, folderDeleteRelationObjectUnDoBean);
                }
            }
        } else {
            folderDeleteRelationObjectUnDoBean.setStartUndoObject(clientBean);
        }
    }

    private FolderObjectClientBean importFileStructure(String pathOnDisk, String pathRoi) throws Exception {
        FolderObjectClientBean folder = null;
        try {
            File f = new File(pathOnDisk);
            if (f.isDirectory() && (folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(pathRoi)) != null) {
                String folderPath = folder.getAnyFolderPath();
                this.importRecursiveFileStructure(f, folder, folderPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return folder;
    }

    private void importFile(String pathOnDisk, String pathRoi) throws Exception {
        try {
            FolderObjectClientBean folder;
            File f = new File(pathOnDisk);
            if (f.isFile() && (folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(pathRoi)) != null) {
                this.createFileObject(f, folder, "");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void importRecursiveFileStructure(File f, FolderObjectClientBean folder, String folderPath) throws Exception {
        File[] fArr = f.listFiles();
        if (fArr != null) {
            int len = fArr.length;
            for (int i = 0; i < len; ++i) {
                if (fArr[i].getName().equalsIgnoreCase("CVS")) continue;
                System.err.println("create: " + folderPath + "/" + fArr[i].getName());
                if (fArr[i].isDirectory()) {
                    FolderObjectClientBean focb = this.createFolderObject(fArr[i].getName(), folder, folderPath);
                    this.importRecursiveFileStructure(fArr[i], focb, folderPath + "/" + fArr[i].getName());
                    continue;
                }
                this.createFileObject(fArr[i], folder, folderPath);
            }
        }
    }

    private FileObjectClientBean createFileObject(File f, FolderObjectClientBean folder, String folderPath) throws Exception {
        FileObjectClientBean focb = null;
        GlobalObjectClientBean updateObject = null;
        try {
            updateObject = this.sessionController.findGlobalObjectByPath(folder, f.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileObjectSessionFacade fileSF = new FileObjectSessionFacade(this.sessionController);
        if (updateObject != null) {
            fileSF.setGlobalObject(updateObject);
        }
        fileSF.setWithTransaction(true);
        fileSF.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, f.getName());
        fileSF.setAttribute(GlobalObjectClientBean.EXPIRATIONDATE_ATTRIBUTE, new Date());
        FileInputStream fis = new FileInputStream(f);
        fileSF.setContentStream(fis);
        if (updateObject != null) {
            focb = (FileObjectClientBean)fileSF.update();
        } else {
            focb = (FileObjectClientBean)fileSF.create();
            System.err.println("Folder : " + folder.getName() + " - Item: " + focb.getName());
            folder.addDeletedItem(focb);
        }
        fis.close();
        return focb;
    }

    private FolderObjectClientBean createFolderObject(String name, FolderObjectClientBean folder, String folderPath) throws Exception {
        FolderObjectClientBean focb = null;
        try {
            FolderObjectClientBeanDefinition focbd = new FolderObjectClientBeanDefinition(this.sessionController);
            focbd.setName(name);
            focbd.setAcl(folder.getAcl());
            focbd.setExpirationDate(new Date());
            focb = (FolderObjectClientBean)this.sessionController.createGlobalObject(focbd);
            System.err.println("Folder : " + folder.getName() + " - Item: " + focb.getName());
            folder.addDeletedItem(focb);
        }
        catch (Exception e) {
            focb = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(folderPath + "/" + name);
        }
        return focb;
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestFolderDeleteRelationObjec");
            SessionController sessionController = SessionController.connect(credential);
            TestFolderDeleteRelationObject testFolderDeleteRelationObject = new TestFolderDeleteRelationObject(sessionController);
            testFolderDeleteRelationObject.test();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Programm ende");
    }
}

