/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.clients;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.beans.MetaDbPropertyBean;
import agorum.roi.metadb.common.MetaDbUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Date;

public class TestMetaDbCache {
    private SessionController sessionController = null;

    public TestMetaDbCache(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void runSCITest() throws Throwable {
        System.err.println("SCI Test:\n");
        System.err.println("Read Anzahl offene Akten (1):");
        MetaDb metaDb = this.sessionController.getMetaDbInstance();
        String[] list = metaDb.listSimplePropertyBundle("MAIN_MODULE_MANAGEMENT/customers/SCI/cosirisimport/control/Anzahl offene Akten");
        if (list != null) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                System.err.println("list[" + i + "]: " + list[i]);
            }
        }
        System.err.println("\nChange something and press return...");
        BufferedReader din = new BufferedReader(new InputStreamReader(System.in));
        String line = din.readLine();
        System.err.println("\nRead Anzahl offene Akten (2):");
        list = metaDb.listSimplePropertyBundle("MAIN_MODULE_MANAGEMENT/customers/SCI/cosirisimport/control/Anzahl offene Akten");
        if (list != null) {
            int len = list.length;
            for (int i = 0; i < len; ++i) {
                System.err.println("list[" + i + "]: " + list[i]);
            }
        }
        System.err.println("\nSCI Test finished\n");
    }

    public void runCacheTest1() throws Throwable {
        GenericCache.logGC((String)"=== Cache Test:\n", null);
        GenericCache.doLog = true;
        MetaDb metaDb = this.sessionController.getMetaDbInstance();
        GenericCache.logGC((String)("==== Read d4wdemo users (NotCached) at " + new Date() + ":"), null);
        Date startReadNotCached = new Date();
        for (int i = 0; i < 100; ++i) {
            String[] list = metaDb.listSimplePropertyEntry("MAIN_TEST", true);
            if (list == null) continue;
            int entriesLen = list.length;
            for (int j = 0; j < entriesLen; ++j) {
                GenericCache.logGC((String)("===== list[" + j + "]: " + list[j]), null);
            }
        }
        GenericCache.logGC((String)("==== Time NotCached: " + (new Date().getTime() - startReadNotCached.getTime()) + " ms\n\n\n"), null);
        GenericCache.logGC((String)("==== Read d4wdemo users (Cached) at " + new Date() + ":"), null);
        Date startReadCached = new Date();
        for (int i = 0; i < 100; ++i) {
            String[] list = metaDb.listSimplePropertyEntry("MAIN_TEST", false);
            if (list == null) continue;
            int entriesLen = list.length;
            for (int j = 0; j < entriesLen; ++j) {
                GenericCache.logGC((String)("===== list[" + j + "]: " + list[j]), null);
            }
        }
        GenericCache.logGC((String)("==== Time Cached: " + (new Date().getTime() - startReadCached.getTime()) + " ms"), null);
        GenericCache.doLog = false;
        GenericCache.logGC((String)"=== \nCache1 Test finished\n", null);
    }

    public void runCacheTest2() throws Throwable {
        GenericCache.logGC((String)"=== Cache Test:\n", null);
        GenericCache.doLog = true;
        MetaDbUtils metaDbUtils = new MetaDbUtils(this.sessionController);
        FolderObjectClientBean fromFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath("/agorum/ngos/MetaDb/MAIN_TEST");
        GenericCache.logGC((String)("==== Read d4wdemo users (NotCached) at " + new Date() + ":"), null);
        Date startReadNotCached = new Date();
        for (int i = 0; i < 100; ++i) {
            MetaDbPropertyBean[] mdpb = metaDbUtils.getItems(null, fromFolder, true);
            if (mdpb == null) continue;
            int mdpbLen = mdpb.length;
            for (int j = 0; j < mdpbLen; ++j) {
                GenericCache.logGC((String)("===== mdpb[" + j + "]: " + mdpb[j].getName()), null);
            }
        }
        GenericCache.logGC((String)("==== Time NotCached: " + (new Date().getTime() - startReadNotCached.getTime()) + " ms\n\n\n"), null);
        GenericCache.logGC((String)("==== Read d4wdemo users (Cached) at " + new Date() + ":"), null);
        Date startReadCached = new Date();
        for (int i = 0; i < 100; ++i) {
            MetaDbPropertyBean[] mdpb = metaDbUtils.getItems(null, fromFolder);
            if (mdpb == null) continue;
            int mdpbLen = mdpb.length;
            for (int j = 0; j < mdpbLen; ++j) {
                GenericCache.logGC((String)("===== mdpb[" + j + "]: " + mdpb[j].getName()), null);
            }
        }
        GenericCache.logGC((String)("==== Time Cached: " + (new Date().getTime() - startReadCached.getTime()) + " ms"), null);
        GenericCache.doLog = false;
        GenericCache.logGC((String)"=== \nCache2 Test finished\n", null);
    }

    public static void main(String[] args) {
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestMetaDbCache");
            SessionController sessionController = SessionController.connect(credential);
            TestMetaDbCache testMetaDbCache = new TestMetaDbCache(sessionController);
            System.err.println("===");
            testMetaDbCache.runCacheTest1();
            System.err.println("===");
            testMetaDbCache.runCacheTest2();
            System.err.println("===");
            System.err.println("finished");
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }
}

