/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.common.utils.JavaUtil;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBean;
import agorum.roi.ejb.client.beans.AccessCounterObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.AccessCounterUserObjectClientBean;
import agorum.roi.ejb.client.beans.AccessCounterUserObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.InternalObjectClientBean;
import agorum.roi.ejb.common.AttributeValueDirectoryObjectClientBean;
import agorum.roi.ejb.common.AttributeValueGlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.DownloadQuota;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.events.Events;
import agorum.roi.search.SearchClass;
import java.io.Serializable;
import java.util.Date;

public class AccessCounterUtils
implements Serializable {
    private static final long serialVersionUID = 8144170932553921949L;
    private SessionController sessionController = null;

    public AccessCounterUtils(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public AccessCounterObjectClientBean getAccessCounterObject(ContentInterface contentInterface) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        if (contentInterface.createAccessCounterObject()) {
            return this.getAccessCounterObject(contentInterface.getId());
        }
        return null;
    }

    public AccessCounterObjectClientBean getAccessCounterObject(Long id) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        try {
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)id, false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return ((AccessCounterObjectClientBean[])ju.convertArray(accb, AccessCounterObjectClientBean.class.getName()))[0];
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public AccessCounterUserObjectClientBean[] getAllAccessCounterUserObject(ContentInterface clientBean) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        if (!clientBean.createAccessCounterObject()) {
            return null;
        }
        try {
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterUserObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterUserObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)clientBean.getId(), false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return (AccessCounterUserObjectClientBean[])ju.convertArray(accb, AccessCounterUserObjectClientBean.class.getName());
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public void moveAccessCounterUserObjects(ContentInterface from, ContentInterface to) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterUserObjectClientBean[] userAccessCouter = this.getAllAccessCounterUserObject(from);
        if (userAccessCouter != null) {
            int len = userAccessCouter.length;
            for (int i = 0; i < len; ++i) {
                userAccessCouter[i].setReferenceObject((GlobalObjectClientBean)((Object)to));
                to.setLastContentModifyDate(from.getLastContentModifyDate());
            }
        }
    }

    public AccessCounterUserObjectClientBean getAccessCounterUserObject(ContentInterface contentInterface, DirectoryUserObjectClientBean user) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        if (!contentInterface.createAccessCounterObject()) {
            return null;
        }
        return this.getAccessCounterUserObject(contentInterface.getId(), user.getId());
    }

    public AccessCounterUserObjectClientBean getAccessCounterUserObject(Long id, Long userId) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        try {
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterUserObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterUserObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)id, false);
            sc.setSearchClauseAND();
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "ACCESSUSER", (Object)userId, false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return ((AccessCounterUserObjectClientBean[])ju.convertArray(accb, AccessCounterUserObjectClientBean.class.getName()))[0];
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public AccessCounterUserObjectClientBean[] getAllAccessCounterUserObject(DirectoryUserObjectClientBean user) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        try {
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterUserObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterUserObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "ACCESSUSER", (Object)user, false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return (AccessCounterUserObjectClientBean[])ju.convertArray(accb, AccessCounterUserObjectClientBean.class.getName());
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public boolean hasUserContentRead(ContentInterface contentInterface, DirectoryUserObjectClientBean user) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return false;
        }
        if (!contentInterface.createAccessCounterObject()) {
            return false;
        }
        boolean bRet = false;
        try {
            InternalObjectClientBean[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterUserObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterUserObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "ACCESSUSER", (Object)user, false);
            sc.setSearchClauseAND();
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)contentInterface.getId(), false);
            sc.setSearchClauseAND();
            sc.setAttributeGREATER_THAN(AccessCounterUserObjectClientBean.CLASS_NAME, "LASTACCESSDATE", (Object)contentInterface.getLastContentModifyDate(), false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            bRet = accb == null ? contentInterface.getUserReadWatchLastModifier() && ((GlobalObjectClientBean)((Object)contentInterface)).getLastModifier().getId().longValue() == user.getId().longValue() : true;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return bRet;
    }

    public AccessCounterUserObjectClientBean[] getAllAccessCounterUserObjectRead(ContentInterface contentInterface) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return null;
        }
        if (!contentInterface.createAccessCounterObject()) {
            return null;
        }
        boolean bRet = false;
        try {
            Object[] accb = null;
            SearchClass sc = new SearchClass(this.sessionController);
            sc.setBindOn();
            sc.setClassname(new String[]{InternalObjectClientBean.CLASS_NAME, AccessCounterUserObjectClientBean.CLASS_NAME});
            sc.setJoin(InternalObjectClientBean.CLASS_NAME, null, AccessCounterUserObjectClientBean.CLASS_NAME, null);
            sc.setAttributeEQUAL(AccessCounterUserObjectClientBean.CLASS_NAME, "REFERENCEOBJECT", (Object)contentInterface.getId(), false);
            sc.setSearchClauseAND();
            sc.setAttributeGREATER_THAN(AccessCounterUserObjectClientBean.CLASS_NAME, "LASTACCESSDATE", (Object)contentInterface.getLastContentModifyDate(), false);
            sc.setSearchClauseAND();
            sc.openSearch(InternalObjectClientBean.CLASS_NAME);
            accb = sc.getItemsInternalObject();
            sc.closeSearch();
            if (accb != null) {
                JavaUtil ju = new JavaUtil();
                return (AccessCounterUserObjectClientBean[])ju.convertArray(accb, AccessCounterUserObjectClientBean.class.getName());
            }
            return null;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public void deleteAccessCounterObject(ContentInterface clientBean) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterObjectClientBean acocb = null;
        acocb = this.getAccessCounterObject(clientBean.getId());
        if (acocb != null) {
            acocb.delete();
        }
    }

    public void deleteAllAccessCounterUserObjects(ContentInterface clientBean) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterUserObjectClientBean[] acoucb = null;
        acoucb = this.getAllAccessCounterUserObject(clientBean);
        if (acoucb != null) {
            int len = acoucb.length;
            for (int i = 0; i < len; ++i) {
                if (acoucb[i] == null) continue;
                acoucb[i].delete();
            }
        }
    }

    public void deleteAllAccessCounterUserObjects(DirectoryUserObjectClientBean user) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterUserObjectClientBean[] acoucb = null;
        acoucb = this.getAllAccessCounterUserObject(user);
        if (acoucb != null) {
            int len = acoucb.length;
            for (int i = 0; i < len; ++i) {
                if (acoucb[i] == null) continue;
                acoucb[i].delete();
            }
        }
    }

    public void setAccessCounter(ContentInterface clientBean, Long userId, Date dat) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        if (!clientBean.createAccessCounterObject()) {
            return;
        }
        AccessCounterObjectClientBean acocb = this.getAccessCounterObject(clientBean.getId());
        if (dat == null) {
            dat = new Date();
        }
        if (acocb != null) {
            try {
                long lastCounter = acocb.getAccessCounter();
                AccessCounterObjectClientBeanDefinition acocbDef = (AccessCounterObjectClientBeanDefinition)acocb.getNewDefinition(this.sessionController);
                acocbDef.setLastAccessDate(dat);
                acocbDef.setAttribute("LASTACCESSOR", new AttributeValueDirectoryObjectClientBean(userId));
                acocbDef.setAccessCounter(++lastCounter);
                acocb.update(acocbDef);
                AccessCounterUserObjectClientBean acuocb = this.getAccessCounterUserObject(clientBean.getId(), userId);
                if (acuocb != null) {
                    lastCounter = acuocb.getAccessCounter();
                    AccessCounterUserObjectClientBeanDefinition acuocbDef = (AccessCounterUserObjectClientBeanDefinition)acuocb.getNewDefinition(this.sessionController);
                    acuocbDef.setLastAccessDate(dat);
                    acuocbDef.setAccessCounter(++lastCounter);
                    acuocb.update(acuocbDef);
                } else {
                    this.createAccessCounterUserObject(clientBean.getId(), userId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setAccessCounter(ContentInterface clientBean, Long userId) throws Exception {
        this.setAccessCounter(clientBean, userId, null);
    }

    public void resetUserAccessCounter(Long id, Long userId) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterUserObjectClientBean acuocb = this.getAccessCounterUserObject(id, userId);
        if (acuocb != null) {
            try {
                long lastCounter = acuocb.getAccessCounter();
                AccessCounterUserObjectClientBeanDefinition acuocbDef = (AccessCounterUserObjectClientBeanDefinition)acuocb.getNewDefinition(this.sessionController);
                acuocbDef.setLastAccessDate(new Date(0L));
                acuocbDef.setAccessCounter(++lastCounter);
                acuocb.update(acuocbDef);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAccessCounterForUser(Long id, Long userId) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        AccessCounterUserObjectClientBean acuocb = this.getAccessCounterUserObject(id, userId);
        if (acuocb != null) {
            acuocb.delete();
        }
    }

    private void createAccessCounterUserObject(Long id, Long userId) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        try {
            GlobalObjectClientBean gocb = this.sessionController.getGlobalObjectById(id);
            if (gocb != null) {
                if (!gocb.createAccessCounterObject()) {
                    return;
                }
                AccessCounterUserObjectClientBeanDefinition acuocbDef = new AccessCounterUserObjectClientBeanDefinition(this.sessionController);
                acuocbDef.setAttribute("REFERENCEOBJECT", new AttributeValueGlobalObjectClientBean(id));
                acuocbDef.setAttribute("ACCESSUSER", new AttributeValueDirectoryObjectClientBean(userId));
                this.sessionController.createInternalObject(acuocbDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void sendReadEvent(ContentInterface contentInterface) throws Exception {
        this.sendReadEvent(contentInterface, false);
    }

    public void sendReadEvent(ContentInterface contentInterface, boolean ignoreAccessCounterService) throws Exception {
        this.sendReadEvent(contentInterface, ignoreAccessCounterService, this.sessionController.getLoginUserId());
    }

    public void sendReadEvent(ContentInterface contentInterface, boolean ignoreAccessCounterService, Long userId) throws Exception {
        Boolean ignore = (Boolean)Transaction.get("AccessCounterReadDisabled");
        if (this.sessionController.isService() || ignore != null && ignore.booleanValue()) {
            return;
        }
        Events.fire(this.sessionController, "contentRead", (GlobalObjectClientBean)((Object)contentInterface));
        ContentInterface realContentInterface = contentInterface.getAccessCounterContentObject();
        if (realContentInterface.getContentSize(true) >= 0L) {
            GlobalObjectClientBean obj = (GlobalObjectClientBean)((Object)realContentInterface);
            if (obj.countDownloadQuota()) {
                DownloadQuota.getInstance(this.sessionController).addObject(this.sessionController, realContentInterface);
            }
            MessageUtils mu = new MessageUtils();
            mu.sendReadEvent(this.sessionController, realContentInterface, ignoreAccessCounterService, userId);
        }
    }

    public void sendUnreadEvent(ContentInterface contentInterface) throws Exception {
        this.sendUnreadEvent(contentInterface, false);
    }

    public void sendUnreadEvent(ContentInterface contentInterface, boolean ignoreAccessCounterService) throws Exception {
        this.sendUnreadEvent(contentInterface, ignoreAccessCounterService, this.sessionController.getLoginUserId());
    }

    public void sendUnreadEvent(ContentInterface contentInterface, boolean ignoreAccessCounterService, Long userId) throws Exception {
        if (this.sessionController.isInClusterMode()) {
            return;
        }
        ContentInterface realContentInterface = contentInterface.getAccessCounterContentObject();
        if (realContentInterface.getContentSize(true) >= 0L) {
            MessageUtils mu = new MessageUtils();
            mu.sendUnreadEvent(this.sessionController, realContentInterface, ignoreAccessCounterService, userId);
        }
    }
}

