/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.AttributeValueArray;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;

public class AttributeValueLongArray
extends AttributeValueArray {
    public AttributeValueLongArray(Integer counter) {
        this.attributeValue = counter;
    }

    public AttributeValueLongArray(AttributeValue[] values) {
        int len = values.length;
        Long[] array = new Long[len];
        this.attributeValue = len;
        this.attributeObjectArray = array;
        for (int i = 0; i < len; ++i) {
            array[i] = values[i].getObject();
        }
    }

    public AttributeValueLongArray(Long[] value) {
        this.attributeObjectArray = value;
        this.attributeValue = new Integer(this.getArrayLength());
    }

    public AttributeValueLongArray(long[] values) {
        int len;
        this.attributeObjectArray = null;
        Long[] lArr = null;
        if (values != null && (len = values.length) != 0) {
            lArr = new Long[len];
            for (int i = 0; i < len; ++i) {
                lArr[i] = new Long(values[i]);
            }
            this.attributeObjectArray = lArr;
            this.attributeValue = new Integer(values.length);
        }
    }

    private Long[] getValue() {
        return (Long[])this.attributeObjectArray;
    }

    @Override
    public String getDataType() {
        return "LONG_ARRAY";
    }

    @Override
    public int getDataTypeInt() {
        return 19;
    }

    @Override
    public int getDataTypeEquals() {
        return this.getDataTypeInt();
    }

    @Override
    public final String getTableName() throws Exception {
        DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        return dbi.getAvLongArrayTableName();
    }

    @Override
    public final String getValueType() {
        return "LONG";
    }

    @Override
    public int getArrayLength() {
        return this.getValue() == null ? 0 : this.getValue().length;
    }

    @Override
    public String getXMLTag(SessionController sessionController, String attributeName, boolean globalObjectOnly) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.setXMLStartTag(attributeName));
        sb.append(">\n");
        Long[] bArr = this.getLongArrayObject(sessionController);
        if (bArr != null) {
            int len = bArr.length;
            for (int i = 0; i < len; ++i) {
                sb.append(this.getXMLArrayStartTag(attributeName));
                sb.append(">");
                sb.append("" + bArr[i]);
                sb.append(this.getXMLArrayEndTag());
            }
        }
        sb.append(this.setXMLEndTag(attributeName));
        return sb.toString();
    }
}

