/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.AttributeXMLObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.messaging.common.MessageUtils;
import agorum.roi.workers.MetadataInheritor;

public class AttributeXMLObjectUtils {
    public static void attributeObjectAdded(GlobalObjectClientBean obj, AttributeXMLObjectClientBean attributeObj) throws Exception {
        if (obj instanceof FolderObjectClientBean && attributeObj.isInheritable() && attributeObj.isDirectAttached(obj)) {
            MetadataInheritor.queue(obj);
        }
    }

    public static void attributeObjectChanged(AttributeXMLObjectClientBean attributeObj) throws Exception {
        new MessageUtils().sendUpdateToMetaDataInheritanceEvent(attributeObj, null);
    }

    public static void itemAdded(GlobalObjectClientBean parent, GlobalObjectClientBean obj) throws Exception {
        MetadataInheritor.inherit(AttributeXMLObjectUtils.asAdmin(obj), null);
    }

    public static void itemRemoved(GlobalObjectClientBean parent, GlobalObjectClientBean obj) throws Exception {
        MetadataInheritor.inherit(AttributeXMLObjectUtils.asAdmin(obj), parent);
    }

    private static <T extends GlobalObjectClientBean> T asAdmin(T obj) throws Exception {
        SessionController sessionController = obj.getSessionController();
        if (sessionController.isAdminEnabled()) {
            return obj;
        }
        return (T)sessionController.asAdmin().getGlobalObjectById(obj.getId());
    }
}

