/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.SystemObjectReference;
import agorum.roi.common.utils.MetaDbNameMatcherUtils;
import agorum.roi.ejb.client.beans.ChangeHistoryRelationObjectClientBean;
import agorum.roi.ejb.client.beans.ChangeHistoryRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ChangeHistoryBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CopyUtils;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.exception.RoiException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class ChangeHistoryUtils {
    private SessionController sessionController = null;
    private MetaDb metaDb = null;
    private static String METADBOFFSET = "MAIN_MODULE_MANAGEMENT/roi/control/changeHistory/";
    private long actTime;
    private CoreStatistic stat = CoreStatistic.getInstance();
    private static final Set<Long> restoring = new HashSet<Long>();

    public ChangeHistoryUtils(SessionController sessionController) {
        this.sessionController = sessionController;
        try {
            this.metaDb = this.sessionController.getMetaDbInstance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void makeHistoryWithUpdate(GlobalObjectClientBean clientBean, GlobalObjectClientBeanDefinition clientBeanDef, GlobalObjectClientBeanDefinition updateDef) throws Exception {
        boolean historyMade;
        if (clientBean.getId().equals(clientBean.getSessionController().getObjectIdNextHistoryEnsured())) {
            if (updateDef == null) {
                updateDef = (GlobalObjectClientBeanDefinition)clientBean.getNewDefinition(clientBean.getSessionController());
            }
            updateDef.setSystemOption("forceMakeHistory", "true");
            clientBean.getSessionController().resetObjectIdNextHistoryEnsured();
        }
        if (historyMade = this.makeHistory(clientBean, clientBeanDef, updateDef)) {
            GlobalObjectClientBean gocb = clientBean;
            boolean forceHistory = false;
            if (updateDef != null && updateDef.getSystemOption("forceMakeHistory") != null) {
                forceHistory = true;
            }
            if (!forceHistory && gocb.getLockState() != 0) {
                boolean makeUpdate = false;
                if (updateDef == null) {
                    updateDef = (GlobalObjectClientBeanDefinition)clientBean.getNewDefinition(clientBean.getSessionController());
                    makeUpdate = true;
                }
                updateDef.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(gocb.getSystemFlags() | GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT));
                if (makeUpdate) {
                    updateDef.setSystemOption("makeNoHistory", "");
                    clientBean.update(updateDef);
                }
            }
        }
    }

    public boolean makeHistory(GlobalObjectClientBean clientBean) throws Exception {
        return this.makeHistory(clientBean, null, null);
    }

    public boolean makeHistory(GlobalObjectClientBean clientBean, GlobalObjectClientBeanDefinition clientBeanDef) throws Exception {
        return this.makeHistory(clientBean, clientBeanDef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean makeHistory(GlobalObjectClientBean clientBean, GlobalObjectClientBeanDefinition clientBeanDef, SuperObjectClientBeanDefinition updateDef) throws Exception {
        if (!clientBean.shouldMakeHistory() || clientBean.isHistoryObject()) {
            return false;
        }
        boolean bRet = false;
        if (this.checkNextHistory(clientBean, clientBeanDef, updateDef)) {
            try (Transaction t = new Transaction();){
                boolean forceAudit = this.sessionController.forceAudit();
                try {
                    if (clientBeanDef != null && clientBeanDef.getSystemOption("enableAuditForHistory") != null && this.sessionController.isInSychronization()) {
                        this.sessionController.setForceAudit(true);
                    }
                    SuperObjectClientBeanDefinition def = clientBean.getHistoryDefinition(this.sessionController);
                    def.setSystemOption("ChangeHistoryCopy", "");
                    def.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT | GlobalObjectClientBean.SYSTEMFLAG_PROTOHISTORYOBJECT));
                    DirectoryUserObjectClientBean lstModifier = clientBean.getLastModifier();
                    Date lstModifyDate = clientBean.getLastModifyDate();
                    Date cmDate = null;
                    if (clientBean instanceof ContentInterface && (cmDate = ((ContentInterface)((Object)clientBean)).getLastContentModifyDate()).getTime() > lstModifyDate.getTime()) {
                        lstModifyDate = cmDate;
                    }
                    GlobalObjectClientBean goHist = (GlobalObjectClientBean)CopyUtils.fullCopy(clientBean, def);
                    String[] scopeAclNames = clientBean.getScopeAclNames();
                    if (scopeAclNames != null) {
                        SuperObjectClientBeanDefinition scopeAclDef = goHist.getNewDefinition(this.sessionController);
                        scopeAclDef.setSystemOption("doNotEA", "true");
                        scopeAclDef.setSystemOption("setScopeAcls", scopeAclNames);
                        scopeAclDef.setSystemOption("leaveAclToAllObjects", "true");
                        goHist.leaveAcl(null, scopeAclDef);
                    }
                    Date lmDateHOObject = goHist.getLastModifyDate();
                    RelationObjectClientBean histRel = clientBean.addRelationship(goHist, (RelationObjectClientBeanDefinition)new ChangeHistoryRelationObjectClientBeanDefinition(this.sessionController));
                    SuperObjectClientBeanDefinition goHistDef = goHist.getNewDefinition(this.sessionController);
                    goHistDef.setAttribute(GlobalObjectClientBean.SYSTEMFLAGS_ATTRIBUTE, AttributeValue.newAttributeValueObject(GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT));
                    goHistDef.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(lstModifyDate));
                    goHistDef.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(lstModifier));
                    if (cmDate != null) {
                        goHistDef.setAttribute(FileObjectClientBean.LASTCONTENTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(cmDate));
                    }
                    goHistDef.setSystemOption("makeNoHistory", "");
                    goHist.update(goHistDef);
                    Object hcDate = null;
                    if (clientBeanDef != null) {
                        hcDate = clientBeanDef.getSystemOption("historyCreateDate");
                    }
                    if (hcDate == null && updateDef != null) {
                        hcDate = updateDef.getSystemOption("historyCreateDate");
                    }
                    if (hcDate != null) {
                        histRel.setCreateDate((Date)hcDate);
                    }
                    bRet = true;
                    GenericCache gc = this.getGenericCache(clientBean);
                    ChangeHistoryBean chb = new ChangeHistoryBean();
                    chb.setLastModifier(this.sessionController.getLoginUserId());
                    chb.setLastModifyDate(lmDateHOObject);
                    gc.put((Object)clientBean.getId(), (Object)chb);
                    this.deleteToMaxHistory(clientBean);
                }
                finally {
                    if (this.sessionController.isInSychronization()) {
                        this.sessionController.setForceAudit(forceAudit);
                    }
                }
                t.commit();
            }
        }
        return bRet;
    }

    private GenericCache getGenericCache(GlobalObjectClientBean clientBean) throws Exception {
        String cacheName = this.getChangeHistoryUtilsCacheName(clientBean);
        return GenericCache.getInstance((Object)cacheName, (int)Integer.MAX_VALUE, (int)10000, (int)this.getNextHisxtoryTime(clientBean));
    }

    private boolean checkLastModifier(GlobalObjectClientBean clientBean) throws Exception {
        boolean lastModifierChanged = false;
        long creator = clientBean.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE).getLong();
        if (this.sessionController.getLoginUserId() != creator && this.checkHistoryAfterCreateDate(clientBean)) {
            lastModifierChanged = true;
        }
        return lastModifierChanged;
    }

    private boolean checkHistoryAfterCreateDate(GlobalObjectClientBean clientBean) throws Exception {
        boolean historyAfterCreateDate = false;
        historyAfterCreateDate = clientBean.getCreateDate().getTime() < this.actTime - this.getFirstHistoryAfterCreate(clientBean);
        return historyAfterCreateDate;
    }

    private boolean checkNextHistory(GlobalObjectClientBean clientBean, GlobalObjectClientBeanDefinition clientBeanDef, SuperObjectClientBeanDefinition updateDef) throws Exception {
        this.actTime = System.currentTimeMillis();
        boolean makeHistory = false;
        boolean forceHistory = false;
        if (updateDef != null && updateDef.getSystemOption("forceMakeHistory") != null) {
            forceHistory = true;
        }
        if (clientBeanDef != null && clientBeanDef.getSystemOption("forceMakeHistory") != null) {
            forceHistory = true;
            clientBeanDef.setSystemOption("forceMakeHistory", null);
        }
        if (!forceHistory && clientBean.getSessionController().isService()) {
            return false;
        }
        boolean makeNoHistory = false;
        if (clientBeanDef != null && clientBeanDef.getSystemOption("makeNoHistory") != null) {
            makeNoHistory = true;
        }
        GenericCache gc = this.getGenericCache(clientBean);
        if (!makeNoHistory && !gc.contains((Object)clientBean.getId()) || forceHistory) {
            boolean lastModifierChanged = this.checkLastModifier(clientBean);
            if ((clientBean.getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_INHISTORYOBJECT) == 0L && this.checkObjectForHistory(clientBean, (GlobalObjectClientBeanDefinition)updateDef, gc, forceHistory)) {
                if (forceHistory) {
                    makeHistory = true;
                } else if (lastModifierChanged) {
                    makeHistory = true;
                } else {
                    long lastUpdateHist;
                    GlobalObjectClientBean gocbLastHist;
                    ChangeHistoryBean chb = null;
                    boolean historyAfterCreateDate = this.checkHistoryAfterCreateDate(clientBean);
                    if (!historyAfterCreateDate && (gocbLastHist = this.getLastHistoryObject(clientBean)) != null && (lastUpdateHist = gocbLastHist.getLastModifyDate().getTime()) >= this.actTime - (long)this.getNextHisxtoryTime(clientBean)) {
                        chb = this.createChangeHistoryBean(gocbLastHist.getAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE).getLong(), gocbLastHist.getLastModifyDate());
                        gc.put((Object)clientBean.getId(), (Object)chb);
                    }
                    if (historyAfterCreateDate) {
                        makeHistory = true;
                    } else {
                        gc.put((Object)clientBean.getId(), (Object)this.createChangeHistoryBean(this.sessionController.getLoginUserId(), new Date()));
                    }
                }
            }
        }
        return makeHistory;
    }

    private ChangeHistoryBean createChangeHistoryBean(long lastModifier, Date lastModifyDate) throws Exception {
        ChangeHistoryBean chb = new ChangeHistoryBean();
        chb.setLastModifier(new Long(lastModifier));
        chb.setLastModifyDate(lastModifyDate);
        return chb;
    }

    private String getChangeHistoryUtilsCacheName(GlobalObjectClientBean clientBean) throws Exception {
        return "ChangeHistoryUtilsCache_" + this.sessionController.getSessionId();
    }

    private int getNextHisxtoryTime(GlobalObjectClientBean clientBean) throws Exception {
        int nextHistoryTime = 100;
        try {
            String[] sArray = this.getMetaDbValue(this.metaDb, "NextHistoryTime", clientBean);
            if (sArray != null) {
                nextHistoryTime = new Integer(sArray[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return nextHistoryTime * 1000;
    }

    private String[] getMetaDbValue(MetaDb metaDb, String name, GlobalObjectClientBean clientBean) throws Exception {
        String nameExtension = null;
        if (clientBean != null) {
            nameExtension = clientBean.getNameExtension();
        }
        String[] values = null;
        if (nameExtension != null) {
            values = MetaDbSuperCache.getSimplePropertyValues(this.sessionController, METADBOFFSET + nameExtension + "/" + name);
        }
        if (values == null) {
            values = MetaDbSuperCache.getSimplePropertyValues(this.sessionController, METADBOFFSET + name);
        }
        return values;
    }

    private boolean checkObjectNameForHistory(GlobalObjectClientBean clientBean) throws Exception {
        MetaDbNameMatcherUtils metaDbNameMatcherUtils = new MetaDbNameMatcherUtils(this.metaDb);
        return metaDbNameMatcherUtils.nameNotMatches(clientBean.getName(), METADBOFFSET + "NotObjectNameForHistory");
    }

    private boolean checkObjectForHistory(GlobalObjectClientBean clientBean, GlobalObjectClientBeanDefinition clientBeanDef, GenericCache gc, boolean forceHistory) throws Exception {
        boolean makeHistory = false;
        if (clientBeanDef != null && clientBeanDef.getSystemOption("doNotCreateHistory") != null) {
            System.err.println("KEINE History erstellen, da SystemOption \"doNotCreateHistory\" gesetzt");
        } else if ((clientBean.getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_HISTORYOBJECT) <= 0L) {
            String[] excludeIds = this.getHistoryExcludeIds(clientBean);
            boolean doExclude = false;
            if (excludeIds != null) {
                int len = excludeIds.length;
                String id = "" + clientBean.getId();
                for (int i = 0; i < len; ++i) {
                    if (!excludeIds[i].equals(id)) continue;
                    doExclude = true;
                }
            }
            if (!doExclude) {
                String classnameClinetBean = clientBean.getClassName();
                String[] historyClassNames = this.getHistoryClassNames(clientBean);
                if (historyClassNames != null) {
                    int len = historyClassNames.length;
                    for (int i = 0; i < len; ++i) {
                        if (!classnameClinetBean.equalsIgnoreCase(historyClassNames[i])) continue;
                        if (forceHistory || this.checkObjectNameForHistory(clientBean)) {
                            makeHistory = true;
                        }
                        break;
                    }
                }
            } else {
                makeHistory = false;
            }
        } else {
            System.err.println("KEINE History erstellen, da es ein HistoryObject ist");
        }
        if (!makeHistory) {
            gc.put((Object)clientBean.getId(), (Object)this.createChangeHistoryBean(this.sessionController.getLoginUserId(), new Date()));
        }
        return makeHistory;
    }

    public void deleteToMaxHistory(GlobalObjectClientBean clientBean) throws Exception {
        this.deleteHistoryObjects(clientBean, this.getMaxHistoryCounter(clientBean));
    }

    public int getMaxHistoryCounter(GlobalObjectClientBean clientBean) throws Exception {
        int maxHistoryCounter = -1;
        try {
            String[] sArray = this.getMetaDbValue(this.metaDb, "MaxHistoryCounter", clientBean);
            if (sArray != null) {
                maxHistoryCounter = Integer.parseInt(sArray[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (maxHistoryCounter <= 0) {
            maxHistoryCounter = -1;
        }
        return maxHistoryCounter;
    }

    public String[] getHistoryClassNames(GlobalObjectClientBean clientBean) throws Exception {
        String[] historyClassNames = new String[]{FileObjectClientBean.CLASS_NAME};
        try {
            String[] sArray = this.getMetaDbValue(this.metaDb, "HistoryClassNames", clientBean);
            if (sArray != null) {
                historyClassNames = sArray;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return historyClassNames;
    }

    private String[] getHistoryExcludeIds(GlobalObjectClientBean clientBean) throws Exception {
        String[] historyExcludeIds = null;
        try {
            historyExcludeIds = this.getMetaDbValue(this.metaDb, "ExcludeIdList", clientBean);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return historyExcludeIds;
    }

    public long getFirstHistoryAfterCreate(GlobalObjectClientBean clientBean) throws Exception {
        long firstHistoryAfterCreate = 60L;
        try {
            String[] sArray = this.getMetaDbValue(this.metaDb, "FirstHistoryAfterCreate", clientBean);
            if (sArray != null) {
                firstHistoryAfterCreate = new Integer(sArray[0]).intValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return firstHistoryAfterCreate * 1000L;
    }

    public int getHistoryCount(GlobalObjectClientBean clientBean) throws Exception {
        RelationObjectClientBean[] allHist = clientBean.getRightwardRelations(ChangeHistoryRelationObjectClientBean.CLASS_NAME);
        return allHist == null ? 0 : allHist.length;
    }

    public GlobalObjectClientBean[] getHistoryObjects(GlobalObjectClientBean clientBean) throws Exception {
        GlobalObjectClientBean[] allHist = clientBean.getRightwardRelationObjects(ChangeHistoryRelationObjectClientBean.CLASS_NAME);
        if (allHist != null) {
            Arrays.sort(allHist, (l, r) -> l.getId().compareTo(r.getId()));
        }
        return allHist;
    }

    public GlobalObjectClientBean getLastHistoryObject(GlobalObjectClientBean clientBean) throws Exception {
        GlobalObjectClientBean[] allHist = this.getHistoryObjects(clientBean);
        if (allHist == null || allHist.length <= 0) {
            return null;
        }
        return allHist[allHist.length - 1];
    }

    public void deleteHistoryObjects(GlobalObjectClientBean clientBean, int keep) throws Exception {
        if (keep < 0) {
            this.stat.info().object((SystemObjectReference)clientBean).send("History deletion is globally disabled");
            return;
        }
        GlobalObjectClientBean[] allHist = this.getHistoryObjects(clientBean);
        if (allHist == null) {
            return;
        }
        int remove = allHist.length - keep;
        if (remove > 2) {
            remove = 2;
        }
        try (Transaction t = new Transaction();){
            for (int i = 1; i < remove; ++i) {
                if (ChangeHistoryUtils.isRestoring(allHist[i]) || (allHist[i].getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_SPECIALBEHAVIOUR) > 0L) continue;
                clientBean.getSessionController().asAdmin().getGlobalObjectById(allHist[i].getId()).deleteInternal(null);
            }
            t.commit();
        }
    }

    public void restoreHistoryObject(GlobalObjectClientBean oldObject, GlobalObjectClientBean historyObject) throws Exception {
        this.restoreHistoryObject(oldObject, historyObject, null);
    }

    public void restoreHistoryObject(GlobalObjectClientBean oldObject, GlobalObjectClientBean historyObject, Boolean history) throws Exception {
        if (historyObject == null || oldObject == null) {
            throw new RoiException("History object or old object is null");
        }
        GlobalObjectClientBean[] histObjects = this.getHistoryObjects(oldObject);
        boolean isHistoryObject = false;
        for (GlobalObjectClientBean histObject : histObjects) {
            if (!histObject.equals(historyObject)) continue;
            isHistoryObject = true;
            break;
        }
        if (isHistoryObject) {
            GlobalObjectClientBeanDefinition def = null;
            def = (GlobalObjectClientBeanDefinition)oldObject.getNewDefinition(oldObject.getSessionController());
            def.setSystemOption("forceMakeHistory", "");
            oldObject.restoreHistoryObject(historyObject, def);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restoring(GlobalObjectClientBean obj) throws Exception {
        Set<Long> set = restoring;
        synchronized (set) {
            restoring.add(obj.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restored(GlobalObjectClientBean obj) throws Exception {
        Set<Long> set = restoring;
        synchronized (set) {
            restoring.remove(obj.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRestoring(GlobalObjectClientBean obj) throws Exception {
        Set<Long> set = restoring;
        synchronized (set) {
            return restoring.contains(obj.getId());
        }
    }
}

