/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.SessionController;
import com.drew.imaging.FileType;
import com.drew.imaging.FileTypeDetector;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.GpsDirectory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ContentTaskImageMetaExtractor
implements ContentTaskInterface {
    private static final String keyStub = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/";

    @Override
    public void runTask(SessionController sessionController, ContentInterface contentInterface, boolean doDelete) throws Exception {
        MetaDb metaDb = sessionController.getMetaDbInstance();
        GlobalObjectClientBean content = (GlobalObjectClientBean)((Object)contentInterface);
        try (BufferedInputStream bis = new BufferedInputStream(contentInterface.getContentStream());){
            String key;
            FileType fileT = FileTypeDetector.detectFileType((BufferedInputStream)bis);
            switch (fileT) {
                case Jpeg: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/JPG";
                    break;
                }
                case Tiff: 
                case Arw: 
                case Cr2: 
                case Nef: 
                case Orf: 
                case Rw2: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/TIF";
                    break;
                }
                case Png: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PNG";
                    break;
                }
                case Bmp: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/BMP";
                    break;
                }
                case Gif: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/GIF";
                    break;
                }
                default: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/JPG";
                }
            }
            String[] properties = metaDb.getSimplePropertyValue(key + "/ImageMetaProperties");
            String[] mapping = metaDb.getSimplePropertyValue(key + "/ExtendedAttributeMapping");
            if (properties.length != mapping.length) {
                throw new Exception("Error: Properties list has to be same length then mapping list");
            }
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)bis);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String dirName = directory.getName();
                    Object metaValue = directory.getObject(tag.getTagType());
                    if (metaValue == null) continue;
                    for (int i = 0; i < properties.length; ++i) {
                        if (!(dirName + ":" + tagName).equalsIgnoreCase(properties[i])) continue;
                        if (metaValue instanceof Number) {
                            Double d = ((Number)metaValue).doubleValue();
                            if (d.isInfinite()) continue;
                            if (mapping[i].equals("image_gps_version_id")) {
                                content.setExtendedAttribute(mapping[i], "" + d);
                                continue;
                            }
                            content.setExtendedAttribute(mapping[i], (double)d);
                            continue;
                        }
                        if (directory instanceof GpsDirectory) {
                            if (properties[i].equals("GPS:GPS Latitude")) {
                                content.setExtendedAttribute(mapping[i], ((GpsDirectory)directory).getGeoLocation().getLatitude());
                                continue;
                            }
                            if (properties[i].equals("GPS:GPS Longitude")) {
                                content.setExtendedAttribute(mapping[i], ((GpsDirectory)directory).getGeoLocation().getLongitude());
                                continue;
                            }
                        }
                        if (metaValue.getClass().isArray()) {
                            content.setExtendedAttribute(mapping[i], tag.getDescription());
                            continue;
                        }
                        content.setExtendedAttribute(mapping[i], metaValue);
                    }
                }
            }
            GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)content.getNewDefinition(sessionController);
            def.setSystemOption("doNotEA", "");
            content.saveExtendedAttributes(def);
        }
    }

    public static void main(String[] args) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File("c:\\Users\\oliver.schulze\\Downloads\\#3268 betroffene Datei.jpg")));){
            FileType fileT = FileTypeDetector.detectFileType((BufferedInputStream)bis);
            String key = null;
            switch (fileT) {
                case Jpeg: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/JPG";
                    break;
                }
                case Tiff: 
                case Arw: 
                case Cr2: 
                case Nef: 
                case Orf: 
                case Rw2: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/TIF";
                    break;
                }
                case Png: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/PNG";
                    break;
                }
                case Bmp: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/BMP";
                    break;
                }
                case Gif: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/GIF";
                    break;
                }
                default: {
                    key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask/JPG";
                }
            }
            String[] properties = new String[]{"Exif IFD0:X Resolution", "Exif IFD0:Y Resolution", "Exif IFD0:Copyright", "Exif IFD0:Date/Time", "JPEG:Image Width", "JPEG:Image Height", "GPS:GPS Latitude", "GPS:GPS Longitude", "Exif SubIFD:Exposure Time", "GPS:GPS Version ID"};
            String[] mapping = new String[]{"image_x_resolution", "image_y_resolution", "image_copyright", "image_date_time", "image_width", "image_height", "image_gps_latitude", "image_gps_longitude", "image_exposure_time", "image_gps_version_id"};
            if (properties.length != mapping.length) {
                throw new Exception("Error: Properties list has to be same length then mapping list");
            }
            Metadata metadata = ImageMetadataReader.readMetadata((InputStream)bis);
            for (Directory directory : metadata.getDirectories()) {
                for (Tag tag : directory.getTags()) {
                    String tagName = tag.getTagName();
                    String dirName = directory.getName();
                    Object metaValue = directory.getObject(tag.getTagType());
                    if (metaValue == null) continue;
                    for (int i = 0; i < properties.length; ++i) {
                        if (!(dirName + ":" + tagName).equalsIgnoreCase(properties[i])) continue;
                        if (metaValue instanceof Number) {
                            Double d = ((Number)metaValue).doubleValue();
                            if (d.isInfinite()) continue;
                            if (mapping[i].equals("image_gps_version_id")) {
                                System.out.println(mapping[i] + "=\"" + metaValue + "\"");
                            }
                            System.out.println(mapping[i] + "=" + d);
                            continue;
                        }
                        if (directory instanceof GpsDirectory) {
                            if (properties[i].equals("GPS:GPS Latitude")) {
                                System.out.println(mapping[i] + "=" + ((GpsDirectory)directory).getGeoLocation().getLatitude());
                                continue;
                            }
                            if (properties[i].equals("GPS:GPS Longitude")) {
                                System.out.println(mapping[i] + "=" + ((GpsDirectory)directory).getGeoLocation().getLongitude());
                                continue;
                            }
                        }
                        if (metaValue.getClass().isArray()) {
                            System.out.println(mapping[i] + "=" + tag.getDescription());
                            continue;
                        }
                        System.out.println(mapping[i] + "=" + metaValue);
                    }
                }
            }
        }
    }
}

