/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.string.StringConverterUtils;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ContentTaskXmlConverter
implements ContentTaskInterface {
    @Override
    public void runTask(SessionController sessionController, ContentInterface contentInterface, boolean doDelete) throws Exception {
        FolderObjectClientBean folder = null;
        try {
            folder = ((GlobalObjectClientBean)((Object)contentInterface)).getParents()[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (folder != null) {
            String name = "." + contentInterface.getName();
            try {
                ParserObject po = null;
                RoiXMLParser roiXMLParser = null;
                roiXMLParser = new RoiXMLParser(sessionController);
                roiXMLParser.setDocument(contentInterface.getContentStream());
                po = roiXMLParser.parse();
                CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(sessionController, folder);
                createRoiObjectsFromParseObject.create(po);
                GlobalObjectClientBean oldObj = folder.getItem(name + ".parseError.txt");
                if (oldObj != null) {
                    SuperObjectClientBeanDefinition def = oldObj.getDefinition(sessionController);
                    def.setSystemOption("parentFolderOfDeleteObject", folder);
                    oldObj.delete(def);
                }
            }
            catch (Exception e) {
                String s = StringConverterUtils.toString((Throwable)e);
                ByteArrayInputStream is = StringConverterUtils.toStream((String)s);
                this.createFile(sessionController, name + ".parseError.txt", folder, is);
            }
            if (doDelete) {
                ((GlobalObjectClientBean)((Object)contentInterface)).deleteDeferred();
            }
        }
    }

    private FileObjectClientBean createFile(SessionController sessionController, String name, FolderObjectClientBean folder, InputStream content) throws Exception {
        FileObjectClientBean fRet = null;
        GlobalObjectClientBean oldObj = folder.getItem(name);
        FileObjectSessionFacade fileSessionFacade = new FileObjectSessionFacade(sessionController);
        if (oldObj != null) {
            fileSessionFacade.setGlobalObject(oldObj);
        }
        fileSessionFacade.setWithTransaction(true);
        fileSessionFacade.setDestinationFolder(folder);
        fileSessionFacade.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
        fileSessionFacade.setContentStream(content);
        fRet = oldObj == null ? (FileObjectClientBean)fileSessionFacade.create() : (FileObjectClientBean)fileSessionFacade.update();
        return fRet;
    }
}

