/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.commons.encrypt.md5.MD5Encoder;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemObjectReference;
import agorum.roi.common.ObjectUpdateCollector;
import agorum.roi.contenthash.common.ContentHashUtils;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttributeXMLObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailAttachmentsRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailBodyRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailMsgRelationObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.BackendInformationBean;
import agorum.roi.ejb.common.ChangeHistoryUtils;
import agorum.roi.ejb.common.ConfigurableContentTaskInterface;
import agorum.roi.ejb.common.ContentInputStreamWrapper;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentOutputStreamWrapper;
import agorum.roi.ejb.common.ContentTaskInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.DbRandomAccessFile;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.LockUtils;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UpdateCounterCacheHandler;
import agorum.roi.ejb.interfaces.home.ContentHome;
import agorum.roi.ejb.interfaces.remote.ContentRemote;
import agorum.roi.exception.RoiException;
import agorum.roi.parser.mail.EmlParser;
import agorum.roi.selector.Selector;
import agorum.roi.statistic.ContentTaskStatistic;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class ContentUtils
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SessionController sessionController = null;
    private ContentInterface contentInterface = null;
    private long fileSize;
    private long updateCounter = -1L;
    private boolean isOpen;
    private String formatTableName;
    private boolean hasBeenChecked;
    private boolean hasReadBeenChecked;
    private boolean hasWriteAccess;
    private boolean hasReadAccess;
    private ContentRemote contentRemote;
    private long blockSize;
    private boolean setSize;
    private boolean hadWrites;
    private static Object syncObj = new Object();
    private static long globalContentUtilsId;
    private long contentUtilsId = -1L;
    private static Hashtable contentTaskSessions;
    private final Object ctSync = new Object();
    private static final Statistic stat;
    private static String[] MAIL_RELATION_TYPES;

    public ContentUtils(SessionController sessionController, ContentInterface contentInterface) throws Exception {
        this.sessionController = sessionController;
        this.contentInterface = contentInterface;
        try {
            this.blockSize = contentInterface.getBlockSize();
        }
        catch (Exception e) {
            stat.error((Throwable)e);
        }
        if (contentInterface != null) {
            this.checkFileObjectReadAcces(contentInterface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentUtilsId() {
        block11: {
            Object object = syncObj;
            synchronized (object) {
                if (this.contentUtilsId == -1L) {
                    this.contentUtilsId = globalContentUtilsId++;
                }
            }
            if (this.contentInterface != null && this.contentInterface instanceof GlobalObjectClientBean) {
                try {
                    long uc = UpdateCounterCacheHandler.getInstance().getUpdateCounter((GlobalObjectClientBean)((Object)this.contentInterface));
                    if (uc == this.updateCounter) break block11;
                    if (this.updateCounter != -1L) {
                        Object object2 = syncObj;
                        synchronized (object2) {
                            this.contentUtilsId = globalContentUtilsId++;
                        }
                    }
                    this.updateCounter = uc;
                }
                catch (Exception e) {
                    CoreStatistic.getInstance().error((Throwable)e);
                }
            }
        }
        return this.contentUtilsId;
    }

    public InputStream getContentStream() throws Exception {
        ContentInputStreamWrapper csw = new ContentInputStreamWrapper(this.sessionController, this.contentInterface, this.contentInterface.getContentSize());
        return csw;
    }

    public InputStream getContentStreamNoRead() throws Exception {
        ContentInputStreamWrapper csw = new ContentInputStreamWrapper(this.sessionController, this.contentInterface, this.contentInterface.getContentSize(), false);
        return csw;
    }

    public DbRandomAccessFile getRandomAccessFile() throws IOException {
        this.isOpen = true;
        return new DbRandomAccessFile(this.sessionController, this.contentInterface);
    }

    public OutputStream getContentOutputStream() throws Exception {
        this.checkFileObjectAcces();
        ContentOutputStreamWrapper csw = new ContentOutputStreamWrapper(this.sessionController, this.contentInterface);
        return csw;
    }

    public OutputStream getContentOutputStream(boolean makeHistory) throws Exception {
        this.checkFileObjectAcces();
        ContentOutputStreamWrapper csw = new ContentOutputStreamWrapper(this.sessionController, this.contentInterface, makeHistory);
        return csw;
    }

    public void clearContent(SessionController sessionController, Long id, String tableName) throws RemoteException, RoiException {
        ContentRemote remContent = null;
        try {
            remContent = this.getContentRemote();
            remContent.clearContent(sessionController, id, tableName, this.contentInterface, this);
        }
        catch (Exception e) {
            stat.warning().objectId(id).send((Throwable)e);
            if (e instanceof RoiException) {
                throw (RoiException)e;
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            throw new RoiException("Error in clearContent", e);
        }
    }

    public void openTransfer() throws Exception {
        this.openTransfer(null, true);
    }

    public void openTransfer(GlobalObjectClientBeanDefinition def) throws Exception {
        this.openTransfer(def, true);
    }

    public void openTransfer(GlobalObjectClientBeanDefinition def, boolean makeHistory) throws Exception {
        this.checkFileObjectAcces();
        ContentRemote remContent = this.getContentRemote();
        if (makeHistory && this.contentInterface.shouldMakeHistory()) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            chu.makeHistoryWithUpdate((GlobalObjectClientBean)((Object)this.contentInterface), def, null);
        }
        this.formatTableName = this.contentInterface.getTableName();
        remContent.openTransfer(this.sessionController, this.contentInterface.getContent(), this.formatTableName, this.contentInterface, this);
        this.fileSize = 0L;
        this.isOpen = true;
        this.setSize = true;
    }

    public void closeTransfer() throws Exception {
        ContentRemote remContent = this.getContentRemote();
        if (this.isOpen) {
            remContent.closeTransfer(this.sessionController, this.contentInterface.getContent(), this);
            if (this.setSize) {
                if (this.contentInterface instanceof AttributeXMLObjectClientBean && this.contentInterface.getContentSize(true) == this.fileSize) {
                    GlobalObjectClientBean gocb = (GlobalObjectClientBean)((Object)this.contentInterface);
                    SuperObjectClientBeanDefinition def = gocb.getNewDefinition(this.sessionController);
                    def.setAttribute(FileObjectClientBean.CONTENTSIZE_ATTRIBUTE, AttributeValue.newAttributeValueObject(this.fileSize));
                    gocb.executeAfterUpdate(def);
                } else {
                    this.contentInterface.setContentSize(this.fileSize);
                }
            }
        }
        this.setSize = false;
        this.isOpen = false;
        if (this.hadWrites) {
            ContentUtils contentUtils = new ContentUtils(this.sessionController, this.contentInterface);
            contentUtils.performContentTask(false);
            this.hadWrites = false;
        }
    }

    public void clearCache() throws Exception {
        ContentRemote remContent = this.getContentRemote();
        if (this.isOpen) {
            remContent.clearCache(this.sessionController, this.contentInterface.getId(), this);
        }
    }

    public void transferContent(ContentTransferBean ctb, long blockNumber) throws Exception {
        this.transferContent(ctb, blockNumber, null, true);
    }

    public void transferContent(ContentTransferBean ctb, long blockNumber, GlobalObjectClientBeanDefinition def) throws Exception {
        this.transferContent(ctb, blockNumber, def, true);
    }

    public void transferContent(ContentTransferBean ctb, long blockNumber, GlobalObjectClientBeanDefinition def, boolean makeHistory) throws Exception {
        this.hadWrites = true;
        this.checkFileObjectAcces();
        if (makeHistory) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            chu.makeHistory((GlobalObjectClientBean)((Object)this.contentInterface), def);
        }
        this.fileSize += (long)ctb.getBufferLength();
        ContentRemote remContent = this.getContentRemote();
        remContent.transferContent(this.sessionController, ctb, this.contentInterface.getContent(), blockNumber, this.formatTableName, (int)this.blockSize, this);
    }

    public void transferContentUpdate(ContentTransferBean ctb, long blockNumber, boolean makeHistory) throws Exception {
        this.hadWrites = true;
        this.isOpen = true;
        this.checkFileObjectAcces();
        if (makeHistory) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            chu.makeHistoryWithUpdate((GlobalObjectClientBean)((Object)this.contentInterface), null, null);
        }
        ContentRemote remContent = this.getContentRemote();
        remContent.transferContentUpdate(this.sessionController, ctb, this.contentInterface.getContent(), blockNumber, this.formatTableName, (int)this.blockSize, this);
    }

    public void setContent(InputStream is) throws Exception {
        this.setContent(is, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(InputStream is, GlobalObjectClientBeanDefinition def) throws Exception {
        try {
            boolean makeHistory = def == null || def.getSystemOption("doNotCreateHistory") == null;
            this.openTransfer(def, makeHistory);
            if (is != null) {
                int max = (int)this.blockSize;
                byte[] buffer = new byte[max];
                long blockNumber = 0L;
                while (true) {
                    int read;
                    int offset = 0;
                    while (max - offset > 0 && (read = is.read(buffer, offset, max - offset)) > 0) {
                        offset += read;
                    }
                    if (offset <= 0) break;
                    this.transferContent(new ContentTransferBean(buffer, offset), blockNumber++, def, makeHistory);
                    makeHistory = false;
                }
            }
            this.sessionController.reconnectIfNeeded();
            this.closeTransfer();
        }
        catch (Exception e) {
            stat.warning((Throwable)e);
            ExceptionUtils.handleException(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void openForRead() throws Exception {
        GlobalObjectClientBean rootObject;
        GlobalObjectClientBean object;
        this.formatTableName = this.contentInterface.getTableName();
        if (this.contentInterface instanceof GlobalObjectClientBean && ((object = (GlobalObjectClientBean)((Object)this.contentInterface)).getSystemFlags() & GlobalObjectClientBean.SYSTEMFLAG_COMPRESSED) > 0L && (rootObject = this.getRootObject(object.getMainObj())) instanceof MailObjectClientBean) {
            EmlParser.reParse((MailObjectClientBean)rootObject);
        }
    }

    private GlobalObjectClientBean getRootObject(GlobalObjectClientBean object) throws Exception {
        for (String type : MAIL_RELATION_TYPES) {
            GlobalObjectClientBean[] left = object.getLeftwardGenericRelationObjects(type);
            if (left == null || left.length <= 0) continue;
            return this.getRootObject(left[0]);
        }
        return object;
    }

    public String getTableName() throws Exception {
        Long foId = this.contentInterface.getFormatId();
        GenericCache gc = GenericCache.getInstance((Object)"FormatObjectTableName", (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        if (gc.contains((Object)foId)) {
            return (String)gc.get((Object)foId);
        }
        FormatObjectClientBean foObj = (FormatObjectClientBean)this.sessionController.getInternalObjectById(foId);
        String tableName = foObj.getTableName();
        gc.put((Object)foId, (Object)tableName);
        return tableName;
    }

    public void closeForRead() throws Exception {
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            ContentRemote remContent = this.getContentRemote();
            remContent.closeForRead(this.sessionController, this.contentInterface, this);
            rth.end();
            rth = null;
        }
        catch (Exception e) {
            stat.warning((Throwable)e, "Error trying to close file");
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception e1) {
                stat.error((Throwable)e1);
            }
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    public boolean validateContent(long contentSize) throws Exception {
        return true;
    }

    public ContentTransferBean getBuffer(long blockNumber, long contentSize, boolean bufferd) throws Exception {
        ContentRemote remContent = this.getContentRemote();
        if (blockNumber * this.blockSize < contentSize) {
            Long content = this.contentInterface.getContent();
            ContentTransferBean ctb = remContent.getBuffer(this.sessionController, content, blockNumber, this.formatTableName, contentSize, this.blockSize, bufferd, this);
            return ctb;
        }
        ContentTransferBean ctb = new ContentTransferBean(null, 0);
        ctb.setIsFilled(false);
        return ctb;
    }

    public void moveContent(BackendInformationBean destBackend) throws RemoteException, Exception {
        System.out.println("Moving content of object " + this.contentInterface.getId() + " to " + destBackend.backendConfiguration + ", db=" + destBackend.storeInDb);
        ContentRemote remContent = this.getContentRemote();
        remContent.moveContent(this.sessionController, this.contentInterface, destBackend, this.blockSize, this);
    }

    private void checkFileObjectAcces() throws Exception {
        this.checkFileObjectAcces(this.contentInterface);
    }

    private void checkFileObjectAcces(ContentInterface contentInterface) throws Exception {
        if (this.sessionController.isAdminEnabled() && this.sessionController.isInSychronization()) {
            return;
        }
        GlobalObjectClientBean go = (GlobalObjectClientBean)((Object)contentInterface);
        if (!this.hasBeenChecked) {
            this.hasBeenChecked = true;
            LockUtils lockUtils = new LockUtils();
            LockUtils.checkLock(this.sessionController, go, null);
            this.hasWriteAccess = contentInterface.checkEffectiveAccess(8L);
        }
        if (!this.hasWriteAccess) {
            ExceptionUtils.handleException("No Access" + go.getPossibleNoAccessCause(), "agorum.roi.remote.exception.SystemFlagsNotDelete", 2000);
        }
    }

    private void checkFileObjectReadAcces(ContentInterface contentInterface) throws Exception {
        if (this.sessionController.isAdminEnabled() && this.sessionController.isInSychronization()) {
            return;
        }
        if (!this.hasReadBeenChecked) {
            this.hasReadBeenChecked = true;
            this.hasReadAccess = contentInterface.checkEffectiveAccess(4L);
        }
        if (!this.hasReadAccess) {
            ExceptionUtils.handleException("No Access to read the file", "agorum.roi.remote.exception.NoAccess", 21);
        }
    }

    public void moveContent(ContentInterface docObj, String sourceTable, String destinationTable) throws Exception {
        ContentRemote remContent = this.getContentRemote();
        remContent.moveContent(this.sessionController, docObj, sourceTable, destinationTable, this);
    }

    public void copyContent(ContentInterface sourceObj, ContentInterface destObj, String sourceTable, String destinationTable, Hashtable systemOptions) throws Exception {
        this.copyContent(sourceObj, destObj, sourceTable, destinationTable, systemOptions, null);
    }

    public void copyContent(ContentInterface sourceObj, ContentInterface destObj, String sourceTable, String destinationTable, Hashtable systemOptions, Boolean history) throws Exception {
        this.checkFileObjectAcces(destObj);
        if (history != Boolean.FALSE) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            GlobalObjectClientBean dest = (GlobalObjectClientBean)((Object)destObj);
            if (history == Boolean.TRUE) {
                GlobalObjectClientBeanDefinition updateDef = (GlobalObjectClientBeanDefinition)dest.getNewDefinition(dest.getSessionController());
                updateDef.setSystemOption("forceMakeHistory", "true");
                chu.makeHistoryWithUpdate((GlobalObjectClientBean)((Object)destObj), null, updateDef);
            } else {
                chu.makeHistoryWithUpdate((GlobalObjectClientBean)((Object)destObj), null, null);
            }
        }
        this.getContentRemote().copyContent(this.sessionController, sourceObj, destObj, sourceTable, destinationTable, this);
    }

    public ContentRemote getContentRemote() throws Exception {
        try {
            if (this.contentRemote == null) {
                ContentHome home = (ContentHome)EJBHomeHolder.getHome("ejb/Content");
                this.contentRemote = home.create();
            }
            return this.contentRemote;
        }
        catch (Exception e) {
            stat.warning().exception((Throwable)e).send("Error accessing remote interface");
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public void performContentTask(boolean runAuto) throws Exception {
        block30: {
            ObjectUpdateCollector.changed(this.contentInterface.getUUID(), "content");
            if (!this.sessionController.makeContentTask() || this.sessionController.isInClusterMode()) {
                return;
            }
            if (this.contentInterface instanceof GlobalObjectClientBean && ((GlobalObjectClientBean)((Object)this.contentInterface)).isTemporary()) {
                return;
            }
            if (this.contentInterface instanceof GlobalObjectClientBean) {
                if (((GlobalObjectClientBean)((Object)this.contentInterface)).isHistoryObject()) {
                    return;
                }
                if (!((GlobalObjectClientBean)((Object)this.contentInterface)).supportsContentTask()) {
                    return;
                }
            }
            try {
                String key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask";
                String[] definitions = MetaDbSuperCache.listSimplePropertyBundles(this.sessionController, key);
                if (definitions == null) break block30;
                int len = definitions.length;
                for (int i = 0; i < len; ++i) {
                    String metaDbPath;
                    if (definitions[i].charAt(0) == '#' || !this.matches(metaDbPath = key + "/" + definitions[i] + "/")) continue;
                    String contentTask = null;
                    try {
                        contentTask = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "Class");
                    }
                    catch (Exception e) {
                        stat.debug((Throwable)e, "Required MetaDb key '" + metaDbPath + "Class' not defined");
                    }
                    if (contentTask == null) continue;
                    String acl = null;
                    try {
                        acl = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "ACL");
                    }
                    catch (Exception e) {
                        stat.debug((Throwable)e, "Required MetaDb key '" + metaDbPath + "ACL' not defined");
                    }
                    AccessControlListObjectClientBean aclObj = null;
                    if (acl != null) {
                        aclObj = this.sessionController.getAclByName(acl);
                    }
                    if (acl != null && aclObj == null) continue;
                    Object contentTaskImpl = null;
                    try {
                        contentTaskImpl = Class.forName(contentTask).newInstance();
                    }
                    catch (Exception e) {
                        stat.error((Throwable)e, "Error creating contentTaskInterface: " + contentTask + ", please check your properties");
                    }
                    if (contentTaskImpl == null) continue;
                    boolean doDelete = Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "DeleteFileAfterTask", "false"));
                    boolean allowEmpty = Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "AllowEmptyFile", "false"));
                    if (!allowEmpty && this.contentInterface.getContentSize() <= 0L) continue;
                    String automaticTaskUser = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "AutomaticTaskUser", null);
                    if (runAuto && automaticTaskUser == null) continue;
                    try {
                        SessionController sessionRun = this.sessionController;
                        ContentInterface ciRun = this.contentInterface;
                        if (runAuto && automaticTaskUser != null && !automaticTaskUser.equalsIgnoreCase(sessionRun.getLoginUser().getName())) {
                            try {
                                sessionRun = this.getContentTaskSession(definitions[i], automaticTaskUser);
                                if (sessionRun != null) {
                                    try {
                                        ciRun = (ContentInterface)((Object)sessionRun.getGlobalObjectById(this.contentInterface.getId()));
                                    }
                                    catch (Exception e) {
                                        stat.error((Throwable)e, "Error getting object with user: " + automaticTaskUser + ", id=" + this.contentInterface.getId());
                                        ciRun = null;
                                    }
                                }
                            }
                            catch (Exception e) {
                                stat.error((Throwable)e);
                                sessionRun = null;
                            }
                        }
                        if (sessionRun != null && ciRun != null) {
                            if (contentTaskImpl instanceof ContentTaskInterface) {
                                ((ContentTaskInterface)contentTaskImpl).runTask(sessionRun, ciRun, doDelete);
                            } else if (contentTaskImpl instanceof ConfigurableContentTaskInterface) {
                                ((ConfigurableContentTaskInterface)contentTaskImpl).runTask(sessionRun, ciRun, doDelete, metaDbPath);
                            }
                        } else if (contentTaskImpl instanceof ConfigurableContentTaskInterface) {
                            ((ConfigurableContentTaskInterface)contentTaskImpl).runTask(sessionRun, ciRun, doDelete, metaDbPath);
                        }
                        stat.count("Content Task '" + contentTask + "' runs", 1L);
                        continue;
                    }
                    catch (Exception e) {
                        if (this.contentInterface != null && this.contentInterface instanceof GlobalObjectClientBean) {
                            stat.error().object((SystemObjectReference)((GlobalObjectClientBean)((Object)this.contentInterface))).exception((Throwable)e).send("Error executing content task: " + contentTask);
                            continue;
                        }
                        stat.error().exception((Throwable)e).send("Error executing content task: " + contentTask);
                    }
                }
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Unable to start any content task");
            }
        }
        ContentHashUtils.addToQueue(this.sessionController, this.contentInterface, true);
    }

    private boolean matches(String metaDbPath) throws Exception {
        String selector = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "Selector");
        if (selector != null) {
            return Selector.compile(selector).selects((GlobalObjectClientBean)((Object)this.contentInterface));
        }
        String extension = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "Extension");
        if (extension != null) {
            return this.contentInterface.getName().toLowerCase().endsWith(extension.toLowerCase());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionController getContentTaskSession(String def, String uName) throws Exception {
        SessionController sessionRun = null;
        String key = def + "_" + uName;
        Object object = this.ctSync;
        synchronized (object) {
            if (contentTaskSessions.containsKey(key)) {
                try {
                    sessionRun = (SessionController)contentTaskSessions.get(key);
                    sessionRun.reconnectIfNeeded();
                }
                catch (Exception e) {
                    sessionRun = null;
                }
            }
            if (sessionRun == null) {
                String passWord = null;
                try {
                    passWord = this.sessionController.getDecodedSystemPassword(uName);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (passWord != null) {
                    try {
                        CredentialObject credential = new CredentialObject();
                        credential.setUserName(uName);
                        credential.setPassWord(passWord);
                        credential.setModulInfo("ContentTask");
                        sessionRun = SessionController.connect(credential);
                    }
                    catch (Exception e) {
                        stat.warning((Throwable)e, "Error logging in with user: " + uName);
                    }
                } else {
                    stat.warning("Error getting password of user: " + uName);
                    sessionRun = null;
                }
            }
            if (sessionRun != null) {
                contentTaskSessions.put(key, sessionRun);
            }
        }
        return sessionRun;
    }

    public void truncate(long newFileLength, boolean setContentSize, boolean makeHistory) throws Exception {
        ContentRemote remContent = this.getContentRemote();
        this.checkFileObjectAcces(this.contentInterface);
        if (makeHistory) {
            ChangeHistoryUtils chu = new ChangeHistoryUtils(this.sessionController);
            chu.makeHistoryWithUpdate((GlobalObjectClientBean)((Object)this.contentInterface), null, null);
        }
        this.formatTableName = this.contentInterface.getTableName();
        remContent.truncate(this.sessionController, this.contentInterface.getContent(), this.formatTableName, newFileLength, this.blockSize, this);
        if (setContentSize) {
            this.contentInterface.setContentSize(newFileLength);
        }
    }

    public ContentInterface getContentInterface() {
        return this.contentInterface;
    }

    public void setContentInterface(ContentInterface contentInterface) {
        this.contentInterface = contentInterface;
    }

    public String getMD5(InputStream is) throws Exception {
        return MD5Encoder.getMD5((InputStream)is);
    }

    static {
        contentTaskSessions = new Hashtable();
        stat = ContentTaskStatistic.getInstance();
        MAIL_RELATION_TYPES = new String[]{MailAttachmentsRelationObjectClientBean.CLASS_NAME, MailBodyRelationObjectClientBean.CLASS_NAME, MailMsgRelationObjectClientBean.CLASS_NAME};
    }
}

