/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cron.Trace;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import java.util.Date;

public class CreateFolderASyncThread
extends Thread {
    FolderObjectClientBean resultFolder = null;
    public static Object syncObject = new Object();
    private boolean hasFinished = false;
    private SessionController sessionController = null;
    private Date folderDate = null;
    private FolderObjectClientBean destFolder = null;
    private String destFolderString = null;

    public CreateFolderASyncThread(SessionController sessionController, Date folderDate, FolderObjectClientBean destFolder) {
        this.sessionController = sessionController;
        this.folderDate = folderDate;
        this.destFolder = destFolder;
    }

    public CreateFolderASyncThread(SessionController sessionController, String destFolderString) {
        this.sessionController = sessionController;
        this.destFolderString = destFolderString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = syncObject;
        synchronized (object) {
            try (Trace.Auto trace = Trace.auto((String)"Deferred folder creation thread");){
                try {
                    RoiTransactionHandler rth = new RoiTransactionHandler();
                    try {
                        trace.working("Creating folder");
                        rth.begin();
                        RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
                        if (this.folderDate != null) {
                            this.resultFolder = rfs.createDateFullpath(this.folderDate, this.destFolder, this.destFolder.getAcl());
                        } else if (this.destFolderString != null) {
                            this.resultFolder = rfs.createFullpath(this.destFolderString);
                        }
                        rth.end();
                        rth = null;
                        trace.ended();
                    }
                    finally {
                        if (rth != null) {
                            rth.abort();
                            rth = null;
                        }
                    }
                }
                catch (Exception e) {
                    trace.failed();
                    e.printStackTrace(System.err);
                }
            }
        }
        this.hasFinished = true;
    }

    public FolderObjectClientBean getResultFolder() {
        return this.resultFolder;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    public static FolderObjectClientBean createFolder(SessionController sessionController, Date folderDate, FolderObjectClientBean destFolder) throws Exception {
        long time = System.currentTimeMillis();
        CreateFolderASyncThread cfat = new CreateFolderASyncThread(sessionController, folderDate, destFolder);
        cfat.start();
        while (!cfat.hasFinished()) {
            CreateFolderASyncThread.sleep(500L);
        }
        return cfat.getResultFolder();
    }

    public static FolderObjectClientBean createFolder(SessionController sessionController, String destFolderString) throws Exception {
        long time = System.currentTimeMillis();
        CreateFolderASyncThread cfat = new CreateFolderASyncThread(sessionController, destFolderString);
        cfat.start();
        while (!cfat.hasFinished()) {
            CreateFolderASyncThread.sleep(500L);
        }
        return cfat.getResultFolder();
    }
}

