/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.common.AccessCounterUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ContentTransferBean;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import java.io.IOException;

public class DbRandomAccessFile
implements AutoCloseable {
    private boolean fileHasBeenModified = false;
    private boolean blockIsModified = false;
    private long blockNumber = -1L;
    private long actualBlockSize = 0L;
    private long filePosition = 0L;
    private byte[] internalBuffer = null;
    private long previousBufferLen = 0L;
    private long fileSize = 0L;
    private long blockPosition = 0L;
    private long blockSize = 0L;
    private long firstBytePos = 0L;
    private long lastBytePos = 0L;
    private boolean newBlock = true;
    private SessionController sessionController = null;
    private final ContentInterface contentInterface;
    private final Snapshot snapshot;
    private boolean firstWrite = true;
    private boolean doNotMakeHistory = false;
    public Object syncRW = new Object();
    public Object syncCache = new Object();
    private boolean useCache = true;

    public DbRandomAccessFile() {
        this.contentInterface = null;
        this.snapshot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbRandomAccessFile(SessionController sessionController, ContentInterface contentInterface) throws IOException {
        try {
            this.sessionController = sessionController;
            contentInterface.openForRead();
            this.contentInterface = contentInterface;
            this.snapshot = new Snapshot(contentInterface.getId());
            this.blockSize = contentInterface.getBlockSize();
            this.firstBytePos = this.blockSize + 1L;
            Object object = this.syncCache;
            synchronized (object) {
                this.internalBuffer = new byte[(int)this.blockSize];
            }
            this.blockNumber = -1L;
            this.filePosition = 0L;
            this.fileSize = contentInterface.getContentSize();
            this.blockPosition = 0L;
        }
        catch (Exception e) {
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    public boolean isDoNotMakeHistory() {
        return this.doNotMakeHistory;
    }

    public void setDoNotMakeHistory(boolean doNotMakeHistory) {
        this.doNotMakeHistory = doNotMakeHistory;
    }

    public long available() {
        return this.fileSize - this.filePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int bufOffset, int bytesToRead) throws IOException {
        Object object = this.syncRW;
        synchronized (object) {
            long bytesRead = -1L;
            int amntToRead = bytesToRead;
            int tmpPos = bufOffset;
            if (buffer != null && bytesToRead > 0) {
                boolean finished;
                bytesRead = 0L;
                this.checkBuffer();
                long intBlockPosition = this.blockPosition;
                do {
                    int length;
                    if (intBlockPosition >= this.blockSize) {
                        this.checkBuffer();
                        intBlockPosition = this.blockPosition;
                    }
                    if ((length = (int)this.blockSize - (int)intBlockPosition) > amntToRead) {
                        length = amntToRead;
                    }
                    finished = false;
                    if (this.filePosition + (long)length > this.fileSize) {
                        length = (int)(this.fileSize - this.filePosition);
                        finished = true;
                    }
                    if (length <= 0) continue;
                    amntToRead -= length;
                    System.arraycopy(this.internalBuffer, (int)intBlockPosition, buffer, tmpPos, length);
                    intBlockPosition += (long)length;
                    this.filePosition += (long)length;
                    tmpPos += length;
                    bytesRead += (long)length;
                } while (amntToRead > 0 && !finished);
            }
            return (int)bytesRead;
        }
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] buffer, int bufOffset, int bytesToWrite) throws IOException {
        Object object = this.syncRW;
        synchronized (object) {
            if (buffer != null && bytesToWrite >= 0) {
                this.checkBuffer();
                int intBlockPosition = (int)this.blockPosition;
                if (this.firstBytePos > this.blockPosition) {
                    this.firstBytePos = this.blockPosition;
                }
                if (this.lastBytePos < (long)intBlockPosition) {
                    this.lastBytePos = intBlockPosition;
                }
                int amntToWrite = bytesToWrite;
                int tmpPos = bufOffset;
                do {
                    if ((long)intBlockPosition >= this.blockSize) {
                        this.checkBuffer();
                        intBlockPosition = (int)this.blockPosition;
                        if (this.firstBytePos > this.blockPosition) {
                            this.firstBytePos = this.blockPosition;
                        }
                    }
                    this.blockIsModified = true;
                    int length = (int)this.blockSize - intBlockPosition;
                    if (length > amntToWrite) {
                        length = amntToWrite;
                    }
                    Object object2 = this.syncCache;
                    synchronized (object2) {
                        amntToWrite -= length;
                        System.arraycopy(buffer, tmpPos, this.internalBuffer, intBlockPosition, length);
                    }
                    intBlockPosition += length;
                    this.filePosition += (long)length;
                    tmpPos += length;
                    if (this.filePosition > this.fileSize) {
                        this.fileSize = this.filePosition;
                    }
                    if (this.lastBytePos >= (long)intBlockPosition) continue;
                    this.lastBytePos = intBlockPosition;
                } while (amntToWrite > 0);
                if (bytesToWrite == 0) {
                    this.blockIsModified = true;
                }
            }
            this.checkBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.syncRW;
        synchronized (object) {
            try (Transaction t = new Transaction();){
                this.writeBuffer();
                try {
                    if (this.fileHasBeenModified) {
                        this.contentInterface.setContentSize(this.fileSize);
                        this.contentInterface.closeTransfer();
                        this.snapshot.update();
                        this.fileHasBeenModified = false;
                    } else {
                        AccessCounterUtils acu = new AccessCounterUtils(this.sessionController);
                        acu.sendReadEvent(this.contentInterface);
                        this.contentInterface.closeForRead();
                    }
                }
                catch (Exception e) {
                    IOException ioException = new IOException(e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
                t.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.syncRW;
        synchronized (object) {
            this.flush();
            this.firstWrite = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLength(long newFileLength) throws IOException {
        Object object = this.syncRW;
        synchronized (object) {
            block18: {
                try {
                    this.seek(newFileLength);
                    if (newFileLength >= this.fileSize) break block18;
                    try (Transaction t = new Transaction();){
                        this.flush();
                        boolean fw = this.firstWrite;
                        if (this.doNotMakeHistory) {
                            fw = false;
                        }
                        this.contentInterface.truncate(newFileLength, true, fw);
                        this.firstWrite = false;
                        this.fileSize = newFileLength;
                        this.snapshot.update();
                        this.invalidateCache();
                        t.commit();
                    }
                }
                catch (Exception e) {
                    IOException ioException = new IOException(e.getMessage());
                    ioException.initCause(e);
                    throw ioException;
                }
            }
        }
    }

    public void setFileLengthInternal(long fileLength) {
        this.fileSize = fileLength;
    }

    public void seek(long seekPosition) {
        this.filePosition = seekPosition;
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    public long length() throws IOException {
        return this.fileSize;
    }

    private void checkBuffer() throws IOException {
        if (this.snapshot.updated() && this.blockNumber >= 0L) {
            this.blockIsModified = false;
            this.invalidateCache();
            try {
                this.fileSize = this.contentInterface.getContentSize();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (this.filePosition != this.blockNumber * this.blockSize + this.blockPosition) {
            long newBlockNumber = this.filePosition / this.blockSize;
            long newBlockPosition = this.filePosition - newBlockNumber * this.blockSize;
            if (this.blockNumber == -1L) {
                this.blockNumber = this.fileSize / this.blockSize;
                if (this.blockNumber < newBlockNumber) {
                    this.readBuffer();
                    this.firstBytePos = this.fileSize - this.blockNumber * this.blockSize;
                    this.lastBytePos = this.blockSize;
                    this.blockIsModified = true;
                } else {
                    this.blockNumber = -1L;
                }
            }
            if (newBlockNumber == this.blockNumber) {
                if (newBlockPosition > this.actualBlockSize) {
                    this.actualBlockSize = newBlockPosition;
                }
            } else if (newBlockNumber > this.blockNumber) {
                this.actualBlockSize = this.blockSize;
                this.lastBytePos = this.blockSize;
            }
            if (newBlockNumber != this.blockNumber) {
                this.writeBuffer();
                this.blockNumber = newBlockNumber;
                this.blockPosition = newBlockPosition;
                this.readBuffer();
            } else {
                this.blockPosition = newBlockPosition;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBuffer() throws IOException {
        RoiTransactionHandler rth = null;
        try {
            if (this.blockIsModified) {
                byte[] tmpBuf = null;
                if (this.newBlock) {
                    this.firstBytePos = 0L;
                    this.lastBytePos = this.actualBlockSize;
                }
                Object object = this.syncCache;
                synchronized (object) {
                    tmpBuf = this.internalBuffer;
                }
                rth = new RoiTransactionHandler();
                rth.begin();
                ContentTransferBean ctb = new ContentTransferBean(tmpBuf, (int)this.actualBlockSize);
                ctb.setPreviousBufferLength((int)this.previousBufferLen);
                ctb.setCacheEnabled(this.useCache);
                ctb.setModifiedLength((int)(this.lastBytePos - this.firstBytePos));
                ctb.setFirstBytePos(this.firstBytePos);
                this.fileHasBeenModified = true;
                boolean fw = this.firstWrite;
                if (this.doNotMakeHistory) {
                    fw = false;
                }
                this.contentInterface.transferContentUpdate(ctb, this.blockNumber, fw);
                this.firstWrite = false;
                rth.end();
                rth = null;
                tmpBuf = null;
            }
            this.blockIsModified = false;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            try {
                if (rth != null) {
                    rth.abort();
                }
            }
            catch (Exception ctb) {
                // empty catch block
            }
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readBuffer() throws IOException {
        try {
            int read = -1;
            this.newBlock = true;
            this.firstBytePos = this.blockSize + 1L;
            this.lastBytePos = 0L;
            this.previousBufferLen = 0L;
            ContentTransferBean ctb = this.contentInterface.getBuffer(this.blockNumber, this.fileSize, this.useCache);
            byte[] tmpBuf = null;
            if (ctb != null) {
                tmpBuf = ctb.getBuffer();
                if (ctb.isFilled() && tmpBuf != null) {
                    this.newBlock = false;
                    read = ctb.getBufferLength();
                    if (ctb.getIsEmptyBlock()) {
                        this.firstBytePos = 0L;
                        this.lastBytePos = this.blockSize;
                    } else {
                        this.previousBufferLen = ctb.getBufferLength();
                    }
                }
            }
            this.cleanUpBuffer(read);
            if (read >= 0) {
                Object object = this.syncCache;
                synchronized (object) {
                    System.arraycopy(tmpBuf, 0, this.internalBuffer, 0, read);
                }
                this.actualBlockSize = read;
            } else {
                this.actualBlockSize = 0L;
                this.firstBytePos = 0L;
            }
            this.blockIsModified = false;
        }
        catch (IOException e) {
            this.blockNumber = -1L;
            throw e;
        }
        catch (Exception e) {
            this.blockNumber = -1L;
            e.printStackTrace(System.err);
            IOException ioException = new IOException(e.getMessage());
            ioException.initCause(e);
            throw ioException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpBuffer(int start) throws IOException {
        int deleteSize = 1024;
        byte[] clearBuffer = new byte[deleteSize];
        for (int i = 0; i < deleteSize; ++i) {
            clearBuffer[i] = 0;
        }
        Object object = this.syncCache;
        synchronized (object) {
            int i;
            int len = this.internalBuffer.length;
            int n = i = start >= 0 ? start : 0;
            while (i < len) {
                int myLen = deleteSize;
                if (i > len - deleteSize) {
                    myLen = len - i;
                }
                System.arraycopy(this.internalBuffer, i, clearBuffer, 0, myLen);
                i += deleteSize;
            }
        }
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public Long getId() {
        return this.contentInterface.getId();
    }

    public long getFileSize() {
        return this.fileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCache() {
        if (!this.blockIsModified) {
            Object object = this.syncCache;
            synchronized (object) {
                this.internalBuffer = new byte[(int)this.blockSize];
                this.blockNumber = -1L;
                this.blockPosition = 0L;
                this.firstBytePos = this.blockSize + 1L;
                this.lastBytePos = 0L;
                this.actualBlockSize = 0L;
            }
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    private static class Snapshot {
        private static final String GLOBAL_KEY = Snapshot.class.getName() + "_Cache";
        private static final int CACHE_TTL = 3600000;
        private final String MY_KEY = this.toString() + "_Cache";
        private final long id;
        private long known;

        private Snapshot(long id) {
            this.id = id;
        }

        private static GenericCache getCache() {
            return GenericCache.getInstance((Object)GLOBAL_KEY, (int)Integer.MAX_VALUE, (int)3600000, (int)3600000);
        }

        public void update() {
            try {
                Transaction.afterCommit(this.MY_KEY, () -> {
                    this.known = System.currentTimeMillis();
                    Snapshot.getCache().put((Object)this.id, (Object)this.known);
                });
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean updated() throws IOException {
            Long lastTimestamp = (Long)Snapshot.getCache().get((Object)this.id);
            if (lastTimestamp != null && lastTimestamp != this.known) {
                this.known = lastTimestamp;
                return true;
            }
            return false;
        }
    }
}

