/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.poi.hpsf.CustomProperties;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hssf.extractor.ExcelExtractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.extractor.XSSFExcelExtractor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.extractor.XWPFWordExtractor;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperties;
import org.openxmlformats.schemas.officeDocument.x2006.customProperties.CTProperty;

public class DocExtractUtil {
    private static final String key = "MAIN_MODULE_MANAGEMENT/roi/control/contenttask";

    public static void extractDoc(SessionController sessionController, ContentInterface contentInterface, String definition) throws Exception {
        boolean isDoc = false;
        if (definition.equals("DOC")) {
            isDoc = true;
        }
        System.out.println("ContentTask DocExtract: Start Extraction");
        InputStream is = contentInterface.getContentStream();
        WordExtractor doc = null;
        XWPFWordExtractor docx = null;
        if (isDoc) {
            doc = new WordExtractor(is);
        } else {
            XWPFDocument tmpDoc = new XWPFDocument(is);
            docx = new XWPFWordExtractor(tmpDoc);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (isDoc) {
            CustomProperties custProp;
            properties.put("title", doc.getSummaryInformation().getTitle());
            properties.put("subject", doc.getSummaryInformation().getSubject());
            properties.put("category", doc.getDocSummaryInformation().getCategory());
            properties.put("keywords", doc.getSummaryInformation().getKeywords());
            DocumentSummaryInformation docSum = doc.getDocSummaryInformation();
            if (docSum != null && (custProp = docSum.getCustomProperties()) != null) {
                for (Object name : custProp.keySet()) {
                    String value = "" + custProp.get((String)name);
                    properties.put((String)name, value);
                }
            }
        } else {
            properties.put("title", docx.getCoreProperties().getTitle());
            properties.put("subject", docx.getCoreProperties().getSubject());
            properties.put("category", docx.getCoreProperties().getCategory());
            properties.put("keywords", docx.getCoreProperties().getKeywords());
            CTProperties props = docx.getCustomProperties().getUnderlyingProperties();
            List propList = props.getPropertyList();
            for (CTProperty oneProp : propList) {
                properties.put(oneProp.getName(), oneProp.getLpwstr());
            }
        }
        DocExtractUtil.setExtendedAttributes(sessionController, contentInterface, definition, properties);
        System.out.println("ContentTask DocExtract: Close InputStream");
        is.close();
    }

    public static void extractXLS(SessionController sessionController, ContentInterface contentInterface, String definition) throws Exception {
        boolean isXLS = false;
        if (definition.equals("XLS")) {
            isXLS = true;
        }
        System.out.println("ContentTask DocExtract: Start Extraction");
        InputStream is = contentInterface.getContentStream();
        ExcelExtractor xls = null;
        XSSFExcelExtractor xlsx = null;
        if (isXLS) {
            POIFSFileSystem tmpFile = new POIFSFileSystem(is);
            xls = new ExcelExtractor(tmpFile);
        } else {
            XSSFWorkbook book = new XSSFWorkbook(is);
            xlsx = new XSSFExcelExtractor(book);
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        if (isXLS) {
            CustomProperties custProp;
            properties.put("title", xls.getSummaryInformation().getTitle());
            properties.put("subject", xls.getSummaryInformation().getSubject());
            properties.put("category", xls.getDocSummaryInformation().getCategory());
            properties.put("keywords", xls.getSummaryInformation().getKeywords());
            DocumentSummaryInformation docSum = xls.getDocSummaryInformation();
            if (docSum != null && (custProp = docSum.getCustomProperties()) != null) {
                for (Object name : custProp.keySet()) {
                    String value = "" + custProp.get((String)name);
                    properties.put((String)name, value);
                }
            }
        } else {
            properties.put("title", xlsx.getCoreProperties().getTitle());
            properties.put("subject", xlsx.getCoreProperties().getSubject());
            properties.put("category", xlsx.getCoreProperties().getCategory());
            properties.put("keywords", xlsx.getCoreProperties().getKeywords());
            CTProperties props = xlsx.getCustomProperties().getUnderlyingProperties();
            List propList = props.getPropertyList();
            for (CTProperty oneProp : propList) {
                properties.put(oneProp.getName(), oneProp.getLpwstr());
            }
        }
        DocExtractUtil.setExtendedAttributes(sessionController, contentInterface, definition, properties);
        System.out.println("ContentTask DocExtract: Close InputStream");
        is.close();
    }

    public static void setExtendedAttributes(SessionController sessionController, ContentInterface contentInterface, String definition, Map<String, String> properties) throws Exception {
        MetaDb metaDb = sessionController.getMetaDbInstance();
        GlobalObjectClientBean content = (GlobalObjectClientBean)((Object)contentInterface);
        String[] description = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/" + definition + "/DocumentProperties");
        String[] mapping = new String[description.length];
        String[] metaDbMapping = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/" + definition + "/ExtendedAttributeMapping");
        if (metaDbMapping != null && metaDbMapping.length == description.length) {
            System.arraycopy(metaDbMapping, 0, mapping, 0, metaDbMapping.length);
        } else {
            for (int i = 0; i < description.length; ++i) {
                mapping[i] = "doc_" + description[i];
            }
        }
        String keywords = properties.get("keywords");
        if (keywords != null) {
            StringTokenizer keywordTokenizer = new StringTokenizer(keywords, ";,");
            keywords = "";
            String colon = "";
            while (keywordTokenizer.hasMoreTokens()) {
                keywords = keywords + colon + keywordTokenizer.nextToken();
                colon = ";";
            }
            properties.put("keywords", keywords);
        }
        GlobalObjectSessionFacade gosf = new GlobalObjectSessionFacade(sessionController);
        gosf.setGlobalObject(content);
        for (int j = 0; j < mapping.length; ++j) {
            gosf.removeExtendedAttribute(mapping[j]);
        }
        gosf.update();
        for (int i = 0; i < description.length; ++i) {
            String property = properties.get(description[i]);
            if (property == null || property.trim().length() <= 0) continue;
            content.setExtendedAttribute(mapping[i], AttributeValue.newAttributeValueObject(property), true);
        }
        content.saveExtendedAttributes();
    }
}

