/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.commons.cache.GenericCache;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.DbRandomAccessFile;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.roi.statistic.DownloadQuotaStatistic;
import java.util.Date;

public class DownloadQuota {
    static final Statistic stat = DownloadQuotaStatistic.getInstance();
    private boolean activated = false;
    private final String metaDbPath = "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota";
    private SessionController sessionControllerAdmin = null;
    private FileObjectClientBean csvFile = null;
    private int maxItemsPerUserOverThreshold = 100;
    private int purgeCacheInterval = 10000;
    private int period = 60000;
    private int threshold = 1000;
    private String csvName = null;
    private String[] excludedUserList = null;
    private String delimiter = ";";
    private String[] statisticInformation = new String[]{"UserId", "User Name", "Date", "Amount of downloads"};

    private DownloadQuota() {
        this.isActivated(SessionControllerAdmin.getSessionControllerAdmin("DownloadQuota"));
    }

    public static DownloadQuota getInstance(SessionController sessionController) {
        return SingletonHolder.instance;
    }

    public void addObject(SessionController sessionController, ContentInterface contentInterface) {
        if (this.isActivated(sessionController)) {
            Long userId = null;
            GenericCache userCache = null;
            try {
                userId = sessionController.getLoginUserId();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (userId == null) {
                return;
            }
            for (String excludedUser : this.excludedUserList) {
                if (userId != Long.parseLong(excludedUser)) continue;
                return;
            }
            userCache = GenericCache.getInstance((Object)userId, (int)(this.threshold + this.maxItemsPerUserOverThreshold), (int)this.purgeCacheInterval, (int)this.period);
            if (userCache == null) {
                return;
            }
            GlobalObjectClientBean object = null;
            Long objectId = null;
            try {
                objectId = contentInterface.getId();
                object = sessionController.getGlobalObjectById(objectId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (object == null || objectId == null) {
                return;
            }
            String cacheKey = objectId + "_" + new Date().getTime();
            userCache.put((Object)cacheKey, (Object)object);
            System.out.println("Excecute: DownloadQuota");
            if (this.exceedThreshold(sessionController, userCache)) {
                this.handleExceedThreshold(sessionController, userCache);
            }
        }
    }

    private boolean exceedThreshold(SessionController sessionController, GenericCache gc) {
        int threshold = 0;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            threshold = Integer.parseInt(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/Threshold")[0]);
        }
        catch (MetaDbException e) {
            e.printStackTrace();
        }
        if (threshold == 0) {
            return false;
        }
        return threshold < gc.size();
    }

    private void handleExceedThreshold(SessionController sessionController, GenericCache gc) {
        int size = gc.size();
        gc.invalidateCache();
        try {
            this.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.csvFile == null) {
            try {
                this.csvFile = this.getProtocolFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            if (!this.csvFile.getName().equalsIgnoreCase(this.csvName)) {
                this.csvFile = this.getProtocolFile();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        FileObjectClientBean contentInterface = this.csvFile;
        try {
            DbRandomAccessFile draf = new DbRandomAccessFile(this.sessionControllerAdmin, contentInterface);
            draf.seek(draf.getFileSize());
            String entry = sessionController.getLoginUserId().toString();
            entry = entry + this.delimiter + sessionController.getLoginUser().getName();
            entry = entry + this.delimiter + new Date();
            entry = entry + this.delimiter + size;
            entry = entry + "\n";
            byte[] entryBytes = entry.getBytes();
            draf.write(entryBytes, 0, entryBytes.length);
            draf.flush();
            draf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FileObjectClientBean getProtocolFile() throws Exception {
        FileObjectClientBean csvFile = null;
        try {
            this.isConnected();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String csvFileName = this.csvName;
        String csvFolderPathOrId = null;
        MetaDb metaDb = this.sessionControllerAdmin.getMetaDbInstance();
        csvFolderPathOrId = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/statistics/CSVFolderPathOrId")[0];
        if (csvFileName != null && !csvFileName.isEmpty() || csvFolderPathOrId != null && !csvFolderPathOrId.isEmpty()) {
            try {
                this.isConnected();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            FolderObjectClientBean csvFolder = null;
            csvFolder = (FolderObjectClientBean)this.sessionControllerAdmin.findGlobalObjectByPathOrId(csvFolderPathOrId);
            csvFile = (FileObjectClientBean)csvFolder.getItem(csvFileName);
            boolean newFile = false;
            if (csvFile == null) {
                FileObjectSessionFacade fosf = new FileObjectSessionFacade(this.sessionControllerAdmin);
                fosf.setDestinationFolder(csvFolder);
                fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, csvFileName);
                csvFile = (FileObjectClientBean)fosf.create();
                newFile = true;
            }
            if (newFile) {
                FileObjectClientBean contentInterface = csvFile;
                try (DbRandomAccessFile draf = new DbRandomAccessFile(this.sessionControllerAdmin, contentInterface);){
                    String header = "";
                    for (String info : this.statisticInformation) {
                        header = header.isEmpty() ? info : header + this.delimiter + info;
                    }
                    header = header + "\n";
                    byte[] headerBytes = header.getBytes();
                    draf.write(headerBytes, 0, headerBytes.length);
                    draf.flush();
                }
            }
            return csvFile;
        }
        return csvFile;
    }

    private void isConnected() throws Exception {
        if (this.sessionControllerAdmin == null) {
            this.connectAdmin();
        } else {
            try {
                this.sessionControllerAdmin.reconnectIfNeeded();
            }
            catch (Exception e) {
                this.connectAdmin();
            }
        }
    }

    private void connectAdmin() throws Exception {
        RoiProperties rp = new RoiProperties();
        CredentialObject credential = new CredentialObject();
        credential.setUserName(rp.getRoiSystemUser());
        credential.setModulInfo("ApiGuestSession");
        credential.setAuthInterface(new ServiceAuthInterface());
        this.sessionControllerAdmin = SessionController.connect(credential);
    }

    private boolean isActivated(SessionController sessionController) {
        try {
            this.activated = Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/Active", "false"));
            if (!this.activated) {
                return false;
            }
            this.period = Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/PeriodOfRecord"));
            this.threshold = Integer.parseInt(MetaDbSuperCache.getSimplePropertyValue(sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/Threshold"));
            this.excludedUserList = MetaDbSuperCache.getSimplePropertyValues(sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/ExcludedUserList");
            this.csvName = MetaDbSuperCache.getSimplePropertyValue(sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/downloadquota/statistics/CSVName");
            this.csvFile = this.getProtocolFile();
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Invalid Configuration");
            this.activated = false;
        }
        return this.activated;
    }

    private static class SingletonHolder {
        public static final DownloadQuota instance = new DownloadQuota();

        private SingletonHolder() {
        }
    }
}

