/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.logging.Log;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.FolderTaskInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class FolderTaskFolderNameInheritance
implements FolderTaskInterface {
    @Override
    public void runTask(SessionController sessionController, String metaDbPath, FolderObjectClientBean folderObject, SuperObjectClientBeanDefinition def, boolean isNew) throws Exception {
        if (!(isNew || def != null && def.getSystemOption("NameChanged") != null)) {
            return;
        }
        MetaDb metaDb = sessionController.getMetaDbInstance();
        String baseFolderPathOrId = null;
        try {
            baseFolderPathOrId = metaDb.getSimplePropertyValue(metaDbPath + "BaseFolderPathOrId")[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (baseFolderPathOrId == null) {
            return;
        }
        GlobalObjectClientBean baseFolder = sessionController.findGlobalObjectByPathOrId(baseFolderPathOrId);
        Long baseFolderId = baseFolder.getId();
        if (!folderObject.insideFolder(baseFolderId)) {
            return;
        }
        String[] extAttributeList = null;
        try {
            extAttributeList = metaDb.getSimplePropertyValue(metaDbPath + "ExtendedAttributesList");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (extAttributeList == null) {
            Log.error((String)"Error in FolderTask FolderNameInheritance: Check ExtendedAttributesList.");
            return;
        }
        boolean stopAtLastAttribute = false;
        try {
            stopAtLastAttribute = Boolean.parseBoolean(metaDb.getSimplePropertyValue(metaDbPath + "StopAtLastAttribute")[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set<Integer> depths = this.getDepths(baseFolder.getId(), folderObject);
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (Integer depth : depths) {
            int numberOfAttr = extAttributeList.length;
            if (depth > numberOfAttr) {
                if (stopAtLastAttribute) continue;
                attributeNames.add(extAttributeList[numberOfAttr - 1]);
                continue;
            }
            attributeNames.add(extAttributeList[depth - 1]);
        }
        if (attributeNames.size() > 0) {
            String attributeValue = this.transform(metaDb, folderObject.getName(), metaDbPath);
            for (String attributeName : attributeNames) {
                folderObject.setInheritableExtendedAttribute(attributeName, attributeValue);
            }
            folderObject.saveExtendedAttributesInheritable();
        }
    }

    private Set<Integer> getDepths(Long baseFolderId, FolderObjectClientBean targetFolder) throws Exception {
        HashSet<Integer> result = new HashSet<Integer>();
        this.findDepths(baseFolderId, targetFolder, 0, result);
        return result;
    }

    private void findDepths(Long baseFolderId, FolderObjectClientBean targetFolder, int depth, Set<Integer> result) throws Exception {
        if (targetFolder.getId().equals(baseFolderId)) {
            result.add(depth);
            return;
        }
        if (!targetFolder.insideFolder(baseFolderId)) {
            return;
        }
        FolderObjectClientBean[] parents = targetFolder.getParents();
        if (parents == null) {
            return;
        }
        for (FolderObjectClientBean parent : parents) {
            this.findDepths(baseFolderId, parent, depth + 1, result);
        }
    }

    private String transform(MetaDb metaDb, String name, String metaDbPath) {
        String[] transformations = null;
        try {
            transformations = metaDb.listSimplePropertyEntry(metaDbPath + "Transformation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (transformations == null) {
            return name;
        }
        for (String transformation : transformations) {
            if (!transformation.equals(name)) continue;
            try {
                return metaDb.getSimplePropertyValue(metaDbPath + "Transformation/" + transformation)[0];
            }
            catch (Exception exception) {
                return name;
            }
        }
        return name;
    }
}

