/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.FolderTaskInterface;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;

public class FolderUtils {
    private SessionController sessionController = null;
    private FolderObjectClientBean folderObject = null;

    public FolderUtils(SessionController sessionController, FolderObjectClientBean folderObject) {
        this.sessionController = sessionController;
        this.folderObject = folderObject;
    }

    public void performFolderTask(SuperObjectClientBeanDefinition def, boolean isNew) {
        String[] definitions;
        try {
            if (!this.folderObject.getIsFolder()) {
                return;
            }
        }
        catch (Exception e1) {
            return;
        }
        String key = "MAIN_MODULE_MANAGEMENT/roi/control/foldertask";
        boolean runFolderTasks = Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(this.sessionController, key + "/control/FolderTaskActivated", "false"));
        if (runFolderTasks && (definitions = MetaDbSuperCache.listSimplePropertyBundles(this.sessionController, key + "/definitions")) != null) {
            for (String definition : definitions) {
                String metaDbPath = key + "/definitions/" + definition + "/";
                if (definition.startsWith("#")) continue;
                String folderTask = null;
                try {
                    folderTask = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, metaDbPath + "Class");
                }
                catch (Exception e) {
                    System.err.println("Error in FolderTask " + definition + ": Check your Properties.");
                    continue;
                }
                if (folderTask == null) continue;
                Object folderTaskImpl = null;
                try {
                    folderTaskImpl = Class.forName(folderTask).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Error creating folderTaskInterface: " + folderTask + ", please check your properties");
                    continue;
                }
                try {
                    System.out.println("Excute FolderTask: " + definition);
                    ((FolderTaskInterface)folderTaskImpl).runTask(this.sessionController, metaDbPath, this.folderObject, def, isNew);
                }
                catch (Exception e) {
                    System.err.println("Error in FolderTask " + definition + ": Check your Properties.");
                }
            }
        }
    }
}

