/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.logging.Log;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class GenericMultiQueueHelper {
    public static final String TRANSACTION_KEY = GenericMultiQueueHelper.class.getName();
    private boolean hasMoreQueueEntries;

    public boolean hasMoreQueueEntries() {
        return this.hasMoreQueueEntries;
    }

    public void createQueueEntry(Long id, String ident) throws Exception {
        this.createQueueEntry(id, ident, null);
    }

    public void createQueueEntry(Long id, String ident, String data) throws Exception {
        this.createQueueEntry(id, ident, data, null);
    }

    public void createQueueEntry(Long id, String ident, String data, Runnable callback) throws Exception {
        String key = TRANSACTION_KEY + "_" + id + "_" + ident + "_" + data;
        Transaction.whileCommit(key, () -> {
            try {
                this.createQueueEntryDirect(id, ident, data);
            }
            catch (Exception e) {
                Log.warning((Throwable)e);
            }
        });
        if (callback != null) {
            Transaction.afterCommit(key, () -> callback.run());
        }
    }

    protected void createQueueEntryDirect(Long id, String ident, String data) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        try (RoiTransactionHandler rth = new RoiTransactionHandler();){
            rth.begin(true);
            try (Connection conn = cu.getConnection();){
                String insert = "insert into genericmultiqueue (id, ident, data) values (?, ?, ?)";
                try (PreparedStatement ps = conn.prepareStatement(insert);){
                    ps.setLong(1, id);
                    ps.setString(2, ident);
                    ps.setString(3, data);
                    ps.execute();
                }
            }
            rth.end();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public List<GenericMultiQueueBean> getQueueEntries(Long id, String ident) throws Exception {
        return this.getQueueEntries(id, ident, -1L);
    }

    public List<GenericMultiQueueBean> getQueueEntries(Long id, String ident, long maxAmount) throws Exception {
        return this.getQueueEntries(id, ident, maxAmount, 0L);
    }

    public List<GenericMultiQueueBean> getQueueEntries(Long id, String ident, long maxAmount, long minSortId) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        ArrayList<GenericMultiQueueBean> result = new ArrayList<GenericMultiQueueBean>();
        long amount = 0L;
        this.hasMoreQueueEntries = false;
        DatabaseUtils dbu = new DatabaseUtils();
        DatabaseInterface dbi = dbu.getDatabaseInterfaceImpl();
        try (RoiTransactionHandler rth = new RoiTransactionHandler();){
            rth.begin(true);
            try (Connection conn = cu.getConnection();
                 PreparedStatement psel = dbi.getGenericMultiQueueSelect(conn, id, ident, maxAmount, minSortId);
                 ResultSet rs = psel.executeQuery();){
                while (rs.next()) {
                    GenericMultiQueueBean b = new GenericMultiQueueBean();
                    b.id = rs.getLong(1);
                    b.sortId = rs.getLong(2);
                    b.ident = rs.getString(3);
                    b.data = rs.getString(4);
                    result.add(b);
                    if (maxAmount == -1L || ++amount <= maxAmount) continue;
                    this.hasMoreQueueEntries = true;
                    break;
                }
            }
            rth.end();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return result;
    }

    public void deleteQueueEntry(GenericMultiQueueBean b) throws Exception {
        this.deleteQueueEntry(b.id, b.sortId, b.ident);
    }

    public void deleteQueueEntry(Long id, Long sortId, String ident) throws Exception {
        Transaction.whileCommit(TRANSACTION_KEY + "_" + id + "_" + sortId + "_" + ident, () -> {
            try {
                this.deleteQueueEntryDirect(id, sortId, ident);
            }
            catch (Exception e) {
                Log.warning((Throwable)e);
            }
        });
    }

    protected void deleteQueueEntryDirect(Long id, Long sortId, String ident) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        try (RoiTransactionHandler rth = new RoiTransactionHandler();
             Connection conn = cu.getConnection();){
            boolean hasEntries;
            rth.begin(true);
            if (sortId != null) {
                hasEntries = false;
                try (PreparedStatement ps = conn.prepareStatement("select * from genericmultiqueue where id=? and sortid=? and ident=?");){
                    ps.setLong(1, id);
                    ps.setLong(2, sortId);
                    ps.setString(3, ident);
                    try (ResultSet rs = ps.executeQuery();){
                        hasEntries = rs.next();
                    }
                }
                if (hasEntries) {
                    ps = conn.prepareStatement("delete from genericmultiqueue where id=? and sortid=? and ident=?");
                    var11_16 = null;
                    try {
                        ps.setLong(1, id);
                        ps.setLong(2, sortId);
                        ps.setString(3, ident);
                        ps.execute();
                    }
                    catch (Throwable rs) {
                        var11_16 = rs;
                        throw rs;
                    }
                    finally {
                        if (ps != null) {
                            if (var11_16 != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable rs) {
                                    var11_16.addSuppressed(rs);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
            } else {
                hasEntries = false;
                try (PreparedStatement ps = conn.prepareStatement("select * from genericmultiqueue where id=? and ident=?");){
                    ps.setLong(1, id);
                    ps.setString(2, ident);
                    try (ResultSet rs = ps.executeQuery();){
                        hasEntries = rs.next();
                    }
                }
                if (hasEntries) {
                    ps = conn.prepareStatement("delete from genericmultiqueue where id=? and ident=?");
                    var11_17 = null;
                    try {
                        ps.setLong(1, id);
                        ps.setString(2, ident);
                        ps.execute();
                    }
                    catch (Throwable throwable) {
                        var11_17 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ps != null) {
                            if (var11_17 != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable throwable) {
                                    var11_17.addSuppressed(throwable);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
            }
            rth.end();
        }
    }

    public long getQueueEntryCount(String ident) throws Exception {
        ConnectionUtils cu = new ConnectionUtils(null);
        String select = null;
        select = "select count(*) from genericmultiqueue where ident=?";
        try (Connection conn = cu.getConnection();
             PreparedStatement psel = conn.prepareStatement(select);){
            psel.setString(1, ident);
            try (ResultSet rs = psel.executeQuery();){
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
            }
        }
        return 0L;
    }
}

