/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.utils.TempFile;
import agorum.roi.common.StartWorkflowInterface;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MailFilterObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.MailFilterBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.parser.mail.EmlParser;
import agorum.roi.scripting.EngineContext;
import agorum.roi.search.SearchClass;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MailFilterUtils {
    private final SystemStatistic globalStat = CoreStatistic.getInstance();
    private SystemStatistic stat = null;

    public MailFilterUtils() {
        this.stat = this.globalStat;
    }

    public MailFilterUtils(SystemStatistic s) {
        this.stat = s;
    }

    public MailFilterObjectClientBean[] getMailFilters(SessionController sessionController, DirectoryUserObjectClientBean user) throws Exception {
        MailFilterObjectClientBean[] mailFilterObjects = null;
        SearchClass sc = new SearchClass(sessionController);
        String[] classNameInternal = new String[]{GlobalObjectClientBean.CLASS_NAME, MailFilterObjectClientBean.CLASS_NAME};
        sc.setClassname(classNameInternal);
        sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, MailFilterObjectClientBean.CLASS_NAME, null);
        sc.setAttributeEQUAL(MailFilterObjectClientBean.CLASS_NAME, "GLOBAL", (Object)Boolean.TRUE, false);
        sc.setSearchClauseAND();
        sc.setSortSpezification(new String[]{MailFilterObjectClientBean.CLASS_NAME}, new String[]{"SORTORDER"}, new int[]{2});
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        GlobalObjectClientBean[] globalMailFilters = sc.getItems();
        sc.closeSearch();
        sc = new SearchClass(sessionController);
        sc.setClassname(classNameInternal);
        sc.setJoin(GlobalObjectClientBean.CLASS_NAME, null, MailFilterObjectClientBean.CLASS_NAME, null);
        sc.setAttributeEQUAL(GlobalObjectClientBean.CLASS_NAME, GlobalObjectClientBean.OWNER_ATTRIBUTE, (Object)user, false);
        sc.setSearchClauseAND();
        sc.setAttributeEQUAL(MailFilterObjectClientBean.CLASS_NAME, "GLOBAL", (Object)Boolean.FALSE, false);
        sc.setSearchClauseAND();
        sc.setSortSpezification(new String[]{MailFilterObjectClientBean.CLASS_NAME}, new String[]{"SORTORDER"}, new int[]{2});
        sc.openSearch(GlobalObjectClientBean.CLASS_NAME);
        GlobalObjectClientBean[] privateMailFilters = sc.getItems();
        sc.closeSearch();
        int len = globalMailFilters == null ? 0 : globalMailFilters.length;
        if ((len += privateMailFilters == null ? 0 : privateMailFilters.length) > 0) {
            FolderObjectClientBean[] parents;
            MailFilterObjectClientBean tmp;
            int i;
            ArrayList<MailFilterObjectClientBean> al = new ArrayList<MailFilterObjectClientBean>();
            mailFilterObjects = new MailFilterObjectClientBean[len];
            if (globalMailFilters != null) {
                int lenG = globalMailFilters.length;
                for (i = 0; i < lenG; ++i) {
                    tmp = (MailFilterObjectClientBean)globalMailFilters[i];
                    parents = tmp.getParents();
                    if (parents == null || parents.length <= 0) continue;
                    al.add(tmp);
                }
            }
            if (privateMailFilters != null) {
                int lenP = privateMailFilters.length;
                for (i = 0; i < lenP; ++i) {
                    tmp = (MailFilterObjectClientBean)privateMailFilters[i];
                    parents = tmp.getParents();
                    if (parents == null || parents.length <= 0) continue;
                    al.add(tmp);
                }
            }
            if ((len = al.size()) > 0) {
                mailFilterObjects = new MailFilterObjectClientBean[len];
                for (int i2 = 0; i2 < len; ++i2) {
                    mailFilterObjects[i2] = (MailFilterObjectClientBean)al.get(i2);
                }
            } else {
                mailFilterObjects = null;
            }
        }
        return mailFilterObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterOutboxAction(SessionController sessionController, MailObjectClientBean mailObject, MailFilterObjectClientBean[] mailFilterObjects) throws Exception {
        ArrayList<MailFilterBean> workflowActions;
        ArrayList<MailFilterBean> jsActions;
        MailFilterBean moveAction;
        boolean moveTheMail;
        block29: {
            moveTheMail = true;
            File tempFile = null;
            moveAction = null;
            jsActions = null;
            workflowActions = null;
            try {
                int read;
                EmlParser emlParser = new EmlParser(sessionController);
                InputStream is = mailObject.getContentStream();
                byte[] buffer = new byte[1024];
                tempFile = TempFile.createTempFile((long)600000L);
                FileOutputStream fos = new FileOutputStream(tempFile);
                while ((read = is.read(buffer)) >= 0) {
                    fos.write(buffer, 0, read);
                }
                fos.close();
                is.close();
                if (mailFilterObjects == null) break block29;
                for (MailFilterObjectClientBean mailFilter : mailFilterObjects) {
                    if (mailFilter == null || !mailFilter.getActive()) continue;
                    boolean isValid = false;
                    if (emlParser.checkMailFilter(tempFile, mailFilter.getMailFilterSearchAttributes(), mailFilter.getMailFilterSearchValues())) {
                        isValid = true;
                    }
                    if (!isValid) continue;
                    this.stat.debug("Got Mail-Filters");
                    if (mailFilter.getAction() == 1) {
                        this.stat.debug("Filter action move to: " + mailFilter.getActionParameter("destinationFolder"));
                        FolderObjectClientBean destFolder = (FolderObjectClientBean)sessionController.getGlobalObjectById(new Long(mailFilter.getActionParameter("destinationFolder")));
                        try (Transaction t = new Transaction();){
                            boolean linkBack = false;
                            try {
                                linkBack = Boolean.parseBoolean(mailFilter.getActionParameter("linkBack"));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.stat.debug("Filter action move to: " + mailFilter.getActionParameter("destinationFolder"));
                            moveAction = new MailFilterBean();
                            moveAction.linkBack = linkBack;
                            moveAction.destFolder = destFolder;
                            if (linkBack) {
                                FolderObjectClientBean sentbox;
                                String userHomeFolderPath = mailObject.getOwner().getPrimaryUserProfile().getHomeFolder().getAnyFolderPath();
                                moveAction.linkBackFolder = sentbox = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(userHomeFolderPath + "/Mail/sentbox");
                            }
                            t.commit();
                        }
                        moveTheMail = false;
                        if (!mailFilter.getStopFilter()) continue;
                        break;
                    }
                    if (mailFilter.getAction() == 6) {
                        if (StartWorkflowInterface.hasWorkflow()) {
                            String wfName = mailFilter.getActionParameter("workflowName");
                            String wfDescription = mailFilter.getActionParameter("workflowDescription");
                            if (workflowActions == null) {
                                workflowActions = new ArrayList<MailFilterBean>();
                            }
                            MailFilterBean mfb = new MailFilterBean();
                            mfb.wfName = wfName;
                            mfb.wfDescription = wfDescription;
                            workflowActions.add(mfb);
                        }
                        if (!mailFilter.getStopFilter()) continue;
                    } else {
                        if (mailFilter.getAction() != 7) continue;
                        if (StartWorkflowInterface.hasWorkflow()) {
                            String js = mailFilter.getActionParameter("js");
                            sessionController.findGlobalObjectByPathOrId(js);
                            if (jsActions == null) {
                                jsActions = new ArrayList<MailFilterBean>();
                            }
                            MailFilterBean jsAction = new MailFilterBean();
                            jsAction.js = js;
                            jsActions.add(jsAction);
                        }
                        if (!mailFilter.getStopFilter()) continue;
                    }
                    break;
                }
            }
            finally {
                if (tempFile != null) {
                    tempFile.delete();
                }
            }
        }
        this.performFilterActions(moveAction, workflowActions, jsActions, mailObject);
        return moveTheMail;
    }

    public void performFilterActions(MailFilterBean moveAction, List<MailFilterBean> workflowActions, List<MailFilterBean> jsActions, MailObjectClientBean mailObject) throws Exception {
        EngineContext context;
        SessionController sc;
        Throwable throwable;
        Transaction t;
        try {
            t = new Transaction();
            throwable = null;
            try {
                if (moveAction != null) {
                    mailObject.getParents()[0].removeItem(mailObject);
                    if (!moveAction.destFolder.hasItem(mailObject.getName())) {
                        moveAction.destFolder.add(mailObject);
                    }
                    mailObject.setAcl(moveAction.destFolder.getAcl());
                    if (moveAction.newOwner != null) {
                        mailObject.setOwner(moveAction.newOwner);
                    }
                    if (moveAction.linkBack && !moveAction.linkBackFolder.hasItem(mailObject.getName())) {
                        moveAction.linkBackFolder.add(mailObject);
                    }
                }
                t.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (t != null) {
                    if (throwable != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        t.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.stat.error().sticky("Error running MailFilterAction: move").exception((Throwable)e).send("Error running MailFilterAction: move");
        }
        if (jsActions != null) {
            try {
                t = new Transaction();
                throwable = null;
                try {
                    for (MailFilterBean jsAction : jsActions) {
                        sc = mailObject.getSessionController();
                        context = new EngineContext(false, sc);
                        context.put("sessionController", sc);
                        context.put("sc", sc);
                        context.put("sessionControllerAdmin", SessionControllerAdmin.getSessionControllerAdmin("MailFilter"));
                        context.put("sca", SessionControllerAdmin.getSessionControllerAdmin("MailFilter"));
                        context.put("object", mailObject);
                        ContentInterface ci = (ContentInterface)((Object)sc.findGlobalObjectByPathOrId(jsAction.js));
                        Object result = context.exec(ci);
                        if (result == null) continue;
                        this.stat.debug(result.toString());
                    }
                    t.commit();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (t != null) {
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.stat.error().sticky("Error running MailFilterAction: JS").exception((Throwable)e).send("Error running MailFilterAction: JS");
            }
        }
        if (workflowActions != null) {
            try {
                t = new Transaction();
                throwable = null;
                try {
                    for (MailFilterBean mfb : workflowActions) {
                        sc = mailObject.getSessionController();
                        context = new EngineContext(false, sc);
                        HashMap<String, String> parameters = new HashMap<String, String>();
                        parameters.put("name", mfb.wfName);
                        parameters.put("description", mfb.wfDescription);
                        context.put("sessionController", sc);
                        context.put("sc", sc);
                        context.put("sessionControllerAdmin", SessionControllerAdmin.getSessionControllerAdmin("MailFilter"));
                        context.put("sca", SessionControllerAdmin.getSessionControllerAdmin("MailFilter"));
                        context.put("object", mailObject);
                        context.put("parameters", parameters);
                        ContentInterface ci = (ContentInterface)((Object)sc.findGlobalObjectByPathOrId("/agorum/roi/customers/agorum.mail.filter/js/utils/start-workflow.js"));
                        Object result = context.exec(ci);
                        if (result == null) continue;
                        this.stat.debug(result.toString());
                    }
                    t.commit();
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (t != null) {
                        if (throwable != null) {
                            try {
                                t.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            t.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.stat.error().sticky("Error running MailFilterAction: Workflow").exception((Throwable)e).send("Error running MailFilterAction: Workflow");
            }
        }
    }
}

