/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.statistic.MetaDbStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.SessionController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MetaDbSuperCache {
    private static final SystemStatistic stat = MetaDbStatistic.getInstance();
    private static Map<String, Object> cacheEntry = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> cacheEntries = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> cacheEntryList = new ConcurrentHashMap<String, Object>();
    private static Map<String, Object> cacheBundleList = new ConcurrentHashMap<String, Object>();
    private static long nextCheckTime = 0L;

    private static void checkCache() {
        if (nextCheckTime < System.currentTimeMillis()) {
            cacheEntry = new ConcurrentHashMap<String, Object>();
            cacheEntries = new ConcurrentHashMap<String, Object>();
            cacheEntryList = new ConcurrentHashMap<String, Object>();
            cacheBundleList = new ConcurrentHashMap<String, Object>();
            nextCheckTime = System.currentTimeMillis() + 30000L;
        }
    }

    public static void invalidate(String key) {
        MetaDbSuperCache.checkCache();
        cacheEntry.remove(key);
        stat.count("MetaDb super cache invalidations", 1L);
    }

    public static String getSimplePropertyValue(SessionController sessionController, String key, String def) {
        String v = MetaDbSuperCache.getSimplePropertyValue(sessionController, key);
        if (v != null) {
            return v;
        }
        return def;
    }

    public static String getEncryptedPropertyValue(SessionController sessionController, String key, String def) {
        String v = MetaDbSuperCache.getSimplePropertyValue(sessionController, key);
        if (v != null) {
            return new CryptKeyController().tryDecrypt(v, "metadb", sessionController);
        }
        return def;
    }

    public static String getEncryptedPropertyValue(SessionController sessionController, String key) {
        return MetaDbSuperCache.getEncryptedPropertyValue(sessionController, key, null);
    }

    public static String getSimplePropertyValue(SessionController sessionController, String key) {
        MetaDbSuperCache.checkCache();
        Object o = cacheEntry.get(key);
        if (o != null) {
            stat.count("MetaDb super cache hits", 1L);
            if (o instanceof NullValue) {
                return null;
            }
            return (String)o;
        }
        stat.count("MetaDb super cache misses", 1L);
        String[] values = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            values = metaDb.getSimplePropertyValue(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (values != null && values.length > 0) {
            cacheEntry.put(key, values[0]);
            return values[0];
        }
        cacheEntry.put(key, new NullValue());
        return null;
    }

    public static String[] getSimplePropertyValues(SessionController sessionController, String key) {
        MetaDbSuperCache.checkCache();
        Object o = cacheEntries.get(key);
        if (o != null) {
            stat.count("MetaDb super cache hits", 1L);
            if (o instanceof NullValue) {
                return null;
            }
            return (String[])o;
        }
        stat.count("MetaDb super cache misses", 1L);
        String[] values = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            values = metaDb.getSimplePropertyValue(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (values != null) {
            cacheEntries.put(key, values);
            return values;
        }
        cacheEntries.put(key, new NullValue());
        return null;
    }

    public static String[] listSimplePropertyBundles(SessionController sessionController, String key) {
        MetaDbSuperCache.checkCache();
        Object o = cacheBundleList.get(key);
        if (o != null) {
            stat.count("MetaDb super cache hits", 1L);
            if (o instanceof NullValue) {
                return null;
            }
            return (String[])o;
        }
        stat.count("MetaDb super cache misses", 1L);
        String[] values = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            values = metaDb.listSimplePropertyBundle(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (values != null) {
            cacheBundleList.put(key, values);
            return values;
        }
        cacheBundleList.put(key, new NullValue());
        return null;
    }

    public static String[] listSimplePropertyEntries(SessionController sessionController, String key) {
        MetaDbSuperCache.checkCache();
        Object o = cacheEntryList.get(key);
        if (o != null) {
            stat.count("MetaDb super cache hits", 1L);
            if (o instanceof NullValue) {
                return null;
            }
            return (String[])o;
        }
        stat.count("MetaDb super cache misses", 1L);
        String[] values = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            values = metaDb.listSimplePropertyEntry(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (values != null) {
            cacheEntryList.put(key, values);
            return values;
        }
        cacheEntryList.put(key, new NullValue());
        return null;
    }

    public static boolean isTrue(SessionController sc, String path) {
        return Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(sc, path));
    }

    private static class NullValue {
        private NullValue() {
        }
    }
}

