/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cache.GenericCache;
import agorum.roi.ejb.client.beans.PropertyBundleObjectClientBean;
import agorum.roi.ejb.common.JMSEventController;
import agorum.roi.ejb.common.JMSEventListenerBean;
import agorum.roi.ejb.common.JMSEventListenerInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.messaging.common.MessageConnectionHolder;
import agorum.roi.ejb.messaging.common.MessageUtils;
import java.util.Hashtable;
import javax.jms.Message;
import javax.jms.MessageListener;

public class PropertyBundleCache
implements MessageListener,
JMSEventListenerInterface {
    private Hashtable propertyObjectCache = new Hashtable();
    private MessageConnectionHolder messageConnectionHolder = null;
    private JMSEventListenerBean jmsBean = null;
    private JMSEventController eventController = null;
    public static boolean killTest = false;

    public PropertyBundleCache() {
        try {
            this.connectEvents();
            this.jmsBean = new JMSEventListenerBean();
            this.jmsBean.setId("PropertyBundleCache_" + this.hashCode());
            this.jmsBean.setJmsEventListener(this);
            this.eventController = JMSEventController.getInstance();
            this.eventController.registerListener(this.jmsBean);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static PropertyBundleCache getInstance(SessionController sessionController) throws Exception {
        GenericCache gc = GenericCache.getInstance((Object)("PropertyCache_" + sessionController.getSessionId()), (int)1000, (int)10000, (int)600000);
        PropertyBundleCache cache = (PropertyBundleCache)gc.get((Object)"PropertyBundleCache");
        if (cache == null) {
            cache = new PropertyBundleCache();
            gc.put((Object)"PropertyBundleCache", (Object)cache);
        }
        return cache;
    }

    private void connectEvents() {
        try {
            MessageUtils messageUtils = new MessageUtils();
            this.messageConnectionHolder = messageUtils.registerSubScriber(this, "deletePropertyObjectListener");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void disconnectEvents() {
        try {
            MessageUtils mu = new MessageUtils();
            mu.unregisterSubScriber(this.messageConnectionHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void reconnectEvent() {
        this.disconnectEvents();
        this.connectEvents();
    }

    @Override
    public void sendCheckEvent() {
        this.eventController.sendMyEvent(this.jmsBean, "deletePropertyObjectListener");
    }

    public void finalize() {
        this.disconnectEvents();
    }

    public void onMessage(Message message) {
        if (killTest) {
            System.err.println(" <<<<<<<<<<< Making a kill Test >>>>>>>>>>>");
            this.disconnectEvents();
            return;
        }
        if (!this.eventController.checkMyEvent(this.jmsBean, message)) {
            try {
                String propertyName = (String)message.getObjectProperty("value");
                if (propertyName != null && this.propertyObjectCache.containsKey(propertyName)) {
                    System.err.println("Got PropertyBundle remove event, removing: " + propertyName);
                    this.propertyObjectCache.remove(propertyName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public PropertyBundleObjectClientBean getPropertyBundleFromCache(String propertyName) throws Exception {
        return (PropertyBundleObjectClientBean)this.propertyObjectCache.get(propertyName);
    }

    public void putPropertyBundleToCache(String propertyName, PropertyBundleObjectClientBean propertyBundle) throws Exception {
        if (this.propertyObjectCache.containsKey(propertyName)) {
            this.propertyObjectCache.remove(propertyName);
        }
        this.propertyObjectCache.put(propertyName, propertyBundle);
    }
}

