/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.encrypt.ntlm.DesEncryption;
import agorum.commons.encrypt.ntlm.NTLMEncryption;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.common.AuthenticationHandler;
import agorum.roi.ejb.common.BaseCredentialManager;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.CredentialCallerBean;
import agorum.roi.ejb.common.CredentialConfig;
import agorum.roi.ejb.common.CredentialInfoBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.CredentialPasswordBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;

public class RoiCredentialManager
extends BaseCredentialManager {
    protected AuthenticationHandler getAuthClass(Connection conn, CredentialObject credential) throws Exception {
        String credentialManager = credential.getCredentialManager();
        CredentialConfig config = RoiCredentialManager.getCredentialConfig(credentialManager);
        Hashtable<String, String> parameters = config.getParameters();
        try {
            String authHandlerS = parameters.get("AuthenticationHandler");
            AuthenticationHandler authHandler = (AuthenticationHandler)Class.forName(authHandlerS).newInstance();
            if (authHandler != null) {
                return authHandler;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected boolean handleAuthClass(Connection conn, CredentialObject credential) throws Exception {
        String credentialManager = credential.getCredentialManager();
        CredentialConfig config = RoiCredentialManager.getCredentialConfig(credentialManager);
        Hashtable<String, String> parameters = config.getParameters();
        try {
            String authHandlerS = parameters.get("AuthenticationHandler");
            AuthenticationHandler authHandler = (AuthenticationHandler)Class.forName(authHandlerS).newInstance();
            boolean authenticated = authHandler.authenticate(conn, credential);
            credential.setAuthenticatedExternally(authenticated);
            return authenticated;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void updatePasswordHashes(Connection conn, String username, String password) throws Exception {
        String ntlmHash = StringConverterUtils.toHexString((byte[])new NTLMEncryption().getNTLMHash(password));
        try (PreparedStatement pstmt = conn.prepareStatement("select PASSWORD from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?");){
            pstmt.setString(1, username.toUpperCase());
            try (ResultSet rs = pstmt.executeQuery();){
                if (rs.next() && ntlmHash.equals(rs.getString(1))) {
                    return;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        new RoiCredentialManager().changePassword(SessionControllerAdmin.getSessionControllerAdmin("Login"), username, password, new CredentialCallerBean("Login"));
    }

    public static void updatePasswordHashes(String username, String password) throws Exception {
        try (Connection conn = new ConnectionUtils().getConnection(true);){
            RoiCredentialManager.updatePasswordHashes(conn, username, password);
        }
    }

    public static void updatePasswordHashes(Connection conn, CredentialObject credential) throws Exception {
        if (credential.getClearTextPassword() == null || credential.getClearTextPassword().equals(credential.getPassWord())) {
            return;
        }
        RoiCredentialManager.updatePasswordHashes(conn, credential.getUserName(), credential.getClearTextPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentialInternal(Connection conn, CredentialObject credential) throws Exception {
        AuthenticationHandler handler = this.getAuthClass(conn, credential);
        if (handler != null && !handler.checkWithLoginLogoutHandler()) {
            return this.handleAuthClass(conn, credential);
        }
        boolean b = false;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            int i;
            DatabaseInterface dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
            String select = dbi.getCredentialManagerSelect();
            pstmt = conn.prepareStatement(select);
            pstmt.setString(1, credential.getUserName().toUpperCase());
            pstmt.setString(2, credential.getPassWord());
            rs = pstmt.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    i = rs.getInt(1);
                    if (i != 1) continue;
                    b = true;
                }
            }
            if (!b) {
                System.err.println("CheckCredential (OLD Method)");
                rs.close();
                pstmt.close();
                pstmt = conn.prepareStatement(select);
                pstmt.setString(1, credential.getUserName().toUpperCase());
                pstmt.setString(2, credential.getOldPassword());
                rs = pstmt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        i = rs.getInt(1);
                        if (i != 1) continue;
                        b = true;
                    }
                }
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createCredentialInternal(SessionController sessionController, CredentialObject credential, String ntlmPassWord, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Statement pstmt = null;
        try {
            String insert = "insert into ROICREDENTIALMANAGER (DISTINGUISHEDNAME, PASSWORD, LMPASSWORD, NTPASSWORD) values (?,?,?,?)";
            pstmt = conn.prepareStatement(insert);
            pstmt.setString(1, credential.getUserName().toUpperCase());
            pstmt.setString(2, ntlmPassWord);
            pstmt.setString(3, credential.getPassWord());
            pstmt.setString(4, "");
            pstmt.execute();
            pstmt.close();
            pstmt = null;
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteCredentialInternal(SessionController sessionController, String distinguisheName, Connection conn) throws Exception {
        Statement pstmt = null;
        try {
            String delete = "delete from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(delete);
            pstmt.setString(1, distinguisheName.toUpperCase());
            pstmt.execute();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePasswordInternal(SessionController sessionController, String distinguisheName, String password, String lmPassword, String ntPassword, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Statement pstmt = null;
        try {
            String update = "update ROICREDENTIALMANAGER set PASSWORD=?, LMPASSWORD=?, NTPASSWORD=? where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(update);
            pstmt.setString(1, password);
            pstmt.setString(2, lmPassword);
            pstmt.setString(3, ntPassword);
            pstmt.setString(4, distinguisheName.toUpperCase());
            pstmt.execute();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    public void setLMAndNTHashes(SessionController sessionController, DirectoryUserObjectClientBean du, String lmHash, String ntHash) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeDistinguisheNameInternal(SessionController sessionController, String distinguisheNameNew, String distinguisheNameOld, Connection conn, CredentialCallerBean credentialCaller) throws Exception {
        Statement pstmt = null;
        try {
            String update = "update ROICREDENTIALMANAGER set DISTINGUISHEDNAME=? where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(update);
            pstmt.setString(1, distinguisheNameNew.toUpperCase());
            pstmt.setString(2, distinguisheNameOld.toUpperCase());
            pstmt.execute();
            pstmt.close();
            pstmt = null;
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNtPassword(SessionController sessionController, String distinguisheName) throws Exception {
        long time = System.currentTimeMillis();
        this.checkAccess(sessionController, distinguisheName);
        System.err.println("getNtPassword 1: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ConnectionUtils cu = null;
        String ntPassword = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String insert = "select NTPASSWORD from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(insert);
            pstmt.setString(1, distinguisheName.toUpperCase());
            rs = pstmt.executeQuery();
            rs.next();
            ntPassword = rs.getString(1);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        System.err.println("getNtPassword 2: " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        return ntPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePasswordToDes(SessionController sessionController, String distinguisheName) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        try {
            StringUtils stringUtils = new StringUtils();
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String select = "select PASSWORD,LMPASSWORD from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(select);
            pstmt.setString(1, distinguisheName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            String ntlmHash = null;
            String lmHash = null;
            String password = null;
            if (rs.next()) {
                ntlmHash = rs.getString(1);
                lmHash = rs.getString(2);
                password = ntlmHash;
            }
            rs.close();
            rs = null;
            pstmt.close();
            pstmt = null;
            if (lmHash == null || lmHash.length() == 0) {
                String ngosPassword = this.getEncodedNTPassword(sessionController, ntlmHash, distinguisheName);
                DesEncryption des = new DesEncryption();
                lmHash = des.getBaseDESPassword(password);
                NTLMEncryption ntlm = new NTLMEncryption();
                ntlmHash = stringUtils.toHexString(ntlm.getNTLMHash(password));
                String update = "update ROICREDENTIALMANAGER set PASSWORD=?, LMPASSWORD=?, NTPASSWORD=? where DISTINGUISHEDNAME=?";
                pstmt = conn.prepareStatement(update);
                pstmt.setString(1, ntlmHash);
                pstmt.setString(2, lmHash);
                pstmt.setString(3, ngosPassword);
                pstmt.setString(4, distinguisheName.toUpperCase());
                pstmt.execute();
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeAliases(SessionController sessionController, String distinguisheName, String[] aliases) throws Exception {
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String delete = "delete from ROICREDENTIALALIASES where DISTINGUISHEDNAME=? and alias != DISTINGUISHEDNAME";
            pstmt = conn.prepareStatement(delete);
            pstmt.setString(1, distinguisheName.toUpperCase());
            pstmt.execute();
            pstmt.close();
            pstmt = null;
            if (aliases != null && aliases.length > 0) {
                int len = aliases.length;
                for (int i = 0; i < len; ++i) {
                    if (aliases[i] == null || aliases[i].length() <= 0) continue;
                    String insert = "insert into ROICREDENTIALALIASES (ALIAS,DISTINGUISHEDNAME) values (?,?)";
                    pstmt = conn.prepareStatement(insert);
                    pstmt.setString(1, aliases[i].toUpperCase());
                    pstmt.setString(2, distinguisheName.toUpperCase());
                    pstmt.execute();
                    pstmt.close();
                    pstmt = null;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialPasswordBean getPasswordHashes(Connection conn, CredentialObject credential) throws Exception {
        CredentialPasswordBean bean = new CredentialPasswordBean();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String select = "select PASSWORD,NTPASSWORD,LMPASSWORD from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(select);
            pstmt.setString(1, credential.getUserName().toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                bean.setNtlmHash(rs.getString(1));
                bean.setNgosPassword(rs.getString(2));
                bean.setLmHash(rs.getString(3));
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CredentialInfoBean getCredentialInfo(SessionController sessionController, String distinguisheName) throws Exception {
        CredentialInfoBean credInfo = null;
        this.checkAccess(sessionController, distinguisheName);
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        ConnectionUtils cu = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            String insert = "select DISTINGUISHEDNAME,PASSWORD,NTPASSWORD,LMPASSWORD from ROICREDENTIALMANAGER where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(insert);
            pstmt.setString(1, distinguisheName.toUpperCase());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                credInfo = new CredentialInfoBean();
                credInfo.setUserName(rs.getString(1));
                credInfo.setPassWord(rs.getString(2));
                credInfo.setNtPassWord(rs.getString(3));
                credInfo.setLmPassWord(rs.getString(4));
                credInfo.setPath(RoiCredentialManager.getPathOfUser(sessionController, distinguisheName));
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
        return credInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCredentialInfo(SessionController sessionController, CredentialInfoBean credentialInfo) throws Exception {
        this.checkAccess(sessionController, credentialInfo.getUserName().toUpperCase());
        Connection conn = null;
        Statement pstmt = null;
        ConnectionUtils cu = null;
        Object ntPassword = null;
        try {
            cu = new ConnectionUtils(sessionController);
            conn = cu.getConnection();
            CredentialInfoBean oldCredentialInfo = this.getCredentialInfo(sessionController, credentialInfo.getUserName());
            String statement = null;
            statement = oldCredentialInfo == null ? "insert into ROICREDENTIALMANAGER (PASSWORD, NTPASSWORD, LMPASSWORD, DISTINGUISHEDNAME) values (?,?,?,?)" : "update ROICREDENTIALMANAGER set PASSWORD=?,NTPASSWORD=?,LMPASSWORD=? where DISTINGUISHEDNAME=?";
            pstmt = conn.prepareStatement(statement);
            pstmt.setString(1, credentialInfo.getPassWord());
            pstmt.setString(2, credentialInfo.getNtPassWord());
            pstmt.setString(3, credentialInfo.getLmPassWord());
            pstmt.setString(4, credentialInfo.getUserName().toUpperCase());
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
            try {
                cu.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void updatePaths(SessionController sessionController, String userName) throws Exception {
    }

    @Override
    public void updateUser(DirectoryUserObjectClientBean user) throws Exception {
    }
}

