/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.system.SystemProperties;
import agorum.roi.common.utils.CycleUtils;
import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.EJBHomeHolder;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiFileSystemInfoBean;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.interfaces.home.RoiFileSystemHome;
import agorum.roi.ejb.interfaces.remote.RoiFileSystemRemote;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class RoiFileSystem {
    private SessionController sessionController = null;
    private RoiFileSystemRemote roiFileSystemRemote = null;

    public RoiFileSystem(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public RoiFileSystemRemote getRoiFileSystemRemote() throws Exception {
        try {
            if (this.roiFileSystemRemote == null) {
                RoiFileSystemHome home = (RoiFileSystemHome)EJBHomeHolder.getHome("ejb/RoiFileSystem");
                this.roiFileSystemRemote = home.create();
            }
            return this.roiFileSystemRemote;
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
            return null;
        }
    }

    public FolderObjectClientBean createFullpath(String fullpath, boolean leaveOwner) throws Exception {
        return this.createFullpath(fullpath, null, null, leaveOwner);
    }

    public FolderObjectClientBean createFullpath(String fullpath) throws Exception {
        return this.createFullpath(fullpath, null, null, false);
    }

    public FolderObjectClientBean createFullpath(String fullpath, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl, boolean leaveOwner) throws Exception {
        return this.getRoiFileSystemRemote().createFullpath(this.sessionController, fullpath, rootFolder, acl, leaveOwner);
    }

    public FolderObjectClientBean createFullpath(String fullpath, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl) throws Exception {
        return this.getRoiFileSystemRemote().createFullpath(this.sessionController, fullpath, rootFolder, acl, false);
    }

    public FolderObjectClientBean createDateFullpath(Date date, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl, boolean leaveOwner) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String fullpath = sdf.format(date);
        return this.getRoiFileSystemRemote().createFullpath(this.sessionController, fullpath, rootFolder, acl, leaveOwner);
    }

    public FolderObjectClientBean createDateFullpath(Date date, FolderObjectClientBean rootFolder, AccessControlListObjectClientBean acl) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        String fullpath = sdf.format(date);
        return this.getRoiFileSystemRemote().createFullpath(this.sessionController, fullpath, rootFolder, acl, false);
    }

    public FileObjectClientBean putDocument(String fileName, InputStream content, String folderPath, AccessControlListObjectClientBean acl, boolean doParse) throws Exception {
        FileObjectClientBean focb = null;
        if (doParse && fileName.toUpperCase().endsWith(".XML")) {
            try {
                RoiXMLParser roiXMLParser = new RoiXMLParser(this.sessionController);
                roiXMLParser.setDocument(content);
                ParserObject po = roiXMLParser.parse();
                CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(this.sessionController);
                createRoiObjectsFromParseObject.create(po);
            }
            catch (Exception e) {
                ExceptionUtils.handleException(e);
            }
        } else {
            String myFolderPath = folderPath;
            if (!myFolderPath.endsWith("/")) {
                myFolderPath = myFolderPath + "/";
            }
            if ((focb = (FileObjectClientBean)this.sessionController.findGlobalObjectByPath(myFolderPath = myFolderPath + fileName)) == null) {
                FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(folderPath);
                if (folder != null) {
                    FileObjectSessionFacade fosf = new FileObjectSessionFacade(this.sessionController);
                    fosf.setDestinationFolder(folder);
                    fosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
                    if (acl != null) {
                        fosf.setAttribute(GlobalObjectClientBean.ACL_ATTRIBUTE, acl);
                    }
                    fosf.setContentStream(content);
                    focb = (FileObjectClientBean)fosf.create();
                } else {
                    ExceptionUtils.handleException("Folder not found", "agorum.roi.remote.exception.FolderNotFound", 64);
                }
            } else {
                focb.setContent(content);
                if (acl != null) {
                    focb.setAcl(acl);
                }
            }
        }
        return focb;
    }

    public void move(FolderObjectClientBean fromFolder, FolderObjectClientBean toFolder, GlobalObjectClientBean object) throws Exception {
        this.checkMayObjectBeMoved(object, toFolder);
        fromFolder.removeItem(object);
        toFolder.addItem(object);
    }

    public void checkMayObjectBeMoved(GlobalObjectClientBean obj, FolderObjectClientBean destFolder) throws Exception {
        if (!obj.mayObjectBeMoved(destFolder)) {
            ExceptionUtils.handleException("Object could not be moved.", "agorum.roi.remote.exception.ObjectCouldNotMoved");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCycleCheck(GlobalObjectClientBean leftObject, GlobalObjectClientBean rightObject) throws Exception {
        ConnectionUtils cou = null;
        try {
            CycleUtils cu = new CycleUtils(this.sessionController);
            cou = new ConnectionUtils(this.sessionController);
            Connection conn = cou.getConnection();
            cu.insertCycleChecker(conn, leftObject.getId(), rightObject.getId());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                cou.closeConnection();
            }
            catch (Exception exception) {}
        }
    }

    public boolean isFolderInTheSamePath(FolderObjectClientBean sourceFolder, FolderObjectClientBean destinationFolder) throws Exception {
        return this.getRoiFileSystemRemote().isFolderInTheSamePath(this.sessionController, sourceFolder, destinationFolder);
    }

    public boolean checkNameCharsCustom(String name, String notAllowedChars) throws Exception {
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (notAllowedChars.indexOf(c) < 0) continue;
            ExceptionUtils.handleException("Name has not allowed characters (" + c + ") (name=" + name + ")", "agorum.roi.remote.exception.NameHasNotAllowedChars", 108);
        }
        if (!SystemProperties.getCharset().newEncoder().canEncode(name)) {
            ExceptionUtils.handleException("Name cannot be encoded in the system charset (name=" + name + ", charset=" + SystemProperties.getCharsetName() + ")", "agorum.roi.remote.exception.NameHasNotAllowedChars", 108);
        }
        return true;
    }

    public boolean checkNameChars(String name) throws Exception {
        if (name == null) {
            ExceptionUtils.handleException("Name is null", "agorum.roi.remote.exception.FolderNotFound", 64);
        } else {
            RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
            String endChars = rpmd.getNameEndNotWithChars();
            String notAllowedChars = rpmd.getNotAllowedNameChars();
            int len = name.length();
            if (endChars.indexOf(name.charAt(len - 1)) >= 0) {
                ExceptionUtils.handleException("Name ends with not allowed characters (name=" + name + ")", "agorum.roi.remote.exception.NameEndWithNotAllowedChars", 109);
            }
            for (int i = 0; i < len; ++i) {
                char c = name.charAt(i);
                if (notAllowedChars.indexOf(c) < 0) continue;
                ExceptionUtils.handleException("Name has not allowed characters (" + c + ") (name=" + name + ")", "agorum.roi.remote.exception.NameHasNotAllowedChars", 108);
            }
        }
        if (!SystemProperties.getCharset().newEncoder().canEncode(name)) {
            ExceptionUtils.handleException("Name cannot be encoded in the system charset (name=" + name + ", charset=" + SystemProperties.getCharsetName() + ")", "agorum.roi.remote.exception.NameHasNotAllowedChars", 108);
        }
        return true;
    }

    public void leaveOwner(GlobalObjectClientBean object, DirectoryUserObjectClientBean owner) throws Exception {
        GlobalObjectClientBean[] subItems;
        object.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, AttributeValue.newAttributeValueObject(owner));
        if (object.getIsFolder() && (subItems = ((FolderObjectClientBean)object).getItems()) != null) {
            int len = subItems.length;
            for (int i = 0; i < len; ++i) {
                this.leaveOwner(subItems[i], owner);
            }
        }
    }

    public GlobalObjectClientBean getGlobalObject(Object o) throws Exception {
        GlobalObjectClientBean gocb = null;
        if (o != null) {
            if (o instanceof GlobalObjectClientBean) {
                gocb = (GlobalObjectClientBean)o;
            } else if (o instanceof String) {
                gocb = this.sessionController.findGlobalObjectByPath((String)o);
            } else if (o instanceof Long) {
                gocb = this.sessionController.getGlobalObjectById((Long)o);
            } else {
                throw new Exception("Object not define: " + o.getClass().getName());
            }
        }
        return gocb;
    }

    public RoiFileSystemInfoBean getFileSystemInfo(GlobalObjectClientBean startObject, int depth) throws RemoteException, Exception {
        return this.getRoiFileSystemRemote().getFileSystemInfo(this.sessionController, startObject, depth);
    }

    public FileObjectClientBean findFileObjectInFolderWithLanguage(String searchPath, Locale locale, String extensionFilter) {
        String mandator = locale.getVariant() == null ? "" : locale.getVariant() + "_";
        String mandatorLanguage = mandator + locale.getLanguage();
        String mandatorWithoutLang = locale.getVariant() == null ? locale.getLanguage() : locale.getVariant();
        String[] variants = new String[]{"/" + mandatorLanguage, "/" + mandatorWithoutLang, "/" + locale.getLanguage(), ""};
        FileObjectClientBean fileObject = null;
        boolean doBreak = false;
        int len = variants.length;
        for (int i = 0; i < len; ++i) {
            FolderObjectClientBean folder = null;
            try {
                folder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(searchPath + variants[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (folder == null) continue;
            try {
                GlobalObjectClientBean[] globalObject = folder.getItems();
                if (globalObject == null) continue;
                int lenO = globalObject.length;
                for (int j = 0; j < lenO; ++j) {
                    if (!(globalObject[j] instanceof FileObjectClientBean) || extensionFilter != null && !globalObject[j].getNameExtension().equalsIgnoreCase(extensionFilter)) continue;
                    fileObject = (FileObjectClientBean)globalObject[j];
                    doBreak = true;
                    break;
                }
                if (!doBreak) continue;
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fileObject;
    }

    public String getUniqueName(FolderObjectClientBean[] parents, GlobalObjectClientBean obj, String newFileName) throws Exception {
        if (parents != null) {
            int pos;
            String name = newFileName;
            String extension = null;
            if (name != null && (pos = name.lastIndexOf(".")) != -1) {
                extension = name.substring(pos + 1);
                name = name.substring(0, pos);
            }
            int counter = 0;
            while (true) {
                String newName = name;
                if (counter > 0) {
                    newName = name + " (" + counter + ")";
                }
                if (extension != null) {
                    newName = newName + "." + extension;
                }
                boolean hasItem = false;
                for (FolderObjectClientBean parent : parents) {
                    if (!parent.hasItem(newName)) continue;
                    if (obj != null) {
                        GlobalObjectClientBean existObj = parent.getItem(newName);
                        if (existObj.getId().equals(obj.getId())) {
                            return newName;
                        }
                        hasItem = true;
                        break;
                    }
                    hasItem = true;
                    break;
                }
                if (!hasItem) {
                    return newName;
                }
                ++counter;
            }
        }
        return newFileName;
    }
}

