/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.string.StringBase64Utils;
import agorum.commons.utils.ReloadablePropertyResourceBundle;
import java.io.UnsupportedEncodingException;

public class RoiProperties {
    private static ReloadablePropertyResourceBundle property;
    private static long nextLoadTime;
    private static final long TIMER_OFFSET = 20000L;
    private static final byte[] key;

    public RoiProperties() {
        RoiProperties.init();
    }

    private static synchronized void init() {
        if (property == null || System.currentTimeMillis() > nextLoadTime) {
            nextLoadTime = System.currentTimeMillis() + 20000L;
            property = (ReloadablePropertyResourceBundle)ReloadablePropertyResourceBundle.getResourceBundle((String)"agorum.roi.properties.Roi");
        }
    }

    public void replaceProperty(String name, String value) throws Exception {
        property.replaceProperty(name, value);
        property.clearCheckTimeHash();
        property = (ReloadablePropertyResourceBundle)ReloadablePropertyResourceBundle.getResourceBundle((String)"agorum.roi.properties.Roi");
    }

    public String getRoiSystemUser() {
        return property.getString("agorum.roi.system.user.User");
    }

    public String getRoiSystemPassword() {
        return this.decrypt(property.getString("agorum.roi.system.user.Password"));
    }

    public void setRoiSystemPassword(String password) throws Exception {
        this.replaceProperty("agorum.roi.system.user.Password", this.encrypt(password));
    }

    public String getRoiGuestUser() {
        return property.getString("agorum.roi.guest.user.User");
    }

    public String getRoiGuestPassword() {
        return this.decrypt(property.getString("agorum.roi.guest.user.Password"));
    }

    public void setRoiGuestPassword(String password) throws Exception {
        this.replaceProperty("agorum.roi.guest.user.Password", this.encrypt(password));
    }

    public int getSessionUnlockPort() {
        return Integer.parseInt(property.getString("agorum.roi.system.SessionUnlockPort"));
    }

    public int getEventAssistanceLifeTime() {
        try {
            return Integer.parseInt(property.getString("agorum.roi.system.EventAssistanceLifeTime"));
        }
        catch (Exception exception) {
            return 30;
        }
    }

    public String getUserTransactionJndiName() {
        return property.getString("agorum.roi.ejb.UserTransactionJndiName");
    }

    public int getIsContainerConnectedInterval() {
        int iRet = 60000;
        try {
            iRet = Integer.parseInt(property.getString("agorum.roi.session.IsContainerConnectedInterval"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iRet;
    }

    public String getXMLHeaderForParsedXML() {
        String sRet = "<?xml version = \"1.0\" encoding=\"ISO-8859-15\"?>";
        try {
            sRet = property.getString("agorum.roi.session.XMLHeaderForParsedXML");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sRet;
    }

    public int getSessionContainerTimeToLive() {
        int iRet = 540000;
        try {
            iRet = Integer.parseInt(property.getString("agorum.roi.session.SessionContainerTimeToLive"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iRet;
    }

    public String getContentTask(String name, String className) throws Exception {
        String task = null;
        if (name.lastIndexOf(".") != -1) {
            String extension = name.substring(name.lastIndexOf(".") + 1);
            try {
                task = property.getString("agorum.roi.system.contenttask." + className.toLowerCase() + "." + extension.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return task;
    }

    public String getRoleDelimiter() {
        String sRet = "\u00a7";
        try {
            sRet = property.getString("agorum.roi.system.RoleDelimiter");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sRet;
    }

    public int getMetaDbGlobalSystemCacheHandlerMaxItems() {
        int i = Integer.MAX_VALUE;
        try {
            i = Integer.parseInt(property.getString("agorum.roi.metadb.metaDbglobalsystemcachehandler.MaxItems"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getMetaDbGlobalSystemCacheHandlerPurgeCacheInterval() {
        int i = 10000;
        try {
            i = Integer.parseInt(property.getString("agorum.roi.metadb.metaDbglobalsystemcachehandler.PurgeCacheInterval"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public int getMetaDbGlobalSystemCacheHandlerChaeEntryLifeTime() {
        int i = 864000000;
        try {
            i = Integer.parseInt(property.getString("agorum.roi.metadb.metaDbglobalsystemcachehandler.ChaeEntryLifeTime"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return i;
    }

    public static boolean isAuditEnabled() {
        try {
            String str = property.getString("agorum.roi.system.AuditEnabled");
            return str == null || Boolean.parseBoolean(str);
        }
        catch (Exception e) {
            return true;
        }
    }

    private String encrypt(String clear) throws UnsupportedEncodingException {
        return "==" + StringBase64Utils.encode((byte[])this.xor(clear.getBytes("UTF-8")));
    }

    private String decrypt(String encrypted) {
        if (!encrypted.startsWith("==")) {
            return encrypted;
        }
        try {
            return new String(this.xor(StringBase64Utils.decode((String)encrypted.substring(2))), "UTF-8");
        }
        catch (Exception e) {
            return encrypted;
        }
    }

    private byte[] xor(byte[] in) {
        int len = in.length;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            out[i] = (byte)(in[i] ^ key[i % key.length]);
        }
        return out;
    }

    static {
        try {
            RoiProperties.init();
        }
        catch (Exception e) {
            CoreStatistic.getInstance().error((Throwable)e);
        }
        key = new byte[]{115, 101, 99, 117, 114, 105, 116, 121, 32, 116, 104, 101, 97, 116, 101, 114};
    }
}

