/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.statistic.PerformanceValueHolder;
import agorum.roi.ejb.common.Transaction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.Random;

public class TestDbPerformanceUtil {
    public static void testDbTruncate(Connection conn) throws Exception {
        TestDbPerformanceUtil.emptyTestTable(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDbManyInserts(Connection conn, boolean createDb, boolean dropDb, int amount, boolean commit) throws Exception {
        if (createDb) {
            TestDbPerformanceUtil.createTestTable(conn);
        }
        try {
            TestDbPerformanceUtil.emptyTestTable(conn);
            for (int i = 0; i < amount; ++i) {
                try (Transaction t = new Transaction();){
                    try (PreparedStatement pstmt = conn.prepareStatement("insert into performancetesttable (id, testint) values(?,?)");){
                        pstmt.setInt(1, i);
                        pstmt.setInt(2, i);
                        pstmt.execute();
                    }
                    t.commit();
                    continue;
                }
            }
        }
        finally {
            if (dropDb) {
                TestDbPerformanceUtil.dropTestTable(conn);
            }
        }
    }

    public static void testDbManySelects(Connection conn, int amount, int maxId) throws Exception {
        for (int i = 0; i < amount; ++i) {
            try (PreparedStatement pstmt = conn.prepareStatement("select id, testint from performancetesttable where id = ?");){
                pstmt.setInt(1, i & maxId);
                try (ResultSet rSet = pstmt.executeQuery();){
                    while (rSet.next()) {
                        rSet.getLong(2);
                    }
                    continue;
                }
            }
        }
    }

    public static void testDbACSelects(Connection conn, int amount) throws Exception {
        long id = 9999L;
        Random rand = new Random(System.currentTimeMillis());
        for (int i = 0; i < amount; ++i) {
            try (PreparedStatement pstmt = conn.prepareStatement("select c.id, c.name from relationobject a, folderpathrelationobject b, globalobject c where a.id = b.id and a.leftobject=? and c.id=a.rightobject");){
                pstmt.setLong(1, id);
                try (ResultSet rSet = pstmt.executeQuery();){
                    while (rSet.next()) {
                        rSet.getLong(1);
                        rSet.getString(2);
                    }
                }
            }
            id = rand.nextLong();
        }
    }

    public static void testDbSelect1(Connection conn, int amount) throws Exception {
        for (int i = 0; i < amount; ++i) {
            try (PreparedStatement pstmt = conn.prepareStatement("select 1 from dual");
                 ResultSet rSet = pstmt.executeQuery();){
                while (rSet.next()) {
                    rSet.getLong(1);
                }
                continue;
            }
        }
    }

    public static void testDbBlobSelects(Connection conn, int amount, int maxId) throws Exception {
        for (int i = 0; i < amount; ++i) {
            try (PreparedStatement pstmt = conn.prepareStatement("select id, testblob from performancetesttable where id = ?");){
                pstmt.setInt(1, i & maxId);
                try (ResultSet rSet = pstmt.executeQuery();){
                    while (rSet.next()) {
                        Blob blob = rSet.getBlob(2);
                        blob.getBytes(1L, 524288);
                    }
                    continue;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDbManyInserts2(Connection conn, boolean createDb, boolean dropDb, int amount) throws Exception {
        if (createDb) {
            TestDbPerformanceUtil.createTestTable(conn);
        }
        try {
            TestDbPerformanceUtil.emptyTestTable(conn);
            for (int i = 0; i < amount; ++i) {
                try (PreparedStatement pstmt = conn.prepareStatement("insert into performancetesttable (id, teststring, testint) values(?,?,?)");){
                    pstmt.setInt(1, i);
                    pstmt.setString(2, "This is a test string with the number: " + i);
                    pstmt.setInt(3, i);
                    pstmt.execute();
                    continue;
                }
            }
        }
        finally {
            if (dropDb) {
                TestDbPerformanceUtil.dropTestTable(conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testDbBlobInserts(Connection conn, boolean createDb, boolean dropDb, int amount) throws Exception {
        if (createDb) {
            TestDbPerformanceUtil.createTestTable(conn);
        }
        try {
            TestDbPerformanceUtil.emptyTestTable(conn);
            int bufLen = 524288;
            byte[] buffer = new byte[bufLen];
            Random rand = new Random(System.currentTimeMillis());
            for (int i = 0; i < amount; ++i) {
                rand.nextBytes(buffer);
                try (PreparedStatement pstmt = conn.prepareStatement("insert into performancetesttable (id, teststring, testint, testblob) values(?,?,?,?)");){
                    pstmt.setInt(1, i);
                    pstmt.setString(2, "This is a test string with the number: " + i);
                    pstmt.setInt(3, i);
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);){
                        pstmt.setBinaryStream(4, (InputStream)bais, bufLen);
                        pstmt.execute();
                        continue;
                    }
                }
            }
        }
        finally {
            if (dropDb) {
                TestDbPerformanceUtil.dropTestTable(conn);
            }
        }
    }

    public static void createTestTable(Connection conn) throws Exception {
        try (PreparedStatement pStmt = conn.prepareStatement("CREATE TABLE PERFORMANCETESTTABLE (ID bigint(16) NOT NULL PRIMARY KEY, TESTSTRING VARCHAR (255) BINARY, TESTBLOB LONGBLOB, TESTINT bigint(16)) Engine=InnoDB");){
            pStmt.execute();
        }
    }

    public static void dropTestTable(Connection conn) throws Exception {
        try (PreparedStatement pstmt = conn.prepareStatement("drop table performancetesttable");){
            pstmt.execute();
        }
    }

    private static void emptyTestTable(Connection conn) throws Exception {
        try (PreparedStatement pstmt = conn.prepareStatement("truncate performancetesttable");){
            pstmt.execute();
        }
    }

    public static void collectPerformance(String msg, long time, long amount, Map<String, PerformanceValueHolder> times, PerformanceValueHolder pvh) {
        long duration = System.currentTimeMillis() - time;
        double perSec = (double)amount / ((double)duration / 1000.0);
        PerformanceValueHolder pvhTmp = times.get(msg);
        if (pvhTmp == null) {
            pvhTmp = pvh;
            pvhTmp.performanceValue = 0.0;
        }
        pvhTmp.performanceValue += perSec;
        times.put(msg, pvhTmp);
    }
}

