/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import agorum.commons.cron.SystemTimer;
import agorum.roi.ejb.common.TransInfoBean;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionTracker {
    private static final ThreadLocal<Set<String>> transactions = new ThreadLocal();
    private static final Map<String, TransInfoBean> transactionsLog = new ConcurrentHashMap<String, TransInfoBean>();
    private static final long LONG_TRANSACTION_TIME = 600000L;

    private TransactionTracker() {
    }

    public static void beginTransaction(String ident, String addInfo) {
        if (transactions.get() == null) {
            transactions.set(new HashSet());
            String threadId = TransactionTracker.getThreadId();
            transactionsLog.put(threadId, new TransInfoBean(threadId, ident, addInfo));
        }
    }

    public static void endTransaction() {
        transactions.remove();
        transactionsLog.remove(TransactionTracker.getThreadId());
    }

    public static List<TransInfoBean> getCurrentTransactions() {
        return new ArrayList<TransInfoBean>(transactionsLog.values());
    }

    public static boolean containsMessage(String uniqueMessageId) {
        Set<String> messages = transactions.get();
        return messages != null && messages.contains(uniqueMessageId);
    }

    public static void addMessage(String uniqueMessageId) {
        Set<String> messages = transactions.get();
        if (messages != null) {
            messages.add(uniqueMessageId);
        }
    }

    private static String getThreadId() {
        return "ThreadId_" + Thread.currentThread().getId();
    }

    static {
        SystemTimer.ofPeriod((long)600000L).call(() -> {
            long threshold = System.currentTimeMillis() + 600000L;
            for (TransInfoBean tib : TransactionTracker.getCurrentTransactions()) {
                if (tib.getStartTime() <= threshold) continue;
                try {
                    System.err.println("Very long transaction: " + tib.getStackTrace());
                    Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
                    for (Thread thread : stackTraces.keySet()) {
                        System.err.println("Thread: " + thread.getId() + " (" + thread.getName() + ") " + (Object)((Object)thread.getState()) + "");
                        for (StackTraceElement stackTraceElement : stackTraces.get(thread)) {
                            System.err.println(stackTraceElement);
                        }
                        System.err.println("");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        });
    }
}

