/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.common;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UserSequenceUtils {
    private Connection connection = null;

    public UserSequenceUtils(Connection connection) {
        this.connection = connection;
    }

    public int getUserSequence(long userId) throws Exception {
        int iRet = this.getUserSequenceFromDB(userId);
        if (iRet <= 0) {
            iRet = this.createNewUserSequence(userId);
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUserSequenceFromDB(long userId) throws Exception {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int iRet = -1;
        try {
            pstmt = this.connection.prepareStatement("select USERSEQUENCE from USERIDMAP where USERID=?");
            pstmt.setLong(1, userId);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                iRet = rs.getInt(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
        return iRet;
    }

    private int createNewUserSequence(long userId) throws Exception {
        int iRet = this.getUserSequenceFromDB(-1L);
        if (iRet > 0) {
            this.updateUserIdFromUserSequence(userId, iRet);
        } else {
            this.createNewUserSequenceInDB(userId);
            iRet = this.getUserSequenceFromDB(userId);
        }
        return iRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewUserSequenceInDB(long userId) throws Exception {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.connection.prepareStatement("insert into USERIDMAP (USERID) values (?)");
            pstmt.setLong(1, userId);
            pstmt.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUserIdFromUserSequence(long userId, int userSequence) throws Exception {
        PreparedStatement pstmt = null;
        try {
            pstmt = this.connection.prepareStatement("update USERIDMAP set USERID=? where USERSEQUENCE=?");
            pstmt.setLong(1, userId);
            pstmt.setInt(2, userSequence);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    public void freeUserSequence(int userSequence) throws Exception {
        this.updateUserIdFromUserSequence(-1L, userSequence);
    }
}

