/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.database.common;

import agorum.roi.ejb.database.common.DatabaseInterface;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class BaseDatabaseImpl
implements DatabaseInterface {
    private static final String AUDIT_RETURN_VALUES = "erg.id, erg.objectclassname, erg.commitid, erg.referenceobject, erg.action, erg.actiondate, erg.objectuuid, erg.ishead";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAclObjectTable(Connection conn, int scope, long objectId) throws Exception {
        PreparedStatement psSel = conn.prepareStatement("select ACLID, ISSCOPE from ACLOBJECTTABLE where OBJECTID=? and isscope=?");
        psSel.setLong(1, objectId);
        psSel.setInt(2, scope);
        ResultSet rs = null;
        try {
            rs = psSel.executeQuery();
            while (rs.next()) {
                long selAclId = rs.getLong(1);
                int selIsScope = rs.getInt(2);
                this.deleteAclObjectTable(conn, selIsScope, objectId, selAclId);
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                psSel.close();
                psSel = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAclObjectTableAllScopes(Connection conn, long objectId) throws Exception {
        PreparedStatement psSel = conn.prepareStatement("select ACLID, ISSCOPE from ACLOBJECTTABLE where OBJECTID=?");
        psSel.setLong(1, objectId);
        ResultSet rs = null;
        try {
            rs = psSel.executeQuery();
            while (rs.next()) {
                long selAclId = rs.getLong(1);
                int selIsScope = rs.getInt(2);
                this.deleteAclObjectTable(conn, selIsScope, objectId, selAclId);
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                psSel.close();
                psSel = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAclObjectTable(Connection conn, int scope, long objectId, long aclId) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = conn.prepareStatement("delete from ACLOBJECTTABLE  where ISSCOPE=? and ACLID=? and OBJECTID=?");
            ps.setLong(1, scope);
            ps.setLong(2, aclId);
            ps.setLong(3, objectId);
            ps.execute();
        }
        finally {
            try {
                ps.close();
                ps = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAclObjectTable(Connection conn, long isScope, long objectId, long aclId) throws Exception {
        PreparedStatement psSel = conn.prepareStatement("select ACLID from ACLOBJECTTABLE where ISSCOPE=0 and OBJECTID=?");
        psSel.setLong(1, objectId);
        ResultSet rs = null;
        try {
            rs = psSel.executeQuery();
            while (rs.next()) {
                long selAclId = rs.getLong(1);
                PreparedStatement ps = null;
                try {
                    ps = conn.prepareStatement("update ACLOBJECTTABLE set ACLID=? where ISSCOPE=0 and OBJECTID=? and ACLID=?");
                    ps.setLong(1, aclId);
                    ps.setLong(2, objectId);
                    ps.setLong(3, selAclId);
                    int anzUpdate = ps.executeUpdate();
                    if (anzUpdate > 0) continue;
                    System.err.println("Update fehlgeschlagen : update ACLOBJECTTABLE set ACLID=" + aclId + " where ISSCOPE=0 and OBJECTID=" + objectId);
                }
                finally {
                    try {
                        ps.close();
                        ps = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        finally {
            try {
                rs.close();
                rs = null;
            }
            catch (Exception exception) {}
            try {
                psSel.close();
                psSel = null;
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public String getCreateTableEndStatement(String tableName) throws Exception {
        return ")";
    }

    @Override
    public String getCyckleCheckerStatement01() {
        return "truncate table FPRCYCLE";
    }

    @Override
    public String getCyckleCheckerStatement02() {
        return "insert into FPRCYCLE (LEFTOBJECT,RIGHTOBJECT) values (?,?)";
    }

    @Override
    public String getCyckleCheckerStatement03() {
        return "select LEFTOBJECT from FPRCYCLE where RIGHTOBJECT = ?";
    }

    @Override
    public String getCyckleCheckerStatement05() {
        return "delete from FPRCYCLE where RIGHTOBJECT = ? and LEFTOBJECT = ?";
    }

    @Override
    public String getCyckleCheckerStatement05Check() {
        return "select count(*) from FPRCYCLE where RIGHTOBJECT = ? and LEFTOBJECT = ?";
    }

    @Override
    public String getAuditSyncDateSelect() {
        return "select min(actiondate) from agorumcoreaudit where actiondate > ?";
    }

    @Override
    public String getAuditSyncSelect() {
        return "select erg.id, erg.objectclassname, erg.commitid, erg.referenceobject, erg.action, erg.actiondate, erg.objectuuid, erg.ishead from agorumcoreaudit a,agorumcoreaudit erg where a.commitid = erg.commitid and a.action != 5 and a.iscommithead=1 and a.actiondate > ? and a.actiondate <= ? ${REPL_COMMITID}order by erg.commitid, erg.actiondate, erg.id";
    }

    @Override
    public String getAuditSyncDependencySelect() {
        return "select erg.id, erg.objectclassname, erg.commitid, erg.referenceobject, erg.action, erg.actiondate, erg.objectuuid, erg.ishead from agorumcoreaudit erg, syncdependency sd where erg.id=sd.id and sd.actiondate >= ? and sd.actiondate < ? and sd.ident = ? order by erg.commitid, erg.actiondate, erg.id";
    }

    protected String buildClassNameStatement(String[] classNames) {
        String statement = "";
        if (classNames != null && classNames.length > 0) {
            String notIn = "";
            String in = "";
            String notInSep = "";
            String inSep = "";
            int len = classNames.length;
            for (int i = 0; i < len; ++i) {
                if (classNames[i] == null || classNames[i].length() <= 0) continue;
                if (classNames[i].startsWith("!")) {
                    if (notIn.length() > 0) {
                        notInSep = ",";
                    }
                    notIn = notIn + notInSep + "'" + classNames[i].substring(1) + "'";
                    continue;
                }
                if (in.length() > 0) {
                    inSep = ",";
                }
                in = in + inSep + "'" + classNames[i] + "'";
            }
            if (notIn.length() > 0) {
                notIn = "classname not in (" + notIn + ")";
            }
            if (in.length() > 0) {
                in = "classname in (" + in + ")";
            }
            if (notIn.length() > 0 && in.length() > 0) {
                statement = "and (" + notIn + " and " + in + ")";
            } else if (notIn.length() > 0) {
                statement = "and (" + notIn + ")";
            } else if (in.length() > 0) {
                statement = "and (" + in + ")";
            }
        }
        return statement;
    }

    protected String buildCreateDateStatement(long after) {
        if (after <= 0L) {
            return "";
        }
        return "and CREATEDATE > " + after;
    }

    @Override
    public String getEAStatement2(String[] classNames, long after) {
        return "select ID,TYPE,CLASSNAME from EVENTASSISTANCE where SUBID=? and (VALUE & ?) > 0 " + this.buildClassNameStatement(classNames) + " " + this.buildCreateDateStatement(after) + " order by CREATEDATE desc";
    }

    @Override
    public String getIndexStatement17(String name, String dirName) {
        return "select LENGTH from INDEX_DOCUMENT_T where NAME='" + name + "' and DIRECTORY_NAME='" + dirName + "'";
    }

    @Override
    public String getIndexStatement20() {
        return "insert into INDEX_DOCUMENT_T (ID, NAME, DIRECTORY_NAME) VALUES (?,?,?)";
    }

    @Override
    public String getIndexStatement1() {
        return "truncate table INDEX_DOCUMENT_T";
    }

    @Override
    public String getIndexStatement2() {
        return "truncate table INDEX_CONTENT_T";
    }

    @Override
    public String getIndexStatement3() {
        return "truncate table INDEX_SEQUENCE_T";
    }

    @Override
    public boolean enableReplication(Connection conn) throws SQLException {
        return false;
    }

    @Override
    public boolean disableReplication(Connection conn) throws SQLException {
        return false;
    }

    protected String inClause(int count) {
        StringBuilder sb = new StringBuilder("in (");
        for (int i = 0; i < count; ++i) {
            sb.append("?");
            if (i + 1 == count) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public PreparedStatement getAuditGetItems(Connection connection, String[] classNames) throws SQLException {
        String sql = "select a.RIGHTOBJECTUUID from agorumcoreaudit a where a.LEFTOBJECTUUID = ? and a.ACTIONDATE <= ? and a.ACTION != 3 and a.ACTION != 1003 and a.ID = (select max(ID) from agorumcoreaudit b where a.OBJECTUUID = b.OBJECTUUID and b.ACTIONDATE <= ?) and a.OBJECTCLASSNAME " + this.inClause(classNames.length);
        PreparedStatement pStmt = connection.prepareStatement(sql, 1003, 1007);
        int i = 4;
        for (String className : classNames) {
            pStmt.setString(i++, className);
        }
        return pStmt;
    }

    @Override
    public String getAuditGetEntry() {
        return "select a.ID, a.COMMITID, a.REFERENCEOBJECT, a.OBJECTUUID, a.ACTIONDATE, a.USERUUID, a.OBJECTCLASSNAME, a.OBJECTNAME, a.ACTION, a.LEFTOBJECTUUID, a.RIGHTOBJECTUUID, a.ISHEAD, a.INFO, a.ATTRIBUTES, a.ISCOMMITHEAD from agorumcoreaudit a where a.id = (select max(b.id) from agorumcoreaudit b where b.OBJECTUUID = ? and b.ACTIONDATE <= ?)";
    }

    @Override
    public String getAuditGetRelated() {
        return "select ID, COMMITID, REFERENCEOBJECT, OBJECTUUID, ACTIONDATE, USERUUID, OBJECTCLASSNAME, OBJECTNAME, ACTION, LEFTOBJECTUUID, RIGHTOBJECTUUID, ISHEAD, INFO, ATTRIBUTES, ISCOMMITHEAD from agorumcoreaudit where (OBJECTUUID = ? or LEFTOBJECTUUID = ? or RIGHTOBJECTUUID = ?) and actiondate >= ? and actiondate <= ?";
    }

    @Override
    public String unescapeWildCards(String s) throws Exception {
        return s;
    }
}

