/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.poststart;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.utils.EnvTools;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.SessionController;

public class SetKeystore {
    private static final CoreStatistic logger = CoreStatistic.getInstance();

    public static void setKeyStore(SessionController sessionController) {
        try {
            MetaDb mdb = sessionController.getMetaDbInstance();
            String keyStorePath = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/keystore/KeystorePath")[0];
            if (keyStorePath != null && !keyStorePath.isEmpty()) {
                if (keyStorePath.indexOf("${HomeDir}") != -1) {
                    EnvTools envTools = new EnvTools();
                    keyStorePath = keyStorePath.replaceAll("\\$\\{HomeDir\\}", envTools.getHomeDir());
                }
                System.setProperty("javax.net.ssl.keyStore", keyStorePath);
            } else {
                logger.error("No key store set in meta db");
            }
            String password = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/keystore/KeystorePassword")[0];
            if (password != null && !password.isEmpty()) {
                CryptKeyController cryptKeyController = new CryptKeyController();
                password = cryptKeyController.tryDecrypt(password, "metadb", sessionController);
                System.setProperty("javax.net.ssl.keyStorePassword", password);
            } else {
                logger.error("No password for key store set in meta db");
            }
        }
        catch (MetaDbException mde) {
            logger.error((Throwable)mde);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }
}

