/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.virtual;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.cache.GenericCache;
import agorum.roi.common.utils.Metadata;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.FolderObjectClientBeanWrapper;
import agorum.roi.statistic.SmartFolderStatistic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VirtualFolderMetadataHandler {
    private FolderObjectClientBeanWrapper virtualFolder = null;
    private Integer maxCacheEntries = null;
    private Integer cachePurgeTime = null;
    private Integer cacheLifetime = null;
    private static final Integer DEFAULT_MAX_CACHE_ENTRIES = new Integer(1000);
    private static final Integer DEFAULT_CACHE_PURGE_TIME = 5000;
    private static final Integer DEFAULT_CACHE_LIFETIME = 36000000;
    private static final String MAX_CACHE_ENTRIES = "MAIN_MODULE_MANAGEMENT/asf/maxCacheMetaDatesEntries";
    private static final String MAX_PURGE_TIME = "MAIN_MODULE_MANAGEMENT/asf/maxCacheMetaDatesPurgeTime";
    private static final String MAX_LIFE_TIME = "MAIN_MODULE_MANAGEMENT/asf/maxCacheMetaDatesLifeTime";

    public VirtualFolderMetadataHandler(FolderObjectClientBeanWrapper virtualFolder) {
        this.virtualFolder = virtualFolder;
    }

    public Map<String, AttributeValue> getStructuredExtendedAttributes() throws Exception {
        HashMap<String, AttributeValue> structuredMap = new HashMap<String, AttributeValue>();
        Map<String, Object> metadataDescription = this.virtualFolder.getVirtualFolderDescriptionProvider().getDescription().getMetadata();
        for (Map.Entry<String, Object> entry : metadataDescription.entrySet()) {
            structuredMap.put(entry.getKey(), AttributeValue.newAttributeValueObject(entry.getValue()));
        }
        return structuredMap;
    }

    public Map<String, AttributeValue[]> getStructuredExtendedAttributesAll() throws Exception {
        Map<String, Object> gatheredMetadata = this.gatherMetaData();
        HashMap<String, AttributeValue[]> structuredMap = new HashMap<String, AttributeValue[]>();
        for (Map.Entry<String, Object> entry : gatheredMetadata.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getValue() instanceof List) {
                structuredMap.put(entry.getKey(), ((List)entry.getValue()).toArray(new AttributeValue[0]));
                continue;
            }
            structuredMap.put(entry.getKey(), new AttributeValue[]{AttributeValue.newAttributeValueObject(entry.getValue())});
        }
        return structuredMap;
    }

    public AttributeValue[] getExtendedAttributeAll(String attributeName) throws Exception {
        Object metadataValue;
        Map<String, Object> gatheredMetadata = this.gatherMetaData();
        if (gatheredMetadata != null && gatheredMetadata.size() > 0 && (metadataValue = gatheredMetadata.get(attributeName)) != null) {
            if (metadataValue instanceof List) {
                return ((List)metadataValue).toArray(new AttributeValue[0]);
            }
            return new AttributeValue[]{AttributeValue.newAttributeValueObject(metadataValue)};
        }
        return null;
    }

    public AttributeValue getExtendedAttribute(String attributeName) throws Exception {
        Object metadataValue;
        Map<String, Object> metadataDescription = this.virtualFolder.getVirtualFolderDescriptionProvider().getDescription().getMetadata();
        if (metadataDescription != null && metadataDescription.size() > 0 && (metadataValue = metadataDescription.get(attributeName)) != null) {
            return AttributeValue.newAttributeValueObject(metadataValue);
        }
        return null;
    }

    private Map<String, Object> gatherMetaData() throws Exception {
        Map<String, Object> gatheredMetadata = this.checkCache();
        if (gatheredMetadata.isEmpty()) {
            String facetField;
            FolderObjectClientBeanWrapper parent;
            Map<String, Object> descriptionMetadata;
            if (this.virtualFolder.getParent() != null) {
                gatheredMetadata.putAll(this.virtualFolder.getParent().getVirtualFolderMetadataHandler().gatherMetaData());
            }
            if ((descriptionMetadata = this.virtualFolder.getVirtualFolderDescriptionProvider().getDescription().getMetadata()) != null && !descriptionMetadata.isEmpty()) {
                for (Map.Entry<String, Object> entry : descriptionMetadata.entrySet()) {
                    if (Metadata.getInheritance(this.virtualFolder.getSessionController(), entry.getKey()).equalsIgnoreCase("inherited")) {
                        ArrayList<AttributeValue> valueList = new ArrayList<AttributeValue>();
                        Object metadata = gatheredMetadata.get(entry.getKey());
                        if (metadata != null) {
                            valueList.addAll((List)metadata);
                            if (valueList.indexOf(entry.getValue()) == -1) {
                                valueList.add(AttributeValue.newAttributeValueObject(entry.getValue()));
                            }
                        } else {
                            valueList.add(AttributeValue.newAttributeValueObject(entry.getValue()));
                        }
                        gatheredMetadata.put(entry.getKey(), valueList);
                        continue;
                    }
                    gatheredMetadata.put(entry.getKey(), entry.getValue());
                }
            }
            if ((parent = this.virtualFolder.getParent()) != null && (facetField = parent.getFacetField()) != null && !facetField.isEmpty()) {
                gatheredMetadata.put(facetField, this.virtualFolder.getFacetValue());
            }
            this.getCacheInstance().put((Object)this.virtualFolder.getID(), gatheredMetadata);
        }
        return gatheredMetadata;
    }

    private Map<String, Object> checkCache() {
        HashMap cachedMetaDates = this.getCacheInstance().get((Object)this.virtualFolder.getID());
        if (cachedMetaDates == null) {
            cachedMetaDates = new HashMap();
            return cachedMetaDates;
        }
        if (cachedMetaDates != null && !(cachedMetaDates instanceof Map)) {
            SmartFolderStatistic.getInstance().warning("Cache contained not expected meta date value for level \"" + this.virtualFolder.getID() + "\"");
            cachedMetaDates = new HashMap();
            return cachedMetaDates;
        }
        return cachedMetaDates;
    }

    private GenericCache getCacheInstance() {
        return GenericCache.getInstance((Object)("Roi.FolderObjectClientBeanWrapper.MetaDates." + this.virtualFolder.getEntryPoint().getSessionController().getSessionId()), (int)this.getMaxCacheEntries(), (int)this.getCachePurgeTime(), (int)this.getCacheLifetime());
    }

    private int getMaxCacheEntries() {
        if (this.maxCacheEntries == null) {
            MetaDb metaDb = this.virtualFolder.getEntryPoint().getSessionController().getMetaDbInstance();
            this.maxCacheEntries = DEFAULT_MAX_CACHE_ENTRIES;
            String[] configuredMaxCacheEntries = metaDb.getSimplePropertyValue(MAX_CACHE_ENTRIES);
            if (configuredMaxCacheEntries != null && configuredMaxCacheEntries.length > 0) {
                this.maxCacheEntries = Integer.parseInt(configuredMaxCacheEntries[0]);
            }
        }
        return this.maxCacheEntries;
    }

    private int getCachePurgeTime() {
        if (this.cachePurgeTime == null) {
            MetaDb metaDb = this.virtualFolder.getEntryPoint().getSessionController().getMetaDbInstance();
            this.cachePurgeTime = DEFAULT_CACHE_PURGE_TIME;
            String[] configuredMaxPurgeTime = metaDb.getSimplePropertyValue(MAX_PURGE_TIME);
            if (configuredMaxPurgeTime != null && configuredMaxPurgeTime.length > 0) {
                this.cachePurgeTime = Integer.parseInt(configuredMaxPurgeTime[0]);
            }
        }
        return this.cachePurgeTime;
    }

    private int getCacheLifetime() {
        if (this.cacheLifetime == null) {
            MetaDb metaDb = this.virtualFolder.getEntryPoint().getSessionController().getMetaDbInstance();
            this.cacheLifetime = DEFAULT_CACHE_LIFETIME;
            String[] configuredMaxLifeTime = metaDb.getSimplePropertyValue(MAX_LIFE_TIME);
            if (configuredMaxLifeTime != null && configuredMaxLifeTime.length > 0) {
                this.cacheLifetime = Integer.parseInt(configuredMaxLifeTime[0]);
            }
        }
        return this.cacheLifetime;
    }
}

