/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.adminsync.helper;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.common.beans.FolderDeleteRelationObjectUnDoBean;
import agorum.roi.common.utils.FolderDeleteRelationObjectUtils;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.interfaces.adminsync.AdminSyncInterface;
import java.util.ArrayList;

public class AdminSyncHelper {
    private String adminOffset;
    private FolderObjectClientBean adminOffsetFolder = null;

    public AdminSyncHelper(String adminOffset) {
        this.adminOffset = adminOffset;
    }

    public String[] getAllSyncs(SessionController sessionController) throws Exception {
        String[] allSyncs = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] allSyncsTmp = metaDb.listSimplePropertyBundle("MAIN_MODULE_MANAGEMENT/ngosadminsync/control");
            if (allSyncsTmp != null && allSyncsTmp.length > 0) {
                int i;
                ArrayList<String> allSyncListTmp = new ArrayList<String>();
                int syncPointsLen = allSyncsTmp.length;
                for (i = 0; i < syncPointsLen; ++i) {
                    boolean active = this.isSyncPointActive(allSyncsTmp[i], metaDb);
                    if (!active) continue;
                    allSyncListTmp.add(allSyncsTmp[i]);
                }
                syncPointsLen = allSyncListTmp.size();
                if (syncPointsLen > 0) {
                    allSyncs = new String[syncPointsLen];
                    for (i = 0; i < syncPointsLen; ++i) {
                        allSyncs[i] = (String)allSyncListTmp.get(i);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return allSyncs;
    }

    public String[] getAllFetchSyncs(SessionController sessionController) throws Exception {
        String[] allSyncs = null;
        try {
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String[] allSyncsTmp = metaDb.listSimplePropertyBundle("MAIN_MODULE_MANAGEMENT/ngosadminsync/control");
            if (allSyncsTmp != null && allSyncsTmp.length > 0) {
                int i;
                ArrayList<String> allSyncListTmp = new ArrayList<String>();
                int syncPointsLen = allSyncsTmp.length;
                for (i = 0; i < syncPointsLen; ++i) {
                    AdminSyncInterface interf;
                    boolean active = this.isSyncPointActive(allSyncsTmp[i], metaDb);
                    if (!active || !(interf = this.getClassFromSyncPoint(allSyncsTmp[i], metaDb)).isFetchClass()) continue;
                    allSyncListTmp.add(allSyncsTmp[i]);
                }
                syncPointsLen = allSyncListTmp.size();
                if (syncPointsLen > 0) {
                    allSyncs = new String[syncPointsLen];
                    for (i = 0; i < syncPointsLen; ++i) {
                        allSyncs[i] = (String)allSyncListTmp.get(i);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return allSyncs;
    }

    public ArrayList getSyncsForObject(SessionController sessionController, Object bean, FolderObjectClientBean parentFolder, String oldName) throws Exception {
        ArrayList<String> syncList = new ArrayList<String>();
        MetaDb mdb = null;
        try {
            mdb = sessionController.getMetaDbInstance();
        }
        catch (MetaDbException e) {
            ExceptionUtils.handleException(e);
        }
        String[] allSyncs = this.getAllSyncs(sessionController);
        if (allSyncs != null) {
            GlobalObjectClientBean gocb = this.getGlobalObject(sessionController, bean, oldName);
            String myAdminPath = null;
            if (parentFolder != null) {
                try {
                    myAdminPath = parentFolder.getAnyFolderPath(this.getAdminOffsetFolder(sessionController).getId());
                    myAdminPath = myAdminPath + "/" + gocb.getName();
                }
                catch (Exception exception) {}
            } else {
                try {
                    myAdminPath = gocb.getAnyFolderPath(this.getAdminOffsetFolder(sessionController).getId());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (myAdminPath == null) {
                    FolderDeleteRelationObjectUtils fdroUtil = new FolderDeleteRelationObjectUtils();
                    FolderDeleteRelationObjectUnDoBean unDoBean = fdroUtil.getFolderDeleteRelationObjectUnDoBean(gocb);
                    try {
                        myAdminPath = unDoBean.getStartFolder().getAnyFolderPath(this.getAdminOffsetFolder(sessionController).getId());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (myAdminPath != null) {
                        if (unDoBean.getMyObjectFolderPath() != null && unDoBean.getMyObjectFolderPath().length() > 0) {
                            myAdminPath = myAdminPath + unDoBean.getMyObjectFolderPath();
                        }
                        myAdminPath = myAdminPath + "/" + gocb.getName();
                    }
                }
            }
            if (myAdminPath != null && myAdminPath.length() > 1) {
                myAdminPath = myAdminPath.substring(1);
                int len = allSyncs.length;
                block12: for (int i = 0; i < len; ++i) {
                    AdminSyncInterface interf = this.getClassFromSyncPoint(allSyncs[i], mdb);
                    if (interf.isFetchClass() || !interf.shouldSync(allSyncs[i], bean)) continue;
                    String[] syncPathControl = null;
                    try {
                        syncPathControl = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/ngosadminsync/control/" + allSyncs[i] + "/SyncPathControl");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    String[] notSyncPathControl = null;
                    try {
                        notSyncPathControl = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/ngosadminsync/control/" + allSyncs[i] + "/NotSyncPathControl");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (syncPathControl == null) continue;
                    int lenS = syncPathControl.length;
                    for (int k = 0; k < lenS; ++k) {
                        if (!myAdminPath.toLowerCase().startsWith(syncPathControl[k].toLowerCase())) continue;
                        boolean doSync = true;
                        if (notSyncPathControl != null) {
                            int lenN = notSyncPathControl.length;
                            for (int n = 0; n < lenN; ++n) {
                                if (notSyncPathControl[n].length() <= 0 || !myAdminPath.toLowerCase().startsWith(notSyncPathControl[n].toLowerCase())) continue;
                                doSync = false;
                                break;
                            }
                        }
                        if (!doSync) continue;
                        syncList.add(allSyncs[i]);
                        continue block12;
                    }
                }
            }
        }
        return syncList;
    }

    private GlobalObjectClientBean getGlobalObject(SessionController sessionController, Object bean, String oldName) throws Exception {
        if (bean instanceof GlobalObjectClientBean) {
            return (GlobalObjectClientBean)bean;
        }
        if (bean instanceof UserManagerBean) {
            String userName = ((UserManagerBean)bean).getUserName();
            if (userName == null) {
                userName = ((UserManagerBean)bean).getMakeUpdateFromUserName();
            }
            if (userName == null) {
                userName = oldName;
            }
            if (userName != null) {
                DirectoryUserObjectClientBean du = sessionController.getUserByName(userName);
                return du;
            }
        }
        return null;
    }

    public boolean isSyncPointActive(String syncPoint, MetaDb metaDb) throws Exception {
        boolean active = false;
        try {
            active = Boolean.parseBoolean(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/ngosadminsync/control/" + syncPoint + "/Active")[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return active;
    }

    public AdminSyncInterface getClassFromSyncPoint(String syncPoint, MetaDb metaDb) throws Exception {
        String className = null;
        className = this.getClassNameFromSyncPoint(syncPoint, metaDb);
        Class<?> syncClass = Class.forName(className);
        AdminSyncInterface interf = (AdminSyncInterface)syncClass.newInstance();
        interf.init(this.adminOffset);
        return interf;
    }

    public String getClassNameFromSyncPoint(String syncPoint, MetaDb metaDb) throws Exception {
        String className = null;
        try {
            className = metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/ngosadminsync/control/" + syncPoint + "/Class")[0];
        }
        catch (Throwable t) {
            ExceptionUtils.handleException(t);
        }
        return className;
    }

    public FolderObjectClientBean getAdminOffsetFolder(SessionController sessionController) throws Exception {
        if (this.adminOffsetFolder == null) {
            this.adminOffsetFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(this.adminOffset);
        }
        return this.adminOffsetFolder;
    }
}

