/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.common;

import agorum.commons.utils.ReloadablePropertyResourceBundle;

public class WsProperties {
    private static ReloadablePropertyResourceBundle property = null;
    private static long lastLoadTime = 0L;
    private static long timerOffset = 20000L;

    public WsProperties() {
        WsProperties.init();
    }

    private static synchronized void init() {
        long currentTime = System.currentTimeMillis();
        if (lastLoadTime < currentTime) {
            lastLoadTime = currentTime + timerOffset;
            property = (ReloadablePropertyResourceBundle)ReloadablePropertyResourceBundle.getResourceBundle((String)"agorum.roi.interfaces.webservices.client.utils.settings.WebService");
        }
    }

    public String getHost() {
        return property.getString("agorum.ngfs.interfaces.webservice.Host");
    }

    public String getPort() {
        return property.getString("agorum.ngfs.interfaces.webservice.Port");
    }

    public String getProtocol() {
        return property.getString("agorum.ngfs.interfaces.webservice.Protocol");
    }

    public String getUploadServlet() {
        return property.getString("agorum.ngfs.interfaces.webservice.servlet.Upload");
    }

    public String getDownloadServlet() {
        return property.getString("agorum.ngfs.interfaces.webservice.servlet.Download");
    }

    public String getWebServiceServlet() {
        return property.getString("agorum.ngfs.interfaces.webservice.servlet.Webservice");
    }

    public String getBaseUrl() {
        return this.getProtocol() + "://" + this.getHost() + ":" + this.getPort();
    }

    public String getUploadUrl() {
        return this.getBaseUrl() + this.getUploadServlet();
    }

    public String getDownloadUrl() {
        return this.getBaseUrl() + this.getDownloadServlet();
    }

    public String getWebServiceUrl() {
        return this.getBaseUrl() + this.getWebServiceServlet();
    }
}

