/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.commons.string.StringUtils;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCreateObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsGetItemsAttributes;
import agorum.roi.interfaces.webservices.client.utils.filing.WsUpdateObject;
import agorum.roi.interfaces.webservices.client.utils.system.WsAbortTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsBeginTransaction;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;

public class TestCreateAndUpdateObject
extends TestBaseClass {
    public TestCreateAndUpdateObject(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(LoginResponseBean loginResponseBean) throws Exception {
        block11: {
            WsAbortTransaction wsAbortTransaction;
            StringUtils su = new StringUtils();
            String transactionId = null;
            WsBeginTransaction wsBeginTransaction = null;
            try {
                wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                int transactionTimeout = 30;
                wsBeginTransaction.setTransactionTimeout(transactionTimeout);
                TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = beginResponse.getTransactionId();
                WsCreateObject ws = new WsCreateObject(loginResponseBean, this.getUrl(), transactionId);
                ws.setClassName("FolderObject");
                ws.setName("MeinTestFolderCreateAndUpdate");
                ObjectLookupBean destinationFolder = new ObjectLookupBean();
                destinationFolder.setFullPath("/");
                ws.setDestinationFolder(destinationFolder);
                ws.setDescription("Meine Description");
                ParseXMLResponseBean responseBean = ws.doWs();
                this.checkResponseError(responseBean);
                String[] folderId = responseBean.getReturnValues();
                Long fId = null;
                if (folderId != null) {
                    fId = new Long(su.strReplace(folderId[0], "\"", ""));
                }
                System.err.println("Folder has been created with Id :" + fId);
                WsGetItemsAttributes wsA = new WsGetItemsAttributes(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean folder = new ObjectLookupBean();
                folder.setObjectId(fId);
                folder.setClassName("FolderObject");
                wsA.addObject(folder);
                wsA.addAttribute("DESCRIPTION");
                ItemsResponseBean responseBeanA = wsA.doWs();
                this.checkResponseError(responseBeanA);
                ItemBean[] items = responseBeanA.getItems();
                if (items != null) {
                    int len = items.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("\n\n");
                        System.err.println("Description : " + su.strReplace(items[i].getAttributes()[0], "\"", ""));
                        System.err.println("\n\n");
                    }
                }
                WsUpdateObject wsU = new WsUpdateObject(loginResponseBean, this.getUrl(), transactionId);
                wsU.addAttribute("DESCRIPTION", "");
                wsU.setObject(folder);
                responseBean = wsU.doWs();
                this.checkResponseError(responseBean);
                wsA = new WsGetItemsAttributes(loginResponseBean, this.getUrl(), transactionId);
                wsA.addObject(folder);
                wsA.addAttribute("DESCRIPTION");
                responseBeanA = wsA.doWs();
                this.checkResponseError(responseBeanA);
                items = responseBeanA.getItems();
                if (items != null) {
                    int len = items.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("\n\n");
                        String description = items[i].getAttributes()[0];
                        description = description == null || description.equals("null") ? "" : su.strReplace(items[i].getAttributes()[0], "\"", "");
                        System.err.println("Description : " + description);
                        System.err.println("\n\n");
                    }
                }
                if (transactionId == null) break block11;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                wsAbortTransaction = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                break block11;
            }
            finally {
                if (transactionId != null) {
                    System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                    WsAbortTransaction wsAbortTransaction2 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                    TransactionResponseBean responseEnd = wsAbortTransaction2.doWs();
                    transactionId = null;
                }
            }
            TransactionResponseBean responseEnd = wsAbortTransaction.doWs();
            transactionId = null;
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: TestCreateAndUpdateObject <UserName> <PassWord>");
        } else {
            try {
                TestCreateAndUpdateObject test = new TestCreateAndUpdateObject(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.test(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("ende test");
        }
    }
}

