/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.commons.string.StringUtils;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCreateFolder;
import agorum.roi.interfaces.webservices.client.utils.filing.WsGetIdFromFullPath;
import agorum.roi.interfaces.webservices.client.utils.filing.WsUploadFile;
import agorum.roi.interfaces.webservices.client.utils.login.WsLogout;
import agorum.roi.interfaces.webservices.client.utils.system.WsAbortTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsBeginTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsEndTransaction;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;
import java.io.File;
import java.io.FileInputStream;

public class TestDiskToNgFS
extends TestBaseClass {
    private String sourcePath = null;
    private String destinationPath = null;

    public TestDiskToNgFS(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        this.setSourcePath(args[2]);
        this.setDestinationPath(args[3]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void importDisk(LoginResponseBean loginResponseBean) throws Exception {
        block11: {
            WsAbortTransaction wsAbortTransaction;
            StringUtils su = new StringUtils();
            String transactionId = null;
            try {
                WsBeginTransaction wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                int transactionTimeout = 30;
                wsBeginTransaction.setTransactionTimeout(transactionTimeout);
                TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = beginResponse.getTransactionId();
                WsGetIdFromFullPath wsgidffpL = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffpL.setFullpath(this.getDestinationPath());
                Long destinationID = wsgidffpL.doWs();
                this.checkResponseError(wsgidffpL.getItemsResponseBean());
                File f = new File(this.getSourcePath());
                if (!f.exists()) {
                    throw new Exception("SourcePath does not exist");
                }
                if (!f.isDirectory()) {
                    throw new Exception("SourcePath is not a Directory");
                }
                int maxObjectPerTransaction = 2;
                int startTransactionCounter = 1;
                transactionId = this.importRecursive(loginResponseBean, transactionId, f, destinationID, maxObjectPerTransaction, startTransactionCounter, transactionTimeout);
                WsLogout wsLogout = new WsLogout(loginResponseBean, this.getUrl());
                wsLogout.doWs();
                if (transactionId != null) {
                    WsEndTransaction wsEndTransaction = new WsEndTransaction(loginResponseBean, this.getUrl(), transactionId);
                    TransactionResponseBean responseEnd = wsEndTransaction.doWs();
                    this.checkResponseError(responseEnd);
                    transactionId = null;
                }
                if (transactionId == null) break block11;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                wsAbortTransaction = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
            }
            catch (Exception e) {
                System.err.println("aborted : message : " + e.getMessage());
                if (transactionId == null) break block11;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                WsAbortTransaction wsAbortTransaction2 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                TransactionResponseBean responseEnd = wsAbortTransaction2.doWs();
                transactionId = null;
            }
            catch (Throwable ta) {
                ta.printStackTrace(System.err);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (transactionId != null) {
                        System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                        WsAbortTransaction wsAbortTransaction3 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                        TransactionResponseBean responseEnd = wsAbortTransaction3.doWs();
                        transactionId = null;
                    }
                }
            }
            TransactionResponseBean responseEnd = wsAbortTransaction.doWs();
            transactionId = null;
        }
    }

    private String importRecursive(LoginResponseBean loginResponseBean, String transactionId, File f, Long destinationId, int maxObjectPerTransaction, int startTransactionCounter, int transactionTimeout) throws Exception {
        File[] myList = f.listFiles();
        if (myList != null) {
            int len = myList.length;
            for (int i = 0; i < len; ++i) {
                if (startTransactionCounter % maxObjectPerTransaction == 0 && transactionId != null) {
                    System.err.println("end Transaction");
                    WsEndTransaction wsEndTransaction = new WsEndTransaction(loginResponseBean, this.getUrl(), transactionId);
                    TransactionResponseBean responseEnd = wsEndTransaction.doWs();
                    this.checkResponseError(responseEnd);
                    WsBeginTransaction wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                    wsBeginTransaction.setTransactionTimeout(transactionTimeout);
                    TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                    this.checkResponseError(beginResponse);
                    transactionId = beginResponse.getTransactionId();
                    startTransactionCounter = 1;
                }
                if (myList[i].isDirectory()) {
                    Long newDestinationId = this.createFolder(loginResponseBean, transactionId, myList[i].getName(), destinationId);
                    transactionId = this.importRecursive(loginResponseBean, transactionId, myList[i], newDestinationId, maxObjectPerTransaction, ++startTransactionCounter, transactionTimeout);
                    continue;
                }
                if (!myList[i].isFile()) continue;
                this.createFile(loginResponseBean, transactionId, myList[i], destinationId);
                ++startTransactionCounter;
            }
        }
        return transactionId;
    }

    private Long createFolder(LoginResponseBean loginResponseBean, String transactionId, String name, Long destinationId) throws Exception {
        WsCreateFolder wscf = new WsCreateFolder(loginResponseBean, this.getUrl(), transactionId);
        wscf.addAttribute("Name", name);
        wscf.addAttribute("Description", "Import with Webservices " + name);
        ObjectLookupBean destinationFolder = new ObjectLookupBean();
        destinationFolder.setObjectId(destinationId);
        destinationFolder.setClassName("FolderObject");
        wscf.setDestinationFolder(destinationFolder);
        ParseXMLResponseBean parseXMLResponseBean = wscf.doWs();
        this.checkResponseError(parseXMLResponseBean);
        String[] folderId = parseXMLResponseBean.getReturnValues();
        Long id = null;
        if (folderId != null) {
            StringUtils su = new StringUtils();
            id = new Long(su.strReplace(folderId[0], "\"", ""));
        }
        return id;
    }

    private void createFile(LoginResponseBean loginResponseBean, String transactionId, File f, Long destinationId) throws Exception {
        WsProperties prop = new WsProperties();
        WsUploadFile wsuf = new WsUploadFile(loginResponseBean, prop.getUploadUrl(), transactionId);
        FileInputStream fis = new FileInputStream(f);
        wsuf.setFileInputStream(fis);
        wsuf.setFileLength((int)f.length());
        wsuf.setFileName(f.getName());
        wsuf.setFolderId(destinationId);
        Long fileId = wsuf.doWs();
        fis.close();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: TestDiskToNgFS <UserName> <PassWord> <SourcePath(Disk-Path)> <DestinationPath(NgFS-Path)>");
        } else {
            try {
                TestDiskToNgFS test = new TestDiskToNgFS(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.importDisk(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("test ended");
        }
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getDestinationPath() {
        return this.destinationPath;
    }

    public void setDestinationPath(String destinationPath) {
        this.destinationPath = destinationPath;
    }
}

