/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.documentservice.client.common.DocumentServiceWSUtils;
import agorum.roi.common.utils.FileCodingUtils;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.filing.AddItemToFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.CopyObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.DownloadFileRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.DownloadFileResponseBean;
import agorum.roi.interfaces.webservices.client.beans.filing.FilingResponseBean;
import agorum.roi.interfaces.webservices.client.beans.filing.MoveObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.RemoveItemFromFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.UploadFileRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.UploadFileResponseBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.common.WebServiceErrorKeys;
import agorum.roi.interfaces.webservices.server.BaseItemService;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletResponse;

public class FilingService
extends BaseItemService {
    private WebServiceSessionBean wsSessionBean = null;

    public FilingService(WebServiceSessionBean wsSessionBean) {
        super(wsSessionBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilingResponseBean moveObject(MoveObjectRequestBean requestBean) {
        FilingResponseBean responseBean = new FilingResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
            FolderObjectClientBean fromFolder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getFromFolder());
            if (fromFolder == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.FROM_FOLDER_NOT_FOUND);
                responseBean.setLogError("given source folder was not found: " + requestBean.getFromFolder());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            FolderObjectClientBean toFolder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getToFolder());
            if (toFolder == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.TO_FOLDER_NOT_FOUND);
                responseBean.setLogError("given destination folder was not found: " + requestBean.getToFolder());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            GlobalObjectClientBean object = this.lookupObject(sessionController, requestBean.getObject());
            if (object == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                responseBean.setLogError("given object was not found: " + requestBean.getObject());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            fromFolder.removeItem(object);
            toFolder.addItem(object);
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ItemsResponseBean copyObject(CopyObjectRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
            FolderObjectClientBean toFolder = null;
            if (requestBean.getToFolder() != null && (toFolder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getToFolder())) == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.TO_FOLDER_NOT_FOUND);
                responseBean.setLogError("given destination folder was not found: " + requestBean.getToFolder());
                ItemsResponseBean itemsResponseBean = responseBean;
                return itemsResponseBean;
            }
            GlobalObjectClientBean object = this.lookupObject(sessionController, requestBean.getObject());
            if (object == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                responseBean.setLogError("given object was not found: " + requestBean.getObject());
                ItemsResponseBean itemsResponseBean = responseBean;
                return itemsResponseBean;
            }
            GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)object.getDefinition(sessionController);
            if (toFolder != null) {
                def.setAddToFolderOption(toFolder);
            }
            GlobalObjectClientBean copyiedObject = (GlobalObjectClientBean)object.copy(def);
            ItemBean itemBean = this.fillItemBean(copyiedObject, requestBean.getRequestAttributes(), null);
            ItemBean[] itemBeans = new ItemBean[]{itemBean};
            responseBean.setResultCount(1);
            responseBean.setItems(itemBeans);
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilingResponseBean addItemToFolder(AddItemToFolderRequestBean requestBean) {
        FilingResponseBean responseBean = new FilingResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
            FolderObjectClientBean toFolder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getToFolder());
            if (toFolder == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.TO_FOLDER_NOT_FOUND);
                responseBean.setLogError("given destination folder was not found: " + requestBean.getToFolder());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            GlobalObjectClientBean object = this.lookupObject(sessionController, requestBean.getObject());
            if (object == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                responseBean.setLogError("given object was not found: " + requestBean.getObject());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            toFolder.addItem(object);
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FilingResponseBean removeItemFromFolder(RemoveItemFromFolderRequestBean requestBean) {
        FilingResponseBean responseBean = new FilingResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
            FolderObjectClientBean fromFolder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getFromFolder());
            if (fromFolder == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.FROM_FOLDER_NOT_FOUND);
                responseBean.setLogError("given source folder was not found: " + requestBean.getFromFolder());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            GlobalObjectClientBean object = this.lookupObject(sessionController, requestBean.getObject());
            if (object == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                responseBean.setLogError("given object was not found: " + requestBean.getObject());
                FilingResponseBean filingResponseBean = responseBean;
                return filingResponseBean;
            }
            fromFolder.removeItem(object);
            rth.end();
            rth = null;
            return responseBean;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            return responseBean;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            return responseBean;
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadFileResponseBean downloadFile(DownloadFileRequestBean requestBean) {
        DownloadFileResponseBean responseBean;
        block20: {
            responseBean = new DownloadFileResponseBean();
            Object rth = null;
            try {
                SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
                InputStream is = null;
                GlobalObjectClientBean gocb = this.lookupObject(sessionController, requestBean.getObject());
                if (!sessionController.isDocument(gocb)) break block20;
                ContentInterface contentInterface = (ContentInterface)((Object)gocb);
                is = contentInterface.getContentStream();
                String filename = gocb.getName();
                String contentType = "";
                FormatObjectClientBean format = contentInterface.getFormat();
                long docSize = contentInterface.getContentSize();
                long modifyTime = gocb.getLastModifyDate().getTime();
                if (format != null) {
                    contentType = format.getMimeType();
                }
                String tmpName = null;
                if (requestBean.getTargetFormat() != null && requestBean.getTargetFormat().length() > 0) {
                    String extension = format.getExtension();
                    contentType = requestBean.getTargetFormat().equalsIgnoreCase("pdf") ? "application/pdf" : (requestBean.getTargetFormat().equalsIgnoreCase("html") ? "application/x-zip-compressed" : "application/octet-stream");
                    if (filename.lastIndexOf(".") != -1) {
                        filename = filename.substring(0, filename.lastIndexOf("."));
                    }
                    filename = filename + "." + requestBean.getTargetFormat();
                    tmpName = "tmpwsconverted_file_" + sessionController.getSessionId() + "_" + gocb.getId() + "_" + System.currentTimeMillis();
                    File fOut = new File(tmpName);
                    DocumentServiceWSUtils dService = new DocumentServiceWSUtils();
                    dService.convertFile(sessionController.getMetaDbInstance(), dService.getDefaultServer(), "convert" + extension.toUpperCase() + "2" + requestBean.getTargetFormat().toUpperCase(), is, docSize, fOut);
                    if (fOut.exists()) {
                        is = new FileInputStream(fOut);
                        docSize = fOut.length();
                    }
                }
                try {
                    HttpServletResponse response = requestBean.getServletResponse();
                    response.setHeader("Content-Length", "" + docSize);
                    response.setContentType(contentType);
                    response.setDateHeader("Last-Modified", modifyTime);
                    response.setHeader("Content-Disposition", "inline; filename=" + URLEncoder.encode(filename));
                    OutputStream out = requestBean.getOutStream();
                    byte[] buffer = new byte[2048];
                    int i = 0;
                    while ((i = is.read(buffer, 0, 2048)) != -1) {
                        out.write(buffer, 0, i);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tmpName != null) {
                        try {
                            File f = new File(tmpName);
                            f.delete();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    is.close();
                }
                catch (Exception response) {
                    // empty catch block
                }
                if (tmpName != null) {
                    try {
                        File f = new File(tmpName);
                        f.delete();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (RoiException re) {
                responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
                responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
            }
            catch (Throwable e) {
                e.printStackTrace(System.err);
                responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
                responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
            }
        }
        return responseBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadFileResponseBean uploadFile(UploadFileRequestBean requestBean) {
        UploadFileResponseBean responseBean = new UploadFileResponseBean();
        RoiTransactionHandler rth = null;
        try {
            rth = new RoiTransactionHandler();
            rth.begin();
            SessionController sessionController = (SessionController)requestBean.getWsSessionBean().getAttribute("SessionController");
            FileCodingUtils fcu = new FileCodingUtils();
            String name = fcu.encodeName(requestBean.getName());
            if (requestBean.getObject() != null) {
                GlobalObjectClientBean globalObject = this.lookupObject(sessionController, requestBean.getObject());
                FileObjectSessionFacade fsf = new FileObjectSessionFacade(sessionController);
                fsf.setWithTransaction(true);
                fsf.setGlobalObject(globalObject);
                fsf.setContentStream(requestBean.getInStream());
                globalObject = fsf.update();
                responseBean.setObjectId("" + globalObject.getId());
            } else {
                FolderObjectClientBean folder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getDestinationFolder());
                FileObjectSessionFacade fsf = new FileObjectSessionFacade(sessionController);
                fsf.setWithTransaction(true);
                fsf.setClassnameFromDestinationFolder(true);
                fsf.setDestinationFolder(folder);
                fsf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, requestBean.getName());
                fsf.setAttribute(GlobalObjectClientBean.DESCRIPTION_ATTRIBUTE, "");
                fsf.setContentStream(requestBean.getInStream());
                GlobalObjectClientBean globalObject = fsf.create();
                responseBean.setObjectId("" + globalObject.getId());
            }
            rth.end();
            rth = null;
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        finally {
            if (rth != null) {
                try {
                    rth.abort();
                    rth = null;
                }
                catch (Exception re) {}
            }
        }
        return responseBean;
    }
}

