/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SortSpecification;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsAttributesRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsFromFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsFromRelationRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetObjectByAttributeRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.common.WebServiceErrorKeys;
import agorum.roi.interfaces.webservices.server.BaseItemService;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.text.SimpleDateFormat;
import java.util.Vector;

public class GetItemsService
extends BaseItemService {
    public GetItemsService(WebServiceSessionBean wsSessionBean) {
        super(wsSessionBean);
    }

    public ItemsResponseBean getItemsFromFolder(GetItemsFromFolderRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            FolderObjectClientBean folder = null;
            folder = (FolderObjectClientBean)this.lookupObject(sessionController, requestBean.getFolder());
            if (folder == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.FOLDER_NOT_FOUND);
                responseBean.setLogError("given folder was not found: " + requestBean.getFolder());
                return responseBean;
            }
            Vector<ItemBean> itemList = null;
            int resultCount = 0;
            if (folder != null) {
                if (!(this.isEmpty(requestBean.getSortAttribute()) || this.isEmpty(requestBean.getSortOrder()) || this.isEmpty(requestBean.getSortClassname()))) {
                    int[] sortOrder = new int[1];
                    if (requestBean.getSortOrder().equalsIgnoreCase("ascending_ignorecase")) {
                        sortOrder[0] = 3;
                    } else if (requestBean.getSortOrder().equalsIgnoreCase("ascending")) {
                        sortOrder[0] = 2;
                    } else if (requestBean.getSortOrder().equalsIgnoreCase("descending_ignorecase")) {
                        sortOrder[0] = 1;
                    } else if (requestBean.getSortOrder().equalsIgnoreCase("descending")) {
                        sortOrder[0] = 0;
                    }
                    SortSpecification sp = new SortSpecification(new String[]{requestBean.getSortClassname()}, new String[]{requestBean.getSortAttribute()}, sortOrder);
                    folder.setSortSpecification(sp);
                }
                GlobalObjectClientBean[] subItems = folder.getItems();
                String startPath = folder.getAnyFolderPath();
                if (subItems != null) {
                    itemList = new Vector<ItemBean>();
                    int len = subItems.length;
                    for (int i = requestBean.getStartItem(); i < requestBean.getStartItem() + requestBean.getItemsPerRequest() && i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(subItems[i], requestBean.getRequestAttributes(), startPath + "/" + subItems[i].getName());
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public ItemsResponseBean getItemsFromRelation(GetItemsFromRelationRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            GlobalObjectClientBean globalObject = null;
            globalObject = this.lookupObject(sessionController, requestBean.getObject());
            if (globalObject == null) {
                responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                responseBean.setLogError("given object was not found: " + requestBean.getObject());
                return responseBean;
            }
            Vector<ItemBean> itemList = null;
            int resultCount = 0;
            if (globalObject != null) {
                GlobalObjectClientBean[] subItems = null;
                subItems = requestBean.getListDirection().equalsIgnoreCase("rightWard") ? globalObject.getRightwardRelationObjects(requestBean.getRelationClass()) : globalObject.getLeftwardRelationObjects(requestBean.getRelationClass());
                if (subItems != null) {
                    itemList = new Vector<ItemBean>();
                    int len = subItems.length;
                    for (int i = requestBean.getStartItem(); i < requestBean.getStartItem() + requestBean.getItemsPerRequest() && i < len; ++i) {
                        ItemBean itemBean = this.fillItemBean(subItems[i], requestBean.getRequestAttributes(), null);
                        itemList.addElement(itemBean);
                        ++resultCount;
                    }
                }
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public ItemsResponseBean getItemsAttributes(GetItemsAttributesRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            Vector<ItemBean> itemList = new Vector<ItemBean>();
            int resultCount = 0;
            try {
                int len = requestBean.getObjects().length;
                for (int i = 0; i < len; ++i) {
                    GlobalObjectClientBean globalObject = this.lookupObject(sessionController, requestBean.getObjects()[i]);
                    if (globalObject == null) {
                        responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                        responseBean.setLogError("given object was not found: " + requestBean.getObjects()[i]);
                        return responseBean;
                    }
                    ItemBean itemBean = this.fillItemBean(globalObject, requestBean.getRequestAttributes(), null);
                    itemList.addElement(itemBean);
                    ++resultCount;
                }
            }
            catch (Exception e) {
                responseBean.setLogError("Object is not accessable (not found or on access)");
                return responseBean;
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }

    public ItemsResponseBean getObjectByAttribute(GetObjectByAttributeRequestBean requestBean) {
        ItemsResponseBean responseBean = new ItemsResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            int attributeValueDataType = requestBean.getAttributeValueDataType();
            String o = requestBean.getAttributeValue();
            Object attributeValue = null;
            if (attributeValueDataType == 4) {
                GlobalObjectClientBean globalObject = null;
                globalObject = this.lookupObject(sessionController, requestBean.getAttributeValueObjectLookupBean());
                attributeValue = globalObject;
                if (globalObject == null) {
                    responseBean.setErrorKey(WebServiceErrorKeys.OBJECT_NOT_FOUND);
                    responseBean.setLogError("given object was not found: " + requestBean.getAttributeValue());
                    return responseBean;
                }
            } else if (attributeValueDataType == 3) {
                attributeValue = Boolean.valueOf(o);
            } else if (attributeValueDataType == 1) {
                attributeValue = new Integer(o);
            } else if (attributeValueDataType == 6) {
                attributeValue = new Double(o);
            } else if (attributeValueDataType == 2) {
                attributeValue = new Long(o);
            } else if (attributeValueDataType == 0) {
                attributeValue = o;
            } else if (attributeValueDataType == 5) {
                SimpleDateFormat sdf = new SimpleDateFormat(requestBean.getAttributeValueFormat());
                attributeValue = sdf.parse(o);
            } else if (o != null) {
                responseBean.setErrorKey(WebServiceErrorKeys.DATATYPE_NOT_SUPPORTED);
                responseBean.setLogError("Datatype (" + attributeValueDataType + ") not supported");
                return responseBean;
            }
            Vector<ItemBean> itemList = null;
            int resultCount = 0;
            SuperObjectClientBean[] subItems = null;
            if (requestBean.getAttributeName().equalsIgnoreCase("ID")) {
                GlobalObjectClientBean gocb = sessionController.getGlobalObjectById((Long)attributeValue);
                if (gocb != null) {
                    subItems = new SuperObjectClientBean[]{gocb};
                }
            } else {
                subItems = sessionController.getSuperObjectByAttribute(sessionController, requestBean.getAttributeName(), attributeValue, requestBean.getIgnoreCase(), requestBean.getOperator() == null ? "=" : requestBean.getOperator(), sessionController.getClassObject(requestBean.getObjectClassName()));
            }
            if (subItems != null) {
                itemList = new Vector<ItemBean>();
                int len = subItems.length;
                for (int i = 0; i < len; ++i) {
                    if (subItems[i] == null || !(subItems[i] instanceof GlobalObjectClientBean)) continue;
                    ItemBean itemBean = this.fillItemBean((GlobalObjectClientBean)subItems[i], requestBean.getRequestAttributes(), null);
                    itemList.addElement(itemBean);
                    ++resultCount;
                }
            }
            ItemBean[] itemBeans = this.getItemBeans(itemList);
            responseBean.setResultCount(resultCount);
            responseBean.setItems(itemBeans);
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }
}

