/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.tree;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.beans.EntryBean;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.cache.tree.Node;
import java.util.List;
import java.util.StringTokenizer;

public class Entry
extends Node {
    private String[] value;

    protected Entry(Context context, GlobalObjectClientBean obj) throws Exception {
        super(context, obj);
        this.value = Entry.getValue(obj);
    }

    @Override
    protected EntryBean getBean() {
        EntryBean bean = new EntryBean();
        bean.setId(this.getId());
        bean.setName(this.getName());
        bean.setValue(this.value);
        return bean;
    }

    @Override
    public EntryBean get(StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Entries cannot have sub-elements");
        }
        return this.getBean();
    }

    @Override
    public List<NodeBean> list(StringTokenizer tokenizer, Node.Type type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(GlobalObjectClientBean obj) throws Exception {
        super.update(obj);
        this.value = Entry.getValue(obj);
    }

    @Override
    public void addChild(GlobalObjectClientBean item) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChild(String name) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static String[] getValue(GlobalObjectClientBean obj) throws Exception {
        if (!(obj instanceof MetaDbPropertyEntryObjectClientBean)) {
            throw new IllegalArgumentException("Entry expected");
        }
        MetaDbPropertyEntryObjectClientBean entry = (MetaDbPropertyEntryObjectClientBean)obj;
        long dataType = entry.getEntryDataType();
        if (dataType == 1L) {
            return new String[]{entry.getStringValue()};
        }
        if (dataType == 64L) {
            return entry.getStringArrayValue();
        }
        if (dataType == 4096L) {
            return new String[]{entry.getContentString()};
        }
        if (dataType == 8192L) {
            return new String[]{entry.getEncryptedValue()};
        }
        return null;
    }
}

