/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util.cache;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.common.MetaDbUtils;
import agorum.roi.metadb.util.cache.Entry;
import agorum.roi.metadb.util.cache.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Bundle
extends Node {
    protected MetaDbPropertyBundleObjectClientBean clientBean;
    private final Map<String, Node> children = new HashMap<String, Node>();

    public Bundle(String path, Bundle parent, SessionController sessionController, MetaDb metaDb, MetaDbUtils metaDbUtils, Map<String, Node> cache, boolean initialize) {
        super(path, parent, sessionController, metaDb, metaDbUtils, cache);
        if (initialize) {
            this.initialize();
        }
    }

    public Bundle createBundle(String path) {
        if (!path.startsWith(this.path)) {
            throw new IllegalArgumentException("Cannot create path " + path + " inside " + this.path);
        }
        if (path.equals(this.path)) {
            return this;
        }
        return this.createBundleInternal(path.substring(this.path.length() + 1));
    }

    private Bundle createBundleInternal(String path) {
        int i = path.lastIndexOf(47);
        if (i >= 0) {
            return this.createBundleInternal(path.substring(0, i)).addBundle(path.substring(i + 1));
        }
        return this.addBundle(path);
    }

    public Entry createEntry(String path) {
        int i = path.lastIndexOf(47);
        if (i >= 0) {
            return this.createBundle(path.substring(0, i)).addEntry(path.substring(i + 1));
        }
        return this.addEntry(path);
    }

    private Bundle addBundle(String name) {
        Bundle bundle = null;
        Node child = this.children.get(name);
        if (child instanceof Bundle) {
            bundle = (Bundle)child;
        }
        if (bundle == null) {
            bundle = new Bundle(this.path + "/" + name, this, this.sessionController, this.metaDb, this.metaDbUtils, this.cache, false);
            this.children.put(name, bundle);
            this.setChanged(true);
        }
        return bundle;
    }

    private Entry addEntry(String name) {
        Entry entry = null;
        Node child = this.children.get(name);
        if (child instanceof Entry) {
            entry = (Entry)child;
        }
        if (entry == null) {
            entry = new Entry(this.path + "/" + name, this, this.sessionController, this.metaDb, this.metaDbUtils, this.cache, false);
            this.children.put(name, entry);
            this.setChanged(true);
        }
        return entry;
    }

    private void initialize() {
        try {
            String[] childEntries;
            String prefix = this.path + "/";
            String[] childBundles = this.metaDb.listSimplePropertyBundle(this.path);
            if (childBundles != null) {
                for (String childBundle : childBundles) {
                    this.children.put(childBundle, new Bundle(prefix + childBundle, this, this.sessionController, this.metaDb, this.metaDbUtils, this.cache, true));
                }
            }
            if ((childEntries = this.metaDb.listSimplePropertyEntry(this.path)) != null) {
                for (String childEntry : childEntries) {
                    this.children.put(childEntry, new Entry(prefix + childEntry, this, this.sessionController, this.metaDb, this.metaDbUtils, this.cache, true));
                }
            }
        }
        catch (Exception e) {
            throw new MetaDbException("Could not initialize MetaDb bundle at " + this.path, (Throwable)e);
        }
    }

    @Override
    protected boolean hasDeletedChildren() {
        for (Node child : this.children.values()) {
            if (!child.isDeleted() && !child.hasDeletedChildren()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void commitImpl() {
        try {
            if (this.parent != null) {
                GlobalObjectClientBean existing = this.parent.clientBean.getItem(this.name);
                if (existing instanceof MetaDbPropertyBundleObjectClientBean) {
                    this.clientBean = (MetaDbPropertyBundleObjectClientBean)existing;
                } else {
                    if (existing != null) {
                        existing.delete();
                    }
                    this.create();
                }
            } else {
                this.create();
            }
        }
        catch (Exception e) {
            throw new MetaDbException("Could not create MetaDb path " + this.path, (Throwable)e);
        }
        for (Node child : this.children.values()) {
            child.commit();
        }
    }

    @Override
    protected void deleteImpl() {
        for (Node child : this.children.values()) {
            child.delete();
        }
    }

    @Override
    public List<String> listImpl(boolean bundles) {
        ArrayList<String> result = new ArrayList<String>();
        for (Node child : this.children.values()) {
            if (child.isDeleted()) continue;
            if (bundles && child instanceof Bundle) {
                result.add(child.name);
                continue;
            }
            if (bundles || !(child instanceof Entry)) continue;
            result.add(child.name);
        }
        return result;
    }

    @Override
    protected String[] getImpl() {
        throw new IllegalArgumentException("Cannot get the value MetaDb bundle " + this.path);
    }

    @Override
    protected boolean setImpl(String[] value) {
        throw new IllegalArgumentException("Cannot set the value MetaDb bundle " + this.path);
    }

    private void create() throws Exception {
        String[] names = this.path.split("\\/");
        Object[] classNames = new String[names.length];
        Arrays.fill(classNames, MetaDbPropertyBundleObjectClientBean.CLASS_NAME);
        this.clientBean = (MetaDbPropertyBundleObjectClientBean)this.metaDbUtils.createMetaDbPath(names, (String[])classNames);
    }
}

