/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util.cache;

import agorum.agceptit.metadb.client.beans.PropertyElementBean;
import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.common.MetaDbUtils;
import agorum.roi.metadb.util.cache.Bundle;
import java.util.List;
import java.util.Map;

public abstract class Node {
    protected final String path;
    protected final String name;
    protected final Bundle parent;
    private boolean changed;
    private boolean deleted;
    protected SessionController sessionController;
    protected MetaDb metaDb;
    protected MetaDbUtils metaDbUtils;
    protected Map<String, Node> cache;

    public Node(String path, Bundle parent, SessionController sessionController, MetaDb metaDb, MetaDbUtils metaDbUtils, Map<String, Node> cache) {
        this.path = path;
        int i = path.lastIndexOf(47);
        this.name = i >= 0 ? path.substring(i + 1) : path;
        this.parent = parent;
        this.sessionController = sessionController;
        this.metaDb = metaDb;
        this.metaDbUtils = metaDbUtils;
        this.cache = cache;
        cache.put(path, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() {
        if (this.deleted) {
            try {
                String id;
                if (this.parent != null) {
                    GlobalObjectClientBean existing = this.parent.clientBean.getItem(this.name);
                    if (existing == null) return;
                    existing.delete();
                    return;
                }
                PropertyElementBean propertyBean = this.metaDb.getProperty(this.path);
                if (propertyBean == null || (id = propertyBean.getId()) == null) return;
                this.sessionController.reconnectIfNeeded();
                this.sessionController.getGlobalObjectById(Long.parseLong(id)).delete();
                return;
            }
            catch (Exception e) {
                throw new MetaDbException("Could not delete MetaDb property at " + this.path, (Throwable)e);
            }
        } else {
            if (!this.changed && !this.hasDeletedChildren()) return;
            this.commitImpl();
        }
    }

    public List<String> list(boolean bundles) {
        return this.listImpl(bundles);
    }

    public void delete() {
        this.deleted = true;
        this.deleteImpl();
    }

    public String[] get() {
        if (this.deleted) {
            return null;
        }
        return this.getImpl();
    }

    public void set(String[] value) {
        if (this.setImpl(value)) {
            this.setChanged(true);
        }
        this.setDeleted(false);
    }

    protected void setChanged(boolean changed) {
        Node current = this;
        while (current != null) {
            current.changed = changed;
            current = current.parent;
        }
    }

    protected void setDeleted(boolean deleted) {
        Node current = this;
        while (current != null) {
            current.deleted = deleted;
            current = current.parent;
        }
    }

    protected boolean hasDeletedChildren() {
        return false;
    }

    public Bundle getParent() {
        return this.parent;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    protected abstract void commitImpl();

    protected abstract void deleteImpl();

    protected abstract List<String> listImpl(boolean var1);

    protected abstract String[] getImpl();

    protected abstract boolean setImpl(String[] var1);
}

