/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.common;

import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManagerAppUserProfileBean;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.parser.common.AttributeObject;
import agorum.roi.parser.common.ClassObject;
import agorum.roi.parser.common.CopyObjectBean;
import agorum.roi.parser.common.MetaDbBean;
import agorum.roi.parser.common.ParseXmlServerBean;
import agorum.roi.parser.common.ParseXmlServiceObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLObject;
import agorum.roi.parser.common.RoiXMLObjectAttribute;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class RoiXMLParser {
    private SessionController sessionController = null;
    private InputStream xmlInputStream = null;
    private String xmlString;
    private boolean closeInputStream;
    private StringUtils su = new StringUtils();

    public RoiXMLParser(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void setDocument(String xmlFileName) throws Exception {
        File f = new File(xmlFileName);
        this.setDocument(f);
    }

    public void setDocument(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        this.setDocument(fis);
        this.closeInputStream = true;
    }

    public void setDocument(InputStream is) throws Exception {
        this.xmlInputStream = is;
    }

    public void setXmlString(String xmlString) {
        this.xmlString = xmlString;
    }

    public ParserObject parse() throws Exception {
        return this.parse(null);
    }

    public ParserObject parse(Hashtable parseAttributes) throws Exception {
        if (parseAttributes != null) {
            StringUtils su = new StringUtils();
            if (this.xmlInputStream != null) {
                String xmlString = StringConverterUtils.toString((InputStream)this.xmlInputStream);
                Enumeration attrEnum = parseAttributes.keys();
                while (attrEnum.hasMoreElements()) {
                    String key = attrEnum.nextElement().toString();
                    String value = parseAttributes.get(key).toString();
                    xmlString = su.strReplace(xmlString, "$$" + key + "$$", value);
                }
                this.xmlInputStream = StringConverterUtils.toStream((String)xmlString);
            } else if (this.xmlString != null) {
                Enumeration attrEnum = parseAttributes.keys();
                while (attrEnum.hasMoreElements()) {
                    String key = attrEnum.nextElement().toString();
                    String value = parseAttributes.get(key).toString();
                    this.xmlString = su.strReplace(this.xmlString, "$$" + key + "$$", value);
                }
            }
        }
        DOMParser parser = new DOMParser();
        if (this.xmlInputStream != null) {
            parser.parse(new InputSource(this.xmlInputStream));
        } else if (this.xmlString != null) {
            parser.parse(new InputSource(new StringReader(this.xmlString)));
        }
        ParserObject po = null;
        Document document = parser.getDocument();
        NodeList nodelist = document.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nodelist.item(i);
            po = new ParserObject();
            if (!node.getNodeName().equalsIgnoreCase("ObjectList")) continue;
            this.parseObjectList(node, po);
        }
        if (this.closeInputStream && this.xmlInputStream != null) {
            this.xmlInputStream.close();
            this.xmlInputStream = null;
        }
        return po;
    }

    private void parseObjectList(Node node, ParserObject po) throws Exception {
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (node.getNodeName().equalsIgnoreCase("ClassObject")) {
                this.parseClassObject(node, po);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("NewUser")) {
                this.parseNewUser(node, po);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("ParseXmlService")) {
                this.parseXmlService(node, po);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("CopyObject")) {
                this.parseCopyObject(node, po);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("MetaDb")) {
                this.parseMetaDb(node, po);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            RoiXMLObject rxo = new RoiXMLObject();
            rxo.setName(node.getNodeName());
            rxo.setAttribute(this.getNodeAttribute(node));
            po.setNewParserObject(rxo);
            this.parseRoiXMLObject(node, rxo.getRoiXMLObjectAttribute(), "");
        }
    }

    private void parseRoiXMLObject(Node node, Vector roiXMLObjectAttribute, String off) throws Exception {
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (node.getNodeType() != 1) continue;
            RoiXMLObjectAttribute rxoa = new RoiXMLObjectAttribute();
            rxoa.setName(node.getNodeName());
            rxoa.setAttribute(this.getNodeAttribute(node));
            rxoa.setValue(this.getValueFromNode(node));
            roiXMLObjectAttribute.addElement(rxoa);
            this.parseRoiXMLObject(node, rxoa.getRoiXMLObjectAttribute(), off + "   ");
        }
    }

    private String getValueFromNode(Node node) throws Exception {
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        if (len <= 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            result.append(this.trim(nodelist.item(i).getNodeValue()));
        }
        return result.toString();
    }

    private void parseClassObject(Node node, ParserObject po) throws Exception {
        ClassObject co = new ClassObject();
        po.setNewParserObject(co);
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        String value = null;
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (node.getNodeName().equalsIgnoreCase("ClassObjectID")) {
                value = this.getNodeValue(node);
                co.setClassObjectID(value == null ? null : new Long(value));
                co.setClassObjectIDAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("AttributeOffsetID")) {
                value = this.getNodeValue(node);
                co.setAttributeOffsetID(value == null ? null : new Long(value));
                co.setAttributeOffsetIDAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("PackageOffset")) {
                value = this.getNodeValue(node);
                co.setPackageOffset(value);
                co.setPackageOffsetAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Name")) {
                value = this.getNodeValue(node);
                co.setName(value);
                co.setNameAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("SuperClass")) {
                value = this.getNodeValue(node);
                co.setSuperClass(value);
                co.setSuperClassAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Description")) {
                value = this.getNodeValue(node);
                co.setDescription(value);
                co.setDescriptionAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("JndiNameHome")) {
                value = this.getNodeValue(node);
                co.setJndiNameHome(value);
                co.setJndiNameHomeAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("JndiNameEJB")) {
                value = this.getNodeValue(node);
                co.setJndiNameEJB(value);
                co.setJndiNameEJBAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("EJBHomeClass")) {
                value = this.getNodeValue(node);
                co.setEJBHomeClass(value);
                co.setEJBHomeClassAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("ClientBeanClass")) {
                value = this.getNodeValue(node);
                co.setClientBeanClass(value);
                co.setClientBeanClassAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("JndiNameEntityHome")) {
                value = this.getNodeValue(node);
                co.setJndiNameEntityHome(value);
                co.setJndiNameEntityHomeAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("SelectorClassPath")) {
                value = this.getNodeValue(node);
                co.setSelectorClassPath(value);
                co.setSelectorClassPathAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("CallBackClassPath")) {
                value = this.getNodeValue(node);
                co.setCallBackClassPath(value);
                co.setCallBackClassPathAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("DataBaseObjectName")) {
                value = this.getNodeValue(node);
                co.setDataBaseObjectName(value);
                co.setDataBaseObjectNameAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("ClassAcl")) {
                value = this.getNodeValue(node);
                co.setClassAcl(value);
                co.setClassAclAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Abstract")) {
                value = this.getNodeValue(node);
                co.setAbstract(Boolean.parseBoolean(value));
                co.setAbstractAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Final")) {
                value = this.getNodeValue(node);
                co.setFinal(Boolean.parseBoolean(value));
                co.setFinalAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Partitioned")) {
                value = this.getNodeValue(node);
                co.setPartitioned(Boolean.parseBoolean(value));
                co.setPartitionedAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("UniqueName")) {
                value = this.getNodeValue(node).toUpperCase();
                co.setUniqueName(value);
                co.setUniqueNameAttribute(this.getNodeAttribute(node));
            } else if (node.getNodeName().equalsIgnoreCase("Update")) {
                value = this.getNodeValue(node).toUpperCase();
                co.setUpdate(true);
                co.setUpdateClassName(value);
            } else if (node.getNodeName().equalsIgnoreCase("Attributes")) {
                value = this.getNodeValue(node);
                Vector v = new Vector();
                co.setAttributes(v);
                this.parseAttributes(node, v);
            }
            value = null;
        }
    }

    private void parseCopyObject(Node node, ParserObject po) throws Exception {
        CopyObjectBean cob = new CopyObjectBean();
        po.setNewParserObject(cob);
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        String value = null;
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (node.getNodeName().equalsIgnoreCase("SourceObject")) {
                value = this.getNodeValue(node);
                cob.setSourceObject(value);
            } else if (node.getNodeName().equalsIgnoreCase("DestinationObject")) {
                value = this.getNodeValue(node);
                cob.setDestinationObject(value);
            } else if (node.getNodeName().equalsIgnoreCase("Owner")) {
                value = this.getNodeValue(node);
                cob.setOwner(value);
            } else if (node.getNodeName().equalsIgnoreCase("Acl")) {
                value = this.getNodeValue(node);
                cob.setAcl(value);
            } else if (node.getNodeName().equalsIgnoreCase("Creator")) {
                value = this.getNodeValue(node);
                cob.setCreator(value);
            }
            value = null;
        }
    }

    private void parseMetaDb(Node node, ParserObject po) throws Exception {
        MetaDbBean mdbb = new MetaDbBean();
        po.setNewParserObject(mdbb);
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (!node.getNodeName().equalsIgnoreCase("WarmupMetaDb")) continue;
            mdbb.setWarmupMetaDb(true);
        }
    }

    private void parseXmlService(Node node, ParserObject po) throws Exception {
        ParseXmlServiceObject pxso = new ParseXmlServiceObject();
        po.setNewParserObject(pxso);
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        String value = null;
        for (int i = 0; i < len; ++i) {
            Node nodeAdd;
            int iAdd;
            int lenAdd;
            NodeList nodelistAdd;
            node = nodelist.item(i);
            if (node.getNodeName().equalsIgnoreCase("Jobs")) {
                nodelistAdd = node.getChildNodes();
                lenAdd = nodelistAdd.getLength();
                for (iAdd = 0; iAdd < lenAdd; ++iAdd) {
                    nodeAdd = nodelistAdd.item(iAdd);
                    if (nodeAdd.getNodeName().equalsIgnoreCase("job")) {
                        value = this.getNodeValue(nodeAdd);
                        pxso.addJobs(value);
                    }
                    value = null;
                }
            } else if (node.getNodeName().equalsIgnoreCase("Servers")) {
                nodelistAdd = node.getChildNodes();
                lenAdd = nodelistAdd.getLength();
                for (iAdd = 0; iAdd < lenAdd; ++iAdd) {
                    nodeAdd = nodelistAdd.item(iAdd);
                    if (!nodeAdd.getNodeName().equalsIgnoreCase("Server")) continue;
                    NodeList nodelistApp = nodeAdd.getChildNodes();
                    int lenApp = nodelistApp.getLength();
                    ParseXmlServerBean pxsb = new ParseXmlServerBean();
                    pxso.addServers(pxsb);
                    for (int iApp = 0; iApp < lenApp; ++iApp) {
                        Node nodeApp = nodelistApp.item(iApp);
                        if (nodeApp.getNodeName().equalsIgnoreCase("url")) {
                            value = this.getNodeValue(nodeApp);
                            pxsb.setUrl(value);
                        } else if (nodeApp.getNodeName().equalsIgnoreCase("LoginUser")) {
                            value = this.getNodeValue(nodeApp);
                            pxsb.setUsername(value);
                        } else if (nodeApp.getNodeName().equalsIgnoreCase("LoginPassword")) {
                            value = this.getNodeValue(nodeApp);
                            pxsb.setPassword(value);
                        } else if (nodeApp.getNodeName().equalsIgnoreCase("TransactionTimeout")) {
                            value = this.getNodeValue(nodeApp);
                            pxsb.setTransactionTimeout(new Long(value));
                        }
                        value = null;
                    }
                }
            }
            value = null;
        }
    }

    private void parseNewUser(Node node, ParserObject po) throws Exception {
        UserManagerBean umb = new UserManagerBean();
        umb.setAdminEnabled(Boolean.FALSE);
        umb.setCredentialManager("roi");
        po.setNewParserObject(umb);
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        String value = null;
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (node.getNodeName().equalsIgnoreCase("UserName")) {
                value = this.getNodeValue(node);
                umb.setUserName(value);
            } else if (node.getNodeName().equalsIgnoreCase("CredentialManager")) {
                value = this.getNodeValue(node);
                umb.setCredentialManager(value);
            } else if (node.getNodeName().equalsIgnoreCase("Password")) {
                value = this.getNodeValue(node);
                umb.setPassWord(value);
            } else if (node.getNodeName().equalsIgnoreCase("UpdateUserName")) {
                value = this.getNodeValue(node);
                umb.setMakeUpdateFromUserName(value);
            } else if (node.getNodeName().equalsIgnoreCase("DirectoryUserDescription")) {
                value = this.getNodeValue(node);
                umb.setDescription(value);
            } else if (node.getNodeName().equalsIgnoreCase("AdminEnabled")) {
                value = this.getNodeValue(node);
                umb.setAdminEnabled(Boolean.valueOf(value));
            } else if (node.getNodeName().equalsIgnoreCase("QuotaAllocatedStorage")) {
                value = this.getNodeValue(node);
                umb.setQuotaAllocatedStorage(new Long(value));
            } else if (node.getNodeName().equalsIgnoreCase("Uuid")) {
                value = this.getNodeValue(node);
                umb.setUserUuid(value);
            } else if (node.getNodeName().equalsIgnoreCase("GivenName")) {
                value = this.getNodeValue(node);
                umb.setGivenName(value);
            } else if (node.getNodeName().equalsIgnoreCase("FamilyName")) {
                value = this.getNodeValue(node);
                umb.setFamilyName(value);
            } else if (node.getNodeName().equalsIgnoreCase("Language")) {
                value = this.getNodeValue(node);
                umb.setLanguage(value);
            } else if (node.getNodeName().equalsIgnoreCase("DestinationFolder")) {
                value = this.getNodeValue(node);
                umb.setDestinationFolder(value);
            } else if (node.getNodeName().equalsIgnoreCase("MandatorIdentifier")) {
                value = this.getNodeValue(node);
                umb.setMandatorIdentifier(value);
            } else if (node.getNodeName().equalsIgnoreCase("DefaultRoleName")) {
                value = this.getNodeValue(node);
                umb.setDefaultRoleName(value);
            } else if (node.getNodeName().equalsIgnoreCase("AssociatedRolesName")) {
                value = this.getNodeValue(node);
                umb.setAssoiciatedRolesName(value);
            } else if (node.getNodeName().equalsIgnoreCase("IsRole")) {
                value = this.getNodeValue(node);
                umb.setIsRole(value);
            } else if (node.getNodeName().equalsIgnoreCase("AddAppUserProfiles")) {
                NodeList nodelistAdd = node.getChildNodes();
                int lenAdd = nodelistAdd.getLength();
                for (int iAdd = 0; iAdd < lenAdd; ++iAdd) {
                    Node nodeAdd = nodelistAdd.item(iAdd);
                    if (!nodeAdd.getNodeName().equalsIgnoreCase("AppUserProfile")) continue;
                    NodeList nodelistApp = nodeAdd.getChildNodes();
                    int lenApp = nodelistApp.getLength();
                    UserManagerAppUserProfileBean appBean = new UserManagerAppUserProfileBean();
                    for (int iApp = 0; iApp < lenApp; ++iApp) {
                        Node nodeApp = nodelistApp.item(iApp);
                        if (nodeApp.getNodeName().equalsIgnoreCase("Application")) {
                            value = this.getNodeValue(nodeApp);
                            appBean.setApplication(value);
                            continue;
                        }
                        if (nodeApp.getNodeName().equalsIgnoreCase("Keyword")) {
                            Hashtable attHash = this.getNodeAttribute(nodeApp);
                            value = this.getNodeValue(nodeApp);
                            appBean.setKeyword(value);
                            appBean.setKeywordAttribute(attHash);
                            continue;
                        }
                        if (!nodeApp.getNodeName().equalsIgnoreCase("Value")) continue;
                        value = this.getNodeValue(nodeApp);
                        appBean.setValue(value);
                    }
                    umb.addToAppUserProfile(appBean);
                }
            } else if (node.getNodeName().equalsIgnoreCase("EmailAddresses")) {
                value = this.getNodeValue(node);
                if (value != null) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    Vector<String> v = new Vector<String>();
                    RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
                    String defaultEmailDomain = rpmd.getEmailDomain();
                    while (st.hasMoreElements()) {
                        String emailAddress = st.nextToken();
                        if (emailAddress == null || emailAddress.length() <= 0) continue;
                        if ((emailAddress = this.su.strTrim(emailAddress)).indexOf("@") < 0) {
                            emailAddress = emailAddress + "@" + defaultEmailDomain;
                        }
                        v.addElement(emailAddress);
                    }
                    int lenA = v.size();
                    if (lenA > 0) {
                        String[] sArr = new String[lenA];
                        for (int k = 0; k < lenA; ++k) {
                            sArr[k] = (String)v.elementAt(k);
                        }
                        umb.setEmailAddresses(sArr);
                    }
                }
            } else if (node.getNodeName().equalsIgnoreCase("Aliases")) {
                value = this.getNodeValue(node);
                String[] aliases = null;
                if (value != null) {
                    StringTokenizer st = new StringTokenizer(value, ",");
                    Vector<String> v = new Vector<String>();
                    while (st.hasMoreElements()) {
                        String alias = st.nextToken();
                        if ((alias = this.su.strTrim(alias)) == null || alias.length() <= 0) continue;
                        v.addElement(alias);
                    }
                    int lenA = v.size();
                    if (lenA > 0) {
                        aliases = new String[lenA];
                        for (int k = 0; k < lenA; ++k) {
                            aliases[k] = (String)v.elementAt(k);
                        }
                    }
                }
                umb.setAliases(aliases);
            } else if (node.getNodeName().equalsIgnoreCase("Lockstate")) {
                value = this.getNodeValue(node);
                umb.setLockstate(value);
            } else if (node.getNodeName().equalsIgnoreCase("NoErrorIfExist")) {
                umb.setNoErrorIfExist(true);
            }
            value = null;
        }
    }

    private String getNodeValue(Node node) throws Exception {
        Node childnode = node.getFirstChild();
        String sRet = null;
        if (childnode != null) {
            sRet = this.trim(childnode.getNodeValue());
        }
        return sRet;
    }

    private String trim(String s) {
        String sRet = s;
        if (sRet != null) {
            sRet = this.su.strTrimRight(this.su.strTrimLeft(sRet, " "), " ");
        }
        return sRet;
    }

    private Hashtable getNodeAttribute(Node node) throws Exception {
        Attr[] attrs = this.sortAttributes(node.getAttributes());
        int len = attrs == null ? 0 : attrs.length;
        Hashtable<String, String> h = null;
        if (len > 0) {
            h = new Hashtable<String, String>();
            for (int k = 0; k < len; ++k) {
                Attr attr = attrs[k];
                h.put(attr.getNodeName().toUpperCase(), this.trim(attr.getNodeValue()));
            }
        }
        return h;
    }

    private void parseAttributes(Node node, Vector v) throws Exception {
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        for (int i = 0; i < len; ++i) {
            node = nodelist.item(i);
            if (!node.getNodeName().equalsIgnoreCase("Attribute")) continue;
            this.parseAttribute(node, v);
        }
    }

    private void parseAttribute(Node node, Vector v) throws Exception {
        NodeList nodelist = node.getChildNodes();
        int len = nodelist.getLength();
        if (len > 0) {
            AttributeObject ao = new AttributeObject();
            v.addElement(ao);
            String value = null;
            for (int i = 0; i < len; ++i) {
                node = nodelist.item(i);
                value = this.getNodeValue(node);
                if (node.getNodeName().equalsIgnoreCase("Name")) {
                    ao.setName(value);
                } else if (node.getNodeName().equalsIgnoreCase("Active")) {
                    ao.setActive(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("Description")) {
                    ao.setDescription(value);
                } else if (node.getNodeName().equalsIgnoreCase("DataType")) {
                    ao.setDataType(value);
                } else if (node.getNodeName().equalsIgnoreCase("DataLength")) {
                    ao.setDataLength(new Integer(value));
                } else if (node.getNodeName().equalsIgnoreCase("DataScale")) {
                    ao.setDataScale(new Integer(value));
                } else if (node.getNodeName().equalsIgnoreCase("isUnique")) {
                    ao.setIsUnique(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("UniqueDataBaseObjects")) {
                    ao.setUniqueDataBaseObjects(value);
                } else if (node.getNodeName().equalsIgnoreCase("IndexedDataBaseObjects")) {
                    ao.setIndexedDataBaseObjects(value);
                } else if (node.getNodeName().equalsIgnoreCase("Required")) {
                    ao.setRequired(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("Indexed")) {
                    ao.setIndexed(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("Setable")) {
                    ao.setSetable(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("Updateable")) {
                    ao.setUpdateable(Boolean.parseBoolean(value));
                } else if (node.getNodeName().equalsIgnoreCase("DataBaseObjectName")) {
                    ao.setDataBaseObjectName(value);
                }
                value = null;
            }
        }
    }

    private Attr[] getAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (int i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        return array;
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    private String getNodeType(Node node) throws Exception {
        short nodeType = node.getNodeType();
        String myType = " " + nodeType + " ";
        myType = nodeType == 2 ? myType + "(ATTRIBUTE_NODE)" : (nodeType == 4 ? myType + "(CDATA_SECTION_NODE)" : (nodeType == 8 ? myType + "(COMMENT_NODE)" : (nodeType == 11 ? myType + "(DOCUMENT_FRAGMENT_NODE)" : (nodeType == 9 ? myType + "(DOCUMENT_NODE)" : (nodeType == 10 ? myType + "(DOCUMENT_TYPE_NODE)" : (nodeType == 1 ? myType + "(ELEMENT_NODE)" : (nodeType == 6 ? myType + "(ENTITY_NODE)" : (nodeType == 5 ? myType + "(ENTITY_REFERENCE_NODE)" : (nodeType == 12 ? myType + "(NOTATION_NODE)" : (nodeType == 7 ? myType + "(PROCESSING_INSTRUCTION_NODE)" : (nodeType == 3 ? myType + "(TEXT_NODE)" : myType + "(unknown)")))))))))));
        return myType;
    }
}

