/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.mail;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.autoupdate.common.DatabaseTools;
import agorum.commons.cache.GenericCache;
import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.string.StringUtils;
import agorum.commons.system.SystemProperties;
import agorum.roi.common.utils.MailUtils;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.AttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FormatObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailAttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailBodyRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailDocumentObjectClientBean;
import agorum.roi.ejb.client.beans.MailMsgRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.MailObjectClientBean;
import agorum.roi.ejb.client.beans.MailObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.RoiPropertiesMetaDb;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.exception.RoiException;
import agorum.roi.parser.common.MailObjectHolder;
import agorum.roi.parser.ical.ICalParser;
import agorum.roi.parser.mail.RFC2231Parser;
import agorum.roi.sessionfacade.beans.MailDocumentObjectSessionFacade;
import agorum.roi.sessionfacade.beans.MailObjectSessionFacade;
import agorum.roi.statistic.MailServiceStatistic;
import com.mirrorworlds.lifestreams.mail.tnef.JTnef;
import com.mirrorworlds.lifestreams.mail.tnef.TnefAttachment;
import com.mirrorworlds.lifestreams.mail.tnef.TnefMessage;
import com.sun.mail.util.BASE64DecoderStream;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.bouncycastle.mail.smime.SMIMESignedParser;

public class EmlParser {
    private InputStream sourceObject = null;
    private InputStream sourceObject2 = null;
    private boolean isOutlookMail;
    private String mailStatus = "inbox";
    private SessionController sessionController = null;
    private StringUtils stringUtils = new StringUtils();
    private boolean addToFolder = true;
    private FolderObjectClientBean destinationFolderObj = null;
    private FolderObjectClientBean destinationFolderOrg = null;
    private Date createDate;
    private String uid;
    private ContentInterface originalMSG = null;
    private DirectoryUserObjectClientBean explicitUser = null;
    private File inputFile = null;
    public static long uniqueId;
    private List<File> deleteFileList = new ArrayList<File>();
    public static String REGULAREXPRESSION_KEY;
    private MailObjectHolder globalMailHolder = null;
    private boolean keepFileName;
    private Map<String, String> cidHash = new HashMap<String, String>();
    private MailObjectClientBean myParentMail = null;
    private Vector mailAddresses = null;
    private static final MailServiceStatistic stat;
    private static final boolean mb3;
    private static final String MIME_ENCODED_WORD_BINARY = "=\\?[a-z0-9\\-]+\\?B\\?.*\\?=";
    private static final String MIME_ENCODED_WORD_QUOTED = "=\\?[a-z0-9\\-]+\\?Q\\?.*\\?=";
    private static final Pattern MIME_ENCODED_TEXT_BINARY;
    private static final Pattern MIME_ENCODED_TEXT_QUOTED;
    private static final Pattern MIME_ENCODED_TEXT_QUOTED_BREAK;
    private static final Pattern addressPattern;
    private static final String ENCODED_PART_REGEX_PATTERN = "=\\?([^?]+)\\?([^?]+)\\?([^?]+)\\?=";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean isMb3() {
        try (Connection conn = new ConnectionUtils().getConnection();){
            if (!"mysql".equals(new DatabaseTools(conn).getDatabaseName())) return false;
            try (PreparedStatement ps = conn.prepareStatement("SELECT character_set_name FROM information_schema.`COLUMNS` WHERE table_schema='roi' AND (table_name='mailobject' AND column_name='subject') OR (table_name='globalobject' AND column_name='name')");
                 ResultSet rs = ps.executeQuery();){
                do {
                    if (!rs.next()) return false;
                } while ("utf8mb4".equalsIgnoreCase(rs.getString(1)));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Could not determine database UTF-8 format");
        }
        return false;
    }

    public EmlParser(SessionController sessionController) {
        try {
            this.sessionController = sessionController;
            this.explicitUser = sessionController.getLoginUser();
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Error in constructor");
        }
    }

    public void setDestinationFolder(String destinationFolder) throws Exception {
        this.destinationFolderObj = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(destinationFolder);
    }

    public MailObjectClientBean getMyParentMail() {
        return this.myParentMail;
    }

    public void setMyParentMail(MailObjectClientBean myParentMail) {
        this.myParentMail = myParentMail;
    }

    public void setDestinationFolder(FolderObjectClientBean destinationFolder) {
        this.destinationFolderObj = destinationFolder;
    }

    public void setUID(String uid) {
        this.uid = uid;
    }

    public void setAddresses(Vector vMailAddresses) {
        this.mailAddresses = vMailAddresses;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public void setMailStatus(String mailStatus) {
        this.mailStatus = mailStatus;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputStream(InputStream inputStream) throws Exception {
        String fName = "tmpMail_" + EmlParser.getUniqueId() + ".eml";
        this.inputFile = new File(fName);
        this.deleteFileList.add(this.inputFile);
        byte[] b = new byte[10240];
        try (FileOutputStream fos = new FileOutputStream(this.inputFile);){
            int len;
            while ((len = inputStream.read(b)) > 0) {
                fos.write(b, 0, len);
            }
        }
        inputStream.close();
    }

    public void cleanUp() {
        for (File file : this.deleteFileList) {
            try {
                if (!file.exists()) continue;
                file.delete();
            }
            catch (Exception exception) {}
        }
        this.deleteFileList.clear();
    }

    public void finalize() {
        this.cleanUp();
    }

    public void setOriginalMSG(ContentInterface originalMSG) {
        this.originalMSG = originalMSG;
    }

    public void setExplicitUser(DirectoryUserObjectClientBean explicitUser) {
        this.explicitUser = explicitUser;
    }

    public MailObjectClientBean doParse() throws Exception {
        return this.doParse(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailObjectClientBean doParse(boolean storeContent) throws Exception {
        MailObjectClientBean mail = null;
        try (Transaction t = new Transaction();){
            Transaction.put(MailObjectClientBean.COPY_CONTEXT);
            try {
                this.sourceObject = new FileInputStream(this.inputFile);
                this.sourceObject2 = new FileInputStream(this.inputFile);
                try {
                    mail = this.doParseInternal(storeContent);
                }
                finally {
                    this.sourceObject.close();
                    this.sourceObject2.close();
                }
            }
            finally {
                Transaction.remove(MailObjectClientBean.COPY_CONTEXT);
            }
            t.commit();
        }
        catch (Throwable e) {
            stat.error().exception(e).send("Error parsing the mail");
        }
        return mail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compress(GlobalObjectClientBean object) throws Exception {
        if (!(object instanceof ContentInterface) || object.getLeftwardRelationCount(RelationObjectClientBean.CLASS_NAME) > 1) {
            object.setSystemFlag(GlobalObjectClientBean.SYSTEMFLAG_INCOMPRESSIBLE, GlobalObjectClientBean.SYSTEMFLAGSMODE_ADD);
            return;
        }
        SessionController scStealth = EmlParser.getStealthSession();
        object = scStealth.getGlobalObjectById(object.getId());
        ContentInterface ci = (ContentInterface)((Object)object);
        try (Transaction t = new Transaction();){
            try {
                Transaction.put(MailObjectClientBean.COPY_CONTEXT);
                ci.truncate(0L, false, false);
            }
            finally {
                Transaction.remove(MailObjectClientBean.COPY_CONTEXT);
            }
            object.setSystemFlag(GlobalObjectClientBean.SYSTEMFLAG_COMPRESSED, GlobalObjectClientBean.SYSTEMFLAGSMODE_ADD);
            t.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reParse(MailObjectClientBean mail) throws Exception {
        try (Transaction t = new Transaction();){
            Transaction.put(MailObjectClientBean.COPY_CONTEXT);
            try {
                SessionController scStealth = EmlParser.getStealthSession();
                mail = (MailObjectClientBean)scStealth.getGlobalObjectById(mail.getId());
                MailObjectClientBean tmpMail = EmlParser.reParse(scStealth, mail);
                HashMap<GlobalObjectClientBean, GlobalObjectClientBean> objectMap = new HashMap<GlobalObjectClientBean, GlobalObjectClientBean>();
                if (EmlParser.prepareSync(tmpMail, mail, objectMap)) {
                    EmlParser.sync(objectMap);
                } else {
                    MailObjectClientBean tmpMail2 = EmlParser.reParse(EmlParser.getSilentSession(), mail);
                    EmlParser.rebuild(tmpMail2, mail);
                    tmpMail2.delete();
                }
                tmpMail.delete();
            }
            finally {
                Transaction.remove(MailObjectClientBean.COPY_CONTEXT);
            }
            t.commit();
        }
    }

    private static SessionController getStealthSession() {
        SessionController sc = SessionControllerAdmin.getService("EmlParserStealth");
        sc.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
        sc.setMakeContentTask(false);
        return sc;
    }

    private static SessionController getSilentSession() {
        SessionController sc = SessionControllerAdmin.getService("EmlParserSilent");
        sc.setMakeContentTask(false);
        return sc;
    }

    /*
     * Exception decompiling
     */
    private static MailObjectClientBean reParse(SessionController sc, MailObjectClientBean mail) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static GlobalObjectClientBean[] sorted(GlobalObjectClientBean[] array) {
        if (array == null) {
            return new GlobalObjectClientBean[0];
        }
        Arrays.sort(array, (l, r) -> l.getId().compareTo(r.getId()));
        return array;
    }

    private static boolean prepareSync(MailObjectClientBean src, MailObjectClientBean trg, Map<GlobalObjectClientBean, GlobalObjectClientBean> objectMap) throws Exception {
        return EmlParser.prepareSync(EmlParser.sorted(src.getMailAttachments()), EmlParser.sorted(trg.getMailAttachments()), objectMap) && EmlParser.prepareSync(EmlParser.sorted(src.getMailBodies()), EmlParser.sorted(trg.getMailBodies()), objectMap);
    }

    private static boolean prepareSync(GlobalObjectClientBean[] srcs, GlobalObjectClientBean[] trgs, Map<GlobalObjectClientBean, GlobalObjectClientBean> objectMap) throws Exception {
        if (srcs.length != trgs.length) {
            return false;
        }
        int len = srcs.length;
        if (len != trgs.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            GlobalObjectClientBean src = srcs[i];
            GlobalObjectClientBean trg = trgs[i];
            objectMap.put(src, trg);
            if (!src.getClass().equals(trg.getClass())) {
                return false;
            }
            if (!(src instanceof MailObjectClientBean) || EmlParser.prepareSync((MailObjectClientBean)src, (MailObjectClientBean)trg, objectMap)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sync(Map<GlobalObjectClientBean, GlobalObjectClientBean> objectMap) throws Exception {
        try {
            Transaction.put(MailObjectClientBean.COPY_CONTEXT);
            Transaction.put("SILENT_CONTENT_UPDATE");
            for (Map.Entry<GlobalObjectClientBean, GlobalObjectClientBean> entry : objectMap.entrySet()) {
                GlobalObjectClientBean src = entry.getKey();
                GlobalObjectClientBean trg = entry.getValue();
                ContentInterface ciSrc = (ContentInterface)((Object)src);
                ContentInterface ciTrg = (ContentInterface)((Object)trg);
                trg.setSystemFlag(GlobalObjectClientBean.SYSTEMFLAG_COMPRESSED, GlobalObjectClientBean.SYSTEMFLAGSMODE_REMOVE);
                if (src.isMailBody()) {
                    String body = ciSrc.getContentString();
                    for (Map.Entry<GlobalObjectClientBean, GlobalObjectClientBean> entry2 : objectMap.entrySet()) {
                        String idSrc = URLEncoder.encode("uuid://" + entry2.getKey().getUUID(), "UTF-8");
                        String idTrg = URLEncoder.encode("uuid://" + entry2.getValue().getUUID(), "UTF-8");
                        body = body.replace(idSrc, idTrg);
                    }
                    ciTrg.setContentString(body);
                    continue;
                }
                ciSrc.streamContent(ciTrg);
            }
        }
        finally {
            Transaction.remove("SILENT_CONTENT_UPDATE");
            Transaction.remove(MailObjectClientBean.COPY_CONTEXT);
        }
    }

    private static void rebuild(MailObjectClientBean src, MailObjectClientBean trg) throws Exception {
        EmlParser.detach(trg, trg.getMailBodies());
        EmlParser.detach(trg, trg.getMailAttachments());
        EmlParser.attach(trg, src.getMailBodies(), new MailBodyRelationObjectClientBeanDefinition(trg.getSessionController()));
        EmlParser.attach(trg, src.getMailAttachments(), new MailAttachmentsRelationObjectClientBeanDefinition(trg.getSessionController()));
    }

    private static void detach(GlobalObjectClientBean left, GlobalObjectClientBean[] rightArr) throws Exception {
        if (rightArr == null) {
            return;
        }
        Long leftId = left.getId();
        block2: for (GlobalObjectClientBean right : rightArr) {
            RelationObjectClientBean[] rels = right.getLeftwardRelations();
            if (rels == null) {
                right.delete();
                continue;
            }
            SuperObjectClientBeanDefinition def = right.getNewDefinition(right.getSessionController());
            for (RelationObjectClientBean rel : rels) {
                if (!rel.getLeftObjectId().equals(leftId)) continue;
                rel.deleteRightObject(def);
                try {
                    right.getSessionController().getGlobalObjectById(right.getId());
                }
                catch (RoiException e) {
                    if (e.getErrorCode() == 101) continue block2;
                    throw e;
                }
            }
        }
    }

    private static void attach(GlobalObjectClientBean left, GlobalObjectClientBean[] rightArr, RelationObjectClientBeanDefinition relDef) throws Exception {
        if (rightArr == null) {
            return;
        }
        for (GlobalObjectClientBean right : rightArr) {
            left.addRelationship(right, relDef);
            GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)right.getNewDefinition(right.getSessionController());
            def.setSystemOption("setScopeAcls", left.getScopeAcls());
            right.leaveAcl(left.getAcl(), def);
        }
    }

    public static InputStream sanitize(InputStream is) throws UnsupportedEncodingException {
        StringBuffer sb;
        Matcher m;
        String content = StringConverterUtils.toString((InputStream)is, (Charset)SystemProperties.getCharset()).replaceAll("(Content-Type:.+)\\\\\"(.+)\\\\\"", "$1\"$2\"");
        try {
            m = MIME_ENCODED_TEXT_QUOTED.matcher(content);
            if (m.find()) {
                sb = new StringBuffer();
                do {
                    m.appendReplacement(sb, Matcher.quoteReplacement(MIME_ENCODED_TEXT_QUOTED_BREAK.matcher(m.group()).replaceAll("")).replaceAll("[\r\n]+$", ""));
                } while (m.find());
                m.appendTail(sb);
                content = sb.toString();
            }
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
        try {
            m = MIME_ENCODED_TEXT_BINARY.matcher(content);
            if (m.find()) {
                sb = new StringBuffer();
                do {
                    String text = MimeUtility.decodeText((String)m.group());
                    String encoded = MimeUtility.encodeText((String)text, (String)"UTF-8", (String)"Q");
                    m.appendReplacement(sb, Matcher.quoteReplacement(encoded.replace("?= =?UTF-8?Q?", "")).replaceAll("[\r\n]+$", ""));
                } while (m.find());
                m.appendTail(sb);
                content = sb.toString();
            }
        }
        catch (StackOverflowError e) {
            e.printStackTrace();
        }
        return StringConverterUtils.toStream((String)content, (Charset)SystemProperties.getCharset());
    }

    private MailObjectClientBean doParseInternal(boolean storeContent) throws Exception {
        this.cidHash = new HashMap<String, String>();
        Session ses = this.getMailSession();
        MimeMessage myMessage = new MimeMessage(ses, EmlParser.sanitize(this.sourceObject));
        MailObjectClientBean mailObject = this.createMail(myMessage, this.myParentMail, storeContent);
        if (this.originalMSG != null) {
            long contentSize = this.originalMSG.getContentSize();
            if (contentSize == 0L) {
                throw new Exception("Contensize of original msg file is 0: " + this.originalMSG.getId());
            }
            MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
            mdosf.setWithTransaction(true);
            mdosf.setNameWithId(true);
            mdosf.setContentStream(this.originalMSG.getContentStream());
            mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, mailObject.getOwner());
            mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, MailDocumentObjectClientBean.CLASS_NAME + "$$ID$$.msg");
            mdosf.setAccessControlList(mailObject.getAcl());
            mdosf.setScopeACLs(mailObject.getScopeAcls());
            MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
            if (mdocb.getContentSize() == 0L) {
                throw new Exception("Content-Size of stored msg mail is: 0: " + mdocb.getId() + ", original msg: " + this.originalMSG.getId());
            }
            mailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailMsgRelationObjectClientBeanDefinition(this.sessionController));
            String fileName = mailObject.getName();
            fileName = fileName.substring(0, fileName.length() - 3);
            fileName = fileName + "msg";
            MailObjectClientBeanDefinition mailDef = (MailObjectClientBeanDefinition)mailObject.getNewDefinition(this.sessionController);
            FormatObjectClientBean format = this.sessionController.getFormatByFileName(fileName);
            mailDef.setAttribute(MailObjectClientBean.FORMATOBJECT_ATTRIBUTE, AttributeValue.newAttributeValueObject(format));
            mailDef.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(fileName));
            mailObject.update(mailDef);
        }
        return mailObject;
    }

    private void handleCid(MailObjectClientBean mailObject) throws Exception {
        GlobalObjectClientBean[] bodies = mailObject.getMailBodies();
        if (bodies != null) {
            boolean changed = false;
            int len = bodies.length;
            for (int i = 0; i < len; ++i) {
                MailDocumentObjectClientBean body = (MailDocumentObjectClientBean)bodies[i];
                String bodyString = StringConverterUtils.toString((InputStream)body.getContentStreamNoRead());
                ArrayList<String> cidList = new ArrayList<String>(this.cidHash.keySet());
                Collections.sort(cidList, new ContentIdComparator());
                int cidLen = cidList.size();
                for (int j = 0; j < cidLen; ++j) {
                    String cid = (String)cidList.get(j);
                    String cidSimple = cid;
                    if (cidSimple.contains("@")) {
                        cidSimple = cidSimple.substring(0, cidSimple.indexOf("@"));
                    }
                    String id = "uuid://" + this.cidHash.get(cid);
                    if ((id = URLEncoder.encode(id, "UTF-8")) == null) continue;
                    Pattern cidPattern = Pattern.compile("\\Qcid:" + cid + "\\E", 2);
                    Pattern cidPatternSimple = Pattern.compile("\\Qcid:" + cidSimple + "\\E", 2);
                    Matcher cidMatcher = cidPattern.matcher(bodyString);
                    Matcher cidMatcherSimple = cidPatternSimple.matcher(bodyString);
                    if (cidMatcher.find()) {
                        bodyString = cidMatcher.replaceAll("cid:" + id);
                        changed = true;
                    }
                    if (!cidMatcherSimple.find()) continue;
                    bodyString = cidMatcherSimple.replaceAll("cid:" + id);
                    changed = true;
                }
                if (changed) {
                    body.setContentString(bodyString);
                }
                changed = false;
            }
        }
    }

    private boolean isInAdr(String[] adresses, String adr) {
        boolean isIn = false;
        if (adresses != null) {
            int len = adresses.length;
            for (int i = 0; i < len; ++i) {
                if (!adresses[i].equalsIgnoreCase(adr)) continue;
                isIn = true;
                break;
            }
        }
        return isIn;
    }

    private String filterMb4(String str) {
        if (str == null || !mb3) {
            return str;
        }
        return str.replaceAll("[^\\u0000-\\uFFFF]", "\ufffd");
    }

    private String[] filterMb4(String[] str) {
        if (str == null || !mb3) {
            return str;
        }
        int len = str.length;
        String[] result = new String[len];
        for (int i = 0; i < len; ++i) {
            result[i] = str[i].replaceAll("[^\\u0000-\\uFFFF]", "\ufffd");
        }
        return result;
    }

    private MailObjectClientBean createMail(MimeMessage myMessage, MailObjectClientBean parentMailObject, boolean storeContent) throws Exception {
        String[] sensitivity;
        String[] mdn;
        String subject = myMessage.getSubject();
        String name = null;
        if (subject != null) {
            subject = this.filterMb4(subject);
            name = this.stringUtils.strReplaceToFilename(subject);
        } else {
            name = subject = "No Subject";
        }
        if (name.length() > 230) {
            name = name.substring(0, 230);
        }
        MailObjectSessionFacade mosf = new MailObjectSessionFacade(this.sessionController);
        mosf.setWithTransaction(true);
        mosf.setNameWithId(true);
        mosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name + "_" + "$$ID$$" + ".eml");
        if (parentMailObject == null) {
            if (this.addToFolder) {
                FolderObjectClientBean destinationFolder = null;
                try {
                    String inbox = this.explicitUser.getPrimaryUserProfile().getHomeFolder().getAnyFolderPath() + "/Mail/inbox";
                    this.destinationFolderOrg = destinationFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(inbox);
                }
                catch (Exception e) {
                    stat.warning().exception((Throwable)e).send("Error getting inbox folder, continue...");
                }
                if (this.destinationFolderObj != null) {
                    destinationFolder = this.destinationFolderObj;
                }
                if (destinationFolder != null) {
                    mosf.setDestinationFolder(destinationFolder);
                    mosf.setAccessControlList(destinationFolder.getAcl());
                }
            }
            if (storeContent) {
                mosf.setContentStream(this.sourceObject2);
            }
        } else {
            mosf.setAccessControlList(parentMailObject.getAcl());
            if (storeContent) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                myMessage.writeTo((OutputStream)baos);
                mosf.setContentStream(new ByteArrayInputStream(baos.toByteArray()));
            }
        }
        boolean hadErrors = false;
        try {
            mosf.setAttribute("SUBJECT", subject);
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Error setting subject");
            hadErrors = true;
        }
        String[] bccAdr = null;
        String[] ccAdr = null;
        String[] toAdr = null;
        try {
            bccAdr = this.getRecipients(myMessage, Message.RecipientType.BCC, "Bcc");
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Error setting receipients");
            hadErrors = true;
        }
        try {
            ccAdr = this.getRecipients(myMessage, Message.RecipientType.CC, "Cc");
            mosf.setAttribute("CCADDRESS", ccAdr);
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Error setting CC");
            hadErrors = true;
        }
        try {
            toAdr = this.getRecipients(myMessage, Message.RecipientType.TO, "To");
            mosf.setAttribute("TOADDRESS", toAdr);
        }
        catch (Exception e) {
            stat.error().exception((Throwable)e).send("Error setting TO");
            hadErrors = true;
        }
        if (parentMailObject == null && this.mailAddresses != null) {
            int len = this.mailAddresses.size();
            for (int i = 0; i < len; ++i) {
                String adr = (String)this.mailAddresses.elementAt(i);
                if (this.isInAdr(ccAdr, adr) || this.isInAdr(toAdr, adr) || this.isInAdr(bccAdr, adr)) continue;
                if (bccAdr == null) {
                    bccAdr = new String[]{adr};
                    continue;
                }
                String[] bccAdrC = new String[bccAdr.length + 1];
                System.arraycopy(bccAdr, 0, bccAdrC, 0, bccAdr.length);
                bccAdrC[bccAdr.length] = adr;
                bccAdr = bccAdrC;
            }
        }
        if (bccAdr != null) {
            mosf.setAttribute("BCCADDRESS", bccAdr);
        }
        Address[] from = null;
        try {
            from = myMessage.getFrom();
        }
        catch (Exception e) {
            try {
                String[] adrHeader = myMessage.getHeader("From");
                from = this.getAddressFromString(adrHeader);
            }
            catch (Exception e1) {
                stat.error().exception((Throwable)e).send("Error setting From");
                hadErrors = true;
            }
        }
        String[] fromAddressArr = this.fillAddressToString(from);
        if (fromAddressArr != null && fromAddressArr.length > 0) {
            String fromAddress = this.convertMailAddress(fromAddressArr[0]);
            DirectoryUserObjectClientBean user = this.sessionController.getDirectoryUserFromEmailAddress(fromAddress);
            if (user == null) {
                String mailCreator = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, "MAIN_MODULE_MANAGEMENT/roi/control/mail/MailCreator", null);
                if (mailCreator != null && mailCreator.trim().length() > 0) {
                    stat.debug().send("user not found with fromAddress: " + fromAddress + ", using: " + mailCreator);
                    user = this.sessionController.getUserByName(mailCreator.trim());
                }
            } else {
                stat.debug().send("setting creator of mail with user: " + user.getName() + ", fromAddress=" + fromAddress);
            }
            if (user != null) {
                mosf.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, user);
            }
        }
        mosf.setAttribute("FROMADDRESS", fromAddressArr);
        Address[] replyTo = null;
        try {
            replyTo = myMessage.getReplyTo();
        }
        catch (Exception e) {
            try {
                String[] adrHeader = myMessage.getHeader("ReplyTo");
                replyTo = this.getAddressFromString(adrHeader);
            }
            catch (Exception e1) {
                stat.error().exception((Throwable)e).send("Error setting ReplyTo");
                hadErrors = true;
            }
        }
        mosf.setAttribute("REPLAYTO", this.fillAddressToString(replyTo));
        String[] normalDate = myMessage.getHeader("Date");
        boolean dateSet = false;
        if (normalDate != null && normalDate.length > 0) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
                String d = normalDate[0];
                Date date = sdf.parse(d);
                if (date.getTime() < 0L) {
                    sdf = new SimpleDateFormat("EEE, d MMM yy HH:mm:ss Z", Locale.US);
                    date = sdf.parse(d);
                }
                if (date.getTime() > 0L) {
                    mosf.setAttribute("RFC822DATE", date);
                    dateSet = true;
                }
            }
            catch (Exception sdf) {
                // empty catch block
            }
        }
        if (!dateSet) {
            mosf.setAttribute("RFC822DATE", myMessage.getSentDate());
        }
        mosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, this.explicitUser);
        Enumeration headerEnum = myMessage.getAllHeaderLines();
        ArrayList<String> headerList = new ArrayList<String>();
        while (headerEnum.hasMoreElements()) {
            headerList.add(this.filterMb4((String)headerEnum.nextElement()));
        }
        mosf.setAttribute("RFC822HEADER", headerList.toArray(new String[headerList.size()]));
        mosf.setAttribute("ANSWERED", myMessage.getFlags().contains(Flags.Flag.ANSWERED));
        mosf.setAttribute("SEEN", myMessage.getFlags().contains(Flags.Flag.SEEN));
        mosf.setAttribute("DRAFT", myMessage.getFlags().contains(Flags.Flag.DRAFT));
        mosf.setAttribute("FLAGGED", myMessage.getFlags().contains(Flags.Flag.FLAGGED));
        mosf.setAttribute("RECENT", myMessage.getFlags().contains(Flags.Flag.RECENT));
        mosf.setAttribute("RFC822SIZE", new Integer(myMessage.getSize()));
        mosf.setAttribute("LINECOUNT", new Integer(myMessage.getLineCount()));
        mosf.setAttribute("CONTENTTRANSFERENCODING", myMessage.getEncoding());
        mosf.setAttribute("RFC822MESSAGEID", this.filterMb4(myMessage.getMessageID()));
        if (this.uid != null) {
            mosf.setAttribute("MESSAGEID", this.uid);
        }
        if ((mdn = myMessage.getHeader("Disposition-Notification-To")) != null && mdn.length > 0 && mdn[0] != null) {
            mosf.setAttribute("DISPOSITIONNOTIFICATIONTO", this.filterMb4(mdn[0]));
        }
        String priority = null;
        String[] importance = myMessage.getHeader("Importance");
        String[] xPriority = myMessage.getHeader("X-Priority");
        String[] xMSMailPriority = myMessage.getHeader("X-MSMail-Priority");
        if (importance != null && importance.length > 0 && importance[0] != null) {
            if (importance[0].equalsIgnoreCase("high")) {
                priority = "High";
            } else if (importance[0].equalsIgnoreCase("normal")) {
                priority = "Normal";
            } else if (importance[0].equalsIgnoreCase("low")) {
                priority = "Low";
            }
        }
        if (priority == null && xPriority != null && xPriority.length > 0 && xPriority[0] != null) {
            if (xPriority[0].startsWith("1") || xPriority[0].startsWith("2")) {
                priority = "High";
            } else if (xPriority[0].startsWith("3")) {
                priority = "Normal";
            } else if (xPriority[0].startsWith("4") || xPriority[0].startsWith("5")) {
                priority = "Low";
            }
        }
        if (priority == null && xMSMailPriority != null && xMSMailPriority.length > 0 && xMSMailPriority[0] != null) {
            if (xMSMailPriority[0].equalsIgnoreCase("high")) {
                priority = "High";
            } else if (xMSMailPriority[0].equalsIgnoreCase("normal")) {
                priority = "Normal";
            } else if (xMSMailPriority[0].equalsIgnoreCase("low")) {
                priority = "Low";
            }
        }
        if (priority != null) {
            mosf.setAttribute("PRIORITY", priority);
        }
        if ((sensitivity = myMessage.getHeader("Sensitivity")) != null && sensitivity.length > 0) {
            mosf.setAttribute("SENSITIVITY", this.filterMb4(sensitivity[0]));
        }
        String inReplyTo = null;
        String[] inReplyToArr = myMessage.getHeader("In-Reply-To");
        if (inReplyToArr != null && inReplyToArr.length > 0) {
            inReplyTo = inReplyToArr[0];
        } else {
            inReplyToArr = myMessage.getHeader("References");
            if (inReplyToArr != null && inReplyToArr.length > 0) {
                inReplyTo = this.decodeText(inReplyToArr[0]);
                int lastStart = inReplyTo.lastIndexOf("<");
                int lastEnd = inReplyTo.lastIndexOf(">");
                if (lastStart > 0 && lastEnd > 0 && lastEnd > lastStart) {
                    inReplyTo = inReplyTo.substring(lastStart, lastEnd + 1);
                }
            }
        }
        if (inReplyTo != null && inReplyTo.length() > 0) {
            mosf.setAttribute("INREPLAYTO", this.filterMb4(inReplyTo));
        }
        if (parentMailObject == null) {
            mosf.setAttribute("MAILSTATUS", this.mailStatus);
        } else if (this.mailStatus.equals("outbox")) {
            mosf.setAttribute("MAILSTATUS", "sentbox");
        } else {
            mosf.setAttribute("MAILSTATUS", "inbox");
        }
        if (this.createDate != null) {
            mosf.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, this.createDate);
            mosf.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, this.createDate);
        }
        MailObjectClientBean mailObject = (MailObjectClientBean)mosf.create();
        if (inReplyTo != null && inReplyTo.length() > 0) {
            SuperObjectClientBean[] inReplyToMails = null;
            try {
                inReplyToMails = this.sessionController.getSuperObjectByAttribute(this.sessionController, "RFC822MESSAGEID", inReplyTo, false, this.sessionController.getClassObject(MailObjectClientBean.CLASS_NAME));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (inReplyToMails != null && inReplyToMails.length > 0) {
                int irtmLen = inReplyToMails.length;
                for (int i = 0; i < irtmLen; ++i) {
                    ((GlobalObjectClientBean)inReplyToMails[i]).addRelationship(mailObject, (RelationObjectClientBeanDefinition)new AttachmentsRelationObjectClientBeanDefinition(this.sessionController));
                }
            }
        }
        if (hadErrors) {
            stat.error().object((SystemObjectReference)mailObject).send("Problem with a mail");
        }
        if (parentMailObject != null) {
            parentMailObject.addRelationship(mailObject, (RelationObjectClientBeanDefinition)new MailAttachmentsRelationObjectClientBeanDefinition(this.sessionController));
        }
        this.dumpPart((Part)myMessage, 0, mailObject);
        if (this.createDate != null) {
            mailObject.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(this.createDate));
        } else {
            MetaDb md = this.sessionController.getMetaDbInstance();
            boolean sentDateIsCreateDate = md.getBoolean("MAIN_MODULE_MANAGEMENT/roi/control/contenttask/EML/SentDateIsCreateDate", false);
            Date d = mailObject.getSentDate();
            if (d != null) {
                mailObject.setAttribute(sentDateIsCreateDate ? GlobalObjectClientBean.CREATEDATE_ATTRIBUTE : GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(d));
            }
        }
        this.handleCid(mailObject);
        return mailObject;
    }

    private String convertMailAddress(String mailAddress) {
        if (mailAddress.lastIndexOf("<") >= 0 && mailAddress.lastIndexOf(">") > mailAddress.lastIndexOf("<")) {
            mailAddress = mailAddress.substring(mailAddress.lastIndexOf("<") + 1, mailAddress.lastIndexOf(">"));
        }
        return mailAddress;
    }

    private InternetAddress getInternetAddressFromString(String mailAddressWithName) throws Exception {
        Matcher m = addressPattern.matcher(mailAddressWithName);
        if (m.find()) {
            String name;
            String address = m.group();
            if (!address.startsWith("<") && !address.startsWith("\"") && address.indexOf("<") != -1) {
                name = "\"" + address.substring(0, address.indexOf("<"));
                name = name.trim() + "\"";
                String adr = address.substring(address.indexOf("<"));
                address = name + " " + adr;
            }
            name = null;
            if (!address.startsWith("<") && address.indexOf("<") != -1 && address.endsWith(">")) {
                name = address.substring(0, address.indexOf("<"));
                if ((name = name.trim()).startsWith("\"")) {
                    name = name.substring(1);
                }
                if (name.endsWith("\"")) {
                    name = name.substring(0, name.length() - 1);
                }
                address = address.substring(address.indexOf("<") + 1, address.indexOf(">"));
            }
            return new InternetAddress(address, name, SystemProperties.getCharsetName());
        }
        int startPos = mailAddressWithName.indexOf("<");
        if (startPos != -1) {
            StringUtils su = new StringUtils();
            String mailAddress = su.getStringFrommTrenner(mailAddressWithName, "<", ">", 1);
            mailAddress = mailAddress.replaceAll("[\\s]*", "");
            String name = mailAddressWithName.substring(0, startPos);
            name = name.replaceAll("^[\\s]*", "");
            name = name.replaceAll("[\\s]*$", "");
            mailAddress.trim();
            return new InternetAddress(mailAddress, name, SystemProperties.getCharsetName());
        }
        mailAddressWithName.trim();
        return new InternetAddress(mailAddressWithName);
    }

    private String[] getRecipients(MimeMessage myMessage, Message.RecipientType type, String sType) throws Exception {
        String[] sArr = null;
        if (myMessage != null) {
            try {
                int i;
                int len;
                ArrayList<InternetAddress> addressList = new ArrayList<InternetAddress>();
                String[] tmpArr = myMessage.getHeader(sType);
                if (tmpArr != null) {
                    len = tmpArr.length;
                    for (i = 0; i < len; ++i) {
                        tmpArr[i] = tmpArr[i].replaceAll("[\\n\\r\\t]*", "");
                        try {
                            InternetAddress[] ia = InternetAddress.parse((String)tmpArr[i], (boolean)false);
                            addressList.addAll(Arrays.asList(ia));
                            continue;
                        }
                        catch (Exception e) {
                            InternetAddress adr = this.getInternetAddressFromString(this.decodeText(tmpArr[i]));
                            addressList.add(adr);
                        }
                    }
                }
                if ((len = addressList.size()) > 0) {
                    sArr = new String[len];
                    for (i = 0; i < len; ++i) {
                        sArr[i] = this.filterMb4(this.fillSingleAddressToString((InternetAddress)addressList.get(i)));
                    }
                }
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Error getting recipients");
            }
        }
        return sArr;
    }

    private Address[] getAddressFromString(String[] addresses) throws Exception {
        InternetAddress[] retAdr = null;
        if (addresses != null) {
            retAdr = new InternetAddress[addresses.length];
            for (int i = 0; i < addresses.length; ++i) {
                String address = addresses[i];
                retAdr[i] = this.getInternetAddressFromString(address);
            }
        }
        return retAdr;
    }

    private String[] fillAddressToString(Address[] adrArr) throws Exception {
        int len;
        String[] sArr = null;
        if (adrArr != null && (len = adrArr.length) > 0) {
            sArr = new String[len];
            for (int i = 0; i < len; ++i) {
                sArr[i] = this.filterMb4(this.fillSingleAddressToString((InternetAddress)adrArr[i]));
            }
        }
        return sArr;
    }

    private String fillSingleAddressToString(InternetAddress ia) {
        String addressStr = null;
        String personal = ia.getPersonal();
        if (personal != null) {
            try {
                personal = EmlParser.decodeMimeParts(personal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String address = ia.getAddress();
        if (personal == null || personal.equals("")) {
            addressStr = address;
        } else {
            if (!personal.startsWith("\"") && !personal.endsWith("\"")) {
                personal = "\"" + personal + "\"";
            }
            addressStr = personal + " <" + address + ">";
        }
        return addressStr;
    }

    private void generateAttachment(String s, Part p, MailObjectClientBean actMailObject) throws Exception {
        try (ByteArrayInputStream is = StringConverterUtils.toStream((String)s);){
            this.generateAttachment(is, p, actMailObject);
        }
    }

    private String determineFormat(MailDocumentObjectSessionFacade mdosf, Part p, String fileName) throws Exception {
        FormatObjectClientBean format;
        String mimeType;
        if (p.getContentType() != null && !"application/octet-stream".equals(mimeType = p.getContentType().split(";")[0]) && (format = this.sessionController.getFormatByMimeType(mimeType)) != null) {
            mdosf.setFormat(format);
            if (format.getExtension() != null && fileName != null && !fileName.toLowerCase().endsWith("." + format.getExtension().toLowerCase())) {
                FormatObjectClientBean nameFormat;
                String fileExtension = null;
                if (fileName.contains(".")) {
                    fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
                }
                if (!(fileExtension != null && fileExtension.length() <= 3 || (nameFormat = this.sessionController.getFormatByFileName(fileName)) != null && !nameFormat.getName().equals("Unknown Binary"))) {
                    return fileName + "." + format.getExtension();
                }
            }
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateAttachment(InputStream is, Part p, MailObjectClientBean actMailObject) throws Exception {
        block33: {
            String fName = actMailObject == null ? "tmpatt_" + new Date().getTime() + ".att" : "tmpatt_" + actMailObject.getId() + ".att";
            FileOutputStream fos = new FileOutputStream(fName);
            try {
                String fileName;
                byte[] b = new byte[10240];
                try {
                    int len;
                    while ((len = is.read(b)) > 0) {
                        fos.write(b, 0, len);
                    }
                }
                finally {
                    fos.close();
                }
                is = new FileInputStream(fName);
                this.isOutlookMail = false;
                try {
                    TnefMessage msg = this.getTnefMessage(is);
                    int count = msg.getCount();
                    if (count > 0) {
                        for (int i = 0; i < count; ++i) {
                            TnefAttachment a = msg.getAttachmentAt(i);
                            String fileName2 = this.stringUtils.strReplaceToFilename(a.getFilename());
                            if (fileName2 != null && fileName2.trim().length() == 0) {
                                fileName2 = null;
                            }
                            String contentType = msg.getContentType();
                            if (fileName2 == null && contentType != null && contentType.equalsIgnoreCase("message/tnef")) {
                                EmlParser emlParser = new EmlParser(this.sessionController);
                                emlParser.setInputFile(new File(fName));
                                emlParser.setMailStatus("inbox");
                                emlParser.setExplicitUser(this.explicitUser);
                                emlParser.setMyParentMail(actMailObject);
                                emlParser.doParse();
                                continue;
                            }
                            MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
                            ByteArrayInputStream bis = new ByteArrayInputStream(a.getContentBytes());
                            mdosf.setWithTransaction(true);
                            mdosf.setContentStream(bis);
                            mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, this.explicitUser);
                            fileName2 = fileName2 == null ? "UnknownFileName" : fileName2;
                            fileName2 = this.determineFormat(mdosf, p, fileName2);
                            mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName2);
                            mdosf.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, actMailObject.getCreator());
                            mdosf.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, actMailObject.getCreateDate());
                            mdosf.setAccessControlList(actMailObject.getAcl());
                            mdosf.setScopeACLs(actMailObject.getScopeAcls());
                            MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
                            actMailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailAttachmentsRelationObjectClientBeanDefinition(this.sessionController));
                        }
                        this.isOutlookMail = true;
                    }
                }
                catch (Exception e) {
                    this.isOutlookMail = false;
                }
                if (this.isOutlookMail) break block33;
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                is = new FileInputStream(fName);
                MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
                mdosf.setWithTransaction(true);
                mdosf.setContentStream(is);
                String[] cid = p.getHeader("Content-ID");
                String contentId = null;
                if (cid != null && cid.length > 0 && (contentId = cid[0]).startsWith("<") && contentId.endsWith(">")) {
                    contentId = contentId.substring(1);
                    contentId = contentId.substring(0, contentId.length() - 1);
                }
                if ((fileName = this.getFilename(p)) != null) {
                    fileName = this.decodeText(fileName);
                } else {
                    RFC2231Parser rfc2231Parser = new RFC2231Parser();
                    try {
                        fileName = rfc2231Parser.getAttachmentName(p);
                    }
                    catch (Throwable t) {
                        fileName = "unknown";
                    }
                }
                if (fileName == null) {
                    if (contentId == null) {
                        mdosf.setNameWithId(true);
                        fileName = "UnknownFileName_$$ID$$";
                    } else {
                        fileName = contentId;
                    }
                } else if (contentId == null) {
                    contentId = fileName;
                }
                fileName = this.stringUtils.strReplaceToFilename(fileName);
                fileName = this.determineFormat(mdosf, p, fileName);
                mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
                mdosf.setAccessControlList(actMailObject.getAcl());
                mdosf.setScopeACLs(actMailObject.getScopeAcls());
                mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, this.explicitUser);
                mdosf.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, actMailObject.getCreator());
                mdosf.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, actMailObject.getCreateDate());
                MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
                if (contentId != null) {
                    this.cidHash.put(contentId, "" + mdocb.getUUID());
                }
                actMailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailAttachmentsRelationObjectClientBeanDefinition(this.sessionController));
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception b) {}
                }
                File file = new File(fName);
                file.delete();
            }
        }
    }

    private TnefMessage getTnefMessage(InputStream is) throws Exception {
        return JTnef.createTnefMessage((InputStream)is);
    }

    private void generateBody(String body, Part p, MailObjectClientBean actMailObject) throws Exception {
        ContentType contentType = new ContentType(p.getContentType());
        String mimeType = contentType.getBaseType();
        this.generateBody(body, mimeType, actMailObject);
    }

    private void generateBody(String body, String mimeType, MailObjectClientBean actMailObject) throws Exception {
        if (body != null && body.indexOf("$$signature_") != -1) {
            RoiFileSystem rfs = new RoiFileSystem(this.sessionController);
            FileObjectClientBean foCompany = rfs.findFileObjectInFolderWithLanguage("/agorum/roi/MailFooter", this.sessionController.getLocale(), "txt");
            String signatureUser = "";
            String signatureCompany = "";
            MailUtils mu = new MailUtils(this.sessionController);
            String from = null;
            try {
                InternetAddress[] ia = InternetAddress.parse((String)actMailObject.getFromAddress()[0], (boolean)false);
                from = ia[0].getAddress();
            }
            catch (Exception e) {
                InternetAddress adr = this.getInternetAddressFromString(actMailObject.getFromAddress()[0]);
                from = adr.getAddress();
            }
            String suUser = mu.getFooterText(actMailObject.getOwner(), from, false);
            if (foCompany != null) {
                signatureCompany = StringConverterUtils.toString((InputStream)foCompany.getContentStream()).trim();
            }
            if (suUser != null) {
                signatureUser = suUser.trim();
            }
            StringUtils su = new StringUtils();
            if (mimeType.equalsIgnoreCase("text/html")) {
                signatureCompany = su.strReplace(signatureCompany, "\n", "<br>");
                signatureUser = su.strReplace(signatureUser, "\n", "<br>");
            }
            body = su.strReplace(body, "$$signature_user$$", signatureUser);
            body = su.strReplace(body, "$$signature_company$$", signatureCompany);
        }
        MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
        mdosf.setWithTransaction(true);
        mdosf.setContentStream(StringConverterUtils.toStream((String)body));
        mdosf.setNameWithId(true);
        String fileName = "part";
        fileName = mimeType.equalsIgnoreCase("text/plain") ? "(Text) $$ID$$.txt" : "(HTML) $$ID$$.html";
        mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
        mdosf.setAccessControlList(actMailObject.getAcl());
        mdosf.setScopeACLs(actMailObject.getScopeAcls());
        mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, this.explicitUser);
        mdosf.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, actMailObject.getCreator());
        mdosf.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, actMailObject.getCreateDate());
        MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
        actMailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailBodyRelationObjectClientBeanDefinition(this.sessionController));
    }

    private String getFilename(Part p) {
        String fileName = null;
        try {
            try {
                fileName = p.getFileName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fileName == null) {
                RFC2231Parser rfc2231Parser = new RFC2231Parser();
                fileName = rfc2231Parser.getAttachmentName(p);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPart(Part p, int depth, MailObjectClientBean actMailObject) throws Exception {
        block60: {
            try {
                String fileName = "unknown";
                try {
                    fileName = this.getFilename(p);
                }
                catch (Throwable e) {
                    stat.error().exception(e).object((SystemObjectReference)actMailObject).send("Error getting attachment fileName");
                }
                Object o = null;
                try {
                    o = p.getContent();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (o == null || o instanceof Image) {
                    o = p.getInputStream();
                }
                if (o instanceof String) {
                    if ((p.isMimeType("text/html") || p.isMimeType("text/plain")) && this.getFilename(p) == null) {
                        this.generateBody((String)o, p, actMailObject);
                    } else {
                        this.generateAttachment(p.getInputStream(), p, actMailObject);
                    }
                    break block60;
                }
                if (p.isMimeType("multipart/signed") && (p.getContentType().toLowerCase().indexOf("application/pkcs7-mime") != -1 || p.getContentType().toLowerCase().indexOf("application/x-pkcs7-mime") != -1)) break block60;
                if ((p.isMimeType("application/pkcs7-mime") || p.isMimeType("application/x-pkcs7-mime")) && p.getContentType().toLowerCase().indexOf("smime-type=signed-data") != -1) {
                    try {
                        SMIMESignedParser s = new SMIMESignedParser(p);
                        this.dumpPart((Part)s.getContent(), depth + 1, actMailObject);
                    }
                    catch (Exception e) {
                        stat.error().exception((Throwable)e).object((SystemObjectReference)actMailObject).detail((Object)"The attachment is ignored, but the mail has been saved").send("Error parsing signed attachment");
                    }
                    break block60;
                }
                if (p.isMimeType("text/calendar")) {
                    ContentType contentType = null;
                    if (p instanceof MimeMessage) {
                        contentType = new ContentType(((MimeMessage)p).getContentType());
                    } else if (p instanceof MimeBodyPart) {
                        contentType = new ContentType(((MimeBodyPart)p).getContentType());
                    }
                    String charSetName = contentType != null ? contentType.getParameter("charset") : null;
                    String partFileName = contentType != null ? contentType.getParameter("name") : null;
                    ICalParser iCalParser = null;
                    try {
                        iCalParser = new ICalParser(p.getInputStream(), charSetName);
                    }
                    catch (Throwable e) {
                        stat.error().exception(e).object((SystemObjectReference)actMailObject).detail((Object)"Could not parse calendar attachment");
                    }
                    String description = null;
                    String summary = null;
                    String xAltDesc = null;
                    if (iCalParser != null) {
                        description = iCalParser.getDescription();
                        summary = iCalParser.getSummary();
                        xAltDesc = iCalParser.getXAltDesc();
                    }
                    if (partFileName != null && partFileName.toLowerCase().endsWith(".ics")) {
                        fileName = partFileName;
                    } else if (summary != null && summary.length() > 0) {
                        partFileName = summary.length() <= 40 ? summary : summary.substring(0, 40);
                        fileName = partFileName + ".ics";
                    } else {
                        fileName = "attach.ics";
                    }
                    fileName = this.stringUtils.strReplaceToFilename(fileName);
                    if (xAltDesc != null) {
                        this.generateBody(xAltDesc, "text/html", actMailObject);
                    }
                    this.generateBody(description != null ? description : "", "text/plain", actMailObject);
                    MailDocumentObjectSessionFacade mdosf = new MailDocumentObjectSessionFacade(this.sessionController);
                    mdosf.setWithTransaction(true);
                    mdosf.setContentStream(p.getInputStream());
                    mdosf.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, fileName);
                    mdosf.setAccessControlList(actMailObject.getAcl());
                    mdosf.setScopeACLs(actMailObject.getScopeAcls());
                    mdosf.setAttribute(GlobalObjectClientBean.OWNER_ATTRIBUTE, this.explicitUser);
                    mdosf.setAttribute(GlobalObjectClientBean.CREATOR_ATTRIBUTE, actMailObject.getCreator());
                    mdosf.setAttribute(GlobalObjectClientBean.CREATEDATE_ATTRIBUTE, actMailObject.getCreateDate());
                    MailDocumentObjectClientBean mdocb = (MailDocumentObjectClientBean)mdosf.create();
                    actMailObject.addRelationship(mdocb, (RelationObjectClientBeanDefinition)new MailAttachmentsRelationObjectClientBeanDefinition(this.sessionController));
                    break block60;
                }
                if (o instanceof Multipart) {
                    Multipart mp = (Multipart)o;
                    int count = 0;
                    try {
                        count = mp.getCount();
                    }
                    catch (Exception partFileName) {
                        // empty catch block
                    }
                    for (int i = 0; i < count; ++i) {
                        if (depth > 20) continue;
                        this.dumpPart((Part)mp.getBodyPart(i), depth + 1, actMailObject);
                    }
                    break block60;
                }
                if (o instanceof Message) {
                    EmlParser subParser = new EmlParser(this.sessionController);
                    subParser.setExplicitUser(this.explicitUser);
                    subParser.createMail((MimeMessage)o, actMailObject, true);
                    break block60;
                }
                if (o instanceof InputStream) {
                    InputStream is = (InputStream)o;
                    String fName = actMailObject == null ? "tmpmail_" + new Date().getTime() + ".eml" : "tmpmail_" + actMailObject.getId() + ".eml";
                    try (FileOutputStream fos = new FileOutputStream(fName);){
                        int len;
                        byte[] b = new byte[10240];
                        while ((len = is.read(b)) > 0) {
                            fos.write(b, 0, len);
                        }
                    }
                    FileInputStream fis = new FileInputStream(fName);
                    try {
                        if (this.stringUtils.isBase64((InputStream)fis)) {
                            fis.close();
                            fis = new FileInputStream(fName);
                            try {
                                if (p.isMimeType("text/html") || p.isMimeType("text/plain")) {
                                    this.generateBody(this.stringUtils.streamToString((InputStream)new BASE64DecoderStream((InputStream)fis)), p, actMailObject);
                                } else {
                                    this.generateAttachment((InputStream)new BASE64DecoderStream((InputStream)fis), p, actMailObject);
                                }
                                break block60;
                            }
                            finally {
                                fis.close();
                                fis = null;
                            }
                        }
                        fis.close();
                        fis = new FileInputStream(fName);
                        try {
                            if (p.isMimeType("text/html") || p.isMimeType("text/plain")) {
                                this.generateBody(this.stringUtils.streamToString((InputStream)fis), p, actMailObject);
                            } else {
                                this.generateAttachment(fis, p, actMailObject);
                            }
                            break block60;
                        }
                        catch (Exception ex) {
                            stat.error().exception((Throwable)ex).send("Error generating body");
                            break block60;
                        }
                        finally {
                            fis.close();
                            fis = null;
                        }
                    }
                    finally {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Exception ex) {}
                        File f = new File(fName);
                        f.delete();
                    }
                }
                if (o instanceof Image) {
                    stat.warning().send("java.awt.Image can not be handled");
                } else {
                    stat.warning().detail((Object)(o.getClass().getName() + "\nFileName = " + fileName)).send("Unknown object as attachment");
                }
            }
            catch (Throwable e) {
                stat.error().exception(e).send("error dumping part");
                ExceptionUtils.handleException(e);
            }
        }
    }

    private String decodeText(String s) {
        String ret = "";
        if (s != null) {
            try {
                ret = EmlParser.decodeMimeParts(s.trim());
            }
            catch (Exception e) {
                ret = s;
                stat.error().exception((Throwable)e).detail((Object)s).send("error decoding text");
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardMailTo(File tmpFile, String toAddress) throws Exception {
        MimeMessage mimeMessage = null;
        try (FileInputStream fis = new FileInputStream(tmpFile);){
            Session session = this.getMailSession();
            mimeMessage = new MimeMessage(session, (InputStream)fis);
        }
        Address[] address = this.buildAddressFromString(toAddress);
        Transport.send((Message)mimeMessage, (Address[])address);
    }

    public void sendSimpleMail(String body, String subject, String toAddress, String fromAddress) throws Exception {
        this.sendSimpleMail(body, subject, toAddress, fromAddress, null);
    }

    public void sendSimpleMail(String body, String subject, String toAddress, String fromAddress, Hashtable headers) throws Exception {
        this.sendSimpleMail(body, subject, toAddress, fromAddress, headers, "text/plain");
    }

    public void sendSimpleMail(String body, String subject, String toAddress, String fromAddress, Hashtable headers, String mimeType) throws Exception {
        Session session = this.getMailSession();
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSentDate(new Date());
        mimeMessage.setContent((Object)body, mimeType);
        mimeMessage.setSubject(subject);
        if (headers != null) {
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)headers.get(key);
                mimeMessage.setHeader(key, value);
            }
        }
        Address[] toAddressA = this.buildAddressFromString(toAddress);
        Address[] fromAddressA = this.buildAddressFromString(fromAddress);
        mimeMessage.setFrom(fromAddressA[0]);
        mimeMessage.setRecipients(Message.RecipientType.TO, toAddressA);
        Transport.send((Message)mimeMessage, (Address[])toAddressA);
    }

    private Session getMailSession() throws Exception {
        Properties props = new Properties();
        RoiPropertiesMetaDb rpmd = new RoiPropertiesMetaDb(this.sessionController);
        props.put("mail.smtp.host", rpmd.getMailserverHostaddress());
        props.put("mail.smtp.port", rpmd.getMailserverPort());
        SMTPAuthenticator auth = null;
        String user = rpmd.getMailserverUser();
        String password = rpmd.getMailserverPassword();
        if (user != null && user.trim().length() > 0 && password != null) {
            props.put("mail.smtp.auth", "true");
            auth = new SMTPAuthenticator(user, password);
        }
        Session session = Session.getInstance((Properties)props, auth);
        session.setDebug(false);
        return session;
    }

    private Address[] buildAddressFromString(String adr) throws Exception {
        StringTokenizer sTok = new StringTokenizer(adr, ";\n");
        ArrayList<InternetAddress> al = new ArrayList<InternetAddress>();
        while (sTok.hasMoreElements()) {
            String toAddressToken = (String)sTok.nextElement();
            if (toAddressToken.trim().length() <= 0) continue;
            try {
                InternetAddress address = this.getInternetAddressFromString(toAddressToken);
                al.add(address);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Address[] address = new Address[al.size()];
        for (int i = 0; i < al.size(); ++i) {
            address[i] = (Address)al.get(i);
        }
        return address;
    }

    public String[] getMessageAttributes(Message message, String attr) throws Exception {
        int i;
        int len;
        MailObjectHolder mailHolder;
        String[] sRet = null;
        if (attr.equalsIgnoreCase("TEXT")) {
            mailHolder = this.collectMailInfo(message);
            len = mailHolder.getBodies().size();
            if (len > 0) {
                sRet = new String[len];
                for (i = 0; i < len; ++i) {
                    String text = (String)mailHolder.getBodies().get(i);
                    text = text.replace('\r', ' ');
                    text = text.replace('\n', ' ');
                    sRet[i] = text = text.replace('\t', ' ');
                }
            }
        } else if (attr.equalsIgnoreCase("ATTACHMENT")) {
            mailHolder = this.collectMailInfo(message);
            len = mailHolder.getAttachments().size();
            if (len > 0) {
                sRet = new String[len];
                for (i = 0; i < len; ++i) {
                    sRet[i] = (String)mailHolder.getAttachments().get(i);
                }
            }
        } else {
            mailHolder = this.collectMailInfo(message);
            sRet = mailHolder.getHeader(attr);
        }
        if (sRet != null) {
            int len2 = sRet.length;
            for (int i2 = 0; i2 < len2; ++i2) {
                sRet[i2] = this.decodeText(sRet[i2]);
            }
        }
        return sRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkMailFilter(File tmpFile, String[] attributes, String[] values) {
        boolean mailIsValid = true;
        if (attributes != null && attributes.length > 0) {
            mailIsValid = false;
            int lenA = attributes.length;
            for (int j = 0; j < lenA; ++j) {
                block17: {
                    String attr = attributes[j];
                    String value = values[j];
                    if (value.toUpperCase().startsWith(REGULAREXPRESSION_KEY)) {
                        value = value.substring(REGULAREXPRESSION_KEY.length());
                    } else {
                        String newValue = "";
                        if (value.startsWith("!")) {
                            value = value.substring(1);
                            newValue = "!";
                        }
                        StringBuffer valueBuf = new StringBuffer();
                        byte[] bytes = value.getBytes();
                        int lenB = bytes.length;
                        for (int b = 0; b < lenB; ++b) {
                            char c = (char)bytes[b];
                            if (c == '.' || c == '+' || c == '?' || c == '*' || c == '^' || c == '$' || c == '|' || c == '(' || c == ')' || c == '[' || c == ']' || c == '<' || c == '>') {
                                valueBuf.append("\\" + c);
                                continue;
                            }
                            valueBuf.append(c);
                        }
                        value = valueBuf.toString();
                        value = newValue = newValue + ".*" + value + ".*";
                    }
                    try {
                        String[] fields = null;
                        try (FileInputStream fis = new FileInputStream(tmpFile);){
                            MimeMessage mimeMessage = null;
                            if (this.globalMailHolder == null) {
                                mimeMessage = new MimeMessage(null, (InputStream)fis);
                            }
                            fields = this.getMessageAttributes((Message)mimeMessage, attr);
                        }
                        if (fields == null) break block17;
                        int lenF = fields.length;
                        for (int k = 0; k < lenF; ++k) {
                            Pattern p;
                            String reg = value;
                            if (reg.startsWith("!")) {
                                p = Pattern.compile(reg = reg.substring(1), 42);
                                if (p.matcher(fields[k]).matches()) continue;
                                stat.debug().detail((Object)("Filter matches: " + reg + " == " + fields[k])).send("Filter match");
                                mailIsValid = true;
                            } else {
                                p = Pattern.compile(reg, 42);
                                if (!p.matcher(fields[k]).matches()) continue;
                                stat.debug().detail((Object)("Filter matches: " + reg + " == " + fields[k])).send("Filter match");
                                mailIsValid = true;
                            }
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (mailIsValid) break;
            }
        }
        return mailIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAutoResponseFilter(File tmpFile, String fromAddress) {
        try {
            String toAddress;
            GenericCache gc;
            int i;
            int len;
            MimeMessage mimeMessage = null;
            try (FileInputStream fis = new FileInputStream(tmpFile);){
                if (this.globalMailHolder == null) {
                    mimeMessage = new MimeMessage(null, (InputStream)fis);
                }
            }
            String[] fields = this.getMessageAttributes((Message)mimeMessage, "X-Mailing-List");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "Mailing-List");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "FROM_DAEMON");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "FROM_MAILER");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "MAILER");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "UUCP");
            if (fields != null && fields.length > 0) {
                return false;
            }
            fields = this.getMessageAttributes((Message)mimeMessage, "Precedence");
            if (fields != null) {
                len = fields.length;
                for (i = 0; i < len; ++i) {
                    if (!fields[i].equalsIgnoreCase("bulk") && !fields[i].equalsIgnoreCase("list") && !fields[i].equalsIgnoreCase("junk")) continue;
                    return false;
                }
            }
            if ((fields = this.getMessageAttributes((Message)mimeMessage, "X-Loop")) != null) {
                len = fields.length;
                for (i = 0; i < len; ++i) {
                    if (!fields[i].equals(fromAddress)) continue;
                    return false;
                }
            }
            if ((fields = this.getMessageAttributes((Message)mimeMessage, "TEXT")) != null) {
                String xLoopStr = "X-Loop: " + fromAddress;
                int len2 = fields.length;
                for (int i2 = 0; i2 < len2; ++i2) {
                    if (fields[i2].indexOf(xLoopStr) == -1) continue;
                    return false;
                }
            }
            if ((gc = GenericCache.getInstance((Object)("MailLoopDetectionCache_" + fromAddress), (int)1000, (int)60000, (int)3600000)).contains((Object)(toAddress = this.getMessageAttributes((Message)mimeMessage, "FROM")[0]))) {
                return false;
            }
            gc.put((Object)toAddress, null);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMessageAttribute(File tmpFile, String attribute) {
        String[] fields = null;
        try (FileInputStream fis = new FileInputStream(tmpFile);){
            MimeMessage mimeMessage = null;
            if (this.globalMailHolder == null) {
                mimeMessage = new MimeMessage(null, (InputStream)fis);
            }
            if (attribute.equalsIgnoreCase("FROM") && mimeMessage != null) {
                Address[] from = null;
                try {
                    from = mimeMessage.getFrom();
                }
                catch (Exception e) {
                    try {
                        String[] adrHeader = mimeMessage.getHeader("FROM");
                        from = this.getAddressFromString(adrHeader);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (from != null) {
                    fields = this.fillAddressToString(from);
                }
            }
            if (fields == null) {
                fields = this.getMessageAttributes((Message)mimeMessage, attribute);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fields;
    }

    private MailObjectHolder collectMailInfo(Message message) throws Exception {
        if (this.globalMailHolder == null) {
            this.globalMailHolder = new MailObjectHolder();
            Object content = message.getContent();
            if (content instanceof Multipart) {
                this.handleMultipart((Multipart)content, this.globalMailHolder);
            } else {
                this.handlePart((Part)message, this.globalMailHolder);
            }
            this.globalMailHolder.setAllHeaders(message);
        }
        return this.globalMailHolder;
    }

    private void handleMultipart(Multipart multipart, MailObjectHolder mailHolder) throws Exception {
        int n = multipart.getCount();
        for (int i = 0; i < n; ++i) {
            this.handlePart((Part)multipart.getBodyPart(i), mailHolder);
        }
    }

    private void handlePart(Part part, MailObjectHolder mailHolder) throws Exception {
        String disposition = part.getDisposition();
        String contentType = part.getContentType();
        if (disposition == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            part.writeTo((OutputStream)baos);
            String text = new String(baos.toByteArray());
            StringUtils stringUtils = new StringUtils();
            if (stringUtils.isBase64(text)) {
                text = stringUtils.decodeFromBase64(text);
            }
            mailHolder.getBodies().add(text);
        } else if (disposition.equalsIgnoreCase("attachment")) {
            String fileName = this.getFilename(part);
            mailHolder.getAttachments().add(fileName);
        } else if (disposition.equalsIgnoreCase("inline")) {
            String fileName = this.getFilename(part);
            mailHolder.getAttachments().add(fileName);
        }
    }

    public static synchronized long getUniqueId() {
        return ++uniqueId;
    }

    public void setKeepFileName(boolean keepFileName) {
        this.keepFileName = keepFileName;
    }

    public FolderObjectClientBean getDestinationFolderOrg() {
        return this.destinationFolderOrg;
    }

    private static String decodeMimeParts(String s) {
        Pattern pattern = Pattern.compile(ENCODED_PART_REGEX_PATTERN);
        Matcher m = pattern.matcher(s);
        ArrayList<String> encodedParts = new ArrayList<String>();
        while (m.find()) {
            encodedParts.add(m.group(0));
        }
        if (encodedParts.size() > 0) {
            try {
                for (String encoded : encodedParts) {
                    s = s.replace(encoded, MimeUtility.decodeText((String)encoded));
                }
                return s;
            }
            catch (Exception ex) {
                return s;
            }
        }
        return s;
    }

    static {
        REGULAREXPRESSION_KEY = "REGEXP:";
        stat = MailServiceStatistic.getInstance();
        mb3 = EmlParser.isMb3();
        MIME_ENCODED_TEXT_BINARY = Pattern.compile("=\\?[a-z0-9\\-]+\\?B\\?.*\\?=(\r\n =\\?[a-z0-9\\-]+\\?B\\?.*\\?=)+");
        MIME_ENCODED_TEXT_QUOTED = Pattern.compile("=\\?[a-z0-9\\-]+\\?Q\\?.*\\?=(\r\n =\\?[a-z0-9\\-]+\\?Q\\?.*\\?=)+");
        MIME_ENCODED_TEXT_QUOTED_BREAK = Pattern.compile("\\?=\r\n =\\?[a-z0-9\\-]+\\?Q\\?");
        addressPattern = Pattern.compile("[^<]*<[^<>]+>");
    }

    private class ContentIdComparator
    implements Comparator<String> {
        @Override
        public int compare(String cid1, String cid2) {
            try {
                return Integer.valueOf(cid2).compareTo(Integer.valueOf(cid1));
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    private class SMTPAuthenticator
    extends Authenticator {
        private String username = null;
        private String password = null;

        public SMTPAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

