/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.preview;

import agorum.roi.common.utils.InstallUtil;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.preview.PreviewHelper;
import agorum.roi.preview.PreviewInterface;

public class PreviewHelperGateway {
    public static String previewInterfaceClass = "agorum.roi.preview.PreviewHelper";

    public boolean isPreviewInstalled() {
        if (previewInterfaceClass == null) {
            return false;
        }
        boolean isInstalled = false;
        if (InstallUtil.isModuleActive("Preview", false)) {
            try {
                isInstalled = this.getPreviewInterface().isPreviewInstalled();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isInstalled;
    }

    public PreviewInterface getPreviewInterface() throws Exception {
        SessionController sc = SessionControllerAdmin.getSessionControllerAdmin("PreviewHelperGateway");
        boolean previewEnabled = InstallUtil.isModuleActive("Preview", false);
        if (previewEnabled) {
            try {
                previewEnabled = Boolean.valueOf(MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/preview/control/PreviewEnabled", "false"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        PreviewInterface pi = null;
        if (previewEnabled) {
            if (previewInterfaceClass != null) {
                pi = (PreviewInterface)Class.forName(previewInterfaceClass).newInstance();
            }
        } else {
            pi = new PreviewHelper();
        }
        return pi;
    }

    public boolean hasPreview(GlobalObjectClientBean fileObject) throws Exception {
        PreviewInterface pi;
        boolean available = false;
        if (InstallUtil.isModuleActive("Preview", false) && (pi = this.getPreviewInterface()) != null) {
            available = pi.hasPreview(fileObject);
        }
        return available;
    }
}

