/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.roi.scripting.Converter;
import agorum.roi.scripting.sandbox.SandboxContext;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Engine {
    private final Scriptable scope;
    private final boolean sandboxed;

    Engine(Scriptable scope, boolean sandboxed) {
        this.scope = scope;
        this.sandboxed = sandboxed;
    }

    Object get(String key) {
        return this.toJava(ScriptableObject.getProperty(this.scope, key));
    }

    Object put(String key, Object value) {
        Object result = this.get(key);
        ScriptableObject.putProperty(this.scope, key, this.toJs(value));
        return result;
    }

    void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    Object remove(String key) {
        Object result = this.get(key);
        ScriptableObject.deleteProperty(this.scope, key);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object eval(String source, String name, Map<? extends String, Object> map, boolean internal) {
        SandboxContext context = (SandboxContext)Context.enter();
        try {
            Scriptable scope;
            context.enterSandbox(this.sandboxed);
            if (map == null) {
                scope = this.scope;
            } else {
                scope = new NativeObject();
                scope.setParentScope(this.scope);
                scope.setPrototype(this.scope);
                for (Map.Entry<? extends String, Object> entry : map.entrySet()) {
                    ScriptableObject.putProperty(scope, entry.getKey(), entry.getValue());
                }
            }
            Object result = context.evaluateString(scope, source, name != null ? name : "<cmd>", 1, null);
            Object object = internal ? result : this.toJava(result);
            return object;
        }
        finally {
            Context.exit();
            context.leaveSandbox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object exec(Script script, Scriptable scope, boolean internal) {
        SandboxContext context = (SandboxContext)Context.enter();
        try {
            context.enterSandbox(this.sandboxed);
            Object result = script.exec(context, scope == null ? this.scope : scope);
            Object object = internal ? result : this.toJava(result);
            return object;
        }
        finally {
            Context.exit();
            context.leaveSandbox();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object call(Function function, Scriptable me, Object ... args) {
        Object[] wrappedArgs = null;
        if (args != null) {
            int len = args.length;
            wrappedArgs = new Object[len];
            for (int i = 0; i < len; ++i) {
                wrappedArgs[i] = this.toJs(args[i]);
            }
        }
        SandboxContext context = (SandboxContext)Context.enter();
        try {
            context.enterSandbox(this.sandboxed);
            Object object = this.toJava(function.call(context, this.scope, me, wrappedArgs));
            return object;
        }
        finally {
            Context.exit();
            context.leaveSandbox();
        }
    }

    Object call(String[] keys, Object ... args) {
        Scriptable parent = this.scope;
        Scriptable function = this.scope;
        for (String key : keys) {
            parent = function;
            function = (Scriptable)function.get(key, this.scope);
        }
        return this.call((Function)function, parent, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Script compile(String source, String name) {
        Context context = Context.enter();
        try {
            Script script = context.compileString(source, name != null ? name : "<cmd>", 1, null);
            return script;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Script compile(Reader reader, String name) throws IOException {
        Context context = Context.enter();
        try {
            Script script = context.compileReader(reader, name != null ? name : "<cmd>", 1, null);
            return script;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function compileFunction(String source, String name) {
        Context context = Context.enter();
        try {
            Function function = context.compileFunction(this.scope, source, name, 1, null);
            return function;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object toJs(Object obj) {
        Context context = Context.enter();
        try {
            Object object = Converter.toJs(context, this.scope, obj);
            return object;
        }
        finally {
            Context.exit();
        }
    }

    public Object toJava(Object obj) {
        return Converter.toJava(obj);
    }
}

